//=============================================================================
// Mission10.
//=============================================================================
class Mission10 expands MissionScript;

// ----------------------------------------------------------------------
// FirstFrame()
// 
// Stuff to check at first frame
// ----------------------------------------------------------------------

function FirstFrame()
{
	local NicoletteDuClare Nicolette;
	local BlackHelicopter chopper;
	local JaimeReyes Jaime;
        local Pawn P;

	Super.FirstFrame();

	if (localURL == "10_PARIS_METRO")
	{
		if (flags.GetBool('NicoletteLeftClub'))
		{
			for ( P=Level.PawnList; P!=None; P=P.NextPawn )
			      if (P.IsA('NicoletteDuClare'))
				    NicoletteDuClare(P).EnterWorld();

			foreach AllActors(class'BlackHelicopter', chopper, 'BlackHelicopter')
				chopper.EnterWorld();
		}

		if (!flags.GetBool('JaimeRecruited'))
		{
			for ( P=Level.PawnList; P!=None; P=P.NextPawn )
			      if (P.IsA('JaimeReyes'))
				    JaimeReyes(P).EnterWorld(); 
		}
	}
	else if (localURL == "10_PARIS_CLUB")
	{
		if (flags.GetBool('NicoletteLeftClub'))
		{
                        for ( P=Level.PawnList; P!=None; P=P.NextPawn )
			      if (P.IsA('NicoletteDuClare'))
			              P.Destroy();
		}
	}
	else if (localURL == "10_PARIS_CHATEAU")
	{
		flags.SetBool('ClubComplete', True,, 11);
	}
}

// ----------------------------------------------------------------------
// PreTravel()
// 
// Set flags upon exit of a certain map
// ----------------------------------------------------------------------

function PreTravel()
{
	if (localURL == "10_PARIS_CLUB")
	{
		if (flags.GetBool('MeetNicolette_Played') &&
			!flags.GetBool('NicoletteLeftClub'))
		{
			flags.SetBool('NicoletteLeftClub', True,, 11);
		}
	}

	Super.PreTravel();
}

// ----------------------------------------------------------------------
// Timer()
//
// Main state machine for the mission
// ----------------------------------------------------------------------

function Timer()
{
	local int count;
	local int notSafeCount, notDeadCount;
	local ScriptedPawn hostage, guard;
	local Greasel greasel;
	local GuntherHermann gunther;
	local MJ12Commando commando;
	local Actor A;
        local Pawn P;

	Super.Timer();

	if (localURL == "10_PARIS_CATACOMBS")
	{
		// see if the greasels are dead
		if (!flags.GetBool('SewerGreaselsDead'))
		{
			count = 0;
			for ( P=Level.PawnList; P!=None; P=P.NextPawn )
                        if (p.IsA('Greasel') && (p.Tag == 'SewerGreasel')) 
				count++;

			if (count == 0)
				flags.SetBool('SewerGreaselsDead', True,, 11);
		}

		// check for dead guards
		if (!flags.GetBool('defoequestcomplete'))
		{
			count = 0;
			for ( P=Level.PawnList; P!=None; P=P.NextPawn )
                        if (p.IsA('ScriptedPawn') && (p.Tag == 'mj12metroguards')) 
				count++;

			if (count == 0)
				flags.SetBool('defoequestcomplete', True,, 11);
		}
	}
	else if (localURL == "10_PARIS_CATACOMBS_TUNNELS")
	{
		if (!flags.GetBool('SilhouetteRescueComplete'))
		{
			// count how many hostages are NOT safe
			notSafeCount = 0;
			notDeadCount = 0;
			for ( P=Level.PawnList; P!=None; P=P.NextPawn )
			{
				if (P.BindName == "hostage")
				{
					notDeadCount++;
					if (!flags.GetBool('CataMaleSafe'))
						notSafeCount++;
				}
				else if (P.BindName == "hostage_female")
				{
					notDeadCount++;
					if (!flags.GetBool('CataFemaleSafe'))
						notSafeCount++;
				}
			}

			if ((notSafeCount == 0) || (notDeadCount == 0))
			{
				flags.SetBool('SilhouetteRescueComplete', True,, 11);
				Player.GoalCompleted('EscortHostages');

				if (notDeadCount == 0)
					flags.SetBool('SilhouetteHostagesDead', True,, 11);
				else if (notDeadCount < 2)
					flags.SetBool('SilhouetteHostagesSomeRescued', True,, 11);
				else
					flags.SetBool('SilhouetteHostagesAllRescued', True,, 11);
			}
		}
	}
	else if (localURL == "10_PARIS_METRO")
	{
		// unhide GuntherHermann
		if (!flags.GetBool('MS_GuntherUnhidden') &&
			flags.GetBool('JockReady_Played'))
		{
			for ( P=Level.PawnList; P!=None; P=P.NextPawn )
			      if (P.IsA('GuntherHermann'))
				    GuntherHermann(P).EnterWorld(); 

			flags.SetBool('MS_GuntherUnhidden', True,, 11);
		}

		// bark something
		if (flags.GetBool('AlleyCopSeesPlayer_Played') &&
			!flags.GetBool('MS_CopBarked'))
		{
			foreach AllActors(class'Actor', A, 'AlleyCopAttacks')
				A.Trigger(Self, Player);

			flags.SetBool('MS_CopBarked', True,, 11);
		}
	}
	else if (localURL == "10_PARIS_CHATEAU")
	{
		// unhide MJ12Commandos when an infolink is played
		if (!flags.GetBool('MS_CommandosUnhidden') &&
			flags.GetBool('everettsignal'))
		{
			for ( P=Level.PawnList; P!=None; P=P.NextPawn )
			      if (P.IsA('MJ12Commando'))
				    MJ12Commando(P).EnterWorld();  

			flags.SetBool('MS_CommandosUnhidden', True,, 11);
		}
	}
}

// ----------------------------------------------------------------------
// ----------------------------------------------------------------------

function RandomizeInventory()
{
    	local int i;
    	local Pawn P;
    	local bool bImportantWeapon;
    	local ScriptedPawn sp;
    	local inventory Inv;
                
    	for ( P=Level.PawnList; P!=None; P=P.NextPawn )
    	{
          		sp = ScriptedPawn(P);
          		if (sp != None)
          		{	 
              			if ( sp.IsA('HumanMilitary') && !sp.IsA('MJ12Commando') && !sp.IsA('Cop') && !sp.IsA('DarkMaiden') )
              			{
                   			i = Rand(10);                      
                   			for( Inv=sp.Inventory; Inv!=None; Inv=Inv.Inventory )
                   			{
                           				if (Inv.IsA('DeusExWeapon') && !DeusExWeapon(Inv).bHandToHand)
                               					Inv.Destroy();
                   			}
                   			if ( Level.Game.Difficulty == 3 )
						AddInventory(sp, WeaponClasses[i]);
					else
					{
						if ( FRand() < 0.25 )
						{
							if ( FRand() < 0.33 )
								AddInventory(sp, "DeusEx.WeaponSMG");
							else if ( FRand() < 0.67 )
								AddInventory(sp, "DeusEx.WeaponPrecisionRifle");
							else
								AddInventory(sp, "DeusEx.WeaponDXQuadShot");
						}
						else
                       					AddInventory(sp, WeaponClasses[i]);
					}
              			} 

              			else if (sp.IsA('DarkMaiden'))
              			{
					if ( FRand() < 0.5 )
					{
					}
                   			else
					{
						for( Inv=sp.Inventory; Inv!=None; Inv=Inv.Inventory )
                   				{
                       					if (Inv.IsA('DeusExWeapon') && !DeusExWeapon(Inv).bHandToHand)
                           						Inv.Destroy();
                   				}
                   				AddInventory(sp, "DeusEx.WeaponAssaultShotgun");
					}
              			}         
           		}
     	}
}

function Surprise()
{
   if (localURL == "10_PARIS_CATACOMBS")
   {    
        SpawnExtraEnemy(Class'BadDenton','HidePoint30','mj12',-1.0,'Standing');
        SpawnExtraEnemy(Class'BadDenton','HidePoint29','mj12',-1.0,'Standing');
        SpawnExtraEnemy(Class'MJ12Sergeant','PathNode390','mj12',-1.0,'Standing');
        SpawnExtraEnemy(Class'MJ12Sergeant','PathNode392','mj12',-1.0,'Standing');
        SpawnExtraEnemy(Class'MJ12Sergeant','PathNode398','mj12',-1.0,'Standing',,true);
        SpawnExtraEnemy(Class'DarkMaiden','PathNode0','Dark',-1.0);
        SpawnExtraEnemy(Class'DarkMaiden','PathNode144','Dark',-1.0);
        SpawnExtraEnemy(Class'DarkMaiden','PathNode301','Dark',-1.0);
        SpawnExtraEnemy(Class'DarkMaiden','PathNode302','Dark',-1.0);
        SpawnExtraEnemy(Class'DarkMaiden','PathNode299','Dark',-1.0);
        SpawnExtraEnemy(Class'DarkMaiden','PathNode195','Dark',-1.0);
        SpawnExtraEnemy(Class'DarkMaiden','PathNode192','Dark',-1.0);
        SpawnExtraEnemy(Class'DarkMaiden','PathNode187','Dark',-1.0);
        SpawnExtraEnemy(Class'ScubaDiver','PathNode517','Greasel',-1.0,'Standing',,true);
        SpawnExtraEnemy(Class'ScubaDiver','PathNode506','Greasel',-1.0,,,true);
        SpawnExtraEnemy(Class'ScubaDiver','PathNode499','Greasel',-1.0,,,true);
        SpawnExtraEnemy(Class'ScubaDiver','PathNode102','Rs',-1.0,'Standing',,true);
   }

   else if (localURL == "10_PARIS_CATACOMBS_TUNNELS")
   {
        SpawnExtraEnemy(Class'BadDenton','PathNode602','mj12',-1.0,,,true);
        SpawnExtraEnemy(Class'MJ12Sergeant','PathNode549','mj12',-1.0,,,true);
        SpawnExtraEnemy(Class'MJ12Sergeant','PathNode451','mj12',-1.0,'Standing',,true);
        SpawnExtraEnemy(Class'MJ12Sergeant','PathNode414','mj12',-1.0,'Standing',,true);
        SpawnExtraEnemy(Class'MJ12Sergeant','PathNode27','mj12',-1.0,'Standing',,true);
        SpawnExtraEnemy(Class'MJ12Sergeant','HidePoint3','mj12',-1.0,'Standing',,true);
        SpawnExtraEnemy(Class'BadDenton','HidePoint1','mj12',-1.0,'Standing');
        SpawnExtraEnemy(Class'MJ12Commando','HidePoint2','mj12',-1.0,'Standing');
        SpawnExtraEnemy(Class'MJ12Commando','PathNode421','mj12',-1.0,'Standing',,true);
        SpawnExtraEnemy(Class'MJ12Sergeant','PathNode234','mj12',-1.0);
        SpawnExtraEnemy(Class'MJ12Commando','PathNode386','mj12',-1.0);
        SpawnExtraEnemy(Class'MJ12Commando','PathNode499','mj12',-1.0);
        SpawnExtraEnemy(Class'MJ12Commando','PathNode455','mj12',-1.0,'Standing',,true);
        SpawnExtraEnemy(Class'MJ12Commando','PathNode552','mj12',-1.0,'Standing',,true);
        SpawnExtraEnemy(Class'BadDenton','PathNode5','mj12',-1.0,'Standing');
   }

    else if (localURL == "10_PARIS_CHATEAU")
   {
        SpawnExtraEnemy(Class'DarkMaiden','PathNode400','Dark',-1.0,'Standing',,true);
        SpawnExtraEnemy(Class'DarkMaiden','PathNode399','Dark',-1.0,'Standing',,true);
        SpawnExtraEnemy(Class'DarkMaiden','PathNode398','Dark',-1.0,'Standing',,true);
   }

   else if (localURL == "10_PARIS_METRO")
   {
        SpawnExtraEnemy(Class'MJ12Sergeant','PathNode429','mj12',-1.0,'Standing',,true);
        SpawnExtraEnemy(Class'MJ12Sergeant','PathNode430','mj12',-1.0,'Standing',,true);
        SpawnExtraEnemy(Class'MJ12Sergeant','PathNode106','mj12',-1.0,'Standing',,true);
        SpawnExtraEnemy(Class'MJ12Sergeant','PathNode104','mj12',-1.0,'Standing',,true);
        SpawnExtraEnemy(Class'MJ12Sergeant','PathNode233','mj12',-1.0,'Standing',,true);
        SpawnExtraEnemy(Class'MJ12Sergeant','PathNode154','mj12',-1.0,'Standing',,true);
        SpawnExtraEnemy(Class'MJ12Sergeant','HidePoint12','mj12',-1.0,'Standing',,true);
        SpawnExtraEnemy(Class'MJ12Sergeant','HidePoint6','mj12',-1.0,'Standing',,true);
        SpawnExtraEnemy(Class'MJ12Sergeant','HidePoint3','mj12',-1.0,'Standing',,true);
        SpawnExtraEnemy(Class'MJ12Commando','PathNode231','mj12',-1.0,'Standing');
        SpawnExtraEnemy(Class'MJ12Commando','PathNode234','mj12',-1.0,'Standing');
        SpawnExtraEnemy(Class'MJ12Commando','HidePoint4','mj12',-1.0,'Standing');
        SpawnExtraEnemy(Class'MJ12Commando','HidePoint1','mj12',-1.0,'Standing');
        SpawnExtraEnemy(Class'MJ12Commando','HidePoint7','mj12',-1.0,'Standing');
        SpawnExtraEnemy(Class'MJ12Commando','HidePoint2','mj12',-1.0,'Standing');
        SpawnExtraActor(Class'MachineGunBase', 'PathNode31');
        SpawnExtraEnemy(Class'MJ12Sergeant','PathNode420','mj12',-1.0,'DefendPosition',,true);
   }
}   

// ----------------------------------------------------------------------
// ----------------------------------------------------------------------

defaultproperties
{
     WeaponClasses(0)="DeusEx.WeaponFlamethrower"
     WeaponClasses(1)="DeusEx.WeaponSawedOffShotgun"
     WeaponClasses(2)="DeusEx.WeaponAssaultGun"
     WeaponClasses(3)="DeusEx.WeaponAssaultShotgun"
     WeaponClasses(4)="DeusEx.WeaponRifle"
     WeaponClasses(5)="DeusEx.WeaponGEPGun"
     WeaponClasses(6)="DeusEx.WeaponMiniCrossbow"
     WeaponClasses(7)="DeusEx.WeaponPistol"
     WeaponClasses(8)="DeusEx.WeaponHideAGun"
     WeaponClasses(9)="DeusEx.WeaponLAW"
}
