//=============================================================================
// Mission11.
//=============================================================================
class Mission11 expands MissionScript;

// ----------------------------------------------------------------------
// FirstFrame()
// 
// Stuff to check at first frame
// ----------------------------------------------------------------------

function FirstFrame()
{
	Super.FirstFrame();
}

// ----------------------------------------------------------------------
// PreTravel()
// 
// Set flags upon exit of a certain map
// ----------------------------------------------------------------------

function PreTravel()
{
	Super.PreTravel();
}

// ----------------------------------------------------------------------
// Timer()
//
// Main state machine for the mission
// ----------------------------------------------------------------------

function Timer()
{
	local TobyAtanwe toby;
	local GuntherHermann gunther;
	local BlackHelicopter chopper;
	local AlexJacobson alex;
	local WaltonSimons walton;
        local Pawn P;

	Super.Timer();

	if (localURL == "11_PARIS_UNDERGROUND")
	{
		// unhide Toby Atanwe
		if (flags.GetBool('templar_upload') &&
			!flags.GetBool('MS_TobyUnhidden'))
		{
			for ( P=Level.PawnList; P!=None; P=P.NextPawn )
			      if (P.IsA('TobyAtanwe'))
				    TobyAtanwe(P).EnterWorld();

			flags.SetBool('MS_TobyUnhidden', True,, 12);
		}

		// knock out the player and teleport him after this convo
		if (flags.GetBool('MeetTobyAtanwe_Played') &&
			!flags.GetBool('MS_PlayerTeleported'))
		{
			flags.SetBool('MS_PlayerTeleported', True,, 12);
			Level.Game.SendPlayer(Player, "11_PARIS_EVERETT");
		}
	}
	else if (localURL == "11_PARIS_EVERETT")
	{
		// unhide the helicopter
		if (flags.GetBool('MeetEverett_Played') &&
			!flags.GetBool('MS_ChopperUnhidden'))
		{
			foreach AllActors(class'BlackHelicopter', chopper)
				chopper.EnterWorld();

			flags.SetBool('MS_ChopperUnhidden', True,, 12);
		}

		// unhide Alex Jacobson
		if (flags.GetBool('AtanweAtEveretts_Played') &&
			!flags.GetBool('MS_AlexUnhidden'))
		{
			for ( P=Level.PawnList; P!=None; P=P.NextPawn )
			      if (P.IsA('AlexJacobson'))
				    AlexJacobson(P).EnterWorld();

			flags.SetBool('MS_AlexUnhidden', True,, 12);
		}

		// set a flag
		if (flags.GetBool('Ray_Dead') &&
			!flags.GetBool('MS_RayDead'))
		{
			Player.GoalCompleted('KillMechanic');
			flags.SetBool('MS_RayDead', True,, 12);
		}
	}
	else if (localURL == "11_PARIS_CATHEDRAL")
	{
		// kill Gunther after a convo
		if (flags.GetBool('M11MeetGunther_Played') &&
			flags.GetBool('KillGunther') &&
			!flags.GetBool('MS_GuntherKilled'))
		{
			for ( P=Level.PawnList; P!=None; P=P.NextPawn )
			{
                            if (P.IsA('GuntherHermann'))
                            {
				GuntherHermann(P).bInvincible = False;
				GuntherHermann(P).HealthTorso = 0;
				GuntherHermann(P).Health = 0;
				GuntherHermann(P).GotoState('KillswitchActivated');
				flags.SetBool('GuntherHermann_Dead', True,, 0);
				flags.SetBool('MS_GuntherKilled', True,, 12);
                             } 
			}
		}

		// unhide Walton Simons
		if (flags.GetBool('templar_upload') &&
			flags.GetBool('M11NearWalt') &&
			!flags.GetBool('MS_M11WaltAppeared'))
		{
			for ( P=Level.PawnList; P!=None; P=P.NextPawn )
			      if (P.IsA('WaltonSimons'))
				    WaltonSimons(P).EnterWorld();

			flags.SetBool('MS_M11WaltAppeared', True,, 12);
		}

		// hide Walton Simons
		if (flags.GetBool('M11WaltonHolo_Played') &&
			!flags.GetBool('MS_M11WaltRemoved'))
		{
			for ( P=Level.PawnList; P!=None; P=P.NextPawn )
			      if (P.IsA('WaltonSimons'))
				    WaltonSimons(P).LeaveWorld();

			flags.SetBool('MS_M11WaltRemoved', True,, 12);
		}
	}
}

// ----------------------------------------------------------------------
// ----------------------------------------------------------------------

function RandomizeInventory()
{
    local int i;
    local Pawn P;
    local bool bImportantWeapon;
    local ScriptedPawn sp;
    local inventory Inv;
                
    for ( P=Level.PawnList; P!=None; P=P.NextPawn )
    {
          sp = ScriptedPawn(P);
          if (sp != None)
          { 
              if (sp.IsA('HumanMilitary') && !sp.IsA('MJ12Commando') && !sp.IsA('GuntherHermann') && !sp.IsA('DarkMaiden'))
              {
                   	i = Rand(11);                                         
                   	for( Inv=sp.Inventory; Inv!=None; Inv=Inv.Inventory )
                   	{
                        	if (Inv.IsA('DeusExWeapon') && !DeusExWeapon(Inv).bHandToHand)
                               		Inv.Destroy();
                   	}
                   	if ( Level.Game.Difficulty == 3 )
				AddInventory(sp, WeaponClasses[i]);
			else
			{
				if ( FRand() < 0.25 )
				{
					if ( FRand() < 0.33 )
						AddInventory(sp, "DeusEx.WeaponSMG");
					else if ( FRand() < 0.67 )
						AddInventory(sp, "DeusEx.WeaponPrecisionRifle");
					else
						AddInventory(sp, "DeusEx.WeaponDXQuadShot");
				}
				else
                       			AddInventory(sp, WeaponClasses[i]);
			}
               }         
           }
     }
}

function Surprise()
{
   local Pawn P;

   if (localURL == "11_PARIS_CATHEDRAL")
   {    
        SpawnExtraEnemy(Class'MJ12Sergeant','PathNode54','mj12',-1.0,'DefendPosition',,true);
        SpawnExtraEnemy(Class'MJ12Sergeant','PathNode327','mj12',-1.0,'Standing',,true);
        SpawnExtraEnemy(Class'MJ12Sergeant','PathNode449','mj12',-1.0,'DefendPosition',,true);
        SpawnExtraEnemy(Class'MJ12Sergeant','PathNode452','mj12',-1.0,'Standing',,true);
        SpawnExtraEnemy(Class'MJ12Sergeant','PathNode10','mj12',-1.0,'Standing',,true);
        SpawnExtraEnemy(Class'MJ12Sergeant','PathNode11','mj12',-1.0,'Standing',,true);
        SpawnExtraEnemy(Class'MJ12Commando','PathNode306','mj12',-1.0,'Standing');
        SpawnExtraEnemy(Class'MIB','HIdePoint38','mj12',-1.0,,,true);
        SpawnExtraEnemy(Class'MIB','PathNode93','mj12',-1.0,,,true);
        SpawnExtraEnemy(Class'MIB','PathNode364','mj12',-1.0,'Standing',,true);
        SpawnExtraEnemy(Class'MIB','PathNode319','mj12',-1.0,'Standing',,true);
        SpawnExtraEnemy(Class'MIB','PathNode385','mj12',-1.0,'Standing',,true);
        SpawnExtraEnemy(Class'MIB','PathNode381','mj12',-1.0,'Standing',,true);
        SpawnExtraEnemy(Class'MIB','PathNode136','mj12',-1.0,'Standing',,true);
        SpawnExtraEnemy(Class'MIB','PathNode137','mj12',-1.0,'Standing',,true);
        SpawnExtraEnemy(Class'MIB','PathNode139','mj12',-1.0,'Standing',,true);
        SpawnExtraEnemy(Class'MJ12Commando','PathNode372','mj12',-1.0,'Standing');
        SpawnExtraEnemy(Class'MJ12Commando','PathNode360','mj12',-1.0,'Standing');  
        SpawnExtraEnemy(Class'MJ12Sergeant','PathNode84','mj12',-1.0,'Standing');
        SpawnExtraEnemy(Class'MJ12Sergeant','PathNode88','mj12',-1.0,'Standing');
        SpawnExtraActor(Class'MachineGunBase', 'PathNode86');
   }

   else if (localURL == "11_PARIS_EVERETT")
   {
        SpawnExtraEnemy(Class'DarkMaiden','PathNode55','Player',1.0,,,,"Carmela");

        for ( P=Level.PawnList; P!=None; P=P.NextPawn )
        {
              if (P.IsA('Maid'))
                    P.Destroy();
              else if (P.IsA('DarkMaiden'))
              {
                    P.UnfamiliarName = "Carmela";
                    P.FamiliarName = "Carmela";
                    DarkMaiden(P).bInvincible = True;
              }
        }
   } 
}

// ----------------------------------------------------------------------
// ----------------------------------------------------------------------

defaultproperties
{
     WeaponClasses(0)="DeusEx.WeaponAssaultShotgun"
     WeaponClasses(1)="DeusEx.WeaponRifle"
     WeaponClasses(2)="DeusEx.WeaponGEPGun"
     WeaponClasses(3)="DeusEx.WeaponMiniCrossbow"
     WeaponClasses(4)="DeusEx.WeaponFlamethrower"
     WeaponClasses(5)="DeusEx.WeaponAssaultGun"
     WeaponClasses(6)="DeusEx.WeaponSawedOffShotgun"
     WeaponClasses(7)="DeusEx.WeaponPistol"
     WeaponClasses(8)="DeusEx.WeaponPepperGun"
     WeaponClasses(9)="DeusEx.WeaponLAW"
     WeaponClasses(10)="DeusEx.WeaponHideAGun"
}
