//=============================================================================
// Mission12.
//=============================================================================
class Mission12 expands MissionScript;

// ----------------------------------------------------------------------
// FirstFrame()
// 
// Stuff to check at first frame
// ----------------------------------------------------------------------

function FirstFrame()
{
	local BlackHelicopter chopper;
	local ScriptedPawn pawn;
	local SandraRenton Sandra;
        local Pawn P;
        
	Super.FirstFrame();

	if (localURL == "12_VANDENBERG_CMD")
	{
                // unhide the black helicopter, Jock, and TracerTong
		if (flags.GetBool('GaryHostageBriefing_Played'))
		{
			foreach AllActors(class'BlackHelicopter', chopper)
				chopper.EnterWorld();

			for ( P=Level.PawnList; P!=None; P=P.NextPawn )
                        {
			      if (P.IsA('Jock'))
				    Jock(P).EnterWorld();
                              else if (P.IsA('TracerTong'))
		                    TracerTong(P).EnterWorld(); 
                        }
                 }
	}
	else if (localURL == "12_VANDENBERG_GAS")
	{
		flags.SetBool('RescueBegan', True,, 14);

		if (flags.GetBool('SandraWentToCalifornia'))
		{
			for ( P=Level.PawnList; P!=None; P=P.NextPawn )
			      if (P.IsA('SandraRenton'))
				    SandraRenton(P).EnterWorld();
		}
	}
}

// ----------------------------------------------------------------------
// PreTravel()
// 
// Set flags upon exit of a certain map
// ----------------------------------------------------------------------

function PreTravel()
{
	Super.PreTravel();
}

// ----------------------------------------------------------------------
// Timer()
//
// Main state machine for the mission
// ----------------------------------------------------------------------

function Timer()
{
	local Robot bot;
	local BlackHelicopter chopper;
	local ScriptedPawn pawn;
	local MJ12Troop troop;
	local Earth earth;
	local BobPage Bob;
	local int count;
	local DeusExMover M;
        local Pawn P;

	Super.Timer();

	if (localURL == "12_VANDENBERG_CMD")
	{
		// play datalinks when robots are destroyed or disabled
		if (!flags.GetBool('MS_DL_Played'))
		{
			count = 0;
			for ( P=Level.PawnList; P!=None; P=P.NextPawn )
                        if (p.IsA('Robot') && (p.Tag == 'enemy_bot'))
				if (Robot(P).EMPHitPoints > 0)
					count++;

			if (count == 3)
				Player.StartDataLinkTransmission("DL_bots_left_3");
			else if (count == 2)
				Player.StartDataLinkTransmission("DL_bots_left_2");
			else if (count == 1)
				Player.StartDataLinkTransmission("DL_bots_left_1");
			else if (count == 0)
			{
				Player.StartDataLinkTransmission("DL_command_bots_destroyed");
				flags.SetBool('MS_DL_Played', True,, 14);
			}
		}

		// rescue the scientist when the guards are dead
		if (!flags.GetBool('CapturedScientistRescued'))
		{
			count = 0;
			for ( P=Level.PawnList; P!=None; P=P.NextPawn )
			      if (P.IsA('MJ12Troop') &&
				 ((p.Tag == 'MJ12_hazlab_troop1') || (p.Tag == 'MJ12_hazlab_troop2')))
					count++;

			if (count == 0)
				flags.SetBool('CapturedScientistRescued', True,, 14);
		}
	}
	else if (localURL == "12_VANDENBERG_GAS")
	{
		// unhide the black helicopter and destroy the doors
		if (!flags.GetBool('MS_ChopperGasUnhidden'))
		{
			if (flags.GetBool('MeetTiffanySavage_Played') ||
				flags.GetBool('TiffanySavage_Dead'))
			{
				foreach AllActors(class'BlackHelicopter', chopper)
					chopper.EnterWorld();

				foreach AllActors(Class'DeusExMover', M, 'junkyard_doors')
					M.BlowItUp(None);

				flags.SetBool('TiffanyRescued', True,, 14);
				flags.SetBool('MS_ChopperGasUnhidden', True,, 14);
			}
		}

		if (!flags.GetBool('MS_TiffanyDLPlayed') &&
			flags.GetBool('TiffanySavage_Dead'))
		{
			Player.StartDataLinkTransmission("DL_JockTiffanyDead");
			flags.SetBool('MS_TiffanyDLPlayed', True,, 14);
		}
	}
	else if (localURL == "12_VANDENBERG_COMPUTER")
	{
		// hide the earth and unhide Bob Page
		if (!flags.GetBool('MS_M12PageAppeared') &&
			flags.GetBool('M12PageAppears'))
		{
			foreach AllActors(class'Earth', earth)
				earth.bHidden = True;
			
                        for ( P=Level.PawnList; P!=None; P=P.NextPawn )
			      if (P.IsA('BobPage'))
				    BobPage(P).EnterWorld();

			flags.SetBool('MS_M12PageAppeared', True,, 14);
		}

		// unhide the earth and hide Bob Page
		if (flags.GetBool('MS_M12PageAppeared') &&
			!flags.GetBool('MS_BobPageHidden') &&
			flags.GetBool('PageHostageBriefing_Played'))
		{
			foreach AllActors(class'Earth', earth)
				earth.bHidden = False;

			for ( P=Level.PawnList; P!=None; P=P.NextPawn )
			      if (P.IsA('BobPage'))
				BobPage(P).LeaveWorld();

			flags.SetBool('MS_BobPageHidden', True,, 14);
		}
	}
}

// ----------------------------------------------------------------------
// ----------------------------------------------------------------------

function RandomizeInventory()
{
    local int i;
    local Pawn P;
    local bool bImportantWeapon;
    local ScriptedPawn sp;
    local inventory Inv;
                
    for ( P=Level.PawnList; P!=None; P=P.NextPawn )
    {
        sp = ScriptedPawn(P);
        if (sp != None)
        { 
        	if (sp.IsA('HumanMilitary') && !sp.IsA('MJ12Commando'))
              	{
                	i = Rand(8);                      
                   	bImportantWeapon = (sp.FindInventoryType(Class'WeaponRifle') != None); 
                   	if (!bImportantWeapon)
                   	{
                       		for( Inv=sp.Inventory; Inv!=None; Inv=Inv.Inventory )
                       		{
                           		if (Inv.IsA('DeusExWeapon') && !DeusExWeapon(Inv).bHandToHand)
                               			Inv.Destroy();
                       		}
                       		if ( Level.Game.Difficulty == 3 )
						AddInventory(sp, WeaponClasses[i]);
				else
				{
					if ( FRand() < 0.25 )
					{
						if ( FRand() < 0.33 )
							AddInventory(sp, "DeusEx.WeaponSMG");
						else if ( FRand() < 0.67 )
							AddInventory(sp, "DeusEx.WeaponPrecisionRifle");
						else
							AddInventory(sp, "DeusEx.WeaponDXQuadShot");
					}
					else
                       				AddInventory(sp, WeaponClasses[i]);
				}
                   	}
              }  
          }
    }
}

function Surprise()
{
   	local Pawn P;

   	if (localURL == "12_VANDENBERG_CMD")
   	{
        		SpawnExtraEnemy(Class'SecurityForce','PathNode171','mj12',-1.0,'Standing',,true);
        		SpawnExtraEnemy(Class'SecurityForce','PathNode172','mj12',-1.0,'Standing',,true);
        		SpawnExtraEnemy(Class'SecurityForce','PathNode173','mj12',-1.0,'Standing',,true);
        		SpawnExtraEnemy(Class'SecurityForce','PathNode174','mj12',-1.0,'Standing',,true);
        		SpawnExtraEnemy(Class'SecurityForce','PathNode176','mj12',-1.0,,,true);
        		SpawnExtraEnemy(Class'SecurityForce','PathNode178','mj12',-1.0,'Standing',,true);
        		SpawnExtraEnemy(Class'SecurityForce','PathNode179','mj12',-1.0,'Standing',,true);
        		SpawnExtraEnemy(Class'MJ12Commando','PathNode32','mj12',-1.0,'Standing',,true);
        		SpawnExtraEnemy(Class'MJ12Commando','PathNode82','mj12',-1.0,'Standing',,true);
        		SpawnExtraEnemy(Class'MJ12Sergeant','PathNode22','mj12',-1.0,'Standing',,true);
        		SpawnExtraEnemy(Class'MJ12Sergeant','PathNode20','mj12',-1.0,'Standing',,true);  
        		SpawnExtraEnemy(Class'MJ12Commando','PathNode244','mj12',-1.0,'Standing',,true);      
        		SpawnExtraEnemy(Class'MJ12Commando','PathNode678','mj12',-1.0,'Standing',,true);
        		SpawnExtraEnemy(Class'MJ12Sergeant','HidePoint47','mj12',-1.0,'Standing',,true);
        		SpawnExtraEnemy(Class'TerroristA','PathNode146','Player',1.0,'Standing',,true,"Mechanic_comm_1");
        		SpawnExtraEnemy(Class'TerroristC','PathNode147','Player',1.0,'Standing',,true,"Mechanic_comm_2");
            
        		for ( P=Level.PawnList; P!=None; P=P.NextPawn )
        		{
              			if (P.IsA('MilitaryBot') && (P.Alliance == 'Bots_Salvagers'))
                        			P.Health = 10000;
        		}
   	}

   	else if (localURL == "12_VANDENBERG_GAS")
   	{    
        		SpawnExtraEnemy(Class'MJ12Sergeant','PathNode45','mj12',-1.0,'DefendPosition',,true);

        		for ( P=Level.PawnList; P!=None; P=P.NextPawn )
        		{
              			if (P.IsA('TiffanySavage') )
                    			TiffanySavage(P).ChangeAlly('mj12',0.0,true);
        		}
   	}
}

// ----------------------------------------------------------------------
// ----------------------------------------------------------------------

defaultproperties
{
     WeaponClasses(0)="DeusEx.WeaponPistol"
     WeaponClasses(1)="DeusEx.WeaponFlamethrower"
     WeaponClasses(2)="DeusEx.WeaponSawedOffShotgun"
     WeaponClasses(3)="DeusEx.WeaponPlasmaRifle"
     WeaponClasses(4)="DeusEx.WeaponAssaultGun"
     WeaponClasses(5)="DeusEx.WeaponMiniCrossbow"
     WeaponClasses(6)="DeusEx.WeaponLAW"
     WeaponClasses(7)="DeusEx.WeaponRifle"
}
