//=============================================================================
// Mission14.
//=============================================================================
class Mission14 expands MissionScript;

// ----------------------------------------------------------------------
// FirstFrame()
// 
// Stuff to check at first frame
// ----------------------------------------------------------------------

function FirstFrame()
{
        Super.FirstFrame();

	if (localURL == "14_OCEANLAB_LAB")
	{
		Player.GoalCompleted('StealSub');
	}
}

// ----------------------------------------------------------------------
// PreTravel()
// 
// Set flags upon exit of a certain map
// ----------------------------------------------------------------------

function PreTravel()
{
	Super.PreTravel();
}

// ----------------------------------------------------------------------
// Timer()
//
// Main state machine for the mission
// ----------------------------------------------------------------------

function Timer()
{
	local int count;
	local HowardStrong Howard;
	local BlackHelicopter chopper;
	local MiniSub sub;
	local ScubaDiver diver;
	local GarySavage Gary;
	local WaltonSimons Walton;
	local Actor part;
	local BobPage Bob;
        local Pawn P;

	Super.Timer();

	if (localURL == "14_VANDENBERG_SUB")
	{
		// when the mission is complete, unhide the chopper and Gary Savage,
		// and destroy the minisub and the welding parts
		if (!flags.GetBool('MS_DestroySub'))
		{
			if (flags.GetBool('DL_downloaded_Played'))
			{
				foreach AllActors(class'MiniSub', sub, 'MiniSub2')
					sub.Destroy();

				foreach AllActors(class'Actor', part, 'welding_stuff')
					part.Destroy();

				foreach AllActors(class'BlackHelicopter', chopper, 'BlackHelicopter')
					chopper.EnterWorld();
				
                                for ( P=Level.PawnList; P!=None; P=P.NextPawn )
			        if (P.IsA('GarySavage'))
				       GarySavage(P).EnterWorld();

				flags.SetBool('MS_DestroySub', True,, 15);
			}
		}
	}
	else if (localURL == "14_OCEANLAB_LAB")
	{
		// when the mission is complete, unhide the minisub and the diver team
		if (!flags.GetBool('MS_UnhideSub'))
		{
			if (flags.GetBool('DL_downloaded_Played'))
			{
				for ( P=Level.PawnList; P!=None; P=P.NextPawn )
			        if (P.IsA('WaltonSimons'))
				    WaltonSimons(P).EnterWorld();

				foreach AllActors(class'MiniSub', sub, 'MiniSub2')
					sub.EnterWorld();
				
                                for ( P=Level.PawnList; P!=None; P=P.NextPawn )
			        if (P.IsA('ScubaDiver') && (P.Tag == 'scubateam'))
				    ScubaDiver(P).EnterWorld();

				flags.SetBool('MS_UnhideSub', True,, 15);
			}
		}
	}
	else if (localURL == "14_OCEANLAB_SILO")
	{
		// when HowardStrong is dead, unhide the helicopter
		if (!flags.GetBool('MS_UnhideHelicopter'))
		{
			count = 0;
			for ( P=Level.PawnList; P!=None; P=P.NextPawn )
			        if (P.IsA('HowardStrong'))
				count++;

			if (count == 0)
			{
				foreach AllActors(class'BlackHelicopter', chopper, 'BlackHelicopter')
					chopper.EnterWorld();

				Player.StartDataLinkTransmission("DL_Dead");
				flags.SetBool('MS_UnhideHelicopter', True,, 15);
			}
		}
	}
	else if (localURL == "14_OCEANLAB_UC")
	{
		// when a flag is set, unhide Bob Page
		if (!flags.GetBool('MS_UnhideBobPage') &&
			flags.GetBool('schematic_downloaded'))
		{
			for ( P=Level.PawnList; P!=None; P=P.NextPawn )
			        if (P.IsA('BobPage'))
				    BobPage(P).EnterWorld();

			flags.SetBool('MS_UnhideBobPage', True,, 15);
		}

		// when a flag is set, hide Bob Page
		if (!flags.GetBool('MS_HideBobPage') &&
			flags.GetBool('PageTaunt_Played'))
		{
			for ( P=Level.PawnList; P!=None; P=P.NextPawn )
			        if (P.IsA('BobPage'))
				    BobPage(P).LeaveWorld();
				
			flags.SetBool('MS_HideBobPage', True,, 15);
		}

                if (!flags.GetBool('MS_DentonSpawnedUC') &&
			flags.GetBool('MS_HideBobPage'))                
                {
                        SuperSurprise();
                        flags.SetBool('MS_DentonSpawnedUC', True,, 15);
                }

	}
}

// ----------------------------------------------------------------------
// ----------------------------------------------------------------------

function RandomizeInventory()
{
    	local int i;
    	local Pawn P;
    	local bool bImportantWeapon;
    	local ScriptedPawn sp;
    	local inventory Inv;
    
    	for ( P=Level.PawnList; P!=None; P=P.NextPawn )
    	{
          		sp = ScriptedPawn(P);
          		if (sp != None)
          		{	 
              			if ( sp.IsA('HumanMilitary') && !sp.IsA('MJ12Commando') && !sp.IsA('WaltonSimons') && !sp.IsA('HowardStrong') )
              			{
                   			i = Rand(10);                      
                   			bImportantWeapon = (sp.FindInventoryType(Class'WeaponRifle') != None); 
                   			if (!bImportantWeapon)
                   			{
                       				for( Inv=sp.Inventory; Inv!=None; Inv=Inv.Inventory )
                       				{
                           					if (Inv.IsA('DeusExWeapon') && !DeusExWeapon(Inv).bHandToHand)
                               					Inv.Destroy();
                       				}
                       				if ( Level.Game.Difficulty == 3 )
							AddInventory(sp, WeaponClasses[i]);
						else
						{
							if ( FRand() < 0.25 )
							{
								if ( FRand() < 0.33 )
									AddInventory(sp, "DeusEx.WeaponSMG");
								else if ( FRand() < 0.67 )
									AddInventory(sp, "DeusEx.WeaponPrecisionRifle");
								else
									AddInventory(sp, "DeusEx.WeaponDXQuadShot");
							}
							else
                       						AddInventory(sp, WeaponClasses[i]);
						}
                   			}
               			}

               			else if ( sp.IsA('HowardStrong') )
               			{                  
                    			for( Inv=sp.Inventory; Inv!=None; Inv=Inv.Inventory )
                    			{
                         				if ( Inv.IsA('DeusExWeapon') && !DeusExWeapon(Inv).bMeleeWeapon )
                             					Inv.Destroy();
                    			}
                    			AddInventory(sp, "DeusEx.WeaponFlamethrower");
                    			AddInventory(sp, "DeusEx.WeaponPlasmaRifle");
                    			AddInventory(sp, "DeusEx.WeaponAssaultShotgun");
					AddInventory(sp, "DeusEx.WeaponLAW");
               			}
           		}
     	}
}

function Surprise()
{
   	local NavigationPoint N;
   	local Pawn P, M;
   	local vector myOldLocation;
   	local rotator myOldRotation;

   	if (localURL == "14_OCEANLAB_SILO")
   	{    
        		SpawnExtraEnemy(Class'BadDenton','PathNode87','mj12',-1.0,'Standing',,true);
        		SpawnExtraEnemy(Class'BadDenton','PathNode83','mj12',-1.0,'Standing',,true);
        		SpawnExtraEnemy(Class'BadDenton','PathNode98','mj12',-1.0,'Standing',,true);
        		SpawnExtraEnemy(Class'SecurityForce','PathNode18','mj12',-1.0,'Standing',,true);
        		SpawnExtraEnemy(Class'BadDenton','PathNode51','mj12',-1.0,'Standing',,true);
        		SpawnExtraEnemy(Class'MJ12Sergeant','PathNode131','mj12',-1.0,'Standing',,true);
        		SpawnExtraEnemy(Class'MJ12Sergeant','PathNode163','mj12',-1.0,'Standing',,true);
        		SpawnExtraEnemy(Class'MJ12Sergeant','PathNode130','mj12',-1.0,'Standing',,true);
        		SpawnExtraEnemy(Class'SecurityForce','PathNode22','mj12',-1.0,'Standing',,true);
        		SpawnExtraEnemy(Class'SecurityBot4','PathNode69','mj12',-1.0,'Standing');
        		SpawnExtraEnemy(Class'CleanerBot2','HidePoint65','mj12',-1.0);   
        		SpawnExtraEnemy(Class'MJ12Sergeant','PathNode140','mj12',-1.0,'Standing',,true);
        		SpawnExtraEnemy(Class'MJ12Sergeant','PathNode166','mj12',-1.0,'Standing',,true);
        		SpawnExtraEnemy(Class'MJ12Sergeant','PathNode169','mj12',-1.0,'Standing',,true);
        		SpawnExtraEnemy(Class'MJ12Sergeant','PathNode171','mj12',-1.0,'Standing',,true);
        		SpawnExtraEnemy(Class'CleanerBot2','PathNode144','mj12',-1.0);
        		SpawnExtraEnemy(Class'CleanerBot2','PathNode120','mj12',-1.0);
        		SpawnExtraEnemy(Class'CleanerBot2','PathNode121','mj12',-1.0);
        		SpawnExtraEnemy(Class'CleanerBot2','PathNode312','mj12',-1.0);
        		SpawnExtraEnemy(Class'CleanerBot2','PathNode145','mj12',-1.0);
        		SpawnExtraEnemy(Class'CleanerBot2','PathNode47','mj12',-1.0);
        		SpawnExtraEnemy(Class'CleanerBot2','PathNode41','mj12',-1.0);
        		SpawnExtraEnemy(Class'CleanerBot2','PathNode40','mj12',-1.0);

        		for ( P=Level.PawnList; P!=None; P=P.NextPawn )
        		{
              			if (P.IsA('HowardStrong'))
              			{
                    			myOldLocation = P.Location;
                    			myOldRotation = P.Rotation;
                    			for ( N=Level.NavigationPointList; N!=None; N=N.NextNavigationPoint )
				{
                          				if ( N.Name == 'PathNode30' )
                                 					P.SetLocation(N.Location);
				}
                    			for ( M=Level.PawnList; M!=None; M=M.NextPawn )
				{
                          				if ( M.IsA('MIB') && (M.Name =='MIB5') )
                          				{
                                 					M.SetLocation(myOldLocation);
                                 					M.SetRotation(myOldRotation);
                                 					MIB(M).SetOrders('Standing');
                          				}
				}
              			}   
        		}           
   	}

   	else if (localURL == "14_OCEANLAB_LAB")
   	{
        		SpawnExtraEnemy(Class'Researcher','PathNode197','dogs',-1.0,'Standing',,true);
        		SpawnExtraEnemy(Class'Doberman','PathNode198','dogs',-1.0,'Standing',,true);
        		SpawnExtraEnemy(Class'Researcher','PathNode214','dogs',-1.0,'Standing',,true);
        		SpawnExtraEnemy(Class'Doberman','PathNode215','dogs',-1.0,'Standing',,true);
        		SpawnExtraEnemy(Class'Researcher','PathNode211','dogs',-1.0,'Standing',,true);
        		SpawnExtraEnemy(Class'Doberman','PathNode212','dogs',-1.0,'Standing',,true);
        		SpawnExtraEnemy(Class'CleanerBot2','PathNode68','dogs',-1.0);
        		SpawnExtraEnemy(Class'CleanerBot2','PathNode189','dogs',-1.0);
        		SpawnExtraEnemy(Class'CleanerBot2','PathNode190','dogs',-1.0);
   	}

   	else if (localURL == "14_OCEANLAB_UC")
   	{
        		SpawnExtraEnemy(Class'Researcher','PathNode90','dog',-1.0,,,true);
        		SpawnExtraEnemy(Class'Researcher','PathNode92','dog',-1.0,,,true);
        		SpawnExtraEnemy(Class'Researcher','PathNode94','dog',-1.0,'DefendPosition');
        		SpawnExtraEnemy(Class'Doberman','PathNode93','dogs',-1.0);
        		SpawnExtraEnemy(Class'Doberman','PathNode91','dogs',-1.0);
        		SpawnExtraEnemy(Class'SecurityBot4','PathNode42','bots',-1.0);
        		SpawnExtraEnemy(Class'SecurityBot4','PathNode50','bots',-1.0);
        		for ( P=Level.PawnList; P!=None; P=P.NextPawn )
        		{
              			if (P.IsA('SpiderBot'))
              			{
                  			SpiderBot(P).SetAlliance('bots');
                  			SpiderBot(P).ChangeAlly('bots', 1.0, true);
              			}
        		}
   	}

   	if (localURL == "14_VANDENBERG_SUB")
   	{
         		SpawnExtraEnemy(Class'MJ12Commando','PathNode288','mj12',-1.0);
         		SpawnExtraEnemy(Class'MJ12Commando','PathNode300','mj12',-1.0);
         		SpawnExtraEnemy(Class'MJ12Commando','PathNode295','mj12',-1.0);
         		SpawnExtraEnemy(Class'MJ12Commando','PathNode319','mj12',-1.0,'Standing');
         		SpawnExtraEnemy(Class'MJ12Sergeant','PathNode122','mj12',-1.0,'Standing',,true);
         		SpawnExtraEnemy(Class'MJ12Sergeant','PathNode249','mj12',-1.0,,,true);
         		SpawnExtraEnemy(Class'MJ12Sergeant','PathNode258','mj12',-1.0,,,true);
         		SpawnExtraEnemy(Class'MJ12Sergeant','PathNode56','mj12',-1.0,,,true);
         		SpawnExtraEnemy(Class'MJ12Sergeant','PathNode118','mj12',-1.0,,,true);
         		SpawnExtraEnemy(Class'Researcher','PathNode106','research',-1.0);
         		SpawnExtraEnemy(Class'Researcher','PathNode269','research',-1.0);
         		SpawnExtraEnemy(Class'Researcher','PathNode229','research',-1.0);
         		SpawnExtraEnemy(Class'Researcher','PathNode105','research',-1.0);
         		SpawnExtraEnemy(Class'Researcher','PathNode186','research',-1.0,'Standing');
         		SpawnExtraEnemy(Class'Researcher','PathNode250','research',-1.0);
         		SpawnExtraEnemy(Class'Researcher','PathNode251','research',-1.0);
         		SpawnExtraEnemy(Class'Researcher','PathNode33','research',-1.0);
         		SpawnExtraEnemy(Class'SecurityBot4','PathNode50','mj12',-1.0,'Standing');
    	}
}

function SuperSurprise()
{
      	local Pawn P;

      	if (localURL == "14_OCEANLAB_UC")  
      	{
          		SpawnExtraEnemy(Class'BadDenton','PathNode8','bots',-1.0,'Attacking',,true);  
          		SpawnExtraEnemy(Class'BadDenton','PathNode6','bots',-1.0,'Attacking',,true); 
          		for ( P=Level.PawnList; P!=None; P=P.NextPawn )
                			if (P.IsA('BadDenton'))
                    			AddInventory(BadDenton(P), "DeusEx.WeaponAssaultShotgun");   
      	}
}

// ----------------------------------------------------------------------
// ----------------------------------------------------------------------

defaultproperties
{
     WeaponClasses(0)="DeusEx.WeaponFlamethrower"
     WeaponClasses(1)="DeusEx.WeaponGEPGun"
     WeaponClasses(2)="DeusEx.WeaponAssaultShotgun"
     WeaponClasses(3)="DeusEx.WeaponPlasmaRifle"
     WeaponClasses(4)="DeusEx.WeaponRifle"
     WeaponClasses(5)="DeusEx.WeaponAssaultGun"
     WeaponClasses(6)="DeusEx.WeaponSawedOffShotgun"
     WeaponClasses(7)="DeusEx.WeaponPistol"
     WeaponClasses(8)="DeusEx.WeaponHideAGun"
     WeaponClasses(9)="DeusEx.WeaponLAW"
}
