//=============================================================================
// MissionScript.
//=============================================================================
class MissionScript extends Info
	transient
	abstract;

//
// State machine for each mission
// All flags set by this mission controller script should be
// prefixed with MS_ for consistency
//

var float checkTime;
var DeusExPlayer Player;
var FlagBase flags;
var string localURL;
var DeusExLevelInfo dxInfo;
var() string WeaponClasses[15];  // weapons available for NPCs in current mission
var() class<inventory> InCrates[20];

// ----------------------------------------------------------------------
// PostPostBeginPlay()
//
// Set the timer
// ----------------------------------------------------------------------

function PostPostBeginPlay()
{
	// start the script
	SetTimer(checkTime, True);
}

// ----------------------------------------------------------------------
// InitStateMachine()
//
// Get the player's flag base, get the map name, and set the player
// ----------------------------------------------------------------------

function InitStateMachine()
{
	local DeusExLevelInfo info;

	Player = DeusExPlayer(GetPlayerPawn());

	foreach AllActors(class'DeusExLevelInfo', info)
		dxInfo = info;

	if (Player != None)
	{
		flags = Player.FlagBase;

		// Get the mission number by extracting it from the
		// DeusExLevelInfo and then delete any expired flags.
		//
		// Also set the default mission expiration so flags
		// expire in the next mission unless explicitly set
		// differently when the flag is created.

		if (flags != None)
		{
			// Don't delete expired flags if we just loaded
			// a savegame
			if (flags.GetBool('PlayerTraveling'))
				flags.DeleteExpiredFlags(dxInfo.MissionNumber);

			flags.SetDefaultExpiration(dxInfo.MissionNumber + 1);

			localURL = Caps(dxInfo.mapName);

			log("**** InitStateMachine() -"@player@"started mission state machine for"@localURL);
		}
		else
		{
			log("**** InitStateMachine() - flagBase not set - mission state machine NOT initialized!");
		}
	}
	else
	{
		log("**** InitStateMachine() - player not set - mission state machine NOT initialized!");
	}
}

// ----------------------------------------------------------------------
// FirstFrame()
// 
// Stuff to check at first frame
// ----------------------------------------------------------------------

function FirstFrame()
{
	local name flagName;
        local name HejhujkaFlag;
        local Pawn L;
	local ScriptedPawn P;
	local int i;

	flags.DeleteFlag('PlayerTraveling', FLAG_Bool);
       
        // Difficulty stuffs
        HejhujkaFlag = Player.rootWindow.StringToName("M"$Caps(dxInfo.mapName)$"_HejhujkaDifficulty");
        if (!flags.GetBool(HejhujkaFlag) && (dxInfo.mapName != "")) // && (Level.Game.Difficulty > 1))
        {
                Surprise();
                RandomizeInventory();
                flags.SetBool(HejhujkaFlag, True);
        }        		       

	// Check to see which NPCs should be dead from prevous missions
        	for ( L=Level.PawnList; L!=None; L=L.NextPawn )
	{
                		P = ScriptedPawn(L);
		if ((P != None) && P.bImportant)
		{
			flagName = Player.rootWindow.StringToName(P.BindName$"_Dead");
			if (flags.GetBool(flagName))
				P.Destroy();
		}
	}

	// print the mission startup text only once per map
	flagName = Player.rootWindow.StringToName("M"$Caps(dxInfo.mapName)$"_StartupText");
	if (!flags.GetBool(flagName) && (dxInfo.startupMessage[0] != ""))
	{
		for (i=0; i<ArrayCount(dxInfo.startupMessage); i++)
			DeusExRootWindow(Player.rootWindow).hud.startDisplay.AddMessage(dxInfo.startupMessage[i]);
		DeusExRootWindow(Player.rootWindow).hud.startDisplay.StartMessage();
                		flags.SetBool(flagName, True);
	}

	flagName = Player.rootWindow.StringToName("M"$dxInfo.MissionNumber$"MissionStart");
	if (!flags.GetBool(flagName))
	{
		// Remove completed Primary goals and all Secondary goals
		Player.ResetGoals();

		// Remove any Conversation History.
		Player.ResetConversationHistory();
                
                		// Set this flag so we only get in here once per mission.
		flags.SetBool(flagName, True);
	}
}

// ----------------------------------------------------------------------
// PreTravel()
// 
// Set flags upon exit of a certain map
// ----------------------------------------------------------------------

function PreTravel()
{
	// turn off the timer
	SetTimer(0, False);

	// zero the flags so FirstFrame() gets executed at load
	flags = None;
}

// ----------------------------------------------------------------------
// Timer()
//
// Main state machine for the mission
// ----------------------------------------------------------------------

function Timer()
{
	// make sure our flags are initialized correctly
	if (flags == None)
	{
		InitStateMachine();

		// Don't want to do this if the user just loaded a savegame
		if ((player != None) && (flags.GetBool('PlayerTraveling')))
			FirstFrame();
	}
}

// ----------------------------------------------------------------------
// GetPatrolPoint()
// ----------------------------------------------------------------------

function PatrolPoint GetPatrolPoint(Name patrolTag, optional bool bRandom)
{
	local PatrolPoint aPoint;

	aPoint = None;

	foreach AllActors(class'PatrolPoint', aPoint, patrolTag)
	{
		if (bRandom && (FRand() < 0.5))
			break;
		else
			break;
	}

	return aPoint;
}

// ----------------------------------------------------------------------
// GetSpawnPoint()
// ----------------------------------------------------------------------

function SpawnPoint GetSpawnPoint(Name spawnTag, optional bool bRandom)
{
	local SpawnPoint aPoint;

	aPoint = None;

	foreach AllActors(class'SpawnPoint', aPoint, spawnTag)
	{
		if (bRandom && (FRand() < 0.5))
			break;
		else
			break;
	}

	return aPoint;
}

// ----------------------------------------------------------------------
// RandomizeInventory()
// ----------------------------------------------------------------------

function Clear(); // remove denied actors, etc.
function Surprise(); // used to create changes on maps for current mission
function RandomizeInventory(); // used to rendomize NPC's inventory
function SuperSurprise();

function AddInventory(ScriptedPawn myPawn, string aClassName )
{
	local class<Weapon> WeaponClass;
	local Weapon NewWeapon;

	WeaponClass = class<Weapon>(DynamicLoadObject(aClassName, class'Class'));

        	if( myPawn.FindInventoryType(WeaponClass) != None )
        	{
                		log(WeaponClass$" not allowed twice!"); 
		return;
        	}
	newWeapon = myPawn.Spawn(WeaponClass,myPawn);
	if( newWeapon != None )
	{
                		newWeapon.InitialState='Idle2';
                		newWeapon.PickupAmmoCount = newWeapon.Default.PickupAmmoCount*24;
		newWeapon.GiveTo(myPawn);
		newWeapon.GiveAmmo(myPawn);
                		newWeapon.SetBase(myPawn);
                		if ( newWeapon.IsA('WeaponAssaultGun') )
                		{
                     		GiveExtraAmmo(myPawn, "DeusEx.Ammo20mm", 2); 
                     		WeaponAssaultGun(newWeapon).GiveAltAmmo(myPawn);
                     		WeaponAssaultGun(newWeapon).bHas20mm = True;  
                		}
                		myPawn.SetupWeapon(false);
	}
}

function GiveExtraAmmo(ScriptedPawn myPawn, string aClassName, optional int AmmoCount )
{
	local class<Ammo> AmmoClass;
	local Ammo NewAmmo;
        	local int i;

        	if ( AmmoCount == 0 )
                		AmmoCount = 1;
       
        	AmmoClass = class<Ammo>(DynamicLoadObject(aClassName, class'Class'));

        	for (i=0; i<AmmoCount; i++)
        	{
         		newAmmo = myPawn.Spawn(AmmoClass,myPawn);
	        	if ( newAmmo != None )
	        	{
                      		newAmmo.InitialState='Idle2';
                      		newAmmo.GiveTo(myPawn);
	              		newAmmo.SetBase(myPawn);
	        	}
        	}
}       

//
// spawn an extra NPC at the specified navigation point, set orders, alliances and conversation events for this NPC
//
function SpawnExtraEnemy(class<ScriptedPawn> myClass, Name spawnName, Name Alliance, float allyLevel, 
                         optional Name Orders, optional bool bReverse, optional bool bWeapon, optional String BindName, optional Name myTag)
{
        	local NavigationPoint N, D;
        	local ScriptedPawn sp;
   
        	for ( N=Level.NavigationPointList; N!=None; N=N.NextNavigationPoint )
        	{
              		if ( N.Name == spawnName ) 
              		{
                    		sp = Spawn(myClass,,,N.Location+40*vect(0,0,1),N.Rotation);
                    		if ( sp != None )
                    		{
                            			sp.SetAlliance(Alliance);
                            			sp.ChangeAlly(Alliance, 1.0, true);
                            			if (bReverse)
                                  				sp.ChangeAlly(Player.Alliance, allyLevel, false);
                            			else
                                  				sp.ChangeAlly(Player.Alliance, allyLevel, true);
                            			if ( Orders != '' ) 
                            			{
					if ( sp.IsA('HumanMilitary') && (Orders == 'DefendPosition') )
					{
						D = N;
						HumanMilitary(sp).DefendPoint = D;
						HumanMilitary(sp).bDefendPosition = True;
						HumanMilitary(sp).SetOrders('Standing');
						//log(sp$" DefendPoint is "$D);
					}
					else
					{
                                  					sp.SetOrders(Orders);
					}
                                  				if ( sp.Orders == 'Standing' )
                                         				sp.SetHomeBase(N.Location + 20 * VRand(), N.Rotation);
                            			}
                            			if ( bWeapon )
                                  				sp.bKeepWeaponDrawn = True;
                            			if ( BindName != "" ) 
                            			{
                                  				sp.BindName = BindName;
                                  				sp.ConBindEvents();
                            			}
                            			else
                                  				sp.BindName = sp.Default.BindName;
                            			if ( myTag != '' )
                                  				sp.Tag = myTag;
                    		}
              		}          
        	}
}  

function SpawnExtraActor(class<Actor> myClass, Name spawnName)
{
        	local NavigationPoint N;
        	local Actor a;
   
        	for ( N=Level.NavigationPointList; N!=None; N=N.NextNavigationPoint )
               		if ( N.Name == spawnName ) 
                     		a = Spawn(myClass,,,N.Location+40*vect(0,0,1),N.Rotation);
}

//----------------------------------------------------------------------
//----------------------------------------------------------------------

defaultproperties
{
     checkTime=1.000000
     localURL="NOTHING"
}
