//=============================================================================
// NanoEmitter.
//=============================================================================
class NanoEmitter extends ElectricityEmitter;

var Name DamageType;
var Name AltDamageType;

function CalcTrace(float deltaTime)
{
	local vector StartTrace, EndTrace, HitLocation, HitNormal, loc;
	local Rotator rot;
	local actor target;
	local int texFlags;
	local name texName, texGroup;

	if (!bHiddenBeam)
	{
		// set up the random beam stuff
		rot.Pitch = Int((0.5 - FRand()) * randomAngle);
		rot.Yaw = Int((0.5 - FRand()) * randomAngle);
		rot.Roll = Int((0.5 - FRand()) * randomAngle);

		StartTrace = Location;
		EndTrace = Location + 5000 * vector(Rotation + rot);
		HitActor = None;

		foreach TraceTexture(class'Actor', target, texName, texGroup, texFlags, HitLocation, HitNormal, EndTrace, StartTrace)
		{
			if ((target.DrawType == DT_None) || target.bHidden)
			{
				// do nothing - keep on tracing
			}
			else if ((target == Level) || target.IsA('Mover'))
			{
				break;
			}
			else
			{
				HitActor = target;
				break;
			}
		}

		lastDamageTime += deltaTime;

		// shock whatever gets in the beam
		if ((HitActor != None) && (lastDamageTime >= damageTime))
		{
			HitActor.TakeDamage(damageAmount, Instigator, HitLocation, vect(0,0,0), DamageType);
			HitActor.TakeDamage(damageAmount, Instigator, HitLocation, vect(0,0,0), AltDamageType);
			lastDamageTime = 0;
		}

		if (LaserIterator(RenderInterface) != None)
			LaserIterator(RenderInterface).AddBeam(0, Location, Rotation + rot, VSize(Location - HitLocation));
	}
}

defaultproperties
{
     DamageType=KnockedOut
     AltDamageType=EMP
     randomAngle=1024.000000
     damageTime=0.100000
     beamTexture=FireTexture'Effects.Electricity.BioCell_SFX'
     bFlicker=False
     SoundRadius=128
     SoundVolume=255
}
