//=============================================================================
// NanoKeyRing
//
// NanoKeyRing object.  In order to make things easier
// on the player, when the player picks up a key it's added 
// to the list of keys stored in the keyring
//=============================================================================

class NanoKeyRing extends SkilledTool;

var localized string NoKeys;
var localized string KeysAvailableLabel;
var() vector FireOffset;
var Rotator AdjustedAim;
var localized String StrDogPatrol;
var localized String StrDogSupport;

// ----------------------------------------------------------------------
// Networking Replication
// ----------------------------------------------------------------------

replication
{
   //server to client function calls
   reliable if (Role == ROLE_Authority)
      GiveClientKey, RemoveClientKey, ClientRemoveAllKeys;
}

// ----------------------------------------------------------------------
// HasKey()
//
// Checks to see if we have the keyname passed in
// ----------------------------------------------------------------------

simulated function bool HasKey(Name KeyToLookFor)
{
	local NanoKeyInfo aKey;
	local Bool bHasKey;

	bHasKey = False;

	if (GetPlayer() != None)
	{
		aKey = GetPlayer().KeyList;

		// Loop through all the keys and see if one exists
		while(aKey != None)
		{
			if (aKey.KeyID == KeyToLookFor)
			{
				bHasKey = True;
				break;
			}

			aKey = aKey.NextKey;
		}
	}
	return bHasKey;
}

// ----------------------------------------------------------------------
// GiveKey()
//
// Adds a key to our array
// ----------------------------------------------------------------------

simulated function GiveKey(Name newKeyID, String newDescription)
{
	local NanoKeyInfo aKey;

	if (GetPlayer() != None)
	{
		// First check to see if the player already has this key
		if (HasKey(newKeyID))
			return;

		// Spawn a key
		aKey = GetPlayer().CreateNanoKeyInfo();

		// Set the appropriate fields and 
		// add to the beginning of our list
		aKey.KeyID       = newKeyID;
		aKey.Description = newDescription;
		aKey.NextKey     = GetPlayer().KeyList;
		GetPlayer().KeyList   = aKey;

	}
}

// ----------------------------------------------------------------------
// function GiveClientKey()
// ----------------------------------------------------------------------

simulated function GiveClientKey(Name newKeyID, String newDescription)
{
   GiveKey(newKeyID, newDescription);
}

// ----------------------------------------------------------------------
// RemoveKey()
// ----------------------------------------------------------------------

simulated function RemoveKey(Name KeyToRemove)
{
	local NanoKeyInfo aKey;
	local NanoKeyInfo lastKey;

	if (GetPlayer() != None)
	{
		aKey = GetPlayer().KeyList;
			
		// Loop through all the keys and see if one exists
		while(aKey != None)
		{
			if (aKey.KeyID == KeyToRemove)
			{
				if (lastKey != None)
					lastKey.NextKey = aKey.NextKey;

				if (GetPlayer().KeyList == aKey)
					GetPlayer().KeyList = aKey.NextKey;

				CriticalDelete(aKey);
				aKey = None;

				break;
			}
			
			lastKey = aKey;
			aKey    = aKey.NextKey;
		}
	}
}

// ----------------------------------------------------------------------
// function RemoveClientKey()
// ----------------------------------------------------------------------

simulated function RemoveClientKey(Name KeyToRemove)
{
   RemoveKey(KeyToRemove);
}

// ----------------------------------------------------------------------
// RemoveAllKeys()
// ----------------------------------------------------------------------

simulated function RemoveAllKeys()
{
	local NanoKeyInfo aKey;
	local NanoKeyInfo deadKey;
	
	if (GetPlayer() != None)
	{
		aKey = GetPlayer().KeyList;

		// Loop through all the keys and see if one exists
		while(aKey != None)
		{
			deadKey = aKey;

			CriticalDelete(aKey);
			aKey = None;

			aKey = deadKey.NextKey;
		}

		GetPlayer().KeyList = None;
	}
}

// ----------------------------------------------------------------------
// ClientRemoveAllKeys()
// ----------------------------------------------------------------------

simulated function ClientRemoveAllKeys()
{ 
   RemoveAllKeys();
}

// ----------------------------------------------------------------------
// UpdateInfo()
// ----------------------------------------------------------------------

simulated function bool UpdateInfo(Object winObject)
{
	local PersonaInfoWindow winInfo;
	local NanoKeyInfo keyInfo;
	local int keyCount;

	winInfo = PersonaInfoWindow(winObject);
	if (winInfo == None)
		return False;

	winInfo.SetTitle(itemName);
	winInfo.SetText(KeysAvailableLabel);
	winInfo.AddLine();

	if (GetPlayer() != None)
	{
		keyInfo = GetPlayer().KeyList;

		if (keyInfo != None)
		{
			while(keyInfo != None)
			{
				winInfo.SetText("  " $ keyInfo.Description);
				keyInfo = keyInfo.NextKey;
				keyCount++;
			}
		}
	}

	if (keyCount > 0)
	{
		winInfo.AddLine();
		winInfo.SetText(Description);
	}
	else
	{
		winInfo.Clear();
		winInfo.SetTitle(itemName);
		winInfo.SetText(NoKeys);
	}

	return True;
}

// ----------------------------------------------------------------------
// GetPlayer()
// ----------------------------------------------------------------------

simulated function DeusExPlayer GetPlayer()
{
	return DeusExPlayer(Owner);
}

// ----------------------------------------------------------------------
// GetKeyCount()
// ----------------------------------------------------------------------

simulated function int GetKeyCount()
{
	local int keyCount;
	local NanoKeyInfo aKey;

	if (GetPlayer() != None)
	{
		aKey = GetPlayer().KeyList;

		// Loop through all the keys and see if one exists
		while(aKey != None)
		{
			keyCount++;
			aKey = aKey.NextKey;
		}
	}

	return keyCount;
}

// ----------------------------------------------------------------------
// ----------------------------------------------------------------------
state UseIt
{
	function PutDown()
	{
		
	}

Begin:
	PlaySound(useSound, SLOT_None);
	PlayAnim('UseBegin',, 0.1);
	FinishAnim();
	LoopAnim('UseLoop',, 0.1);
	GotoState('StopIt');
}

// ----------------------------------------------------------------------
// ----------------------------------------------------------------------
state StopIt
{
	function PutDown()
	{
		
	}

Begin:
	PlayAnim('UseEnd',, 0.1);
	GotoState('Idle', 'DontPlaySelect');
}

// ----------------------------------------------------------------------
// ----------------------------------------------------------------------

function BringUp()
{
    	local Inventory pick, tool;

    	Super.BringUp();
    	/*if ( (Owner != None) && Owner.IsA('DeusExPlayer') )
    	{
          		tool = DeusExPlayer(Owner).FindInventoryType(Class'Multitool');
          		if (tool != None)
              			DeusExPlayer(Owner).ClientMessage("Hack uses: "$Multitool(tool).NumCopies);
          		else
              			DeusExPlayer(Owner).ClientMessage("Hack uses: 0");

          		pick = DeusExPlayer(Owner).FindInventoryType(Class'Lockpick');
          		if (pick != None)
              			DeusExPlayer(Owner).ClientMessage("Lockpick uses: "$Lockpick(pick).NumCopies);
          		else
              			DeusExPlayer(Owner).ClientMessage("Lockpick uses: 0");
    	}*/
}

// ----------------------------------------------------------------------
// ----------------------------------------------------------------------

function bool CanHack()
{
   local Inventory tool;
   local DeusExPlayer player;

   player = DeusExPlayer(Owner);
   
   tool = player.FindInventoryType(Class'Multitool');
   if (tool != None)
   {
       Multitool(tool).numCopies--;
       if (Multitool(tool).NumCopies <= 0)
           player.DeleteInventory(tool);
       return true;
   }
   else
       return false;
}

// ----------------------------------------------------------------------
// ----------------------------------------------------------------------

function bool CanPick()
{
   local Inventory pick;
   local DeusExPlayer player;

   player = DeusExPlayer(Owner);
   
   pick = player.FindInventoryType(Class'Lockpick');
   if (pick != None)
   {
       Lockpick(pick).numCopies--;
       if (Lockpick(pick).NumCopies <= 0)
           player.DeleteInventory(pick);
       return true;
   }
   else
       return false;
}

// ----------------------------------------------------------------------
// ----------------------------------------------------------------------
function AltFire(float Value)
{
     if (IsInState('Idle'))
     {
         GotoState('AltFiring');
         TraceFire(0.0);
     }
}

// ----------------------------------------------------------------------
// ----------------------------------------------------------------------

function TraceFire( float Accuracy )
{
	local vector HitLocation, HitNormal, StartTrace, EndTrace, X,Y,Z;
	local actor Other;
	local Pawn PawnOwner;

	PawnOwner = Pawn(Owner);

	Owner.MakeNoise(PawnOwner.SoundDampening*0.1);
        	GetAxes(PawnOwner.ViewRotation,X,Y,Z);
	StartTrace = Owner.Location + CalcDrawOffset() + FireOffset.X * X + FireOffset.Y * Y + FireOffset.Z * Z; 
	AdjustedAim = PawnOwner.AdjustAim(1000000, StartTrace, 100, False, False);	
	EndTrace = StartTrace + Accuracy * (FRand() - 0.5 )* Y * 1000
		+ Accuracy * (FRand() - 0.5 ) * Z * 1000;
	X = vector(AdjustedAim);
	EndTrace += (80 * X); 
	Other = PawnOwner.TraceShot(HitLocation,HitNormal,EndTrace,StartTrace);
	ProcessTraceHit(Other, HitLocation, HitNormal, X,Y,Z);
} 

// ----------------------------------------------------------------------
// ----------------------------------------------------------------------

function ProcessTraceHit(Actor Other, Vector HitLocation, Vector HitNormal, Vector X, Vector Y, Vector Z)
{
	if (Other != None)
	{	
		if ((Other != self) && (Other != Owner))
		{
		     	if ( Role == ROLE_Authority )
			{
				if ( Other.IsA('CyborgDog') )
					SwitchDogOrders(CyborgDog(Other));
				else
                           				Other.TakeDamage(25, Pawn(Owner), HitLocation, 500.0*X, 'KnockedOut');
			}
                	}
	}
} 

// ----------------------------------------------------------------------
// ----------------------------------------------------------------------

simulated function SwitchDogOrders(CyborgDog Dog)
{
	if ( Dog == None )
		return;

	if ( Dog.IsInState('Following') )
	{
		Dog.SetOrders('Wandering', '', True);
		Pawn(Owner).ClientMessage(StrDogPatrol);
		PlaySound(Sound'Beep3');
		return;
	}
	if ( Dog.IsInState('Wandering') )
	{
		Dog.SetOrders('Following', '', True);
		Pawn(Owner).ClientMessage(StrDogSupport);
		PlaySound(Sound'Beep3');
	}
}

// ----------------------------------------------------------------------
// ----------------------------------------------------------------------

state AltFiring
{
        function PutDown()
        {	
        }
Begin:
        PlaySound(Sound'BulletProofHit', SLOT_None);
	PlayAnim('UseBegin',2.0, 0.01);
	FinishAnim();
        PlayAnim('UseEnd',, 0.1);
	GotoState('Idle', 'DontPlaySelect');
}       

// ----------------------------------------------------------------------
// ----------------------------------------------------------------------

defaultproperties
{
     NoKeys="No Nano Keys Available!"
     KeysAvailableLabel="Nano Keys Available:"
     FireOffset=(X=-16.000000,Y=-15.000000,Z=16.000000)
     StrDogPatrol="Cyborg Dog orders: Patroling"
     StrDogSupport="Cyborg Dog orders: Supporting"
     UseSound=Sound'DeusExSounds.Generic.KeysRattling'
     bDisplayableInv=False
     ItemName="Nanokey Ring"
     ItemArticle="the"
     PlayerViewOffset=(X=16.000000,Y=15.000000,Z=-16.000000)
     PlayerViewMesh=LodMesh'DeusExItems.NanoKeyRingPOV'
     PickupViewMesh=LodMesh'DeusExItems.NanoKeyRing'
     ThirdPersonMesh=LodMesh'DeusExItems.NanoKeyRing'
     Icon=Texture'DeusExUI.Icons.BeltIconNanoKeyRing'
     largeIcon=Texture'DeusExUI.Icons.LargeIconNanoKeyRing'
     largeIconWidth=47
     largeIconHeight=44
     Description="A nanokey ring can read and store the two-dimensional molecular patterns from different nanokeys, and then recreate those patterns on demand. The nanokey ring also use the command frequencies used by CD-01 cyborg dogs by switching the dog's supporting mode."
     beltDescription="KEY RING"
     bHidden=True
     Mesh=LodMesh'DeusExItems.NanoKeyRing'
     CollisionRadius=5.510000
     CollisionHeight=4.690000
     Mass=10.000000
     Buoyancy=5.000000
}
