//=============================================================================
// NanoSword.
//=============================================================================
class NanoSword extends DeusExProjectile;

var bool bSpawned;

function PostBeginPlay()
{
	Super.PostBeginPlay();
        	SetTimer(1.0,false);
}

function Timer()
{
         	bSpawned = True;
         	Target = Instigator;
         	bTracking = True;
}

function Frob(Actor Frobber, Inventory frobWith)
{
	 GrabProjectile(DeusExPlayer(Frobber));
}

function GrabProjectile(DeusExPlayer player)
{
	local Inventory item;

	if (player != None)
	{
		if (spawnWeaponClass != None)		
			item = Spawn(spawnWeaponClass);
		if (item != None)
		{
			player.FrobTarget = item;
			if (player.HandleItemPickup(item))
			{
				Destroy();				
				player.GetNanoSword();
			}
			else
				item.Destroy();			
			player.FrobTarget = None;
		}
	}
}

simulated function SpawnEffects(Vector HitLocation, Vector HitNormal, Actor Other)
{
	local int i;
	local DeusExDecal mark;
        
  	if (DeusExMover(Other) != None)
		if (DeusExMover(Other).bDestroyed)
			ExplosionDecal = None;

	if (ExplosionDecal != None)
	{
		mark = DeusExDecal(Spawn(ExplosionDecal, Self,, HitLocation, Rotator(HitNormal)));
		if (mark != None)
		{
			mark.DrawScale = 0.3;
			mark.ReattachDecal();
		}

		ExplosionDecal = None;
	}
        	SpawnComets(HitLocation);
}

simulated function SpawnComets(Vector HitLocation)
{
    	local int i;
    	local FireComet c;
  
    	for ( i=0; i<5; i++ )
    	{
         		c = Spawn(class'FireComet', Self,, HitLocation);
         		if (c != None)
         		{
             			c.Skin = Texture'Effects.Electricity.Nano_SFX';
             			c.DrawScale = 0.25;
             			c.bNoDecal = True;
             			c.RemoteRole = ROLE_None;
         		}
    	}
}

auto simulated state Flying
{
	simulated function ProcessTouch (Actor Other, Vector HitLocation)
	{
		if ( (Other != instigator) && (DeusExProjectile(Other) == None) &&
			(Other != Owner) )
		{
			damagee = Other;
			damagee.TakeDamage(Damage, Pawn(Owner), HitLocation, MomentumTransfer*Normal(Velocity), damageType);
                        		PlayImpactSound();
                        		MakeNoise(0.5);
                        		if (Role == ROLE_Authority)
			{
                            			if ( damagee.IsA('Pawn') && !damagee.IsA('Robot') && !damagee.IsA('CyborgDog') && !damagee.IsA('HoloDenton') && bBlood )
                                				SpawnBlood(HitLocation, Normal(HitLocation-damagee.Location));
                            			SpawnComets(HitLocation);
			}
		}

                		else if ( (Other == instigator) && bSpawned )
                		{
                     		if ( Instigator.IsA('DeusExPlayer') )
                          			Frob(Other, None);
                     		else
                          			Destroy(); 
                		}
	}

	simulated function HitWall (vector HitNormal, actor Wall)
	{
		local vector Vel2D, Norm2D;

		PlayImpactSound();
                		MakeNoise(0.5);
                		SpawnEffects(Location, HitNormal, Wall);               
		Vel2D = Velocity;
		Vel2D.Z = 0;
		Norm2D = HitNormal;
		Norm2D.Z = 0;
		Norm2D = Normal(Norm2D);
		Vel2D = Normal(Vel2D);
		if ( (Vel2D Dot Norm2D) < -0.999 )
		{
			HitNormal = Normal(HitNormal + 0.6 * Vel2D);
			Norm2D = HitNormal;
			Norm2D.Z = 0;
			Norm2D = Normal(Norm2D);
			if ( (Vel2D Dot Norm2D) < -0.999 )
			{
				if ( Rand(1) == 0 )
					HitNormal = HitNormal + vect(0.05,0,0);
				else
					HitNormal = HitNormal - vect(0.05,0,0);
				if ( Rand(1) == 0 )
					HitNormal = HitNormal + vect(0,0.05,0);
				else
					HitNormal = HitNormal - vect(0,0.05,0);
				HitNormal = Normal(HitNormal);
			}
		}
	
	        	Velocity -= 2 * (Velocity dot HitNormal) * HitNormal;  
	        	SetRoll(Velocity);
	}

        	simulated function SetRoll(vector NewVelocity) 
	{
		local rotator newRot;	
	
		newRot = rotator(NewVelocity);	
		SetRotation(newRot);	
	}

        	simulated function BeginState()
	{
		Super.BeginState();
                		RandSpin(100000);
	}
}

defaultproperties
{
     bBlood=True
     DamageType=shot
     AccurateRange=28800
     maxRange=28800
     spawnWeaponClass=Class'DeusEx.WeaponNanoSword'
     bIgnoresNanoDefense=True
     ItemName="Nano Sword"
     ItemArticle="a"
     speed=1500.000000
     MaxSpeed=1500.000000
     Damage=125.000000
     MomentumTransfer=1000
     ImpactSound=Sound'DeusExSounds.Weapons.NanoSwordHitHard'
     ExplosionDecal=Class'DeusEx.ScorchMark'
     LifeSpan=0.000000
     Mesh=LodMesh'DeusExItems.NanoSwordPickup'
     LightType=LT_Steady
     LightEffect=LE_WateryShimmer
     LightBrightness=224
     LightHue=160
     LightSaturation=64
     LightRadius=4
     bBounce=True
     RotationRate=(Pitch=0,Yaw=64384)
}
