//=============================================================================
// NapalmCannister.
//=============================================================================
class NapalmCannister extends DeusExProjectile;

var bool bCanHitOwner;
var bool bExploded;
var ParticleGenerator smokeGen;
var float mpBlastRadius;

simulated function PreBeginPlay()
{
	Super.PreBeginPlay();

	if ( ((Level.Game != None) && Level.Game.bDeathMatch) || (Level.NetMode != NM_Standalone) )
		blastRadius = mpBlastRadius;
}

simulated function PostBeginPlay()
{
	Super.PostBeginPlay();

   	SetTimer(2.0+FRand()*0.5,false);

   	bCanHitOwner = False;
   	bExploded = False;

   	if (Level.NetMode != NM_DedicatedServer)    
            		SpawnSmokeEffects();
}

simulated function PostNetBeginPlay()
{
   	Super.PostNetBeginPlay();
   
   	if (Role != ROLE_Authority)
      		SpawnSmokeEffects();
}

simulated function SpawnSmokeEffects()
{
	smokeGen = Spawn(class'ParticleGenerator', Self);
	if (smokeGen != None)
	{
		smokeGen.particleTexture = Texture'Effects.Smoke.SmokePuff1';
		smokeGen.particleDrawScale = 0.1;
		smokeGen.checkTime = 0.02;
		smokeGen.riseRate = 8.0;
		smokeGen.ejectSpeed = 0.0;
		smokeGen.particleLifeSpan = 1.5;
		smokeGen.bRandomEject = True;
		smokeGen.SetBase(Self);
                		smokeGen.RemoteRole = ROLE_None;
	}
}

simulated function Destroyed()
{
	if (smokeGen != None)
		smokeGen.DelayedDestroy();

	Super.Destroyed();
}

simulated function Timer()
{
	Explode(Location, Location);
}

auto simulated state Flying
{
	simulated function ProcessTouch (Actor Other, Vector HitLocation)
	{
		if (bStuck)
			return;

		if ((Other != instigator) && (Other != Owner) && (DeusExProjectile(Other) == None) || bCanHitOwner)
		{
			damagee = Other;
                        		Explode(HitLocation, Normal(HitLocation-damagee.Location));
			if (Role == ROLE_Authority)
			{
            				if (damagee.IsA('Pawn') && !damagee.IsA('Robot') && !damagee.IsA('CyborgDog') && !damagee.IsA('HoloDenton') && bBlood)
               					SpawnBlood(HitLocation, Normal(HitLocation-damagee.Location));
			}
		}
	}

	simulated function HitWall(vector HitNormal, actor Wall)
	{
		bCanHitOwner = True;
	        	Velocity = 0.75*(( Velocity dot HitNormal ) * HitNormal * (-2.0) + Velocity);   // Reflect off Wall w/damping
	        	RandSpin(100000);
	        	speed = VSize(Velocity);
	        	if ( Level.NetMode != NM_DedicatedServer )
		     	PlaySound(MiscSound, SLOT_Misc, 3.0 );
                		MakeNoise(1.0);
	        	if ( Velocity.Z > 400 )
			Velocity.Z = 0.5 * (400 + Velocity.Z);	
	        	else if ( speed < 20 ) 
	        	{
		    	bBounce = False;
		    	SetPhysics(PHYS_None);
	        	}

		if (Wall.IsA('BreakableGlass'))
			bDebris = False;
                		if (bExploded)
			SpawnEffects(Location, HitNormal, Wall);
	}

	simulated function Explode(vector HitLocation, vector HitNormal)
	{
		local bool bDestroy;
		local float rad;

		bDestroy = false;

		if (bExplodes)
		{
                        		//SpawnEffects(HitLocation, HitNormal, None);
                        		bExploded = True;
			if ((Level.NetMode != NM_DedicatedServer) || (Role < ROLE_Authority))
				DrawExplosionEffects(HitLocation, HitNormal);
                        		GotoState('Exploding');
		}
		else
		{
			if ( Role == ROLE_Authority )
			{
				if (damagee != None)
					damagee.TakeDamage(Damage, Pawn(Owner), HitLocation, MomentumTransfer*Normal(Velocity), damageType);
			}
			if (!bStuck)
				bDestroy = true;
		}

		rad = Max(blastRadius*24, 1024);
		PlaySound(ImpactSound, SLOT_None, 2.0,, rad);
		if (Role == ROLE_Authority)
      		{
			if (ImpactSound != None)
			{
				AISendEvent('LoudNoise', EAITYPE_Audio, 2.0, blastRadius*24);
				if (bExplodes)
					AISendEvent('WeaponFire', EAITYPE_Audio, 2.0, blastRadius*5);
			}
		}

		if (bDestroy)
			Destroy();
	}

	simulated function BeginState()
	{
		local DeusExWeapon W;

		initLoc = Location;
		initDir = vector(Rotation);	
		Velocity = speed*initDir;
                		RandSpin(50000);
		PlaySound(SpawnSound, SLOT_None);
	}
}

simulated function Tick(float deltaTime)
{
	local Rotator rot;

	Super.Tick(deltaTime);

	if (Level.Netmode != NM_DedicatedServer)
	{
		rot = Rotation;
		rot.Pitch -= 16384;
		SetRotation(rot);
	}
}

defaultproperties
{
     mpBlastRadius=384.000000
     bExplodes=True
     bBlood=True
     blastRadius=512.000000
     DamageType=Flamed
     AccurateRange=400
     maxRange=800
     ItemName="Napalm Cannister"
     ItemArticle="a"
     speed=800.000000
     MaxSpeed=800.000000
     Damage=10.000000
     MomentumTransfer=150000
     SpawnSound=Sound'DeusExSounds.Weapons.AssaultGunFire20mm'
     ImpactSound=Sound'DeusExSounds.Generic.MediumExplosion2'
     MiscSound=Sound'DeusExSounds.Generic.GlassDrop'
     ExplosionDecal=Class'DeusEx.ScorchMark'
     Mesh=LodMesh'DeusExItems.AmmoNapalm'
     DrawScale=1.500000
     bBounce=True
}
