//=============================================================================
// OfficeChair.
//=============================================================================
class OfficeChair extends Seat;

enum ESkinColor
{
	SC_GrayLeather,
	SC_BrownLeather,
	SC_BrownCloth,
	SC_GrayCloth
};

var() ESkinColor SkinColor;
	var texture HDTPSkin;


//-----------------------------------
// Uses HDTP's models/textures if they exists ;) 
function prebeginplay()
{
     local mesh HDTPmesh;
     HDTPmesh = LODMesh(dynamicloadObject("HDTPDecos.HDTPOfficeChair",class'mesh', true));
     if(HDTPmesh != none)
     {
	        mesh = HDTPmesh;
     }
 super.prebeginplay();
}
//----------------------------------------


function BeginPlay()
{
	Super.BeginPlay();

	switch (SkinColor)
	{
		case SC_GrayLeather:	
									HDTPSkin = texture(dynamicloadObject("HDTPDecos.Skins.HDTPOfficeChairTex1",class'texture', true));
										If (HDTPSkin != none)
										Skin=HDTPSkin;
												else
													Skin = Texture'OfficeChairTex1';
													break;
		case SC_BrownLeather:	
									HDTPSkin = texture(dynamicloadObject("HDTPDecos.Skins.HDTPOfficeChairTex2",class'texture', true));
										If (HDTPSkin != none)
										Skin=HDTPSkin;
												else
													Skin = Texture'OfficeChairTex2';
													break;
		case SC_BrownCloth:		
									HDTPSkin = texture(dynamicloadObject("HDTPDecos.Skins.HDTPOfficeChairTex3",class'texture', true));
										If (HDTPSkin != none)
										Skin=HDTPSkin;
												else
													Skin = Texture'OfficeChairTex3';
													break;
		case SC_GrayCloth:		
									HDTPSkin = texture(dynamicloadObject("HDTPDecos.Skins.HDTPOfficeChairTex4",class'texture', true));
										If (HDTPSkin != none)
										Skin=HDTPSkin;
												else
													Skin = Texture'OfficeChairTex4';
													break;
	}
}

defaultproperties
{
     sitPoint(0)=(X=0.000000,Y=-4.000000,Z=0.000000)
     ItemName="Swivel Chair"
     Mesh=LodMesh'DeusExDeco.OfficeChair'
     CollisionRadius=16.000000
     CollisionHeight=25.549999
     Mass=30.000000
     Buoyancy=5.000000
}
