//=============================================================================
// PersonaNormalLargeTextWindow
//=============================================================================

class PersonaNormalLargeTextWindow extends LargeTextWindow;

#exec obj load file=AV_Fonts_RUS

var DeusExPlayer player;
var Font         fontText;

// ----------------------------------------------------------------------
// InitWindow()
//
// Initialize the Window
// ----------------------------------------------------------------------

event InitWindow()
{
	Super.InitWindow();

//	SetFont(fontText);

	player = DeusExPlayer(GetRootWindow().parentPawn);


	if (Player.bRussian)
  	  SetFont(Font'AV_Fonts_RUS.AV_FontSmall');
	else
  	  SetFont(font'FontMenuSmall');

	SetTextMargins(0, 0);
	SetTextAlignments(HALIGN_Left, VALIGN_Center);

	// Get a pointer to the player
//	player = DeusExPlayer(GetRootWindow().parentPawn);

	StyleChanged();
}

// ----------------------------------------------------------------------
// StyleChanged()
// ----------------------------------------------------------------------

event StyleChanged()
{
	local ColorTheme theme;
	local Color colText;

	theme = player.ThemeManager.GetCurrentHUDColorTheme();

	// Title colors
	colText = theme.GetColorFromName('HUDColor_NormalText');

	SetTextColor(colText);
}

// ----------------------------------------------------------------------
// ----------------------------------------------------------------------

defaultproperties
{
     fontText=Font'DeusExUI.FontMenuSmall'
}
