//=============================================================================
// PlasmaBall.
//=============================================================================
class PlasmaBall extends DeusExProjectile;

var float mpDamage;
var() Sound ExploSound;
var float Size;

simulated function PostBeginPlay()
{
	Super.PostBeginPlay();
	if ( Level.bDropDetail )
		LightType = LT_None;
}

simulated function SuperExplosion()
{
        	Size = 3.000000;
        	DrawExplosionEffects(Location, Location);
	HurtRadius(Damage*4, 512, MyDamageType, MomentumTransfer*2, Location );
	PlaySound(ExploSound,,20.0,,2000,0.6);	
	Destroy(); 
}

simulated function DrawExplosionEffects(vector HitLocation, vector HitNormal)
{
	local ExplosionLight light;
	local int i;
	local Rotator rot;
	local GreenSphere sphere;
        	local ExplosionSmall expeffect;

	light = Spawn(class'ExplosionLight',,, HitLocation);
	if (light != None)
	{
                		light.RemoteRole = ROLE_None;
		light.size = 2*Size;
		light.LightHue = 83;
		light.LightSaturation = 96;
		light.LightEffect = LE_Shell;
	}

	sphere = Spawn(class'GreenSphere',,, HitLocation);
	if (sphere != None)
        	{
                		sphere.RemoteRole = ROLE_None;
		sphere.size = (blastRadius / 64.0)*Size;
        	}
}

defaultproperties
{
     ExploSound=Sound'DeusExSounds.Robot.RobotExplode'
     size=1.000000
     bExplodes=True
     blastRadius=192.000000
     DamageType=Burned
     AccurateRange=24400
     maxRange=24400
     bIgnoresNanoDefense=True
     ItemName="Plasma Ball"
     ItemArticle="a"
     speed=1000.000000
     Damage=55.000000
     MomentumTransfer=70000
     MyDamageType=Burned
     ExplosionDecal=Class'DeusEx.ScorchMark'
     DrawType=DT_Sprite
     Style=STY_Translucent
     Texture=Texture'DeusEx.Effects.phit_a00'
     DrawScale=0.500000
     bUnlit=True
     CollisionRadius=12.000000
     CollisionHeight=12.000000
     bProjTarget=True
     LightType=LT_Steady
     LightEffect=LE_NonIncidence
     LightBrightness=200
     LightHue=80
     LightSaturation=128
     LightRadius=6
     bFixedRotationDir=True
     RotationRate=(Pitch=45345,Yaw=33453,Roll=63466)
     DesiredRotation=(Pitch=23442,Yaw=34234,Roll=34234)
}
