//=============================================================================
// PlasmaBolt.
//=============================================================================
class PlasmaBolt extends DeusExProjectile;

var ParticleGenerator pGen1;
var ParticleGenerator pGen2;
var float mpDamage;

#exec OBJ LOAD FILE=Effects

simulated function DrawExplosionEffects(vector HitLocation, vector HitNormal)
{
	local ParticleGenerator gen;

	// create a particle generator shooting out plasma spheres
	gen = Spawn(class'ParticleGenerator',,, HitLocation, Rotator(HitNormal));
	if (gen != None)
	{
                gen.RemoteRole = ROLE_None;
		gen.particleDrawScale = 1.0;
		gen.checkTime = 0.10;
		gen.frequency = 1.0;
		gen.ejectSpeed = 200.0;
		gen.bGravity = True;
		gen.bRandomEject = True;
		gen.particleLifeSpan = 0.75;
		gen.particleTexture = Texture'Effects.Fire.Proj_PRifle';
		gen.LifeSpan = 1.3;
	}
}

function PostBeginPlay()
{
	Super.PostBeginPlay();

   	if ((Level.NetMode == NM_Standalone) || (Level.NetMode == NM_ListenServer))
        		SpawnPlasmaEffects();
}

simulated function PreBeginPlay()
{
  	Super.PreBeginPlay();
  	if(Level.Game.bDeathMatch)
 		Damage = mpDamage;
}

simulated function PostNetBeginPlay()
{
   	if (Role < ROLE_Authority)
       		SpawnPlasmaEffects();
}

simulated function SpawnPlasmaEffects()
{
	local Rotator rot;
   	rot = Rotation;
	rot.Yaw -= 32768;

        	pGen2 = Spawn(class'ParticleGenerator', Self,, Location, rot);
	if (pGen2 != None)
	{
                	pGen2.RemoteRole = ROLE_None;
		pGen2.particleTexture = Texture'Effects.Fire.Proj_PRifle';
		pGen2.particleDrawScale = 0.1;
		pGen2.checkTime = 0.04;
		pGen2.riseRate = 0.0;
		pGen2.ejectSpeed = 100.0;
		pGen2.particleLifeSpan = 0.5;
		pGen2.bRandomEject = True;
		pGen2.SetBase(Self);
	}  
}

simulated function Destroyed()
{
	if (pGen1 != None)
		pGen1.DelayedDestroy();
	if (pGen2 != None)
		pGen2.DelayedDestroy();

	Super.Destroyed();
}

auto simulated state Flying
{
    	simulated function Explode(vector HitLocation, vector HitNormal)
    	{
		local bool bDestroy;
		local float rad;  	       

		if ( Role == ROLE_Authority )
		{
			if (damagee != None)
			{
              				if ( Level.NetMode != NM_Standalone )
				{
					if ( damagee.IsA('DeusExPlayer') )
						DeusExPlayer(damagee).myProjKiller = Self;
				}
			damagee.TakeDamage(Damage, Pawn(Owner), HitLocation, MomentumTransfer*Normal(Velocity), damageType);
			}
		}
		if (!bStuck)
			bDestroy = true;
		
		rad = Max(blastRadius*24, 1024);
			PlayImpactSound();

      		 if (Role == ROLE_Authority)
       		{
           			if (ImpactSound != None)
           			{
               				AISendEvent('LoudNoise', EAITYPE_Audio, 2.0, blastRadius*24);
               				if (bExplodes)
                   				AISendEvent('WeaponFire', EAITYPE_Audio, 2.0, blastRadius*5);
               				MakeNoise(0.5);
           			}
        		}
        		if ((Level.NetMode != NM_DedicatedServer) || (Role < ROLE_Authority))			
             			DrawExplosionEffects(HitLocation, HitNormal);
		if (bDestroy)
			Destroy();
   	}
}

defaultproperties
{
     mpDamage=20.000000
     DamageType=Burned
     AccurateRange=14400
     maxRange=24000
     bIgnoresNanoDefense=True
     ItemName="Plasma Bolt"
     ItemArticle="a"
     speed=1800.000000
     Damage=20.000000
     MomentumTransfer=5000
     ImpactSound=Sound'DeusExSounds.Weapons.PlasmaRifleHit'
     ExplosionDecal=Class'DeusEx.ScorchMark'
     Mesh=LodMesh'DeusExItems.PlasmaBolt'
     DrawScale=3.000000
     bUnlit=True
     LightType=LT_Steady
     LightEffect=LE_NonIncidence
     LightBrightness=200
     LightHue=80
     LightSaturation=128
     LightRadius=3
     bFixedRotationDir=True
}
