//=============================================================================
// Poolball.
//=============================================================================
class Poolball extends DeusExDecoration;

enum ESkinColor
{
	SC_1,
	SC_2,
	SC_3,
	SC_4,
	SC_5,
	SC_6,
	SC_7,
	SC_8,
	SC_9,
	SC_10,
	SC_11,
	SC_12,
	SC_13,
	SC_14,
	SC_15,
	SC_Cue
};

var() ESkinColor SkinColor;
var bool bJustHit;

	var texture HDTPSkin;



//-----------------------------------
// Uses HDTP's models/textures if they exists ;)
function prebeginplay()
{
     local mesh HDTPmesh;
     HDTPmesh = LODMesh(dynamicloadObject("HDTPDecos.HDTPPoolball",class'mesh'));
     if(HDTPmesh != none)
     {
        mesh = HDTPmesh;
        //default.mesh = HDTPmesh; //just in case
     }
 super.prebeginplay();
}
//----------------------------------------


function BeginPlay()
{
	Super.BeginPlay();

	switch (SkinColor)
	{
		case SC_1:		
						    HDTPSkin = texture(dynamicloadObject("HDTPDecos.Skins.HDTPPoolballTex1",class'texture', true));
								If (HDTPSkin != none)
									MultiSkins[1]=HDTPSKin;										
										else

									Skin = Texture'PoolballTex1'; 
									break;
		case SC_2:		
						    HDTPSkin = texture(dynamicloadObject("HDTPDecos.Skins.HDTPPoolballTex2",class'texture', true));
								If (HDTPSkin != none)
									MultiSkins[1]=HDTPSKin;										
										else

									Skin = Texture'PoolballTex2'; 
									break;
		case SC_3:		
						    HDTPSkin = texture(dynamicloadObject("HDTPDecos.Skins.HDTPPoolballTex3",class'texture', true));
								If (HDTPSkin != none)
									MultiSkins[1]=HDTPSKin;										
										else

									Skin = Texture'PoolballTex3'; 
									break;
		case SC_4:		
						    HDTPSkin = texture(dynamicloadObject("HDTPDecos.Skins.HDTPPoolballTex4",class'texture', true));
								If (HDTPSkin != none)
									MultiSkins[1]=HDTPSKin;										
										else

									Skin = Texture'PoolballTex4'; 
									break;

		case SC_5:		
						    HDTPSkin = texture(dynamicloadObject("HDTPDecos.Skins.HDTPPoolballTex5",class'texture', true));
								If (HDTPSkin != none)
									MultiSkins[1]=HDTPSKin;										
										else

									Skin = Texture'PoolballTex5'; 
									break;

		case SC_6:		
						    HDTPSkin = texture(dynamicloadObject("HDTPDecos.Skins.HDTPPoolballTex6",class'texture', true));
								If (HDTPSkin != none)
									MultiSkins[1]=HDTPSKin;										
										else

									Skin = Texture'PoolballTex6'; 
									break;
		case SC_7:		
						    HDTPSkin = texture(dynamicloadObject("HDTPDecos.Skins.HDTPPoolballTex7",class'texture', true));
								If (HDTPSkin != none)
									MultiSkins[1]=HDTPSKin;										
										else

									Skin = Texture'PoolballTex7'; 
									break;

		case SC_8:		
						    HDTPSkin = texture(dynamicloadObject("HDTPDecos.Skins.HDTPPoolballTex8",class'texture', true));
								If (HDTPSkin != none)
									MultiSkins[1]=HDTPSKin;										
										else

									Skin = Texture'PoolballTex8'; 
									break;

		case SC_9:		
						    HDTPSkin = texture(dynamicloadObject("HDTPDecos.Skins.HDTPPoolballTex9",class'texture', true));
								If (HDTPSkin != none)
									MultiSkins[1]=HDTPSKin;										
										else

									Skin = Texture'PoolballTex9'; 
									break;

		case SC_10:		
						    HDTPSkin = texture(dynamicloadObject("HDTPDecos.Skins.HDTPPoolballTex10",class'texture', true));
								If (HDTPSkin != none)
									MultiSkins[1]=HDTPSKin;										
										else

									Skin = Texture'PoolballTex10'; 
									break;

		case SC_11:		
						    HDTPSkin = texture(dynamicloadObject("HDTPDecos.Skins.HDTPPoolballTex11",class'texture', true));
								If (HDTPSkin != none)
									MultiSkins[1]=HDTPSKin;										
										else

									Skin = Texture'PoolballTex11'; 
									break;

		case SC_12:		
						    HDTPSkin = texture(dynamicloadObject("HDTPDecos.Skins.HDTPPoolballTex12",class'texture', true));
								If (HDTPSkin != none)
									MultiSkins[1]=HDTPSKin;										
										else

									Skin = Texture'PoolballTex12'; 
									break;

		case SC_13:		
						    HDTPSkin = texture(dynamicloadObject("HDTPDecos.Skins.HDTPPoolballTex13",class'texture', true));
								If (HDTPSkin != none)
									MultiSkins[1]=HDTPSKin;										
										else

									Skin = Texture'PoolballTex13'; 
									break;

		case SC_14:		
						    HDTPSkin = texture(dynamicloadObject("HDTPDecos.Skins.HDTPPoolballTex14",class'texture', true));
								If (HDTPSkin != none)
									MultiSkins[1]=HDTPSKin;										
										else

									Skin = Texture'PoolballTex14'; 
									break;
		case SC_15:		
						    HDTPSkin = texture(dynamicloadObject("HDTPDecos.Skins.HDTPPoolballTex15",class'texture', true));
								If (HDTPSkin != none)
									MultiSkins[1]=HDTPSKin;										
										else
									Skin = Texture'PoolballTex15'; 
									break;

		case SC_Cue:	
						    HDTPSkin = texture(dynamicloadObject("HDTPDecos.Skins.HDTPPoolballTex16",class'texture', true));
								If (HDTPSkin != none)
									MultiSkins[1]=HDTPSKin;
										else
									Skin = Texture'PoolballTex16'; 
									break;
	}
}

function Tick(float deltaTime)
{
	local float speed;

	speed = VSize(Velocity);

	if ((speed >= 0) && (speed < 5))
	{
		bFixedRotationDir = False;
		Velocity = vect(0,0,0);
	}
	else if (speed >= 5)
	{
		bFixedRotationDir = True;
		SetRotation(Rotator(Velocity));
		RotationRate.Pitch = speed * 60000;
	}
}

event HitWall(vector HitNormal, actor HitWall)
{
	local Vector newloc;

	// if we hit the ground, make sure we are rolling
	if (HitNormal.Z == 1.0)
	{
		SetPhysics(PHYS_Rolling, HitWall);
		if (Physics == PHYS_Rolling)
		{
			bFixedRotationDir = False;
			Velocity = vect(0,0,0);
			return;
		}
	}

	Velocity = 0.9*((Velocity dot HitNormal) * HitNormal * (-2.0) + Velocity);   // Reflect off Wall w/damping
	Velocity.Z = 0;
	newloc = Location + HitNormal;	// move it out from the wall a bit
	SetLocation(newloc);
}

function Timer()
{
	bJustHit = False;
}

function Bump(actor Other)
{
	local Vector HitNormal;

	if (Other.IsA('Poolball'))
	{
		if (!Poolball(Other).bJustHit)
		{
			PlaySound(sound'PoolballClack', SLOT_None);
			HitNormal = Normal(Location - Other.Location);
			Velocity = HitNormal * VSize(Other.Velocity);
			Velocity.Z = 0;
			bJustHit = True;
			Poolball(Other).bJustHit = True;
			SetTimer(0.02, False);
			Poolball(Other).SetTimer(0.02, False);
		}
	}
}

function Frob(Actor Frobber, Inventory frobWith)
{
	Velocity = Normal(Location - Frobber.Location) * 400;
	Velocity.Z = 0;
}

defaultproperties
{
     bInvincible=True
     ItemName="Poolball"
     bPushable=False
     Physics=PHYS_Rolling
     Mesh=LodMesh'DeusExDeco.Poolball'
     CollisionRadius=1.700000
     CollisionHeight=1.700000
     bBounce=True
     Mass=5.000000
     Buoyancy=2.000000
}
