//=============================================================================
// ProdEffect.
//=============================================================================
class ProdEffect extends Effects;

var vector KickVelocity;

simulated function PreBeginPlay()
{
	Super.PreBeginPlay();

	if ( ((Level.Game != None) && Level.Game.bDeathMatch) || (Level.NetMode != NM_Standalone) )
	{
		bProjTarget = False;
     		SetCollision(False, False, False);
	}
	else
	{
		bProjTarget = True;
     		SetCollision(True, False, False);
	}
}

simulated function Touch( actor Other )
{	
	local Pawn P;

	P = Pawn(Other);

	if ( ((Level.Game != None) && Level.Game.bDeathMatch) || (Level.NetMode != NM_Standalone) )
	{
		SetCollision(False, False, False);
		return;
	}
		
	if ( (P != None) && (P != Owner) )
	{
		PendingTouch = Other.PendingTouch;
		Other.PendingTouch = self;
	}
}

simulated function PostTouch( actor Other )
{
	local bool bWasFalling;
	local vector Push;
	local float PMag;
	local Pawn P;

	P = Pawn(Owner);
	bWasFalling = ( Other.Physics == PHYS_Falling );
	Push = -1 * Other.Velocity;
	PMag = VSize(KickVelocity);
	Push += PMag * Normal(KickVelocity + 0.5 * PMag * VRand());
	if ( Other.IsA('Bot') )
	{
		if ( bWasFalling )
			Bot(Other).bJumpOffPawn = true;
		Bot(Other).SetFall();
	}
	else if ( Other.IsA('ScriptedPawn') )
	{
		if ( bWasFalling )
			ScriptedPawn(Other).bJumpOffPawn = true;
		ScriptedPawn(Other).SetFall();
	}
	Other.SetPhysics(PHYS_Falling);
	Other.Velocity += Push;
	MakeSound();
	if ( P != None )
		Other.TakeDamage(0, P, Other.Location, vect(0,0,0), 'Shocked');
	else
		Other.TakeDamage(0, None, Other.Location, vect(0,0,0), 'Shocked');
}

function TakeDamage(int Damage, Pawn EventInstigator, vector HitLocation, vector Momentum, name DamageType)
{
	local Pawn P;

	P = Pawn(Owner);

	if ( DamageType == 'SniperDeath' )
	{
		if ( P != None )
		{
			if ( EventInstigator != None )
				P.TakeDamage(Damage, EventInstigator, P.Location, Momentum, DamageType);
			else
				P.TakeDamage(Damage, None, P.Location, Momentum, DamageType);
		}
	}
	
	MakeSound();
}

function MakeSound()
{
        	PlaySound(EffectSound1,SLOT_None,,,1024);
}

defaultproperties
{
     KickVelocity=(X=500.000000,Y=500.000000,Z=100.000000)
     EffectSound1=Sound'DeusEx.Effect.ProdArmorHit'
     bTrailerSameRotation=True
     bDetectable=False
     Physics=PHYS_Trailer
     DrawType=DT_Mesh
     Style=STY_Translucent
     Mesh=LodMesh'DeusExItems.SphereEffect'
     DrawScale=7.000000
     bUnlit=True
     CollisionRadius=50.000000
     CollisionHeight=50.000000
}
