//=============================================================================
// Rebreather.
//=============================================================================
class Rebreather extends ChargedPickup;

function ChargedPickupUpdate(DeusExPlayer Player)
{
	Super.ChargedPickupUpdate(Player);

	Player.swimTimer = Player.swimDuration;
}

state Activated
{
	function Timer()
	{
		local DeusExPlayer Player;

		Player = DeusExPlayer(Owner);
		if (Player != None)
		{
			ChargedPickupUpdate(Player);

                      if (Player.HeadRegion.Zone.bWaterZone)
                      {
			Charge -= CalcChargeDrain(Player);
                        LoopSound = Sound'DeusExSounds.Pickup.RebreatherLoop';
                      }
                      else
                      {
                        LoopSound = None;
                      }
			if (Charge <= 0)
				UsedUp();
		}
	}
}

defaultproperties
{
     skillNeeded=Class'DeusEx.SkillEnviro'
     ChargedIcon=Texture'DeusExUI.Icons.ChargedIconRebreather'
     ExpireMessage="Rebreather power supply used up"
     bAutoActivate=True
     ItemName="Rebreather"
     PlayerViewOffset=(X=30.000000,Z=-6.000000)
     PlayerViewMesh=LodMesh'DeusExItems.Rebreather'
     PickupViewMesh=LodMesh'DeusExItems.Rebreather'
     ThirdPersonMesh=LodMesh'DeusExItems.Rebreather'
     LandSound=Sound'DeusExSounds.Generic.PaperHit2'
     Icon=Texture'DeusExUI.Icons.BeltIconRebreather'
     largeIcon=Texture'DeusExUI.Icons.LargeIconRebreather'
     largeIconWidth=44
     largeIconHeight=34
     Description="A disposable chemical scrubber that can extract oxygen from water during brief submerged operations."
     beltDescription="REBREATHR"
     Mesh=LodMesh'DeusExItems.Rebreather'
     CollisionRadius=6.900000
     CollisionHeight=3.610000
     Mass=10.000000
     Buoyancy=8.000000
}
