//=============================================================================
// Researcher.
//=============================================================================
class Researcher extends HumanMilitary;

var float mySpeechTime;

function PostBeginPlay()
{
	Super.PostBeginPlay();

	if ( FRand() < 0.25 )
		 bCanCommunicate = True;
}       

function float ModifyDamage(int Damage, Pawn instigatedBy, Vector hitLocation,
                            Vector offset, Name damageType)
{
	if ( (damageType == 'Poison') || (damageType == 'PoisonEffect') || (damageType == 'PoisonGas')
           		|| (damageType == 'Radiation') || (damageType == 'Shocked') || (damageType == 'HalonGas') )
		return 0.0;
	else if ( (damageType == 'KnockedOut') || (damageType == 'Fell') )
		return 0.25;
        	else
		return Super.ModifyDamage(Damage, instigatedBy, hitLocation, offset, damageType);
}

function GotoDisabledState(name damageType, EHitLocation hitPos)
{
	if ( !bCollideActors && !bBlockActors && !bBlockPlayers )
		return;
	else if ( CanShowPain() )
		TakeHit(hitPos);
	else
		GotoNextState();
}     

function UpdateFire()
{
}

function PlayOnFireSound()
{
	local DeusExPlayer dxPlayer;

	dxPlayer = DeusExPlayer(GetPlayerPawn());
	if ( dxPlayer != None )
		dxPlayer.StartAIBarkConversation(self, BM_Futz);
}

function PlayTargetAcquiredSound()
{
	local DeusExPlayer dxPlayer;

	dxPlayer = DeusExPlayer(GetPlayerPawn());
	if ( dxPlayer != None ) 
		dxPlayer.StartAIBarkConversation(self, BM_TargetAcquired);
}

function PlayAreaSecureSound()
{
	local DeusExPlayer dxPlayer;
	
	dxPlayer = DeusExPlayer(GetPlayerPawn());
	if ( dxPlayer != None ) 
		dxPlayer.StartAIBarkConversation(self, BM_AreaSecure);
}

function PlaySurpriseSound()
{
	local DeusExPlayer dxPlayer;

	dxPlayer = DeusExPlayer(GetPlayerPawn());
	if ( dxPlayer != None )
		dxPlayer.StartAIBarkConversation(self, BM_Surprise);
}

function CatchFire()
{
        	Super.CatchFire();
        	PlayOnFireSound();
}

function PlayAttackSounds()
{
        	local float rnd;

        	rnd = FRand();

        	if ( rnd < 0.33 )
             		PlayTargetAcquiredSound();
        	else if ( rnd < 0.67 )
             		PlaySurpriseSound();
        	else   
             		PlayAreaSecureSound();  
}     

function Tick(float deltaTime)
{
        	Super.Tick(deltaTime);
        	if ( IsInState('Attacking') || IsInState('DefendPosition') || IsInState('TakeCover') )
        	{
             		mySpeechTime += deltaTime;
             		if ( mySpeechTime > 2.0 )
             		{
                      		PlayAttackSounds(); 
	              		mySpeechTime = 0;             
	     	}
        	}
}

function CallForHelp()
{
	local Pawn P;

	if ( Level.Game.Difficulty != 3 )
		return;

        	if ( !bCanCommunicate )
           		return;
      	
	for ( P=Level.PawnList; P!=None; P=P.NextPawn )
	{
		if ( P.IsA('Researcher') && (P.Alliance == Alliance) )
		     	P.HandleHelpMessageFrom(Self);
	}
}

function HandleHelpMessageFrom(Pawn Other)
{
	if ( Level.Game.Difficulty != 3 )
		return;
	if ( !bCanCommunicate || bImportant || bDefendHome )
                		return;
	if ( !Other.IsA('Researcher') )
		return;
       	if ( IsInState('Attacking') || IsInState('Fleeing') || IsInState('Seeking') || IsInState('Alerting') || IsInState('DefendPosition') || IsInState('TakeCover') )
                		return;
        	if ( (Other.Enemy != None) && SetEnemy(Other.Enemy) && (VSize(Other.Enemy.Location - Location) < HelpDistance)
           		&& (ActorReachable(Other.Enemy) || (FindPathToward(Other.Enemy) != None)) ) 
                		HandleEnemy();
}

defaultproperties
{
     JumpSound=Sound'DeusEx.Player.HPlayerJump1'
     HelpDistance=1200.000000
     BaseAccuracy=-0.250000
     bCanCommunicate=False
     CarcassType=Class'DeusEx.ResearcherCarcass'
     WalkingSpeed=0.213333
     bShowPain=False
     AvoidAccuracy=0.950000
     HarmAccuracy=0.950000
     CrouchRate=0.100000
     CloseCombatMult=1.000000
     SurprisePeriod=0.000000
     BaseAssHeight=-23.000000
     InitialInventory(0)=(Inventory=Class'DeusEx.WeaponCrowbar')
     BurnPeriod=10.000000
     GroundSpeed=350.000000
     AccelRate=2048.000000
     JumpZ=250.000000
     PeripheralVision=-0.200000
     HearingThreshold=0.050000
     Health=500
     Skill=1.250000
     Land=Sound'DeusEx.Player.PlayerLand1'
     CombatStyle=0.750000
     HealthHead=500
     HealthTorso=500
     HealthLegLeft=500
     HealthLegRight=500
     HealthArmLeft=500
     HealthArmRight=500
     Mesh=LodMesh'DeusExCharacters.GM_Trench'
     MultiSkins(0)=Texture'DeusExCharacters.Skins.ThugMaleTex0'
     MultiSkins(1)=Texture'DeusExCharacters.Skins.LabCoatTex1'
     MultiSkins(2)=Texture'DeusExCharacters.Skins.PantsTex5'
     MultiSkins(3)=Texture'DeusExCharacters.Skins.ThugMaleTex0'
     MultiSkins(4)=Texture'DeusExCharacters.Skins.PaulDentonTex1'
     MultiSkins(5)=Texture'DeusExCharacters.Skins.LabCoatTex1'
     MultiSkins(6)=Texture'DeusExCharacters.Skins.FramesTex1'
     MultiSkins(7)=Texture'DeusExCharacters.Skins.LensesTex2'
     CollisionRadius=20.000000
     CollisionHeight=47.500000
     BindName="ThugMale"
     BarkBindName="ThugMale"
     FamiliarName="Researcher"
     UnfamiliarName="Researcher"
     bVisionImportant=False
}
