//=============================================================================
// RocketGrenade.
//=============================================================================
class RocketGrenade extends DeusExProjectile;

var ParticleGenerator smokeGen;
var bool bCanHitOwner;
var bool bExploded;
var float mpBlastRadius;
var float mpDamage;

simulated function PostBeginPlay()
{
	Super.PostBeginPlay();

   	SetTimer(2.5+FRand()*0.5,false);

   	bCanHitOwner = False;
   	bExploded = False;
   
   	if (Level.NetMode == NM_DedicatedServer)
      		return;
   
   	SpawnSmokeEffects();
}
simulated function PostNetBeginPlay()
{
   	Super.PostNetBeginPlay();
   
   	if (Role != ROLE_Authority)
      		SpawnSmokeEffects();
}

simulated function SpawnSmokeEffects()
{
	smokeGen = Spawn(class'ParticleGenerator', Self);
	if (smokeGen != None)
	{
		smokeGen.particleTexture = Texture'Effects.Smoke.SmokePuff1';
		smokeGen.particleDrawScale = 0.2;
		smokeGen.checkTime = 0.02;
		smokeGen.riseRate = 8.0;
		smokeGen.ejectSpeed = 0.0;
		smokeGen.particleLifeSpan = 2.0;
		smokeGen.bRandomEject = True;
		smokeGen.SetBase(Self);
                		smokeGen.RemoteRole = ROLE_None;
	}
}

simulated function Destroyed()
{
	if (smokeGen != None)
		smokeGen.DelayedDestroy();

	Super.Destroyed();
}

simulated function Timer()
{
	Explode(Location, Location);
}

auto simulated state Flying
{
	simulated function ProcessTouch (Actor Other, Vector HitLocation)
	{
		if (bStuck)
			return;

		if ((Other != instigator) && (Other != Owner) && (DeusExProjectile(Other) == None) || bCanHitOwner)
		{
			damagee = Other;
                        		Explode(HitLocation, Normal(HitLocation-damagee.Location));
			if (Role == ROLE_Authority)
			{
            				if (damagee.IsA('Pawn') && !damagee.IsA('Robot') && !damagee.IsA('CyborgDog') && !damagee.IsA('HoloDenton') && bBlood)
               					SpawnBlood(HitLocation, Normal(HitLocation-damagee.Location));
			}
		}
	}

	simulated function HitWall(vector HitNormal, actor Wall)
	{
		bCanHitOwner = True;
	        	Velocity = 0.75*(( Velocity dot HitNormal ) * HitNormal * (-2.0) + Velocity);   // Reflect off Wall w/damping
	        	RandSpin(100000);
	        	speed = VSize(Velocity);
	        	if ( Level.NetMode != NM_DedicatedServer )
		     	PlaySound(MiscSound, SLOT_Misc, 3.0 );
                		MakeNoise(1.0);
	        	if ( Velocity.Z > 400 )
			Velocity.Z = 0.5 * (400 + Velocity.Z);	
	        	else if ( speed < 20 ) 
	        	{
		    	bBounce = False;
		    	SetPhysics(PHYS_None);
	        	}

		if (Wall.IsA('BreakableGlass'))
			bDebris = False;
                		if (bExploded)
			SpawnEffects(Location, HitNormal, Wall);
	}

	simulated function Explode(vector HitLocation, vector HitNormal)
	{
		local bool bDestroy;
		local float rad;

		bDestroy = false;

		if (bExplodes)
		{
                        		//SpawnEffects(HitLocation, HitNormal, None);
                        		bExploded = True;
			if ((Level.NetMode != NM_DedicatedServer) || (Role < ROLE_Authority))
				DrawExplosionEffects(HitLocation, HitNormal);
                        		GotoState('Exploding');
		}
		else
		{
			if ( Role == ROLE_Authority )
			{
				if (damagee != None)
					damagee.TakeDamage(Damage, Pawn(Owner), HitLocation, MomentumTransfer*Normal(Velocity), damageType);
			}
			if (!bStuck)
				bDestroy = true;
		}

		rad = Max(blastRadius*24, 1024);
		PlaySound(ImpactSound, SLOT_None, 2.0,, rad);
		if (Role == ROLE_Authority)
      		{
			if (ImpactSound != None)
			{
				AISendEvent('LoudNoise', EAITYPE_Audio, 2.0, blastRadius*24);
				if (bExplodes)
					AISendEvent('WeaponFire', EAITYPE_Audio, 2.0, blastRadius*5);
			}
		}

		if (bDestroy)
			Destroy();
	}

	simulated function BeginState()
	{
		local DeusExWeapon W;
		local vector X,Y,Z;

		initLoc = Location;
		initDir = vector(Rotation);
		Velocity = X * (Instigator.Velocity Dot X)*0.4 + initDir * (Speed + FRand() * 100);	
		Velocity.z += 150;
		MaxSpeed = 1000;
		RandSpin(50000);	
                		PlaySound(SpawnSound, SLOT_None);
	}
}

simulated function PreBeginPlay()
{
	Super.PreBeginPlay();

	if ( ((Level.Game != None) && Level.Game.bDeathMatch) || (Level.NetMode != NM_Standalone) )
        	{
	   	blastRadius = mpBlastRadius;
           		damage = mpDamage;
        	}
}

defaultproperties
{
     mpBlastRadius=224.000000
     mpDamage=80.000000
     bExplodes=True
     bBlood=True
     bDebris=True
     blastRadius=192.000000
     DamageType=exploded
     AccurateRange=400
     maxRange=800
     ItemName="Rocket Grenade"
     ItemArticle="a"
     speed=700.000000
     MaxSpeed=1000.000000
     Damage=300.000000
     MomentumTransfer=80000
     SpawnSound=Sound'DeusExSounds.Weapons.GEPGunFire'
     ImpactSound=Sound'DeusExSounds.Generic.SmallExplosion1'
     MiscSound=Sound'DeusExSounds.Generic.GlassHit1'
     ExplosionDecal=Class'DeusEx.ScorchMark'
     Mesh=LodMesh'DeusExItems.Rocket'
     DrawScale=0.250000
     bBounce=True
}
