//=============================================================================
// RocketMicro.
//=============================================================================
class RocketMicro extends Rocket;

simulated function SpawnRocketEffects()
{	
	smokeGen = Spawn(class'ParticleGenerator', Self);
	if (smokeGen != None)
	{
		smokeGen.particleTexture = Texture'Effects.Smoke.SmokePuff1';
		smokeGen.particleDrawScale = 0.07;
		smokeGen.checkTime = 0.02;
		smokeGen.riseRate = 8.0;
		smokeGen.ejectSpeed = 0.0;
		smokeGen.particleLifeSpan = 2.0;
		smokeGen.bRandomEject = True;
		smokeGen.SetBase(Self);
                		smokeGen.RemoteRole = ROLE_None;
	}
}

simulated function SpawnEffects(Vector HitLocation, Vector HitNormal, Actor Other)
{
	local int i;
	local DeusExDecal mark;
        	
  	if (DeusExMover(Other) != None)
		if (DeusExMover(Other).bDestroyed)
			ExplosionDecal = None;

	if (ExplosionDecal != None)
	{
		mark = DeusExDecal(Spawn(ExplosionDecal, Self,, HitLocation, Rotator(HitNormal)));
		if (mark != None)
		{
			mark.DrawScale = 0.4;
			mark.ReattachDecal();
		}

		ExplosionDecal = None;
	}
}

auto simulated state Flying
{
	simulated function Explode(vector HitLocation, vector HitNormal)
	{	      
              		if ((Level.NetMode != NM_DedicatedServer) || (Role < ROLE_Authority))			
            			DrawExplosionEffects(HitLocation, HitNormal);
		HurtRadius(damage, blastRadius, DamageType, MomentumTransfer, HitLocation);
		
		PlayImpactSound();     
     
		 if (Role == ROLE_Authority)
      		{
         			if (ImpactSound != None)
         			{
            				AISendEvent('LoudNoise', EAITYPE_Audio, 2.0, blastRadius*24);
                        			AISendEvent('WeaponFire', EAITYPE_Audio, 2.0, blastRadius*5);
            				MakeNoise(0.75);
         			}
      		}
		Destroy();
	}
}

defaultproperties
{
     mpBlastRadius=64.000000
     mpDamage=50.000000
     blastRadius=64.000000
     bTracking=False
     Damage=50.000000
     MomentumTransfer=25000
     ImpactSound=Sound'DeusExSounds.Generic.SmallExplosion2'
     Mesh=LodMesh'DeusExItems.RocketLAW'
     DrawScale=0.500000
}
