//=============================================================================
// SabotGrenade.
//=============================================================================
class SabotGrenade extends DeusExProjectile;

var ParticleGenerator smokeGen;

#exec OBJ LOAD FILE=Effects

simulated function PostBeginPlay()
{
   	Super.PostBeginPlay();

   	if (Level.NetMode == NM_DedicatedServer)
      		return;
      	SpawnSmokeEffects();
}

simulated function PostNetBeginPlay()
{
   	Super.PostNetBeginPlay();
   
   	if (Role != ROLE_Authority)
       		SpawnSmokeEffects();
}

simulated function SpawnSmokeEffects()
{      
	smokeGen = Spawn(class'ParticleGenerator', Self);
	if (smokeGen != None)
	{
		smokeGen.particleTexture = Texture'Effects.Smoke.SmokePuff1';
		smokeGen.particleDrawScale = 0.07;
		smokeGen.checkTime = 0.02;
		smokeGen.riseRate = 8.0;
		smokeGen.ejectSpeed = 0.0;
		smokeGen.particleLifeSpan = 2.0;
		smokeGen.bRandomEject = True;
		smokeGen.SetBase(Self);
                		smokeGen.RemoteRole = ROLE_None;
	}
}

simulated function Destroyed()
{
	if (smokeGen != None)
		smokeGen.DelayedDestroy();
       	Super.Destroyed();
}

simulated function SpawnEffects(Vector HitLocation, Vector HitNormal, Actor Other)
{
	local int i;
	local DeusExDecal mark;
        	
  	if (DeusExMover(Other) != None)
		if (DeusExMover(Other).bDestroyed)
			ExplosionDecal = None;

	if (ExplosionDecal != None)
	{
		mark = DeusExDecal(Spawn(ExplosionDecal, Self,, HitLocation, Rotator(HitNormal)));
		if (mark != None)
		{
			mark.DrawScale = 0.4;
			mark.ReattachDecal();
		}

		ExplosionDecal = None;
	}
}

auto simulated state Flying
{
	simulated function Explode(vector HitLocation, vector HitNormal)
	{	      
		local vector start;
		local int i;
		local SabotFragment sabot;
		
		start = Location + 10 * HitNormal;		
   		
              		if ((Level.NetMode != NM_DedicatedServer) || (Role < ROLE_Authority))			
            			DrawExplosionEffects(HitLocation, HitNormal);
		HurtRadius(damage, blastRadius, DamageType, MomentumTransfer, HitLocation);
		
		for (i=0; i<15; i++)
		{
			sabot = Spawn( class 'SabotFragment', Instigator, '', Start);
			if ( sabot != None)
				sabot.RemoteRole = ROLE_None;
		}		
		PlayImpactSound();     
     
		 if (Role == ROLE_Authority)
      		{
         			if (ImpactSound != None)
         			{
            				AISendEvent('LoudNoise', EAITYPE_Audio, 2.0, blastRadius*24);
                        			AISendEvent('WeaponFire', EAITYPE_Audio, 2.0, blastRadius*5);
            				MakeNoise(0.75);
         			}
      		}
		Destroy();
	}

	simulated function BeginState()
	{
		local DeusExWeapon W;
		local vector X,Y,Z;

		initLoc = Location;
		initDir = vector(Rotation);
		Velocity = speed*initDir;
		Velocity.z += 120;	
                		PlaySound(SpawnSound, SLOT_None);
	}
}

defaultproperties
{
     bExplodes=True
     bBlood=True
     blastRadius=192.000000
     DamageType=Sabot
     AccurateRange=240
     maxRange=480
     ItemName="Fragmentation Grenade"
     ItemArticle="a"
     speed=1200.000000
     MaxSpeed=1800.000000
     Damage=70.000000
     MomentumTransfer=75000
     SpawnSound=Sound'DeusExSounds.Weapons.GEPGunFire'
     ImpactSound=Sound'DeusExSounds.Generic.MediumExplosion1'
     ExplosionDecal=Class'DeusEx.ScorchMark'
     Mesh=LodMesh'DeusExItems.Rocket'
     DrawScale=0.100000
}
