//=============================================================================
// SabotShell.  
//=============================================================================
class SabotShell extends DeusExProjectile;

var float mpDamage;

#exec OBJ LOAD FILE=Effects

simulated function PreBeginPlay()
{
	Super.PreBeginPlay();

	if ( ((Level.Game != None) && Level.Game.bDeathMatch) || (Level.NetMode != NM_Standalone) 
	|| ((Level.Game != None) && (Level.Game.Difficulty == 3)) )
		Damage = mpDamage;
}

simulated function SpawnEffects(Vector HitLocation, Vector HitNormal, Actor Other)
{
	local int i;
	local DeusExDecal mark;
        	local Rockchip chip;
        	local SmokeTrail puff;

  	if (DeusExMover(Other) != None)
		if (DeusExMover(Other).bDestroyed)
			ExplosionDecal = None;

	if (ExplosionDecal != None)
	{
		mark = DeusExDecal(Spawn(ExplosionDecal, Self,, HitLocation, Rotator(HitNormal)));
		if (mark != None)
		{
			mark.DrawScale = 0.2;
			mark.ReattachDecal();
		}

		ExplosionDecal = None;
	}

        	puff = spawn(class'SmokeTrail',,, HitLocation, Rotator(HitNormal));
	if (puff != None)
	{
		puff.DrawScale = 0.15;
		puff.OrigScale = puff.DrawScale;
		puff.LifeSpan = 0.75;
		puff.OrigLifeSpan = puff.LifeSpan;
                		puff.RemoteRole = ROLE_None;
	}
}

function PlayImpactSound()
{
	if ((Level.NetMode == NM_Standalone) || (Level.NetMode == NM_ListenServer) || (Level.NetMode == NM_DedicatedServer))
	{
		PlaySound(ImpactSound, SLOT_None, 1.0,, 512);
	}
}

defaultproperties
{
     mpDamage=20.000000
     bBlood=True
     DamageType=Sabot
     AccurateRange=7200
     maxRange=14400
     bIgnoresNanoDefense=True
     ItemName="Sabot Shell"
     ItemArticle="a"
     speed=7500.000000
     MaxSpeed=8000.000000
     Damage=15.000000
     MomentumTransfer=40000
     ImpactSound=Sound'DeusExSounds.Generic.GlassHit2'
     ExplosionDecal=Class'DeusEx.BulletHole'
     Skin=FireTexture'Effects.Electricity.Nano_SFX_A'
     Mesh=LodMesh'DeusExItems.Tracer'
     DrawScale=2.000000
     AmbientGlow=64
     LightType=LT_Steady
     LightEffect=LE_NonIncidence
     LightBrightness=128
     LightHue=150
     LightSaturation=32
     LightRadius=1
}
