//=============================================================================
// ScriptedBot. Actually used for KTL game only as a Leader Bots. 
// This bots are also able to roam across the maps if not "Leaders",
// but they may cause slowdowns.    
//=============================================================================
class ScriptedBot expands ScriptedPawn
        abstract;

var bool  bCamping;
var float CampTime;
var float CampingRate;
var float LastCampCheck;
var bool  bWantsToCamp;
var bool  bCampOnlyOnce;
var bool  bSniping;
var bool  bWallAdjust;
var Pawn  myBurner;
var float RestartWait;
var bool  bNoRestart;
var Weapon EnemyDropped;
var Texture TauntPortrait;
var bool bJumpy;
var Ambushpoint AmbushSpot;
var(Sounds) sound JumpSound;
var bool bIgnorePoison;     
var EBarkModes TauntType; 
var EBarkModes FFType; 

function PreBeginPlay()
{
	bIsPlayer = true;
	Super.PreBeginPlay();
}

function PostBeginPlay()
{
        	Super(Pawn).PostBeginPlay();
     
        	if (!Level.Game.bDeathMatch)
        	{
                		Destroy();
                		return;
        	}
        	if (Region.Zone.bPainZone || HeadRegion.Zone.bPainZone ||
	    	FootRegion.Zone.bPainZone)
	PainTime = 5.0;
        	else if (HeadRegion.Zone.bWaterZone)
		PainTime = UnderWaterTime;
        	if (FRand() < 0.5)
                		bJumpy = True;
        	SetPeripheralVision();
        	// change the sounds for chicks
        	if (bIsFemale)
        	{
	       	HitSound1 = Sound'FemalePainMedium';
	       	HitSound2 = Sound'FemalePainLarge';
               		JumpSound = Sound'FemaleJump';
	       	Die = Sound'FemaleDeath';
        	}
	if ( Level.Netmode != NM_Standalone )
	{
		bMustFaceTarget = False;
		BaseAccuracy = 0.100000;
	}
}

function bool FireIfClearShot()
{
    	local DeusExWeapon dxWeapon;
    
    	dxWeapon = DeusExWeapon(Weapon);

    	if (dxWeapon != None)
    	{
		if (Level.Netmode != NM_Standalone)
		{
			if (AICanShoot(Enemy, true, false, 0.025))
        			{
                				FireWeapon();
                		         		return true;
        			}
        			else
        			{
                				StopFiring();
                				return false;
        			}
		}
		else
		{
	  		if (AICanShoot(Enemy, true, true, 0.025))
        			{
                				FireWeapon();
                		         		return true;
        			}
        			else
        			{
                				StopFiring();
                				return false;
        			}
		}
   	}
   	else
   	{     
        		StopFiring();
	  	return false;
   	}
}

function FireWeapon()
{
	local int usealt;
	
	if( Weapon!=None )
	{
            		Weapon.RateSelf(usealt);
		if (usealt > 0)
		{
                      		Weapon.AltFire(1.0);
                      		bFire = 0;
		          	bAltFire = 1;
			//log(""$self$" wants to altfire "$weapon$"");
		}
		else
		{
                      		Weapon.Fire(1.0);
                      		bFire = 1;
		          	bAltFire = 0;
			//log(""$self$" wants to fire "$weapon$"");
		}
	}
}

function SetPeripheralVision()
{
	PeripheralVision = -0.2;
		
	if ( bSniping && (AmbushSpot != None) )
		SightRadius = AmbushSpot.SightRadius;
	else
		SightRadius = Default.SightRadius;
}

function SendVoiceMessage(PlayerReplicationInfo Sender, PlayerReplicationInfo Recipient, name messagetype, byte messageID, name broadcasttype)
{
        	local Pawn P;

	if (Level.Netmode != NM_Standalone)
		return;
      
	if ( broadcasttype == 'TEAM')
        	{
                 		for ( P=Level.PawnList; P!=None; P=P.NextPawn )
                      		if ( P.IsA('DeusExPlayer') && (P.PlayerReplicationInfo.Team == PlayerReplicationInfo.Team) )
                           			DeusExPlayer(P).StartAIBarkConversation(self, FFType);
        	}
        	else
        	{
                 		for ( P=Level.PawnList; P!=None; P=P.NextPawn )
                       		if ( P.IsA('DeusExPlayer') )
                           			DeusExPlayer(P).StartAIBarkConversation(self, TauntType);
        	}
}

function SendGlobalMessage(PlayerReplicationInfo Recipient, name MessageType, byte MessageID, float Wait)
{
        SendVoiceMessage(PlayerReplicationInfo, Recipient, MessageType, MessageID, 'GLOBAL');
}

function YellAt()
{
        SendTeamMessage(None, 'FRIENDLYFIRE', 0, 0);
}

function UnderLift(Mover M)
{
	local NavigationPoint N;

	// find nearest lift exit and go for that
	if ( (MoveTarget != None) && MoveTarget.IsA('LiftCenter') )
		for ( N=Level.NavigationPointList; N!=None; N=N.NextNavigationPoint )
			if ( N.IsA('LiftExit') && (LiftExit(N).LiftTag == M.Tag)
				&& ActorReachable(N) )
			{
				MoveTarget = N;
				return;
			}
}

function bool FindAmbushSpot()
{	
	      return false;
}	

function Killed(pawn Killer, pawn Other, name damageType)
{
	if ((Enemy == Other) && (Other != None))
        {
               EnemyDropped = Enemy.Weapon;
	       Enemy = None;
               StopFiring();
        }
}

function bool NearWall(float walldist)
{
	local actor HitActor;
	local vector HitLocation, HitNormal, ViewSpot, ViewDist, LookDir;

	LookDir = vector(Rotation);
	ViewSpot = Location + BaseEyeHeight * vect(0,0,1);
	ViewDist = LookDir * walldist; 
	HitActor = Trace(HitLocation, HitNormal, ViewSpot + ViewDist, ViewSpot, false);
	if ( HitActor == None )
		return false;

	ViewDist = Normal(HitNormal Cross vect(0,0,1)) * walldist;
	if (FRand() < 0.5)
		ViewDist *= -1;

	HitActor = Trace(HitLocation, HitNormal, ViewSpot + ViewDist, ViewSpot, false);
	if ( HitActor == None )
	{
		Focus = Location + ViewDist;
		return true;
	}

	ViewDist *= -1;

	HitActor = Trace(HitLocation, HitNormal, ViewSpot + ViewDist, ViewSpot, false);
	if ( HitActor == None )
	{
		Focus = Location + ViewDist;
		return true;
	}

	Focus = Location - LookDir * 300;
	return true;
}

state Attacking
{
        function bool FireIfClearShot()
	{
	     Global.FireIfClearShot();	
	}
            
        function Timer()
        {
           Global.Timer();
        }

        function Tick(float deltaSeconds)
	{
		local bool   bCanSee;
		local float  yaw;
		local vector lastLocation;
		local Pawn   lastEnemy;
		local float  surpriseTime;

		Global.Tick(deltaSeconds);
		if (CrouchTimer > 0)
		{
			CrouchTimer -= deltaSeconds;
			if (CrouchTimer < 0)
				CrouchTimer = 0;
		}
		EnemyTimer += deltaSeconds;
                UpdateActorVisibility(Enemy, deltaSeconds, 1.0, false);
                if ((Enemy != None) && HasEnemyTimedOut())
		{
			lastLocation = Enemy.Location;
			lastEnemy    = Enemy;
			FindBestEnemy(true);
			if (Enemy == None)
			{
                             SetSeekLocation(lastEnemy, lastLocation, SEEKTYPE_Guess, true);
			     GotoState('Seeking');
			}
		}
		else if (bCanFire && (Enemy != None))
		{
			ViewRotation = Rotator(Enemy.Location-Location);
			if (bFacingTarget)
				FireIfClearShot();
			else if (!bMustFaceTarget)
			{
				yaw = (ViewRotation.Yaw-Rotation.Yaw) & 0xFFFF;
				if (yaw >= 32768)
					yaw -= 65536;
				yaw = Abs(yaw)*360/32768;  // 0-180 x 2
				if (yaw <= FireAngle)
					FireIfClearShot();
			}
		}
	  }
          	
	function bool ReadyForWeapon()
	{
		local bool bReady;

		bReady = false;
		if (DeusExWeapon(weapon) != None)
		{
			if (DeusExWeapon(weapon).bReadyToFire)
				if (!IsWeaponReloading())
					bReady = true;
		}
		if (!bReady)
			if (enemy == None)
				bReady = true;
		if (!bReady)
			if (!AICanShoot(enemy, true, false, 0.025))
				bReady = true;

		return (bReady);
	}
        
          function bool ShouldCrouch()
	  {
                if (bJumpy && !IsHandToHand() && !Region.Zone.bWaterZone && 
                   ((Enemy != None) && (VSize(Enemy.Location-Location) < 1600))) 
		                 return true;
                else
                                 return false;
	  }

	  function StartCrouch()
	  { 
                 SetPhysics(PHYS_Falling);
                 FireIfClearShot();
	         Acceleration = vect(0,0,0);
                 Destination = Location + 400 * vect(0,0,1);
	         NextState = 'Attacking'; 
	         NextLabel = 'ContinueAttack';
	         GotoState('FallingState');    
	  }

          function EndCrouch()
	  {          
	  } 
}

function float ComputeActorVisibility(actor seeActor)
{
	return 1.0;
}

function TakeDamageBase(int Damage, Pawn instigatedBy, Vector hitlocation, Vector momentum, name damageType, bool bPlayAnim)
{
	local int          actualDamage;
	local Vector       offset;
	local float        origHealth;
	local EHitLocation hitPos;
	local float        shieldMult;
	
	offset = (hitLocation - Location) << Rotation;

	if (!CanShowPain())
		bPlayAnim = false;

	if (!bBlockActors && !bBlockPlayers && !bCollideActors)
		return;

	if ((Damage <= 0) && (damageType == 'None'))
		return;

	if (!FilterDamageType(instigatedBy, hitLocation, offset, damageType))
		return;

	ImpartMomentum(momentum, instigatedBy);

	actualDamage = ModifyDamage(Damage, instigatedBy, hitLocation, offset, damageType);

	if (actualDamage > 0)
	{
		shieldMult = ShieldDamage(damageType);
		if (shieldMult > 0)
			actualDamage = Max(int(actualDamage*shieldMult), 1);
		else
			actualDamage = 0;
		if (shieldMult < 1.0)
			DrawShield();
	}

	origHealth = Health;

	hitPos = HandleDamage(actualDamage, hitLocation, offset, damageType);
	if (!bPlayAnim || (actualDamage <= 0))
		hitPos = HITLOC_None;

	if (bCanBleed)
		if ((damageType != 'Stunned') && (damageType != 'TearGas') && (damageType != 'HalonGas') &&
		    (damageType != 'PoisonGas') && (damageType != 'Radiation') && (damageType != 'EMP') &&
		    (damageType != 'NanoVirus') && (damageType != 'Drowned') && (damageType != 'KnockedOut') &&
		    (damageType != 'Poison') && (damageType != 'PoisonEffect'))
			bleedRate += (origHealth-Health)/(0.3*Default.Health);  // 1/3 of default health = bleed profusely

	if (CarriedDecoration != None)
		DropDecoration();

	if (!bIgnorePoison && (actualDamage > 0) && (damageType == 'Poison'))
		StartPoison(Damage, instigatedBy);

	if (Health <= 0)
	{
		ClearNextState();
		
		if ( actualDamage > mass )
			Health = -1 * actualDamage;
		SetEnemy(instigatedBy, 0, true);

		// gib us if we get blown up
		if ((DamageType == 'Exploded') || (DamageType == 'SniperDeath') || (damageType == 'GrenadeDeath')) 
			Health = -10000;
		else if ((DamageType == 'Shocked') || (DamageType == 'Flamed') || (DamageType == 'Burned') || (DamageType == 'Poison') ) 
			Health = -1 * actualDamage;
            else
                  Health = -1;  

		Died(instigatedBy, damageType, HitLocation);

		if ((DamageType == 'Flamed') || (DamageType == 'Burned'))
		{
			bBurnedToDeath = true;
		}
		else
			bBurnedToDeath = false;

		return;
	}

	if (DamageType != 'Stunned')
		PlayTakeHitSound(actualDamage, damageType, 1);

	if ((actualDamage > 0) && (DamageType == 'Flamed') && !bOnFire)
     		CatchFlame(instigatedBy);
         
	ReactToInjury(instigatedBy, damageType, hitPos);
}

function EHitLocation HandleDamage(int actualDamage, Vector hitLocation, Vector offset, name damageType)
{
	local EHitLocation hitPos;
	local float headOffsetZ, headOffsetY, armOffset;

	// calculate our hit extents
	headOffsetZ = CollisionHeight * 0.7;
	headOffsetY = CollisionRadius * 0.3;
	armOffset   = CollisionRadius * 0.35;

	hitPos = HITLOC_None;

	if (actualDamage > 0)
	{
		if (offset.z > headOffsetZ)		// head
		{
			// narrow the head region
			if ((Abs(offset.x) < headOffsetY) || (Abs(offset.y) < headOffsetY))
			{
				// only allow headshots with sniper rifle
				if (damageType == 'Decapitated') 
					HealthHead -= actualDamage * 8;
				else
					HealthHead -= actualDamage;
				if (offset.x < 0.0)
					hitPos = HITLOC_HeadBack;
				else
					hitPos = HITLOC_HeadFront;
			}
			else  // sides of head treated as torso
			{
				HealthTorso -= actualDamage;
				if (offset.x < 0.0)
					hitPos = HITLOC_TorsoBack;
				else
					hitPos = HITLOC_TorsoFront;
			}
		}
		else if (offset.z < 0.0)	// legs
		{
			if (offset.y > 0.0)
			{
				HealthLegRight -= actualDamage;
				if (offset.x < 0.0)
					hitPos = HITLOC_RightLegBack;
				else
					hitPos = HITLOC_RightLegFront;
			}
			else
			{
				HealthLegLeft -= actualDamage;
				if (offset.x < 0.0)
					hitPos = HITLOC_LeftLegBack;
				else
					hitPos = HITLOC_LeftLegFront;
			}

 			// if this part is already dead, damage the adjacent part
			if ((HealthLegRight < 0) && (HealthLegLeft > 0))
			{
				HealthLegLeft += HealthLegRight;
				HealthLegRight = 0;
			}
			else if ((HealthLegLeft < 0) && (HealthLegRight > 0))
			{
				HealthLegRight += HealthLegLeft;
				HealthLegLeft = 0;
			}

			if (HealthLegLeft < 0)
			{
				HealthTorso += HealthLegLeft;
				HealthLegLeft = 0;
			}
			if (HealthLegRight < 0)
			{
				HealthTorso += HealthLegRight;
				HealthLegRight = 0;
			}
		}
		else						// arms and torso
		{
			if (offset.y > armOffset)
			{
				HealthArmRight -= actualDamage;
				if (offset.x < 0.0)
					hitPos = HITLOC_RightArmBack;
				else
					hitPos = HITLOC_RightArmFront;
			}
			else if (offset.y < -armOffset)
			{
				HealthArmLeft -= actualDamage;
				if (offset.x < 0.0)
					hitPos = HITLOC_LeftArmBack;
				else
					hitPos = HITLOC_LeftArmFront;
			}
			else
			{
				HealthTorso -= actualDamage;
				if (offset.x < 0.0)
					hitPos = HITLOC_TorsoBack;
				else
					hitPos = HITLOC_TorsoFront;
			}

			// if this part is already dead, damage the adjacent part
			if (HealthArmLeft < 0)
			{
				HealthTorso += HealthArmLeft;
				HealthArmLeft = 0;
			}
			if (HealthArmRight < 0)
			{
				HealthTorso += HealthArmRight;
				HealthArmRight = 0;
			}
		}
	}

	GenerateTotalHealth();

	return hitPos;
}

function CatchFlame(Pawn burner)
{
	local Fire f;
	local int i;
	local vector loc;

        myBurner = burner;

	if (bOnFire || Region.Zone.bWaterZone || (BurnPeriod <= 0) || bInvincible)
		return;

	bOnFire = True;
	burnTimer = 0;

	EnableCloak(false);

	for (i=0; i<8; i++)
	{
		loc.X = 0.5*CollisionRadius * (1.0-2.0*FRand());
		loc.Y = 0.5*CollisionRadius * (1.0-2.0*FRand());
		loc.Z = 0.6*CollisionHeight * (1.0-2.0*FRand());
		loc += Location;
		f = Spawn(class'Fire', Self,, loc);
		if (f != None)
		{
			f.DrawScale = 0.5*FRand() + 1.0;

			// turn off the sound and lights for all but the first one
			if (i > 0)
			{
				f.AmbientSound = None;
				f.LightType = LT_None;
			}

			// turn on/off extra fire and smoke
			if (FRand() < 0.5)
				f.smokeGen.Destroy();
			if (FRand() < 0.5)
				f.AddFire();
		}
	}

	// set the burn timer
	SetTimer(1.0, True);
}

auto state StartUp
{
	function Tick(float deltaSeconds)
	{
		Global.Tick(deltaSeconds);
		PlayWaiting();
		InitializePawn();
		FollowOrders();
	}
}

function bool SwitchToBestWeapon()
{
	local float rating;
	local int usealt;
        
	if ( Inventory == None )
		return false;         

	PendingWeapon = Inventory.RecommendWeapon(rating, usealt);
        SetWeapon(PendingWeapon);

	if ( PendingWeapon == Weapon )
		PendingWeapon = None;
	if ( PendingWeapon == None )
		return false;

        if ( Weapon != PendingWeapon )
		Weapon.PutDown();

	return (usealt > 0);
}

function bool WillTakeStompDamage(actor stomper)
{
        return false;
}

function InitializeInventory(){}

function TakeHit(EHitLocation hitPos){}

function UpdatePoison(float deltaTime)
{
	if ((Health <= 0) || bDeleteMe)  // no more pain -- you're already dead!
		return;       

	if (poisonCounter > 0)
	{
		poisonTimer += deltaTime;
		if (poisonTimer >= 2.0)  // pain every two seconds
		{
			poisonTimer = 0;
			poisonCounter--;
			TakeDamage(poisonDamage, Poisoner, Location, vect(0,0,0), 'PoisonGas');
		}
		if ((poisonCounter <= 0) || (Health <= 0) || bDeleteMe)
			StopPoison();
	}
}

function PlayPreAttackSearchingSound(){}

function PlayPreAttackSightingSound(){}

function PlayPostAttackSearchingSound(){}

function PlayTargetAcquiredSound(){}

function PlayTargetLostSound(){}

function PlaySearchGiveUpSound(){}

function PlayOutOfAmmoSound(){}

function PlayAreaSecureSound(){}

function PlaySurpriseSound(){}

function PlayCarcassSound(){}

function bool AddInventory( inventory NewItem )
{
	local inventory Inv;
	
	if (NewItem ==None )
		log("tried to add none inventory to "$self);

	for( Inv=Inventory; Inv!=None; Inv=Inv.Inventory )
		if( Inv == NewItem )
			return false;

	NewItem.SetOwner(Self);
        NewItem.SetBase(Self);
     	NewItem.Inventory = Inventory;
	Inventory = NewItem;

	return true;
}

function float ModifyDamage(int Damage, Pawn instigatedBy, Vector hitLocation,
                            Vector offset, Name damageType)
{
	local int   actualDamage;
	local float headOffsetZ, headOffsetY, armOffset;

	actualDamage = Damage;

	// calculate our hit extents
	headOffsetZ = CollisionHeight * 0.7;
	headOffsetY = CollisionRadius * 0.3;
	armOffset   = CollisionRadius * 0.35;	

	actualDamage = Level.Game.ReduceDamage(actualDamage, DamageType, self, instigatedBy);

	if (ReducedDamageType == 'All') //God mode
		actualDamage = 0;
	else if (Inventory != None) //then check if carrying armor
		actualDamage = Inventory.ReduceDamage(actualDamage, DamageType, HitLocation);

	// gas, EMP and nanovirus do no damage
	if (damageType == 'TearGas' || damageType == 'EMP' || damageType == 'NanoVirus')
		actualDamage = 0;
      
	return actualDamage;
}

function bool ShouldDropWeapon()
{
	return false;
}

function bool ShouldFlee()
{
	return false;
}

function GotoDisabledState(name damageType, EHitLocation hitPos)
{
	if (!bCollideActors && !bBlockActors && !bBlockPlayers)
		return;
	else if (CanShowPain())
		TakeHit(hitPos);
	else
		GotoNextState();
}

function SpurtBlood(){}

function bool ShouldStrafe()
{
       return true;
}

function WarnTarget(Pawn shooter, float projSpeed, vector FireDir)
{
	local float enemyDist;
	local vector X,Y,Z, enemyDir;

	// Bots may duck if not falling
	if ( (health <= 0) || (Enemy == None) 
		|| (Physics == PHYS_Falling) || (Physics == PHYS_Swimming) )
		return;
	
	if ( FRand() > 0.75 )
		return;

	// and projectile time is long enough
	enemyDist = VSize(shooter.Location - Location);
	if (enemyDist/projSpeed < 0.11 + 0.15 * FRand()) 
		return;
					
	// only if tight FOV
	GetAxes(Rotation,X,Y,Z);
	enemyDir = (shooter.Location - Location)/enemyDist;
	if ((enemyDir Dot X) < 0.8)
		return;

	if ( (FireDir Dot Y) > 0 )
	{
		Y *= -1;
		TryToDuck(Y, true);
	}
	else
		TryToDuck(Y, false);
}

function TryToDuck(vector duckDir, bool bReversed)
{
	local vector HitLocation, HitNormal, Extent;
	local actor HitActor;
	local bool bSuccess, bDuckLeft;

	if ( Region.Zone.bWaterZone || (Region.Zone.ZoneGravity.Z > Region.Zone.Default.ZoneGravity.Z) )
		return;

	duckDir.Z = 0;
	bDuckLeft = !bReversed;
	Extent.X = CollisionRadius;
	Extent.Y = CollisionRadius;
	Extent.Z = CollisionHeight;
	HitActor = Trace(HitLocation, HitNormal, Location + 240 * duckDir, Location, false, Extent);
	bSuccess = ( (HitActor == None) || (VSize(HitLocation - Location) > 150) );
	if ( !bSuccess )
	{
		bDuckLeft = !bDuckLeft;
		duckDir *= -1;
		HitActor = Trace(HitLocation, HitNormal, Location + 240 * duckDir, Location, false, Extent);
		bSuccess = ( (HitActor == None) || (VSize(HitLocation - Location) > 150) );
	}
	if ( !bSuccess )
		return;
	
	if ( HitActor == None )
		HitLocation = Location + 240 * duckDir; 

	HitActor = Trace(HitLocation, HitNormal, HitLocation - MaxStepHeight * vect(0,0,1), HitLocation, false, Extent);
	if (HitActor == None)
		return;
		
	SetFall();
	Velocity = duckDir * 400;
	Velocity.Z = 160;
	PlaySound(JumpSound, SLOT_Talk, 1.5, true, 1200, 1.0 - 0.2*FRand());
	SetPhysics(PHYS_Falling);
	if ( (Weapon != None) && Weapon.bSplashDamage
		&& ((bFire != 0) || (bAltFire != 0)) && (Enemy != None) 
		&& !FastTrace(Enemy.Location, HitLocation) 
		&& FastTrace(Enemy.Location, Location) )
	{
		bFire = 0;
		bAltFire = 0;
	}
	GotoState('FallingState','Ducking');
}

state FallingState
{
        function adjustJump()
	{
		local float velZ;
		local vector FullVel;

		velZ = Velocity.Z;
		FullVel = Normal(Velocity) * GroundSpeed;
		Acceleration = vect(0,0,0);
		If (Location.Z > Destination.Z + CollisionHeight + 2 * MaxStepHeight)
		{
			Velocity = FullVel;
			Velocity.Z = velZ;
			Velocity = EAdjustJump();
			Velocity.Z = 0;
			if ( VSize(Velocity) < 0.9 * GroundSpeed )
			{
				Velocity.Z = velZ;
				return;
			}
		}

		PlaySound(JumpSound, SLOT_Talk, 1.5, true, 1200, 1.0 - 0.2*FRand());
		Velocity = FullVel;
		Velocity.Z = Default.JumpZ + velZ;
		Velocity = EAdjustJump();
	}

        function Tick(float DeltaTime)
	{
                Global.Tick(DeltaTime);
		if ( Enemy != None )
		{
			if (AICanShoot(Enemy, true, false, 0.025))
                        {
                                FireWeapon();
				GotoState('FallingState', 'FireWhileFalling');
                        } 
		}
	}
    
        function Landed(vector HitNormal)
	{
		local float landVol, minJumpZ;
		local vector legLocation;

		minJumpZ = FMax(JumpZ, 150.0);

		if ( (Velocity.Z < -0.8 * minJumpZ) || bUpAndOut)
		{
			PlayLanded(Velocity.Z);
			if (Velocity.Z < -1600)
			{
				legLocation = Location + vect(-1,0,-1);			// damage left leg
				TakeDamage(-0.14 * (Velocity.Z + 700), Self, legLocation, vect(0,0,0), 'fell');
				legLocation = Location + vect(1,0,-1);			// damage right leg
				TakeDamage(-0.14 * (Velocity.Z + 700), Self, legLocation, vect(0,0,0), 'fell');
				legLocation = Location + vect(0,0,1);			// damage torso
				TakeDamage(-0.04 * (Velocity.Z + 700), Self, legLocation, vect(0,0,0), 'fell');
			}
			landVol = Velocity.Z/JumpZ;
			landVol = 0.005 * Mass * FMin(5, landVol * landVol);
			if ( !FootRegion.Zone.bWaterZone )
				PlaySound(Land, SLOT_Interact, FMin(20, landVol));
		}
		else if ( Velocity.Z < -0.8 * JumpZ )
			PlayLanded(Velocity.Z);
	}

        function SeePlayer(Actor SeenPlayer)
	{
		Global.SeePlayer(SeenPlayer);
		disable('SeePlayer');
		disable('HearNoise');
	}

	function EnemyNotVisible()
	{
		enable('SeePlayer');
		enable('HearNoise');
	}

        function FindNewJumpDest()
	{
		local NavigationPoint N, Best;
		local float BestRating, Rating;
		local vector Dist;

		// look for pathnode below current location and visible
		BestRating = 1;
		for ( N=Level.NavigationPointList; N!=None; N=N.NextNavigationPoint )
			if ( N.Location.Z + 100 < Location.Z )
			{
				Dist = Location - N.Location;
				Rating = Dist.Z * Dist.Z/(Dist.X * Dist.X + Dist.Y * Dist.Y); 
				if ( (Rating > BestRating) && FastTrace(N.Location, Location) )
				{
					BestRating = Rating;
					Best = N;
				}
			}
				
		if ( Best != None )
			Destination = Best.Location;
	}      
FireWhileFalling:

	Disable('HearNoise');
	Disable('SeePlayer');
	if ( Physics != PHYS_Falling )
		Goto('Done');
	if ( Enemy == None )
		Goto('LongFall');
	TurnToward(Enemy);
	FireIfClearShot();

	if ( Region.Zone.ZoneGravity.Z > Region.Zone.Default.ZoneGravity.Z )
	{
		if ( (Velocity.Z < 0) && (Destination.Z > Location.Z + MaxStepHeight + CollisionHeight) )
			FindNewJumpDest();			
		StrafeFacing(Destination, Enemy);
	}
	else
		Sleep(0.5 + 0.2 * FRand());
	if ( LineOfSightTo(Enemy) )
		Goto('FireWhileFalling');
LongFall:
        if ( (Region.Zone.ZoneGravity.Z > Region.Zone.Default.ZoneGravity.Z)
		&& (Velocity.Z < 0) && (Destination.Z > Location.Z + MaxStepHeight + CollisionHeight) )
	{
		FindNewJumpDest();
		MoveTo(Destination);
	}			
	if ( bCanFly )
	{
		SetPhysics(PHYS_Flying);
		Goto('Done');
	}
	Sleep(0.7);
	PlayFalling();
        if ( Enemy != None )
	    TurnToward(Enemy);
	if ( (Velocity.Z > -150) && (Region.Zone.ZoneGravity.Z <= Region.Zone.Default.ZoneGravity.Z) ) //stuck
	{
		SetPhysics(PHYS_Falling);
		if ( Enemy != None )
			Velocity = groundspeed * normal(Enemy.Location - Location);
		else
			Velocity = groundspeed * VRand();

		Velocity.Z = FMax(JumpZ, 250);
	}
	Goto('LongFall');

FastLanded:
	FinishAnim();
	TweenToWaiting(0.15);
	Goto('Done');

Landed:
	FinishAnim();
	TweenToWaiting(0.2);
	
Done:
	bUpAndOut = false;
	if (HasNextState())
		GotoNextState();
	else
		GotoState('Wandering');

Splash:
	bUpAndOut = false;
	FinishAnim();
	if (HasNextState())
		GotoNextState();
	else
		GotoState('Wandering');

Begin:
	if (Enemy == None)
		Disable('EnemyNotVisible');
	else
	{
		Disable('HearNoise');
		Disable('SeePlayer');
	}
	if (bUpAndOut) //water jump
	{
		if ( !bIsPlayer ) 
		{
			DesiredRotation = Rotation;
			DesiredRotation.Pitch = 0;
			Velocity.Z = 440; 
		}
	}
	else
	{	
		if (Region.Zone.bWaterZone)
		{
			SetPhysics(PHYS_Swimming);
			GotoNextState();
		}	
		if ( !bJumpOffPawn )
			AdjustJump();
		else
			bJumpOffPawn = false;

PlayFall:
		PlayFalling();
		FinishAnim();
	}
	
	if (Physics != PHYS_Falling)
		Goto('Done');
	Sleep(0.0);
        if ((Enemy != None) && (Region.Zone.ZoneGravity.Z > Region.Zone.Default.ZoneGravity.Z))
	{
		Acceleration = AccelRate * Normal(Destination - Location);
		Goto('FireWhileFalling');
	}

	Goto('LongFall');

Ducking:
	if ( Region.Zone.ZoneGravity.Z > Region.Zone.Default.ZoneGravity.Z )
	{
		Acceleration = AccelRate * Normal(Destination - Location);
		PlayFalling();
		if ( Enemy != None )
			Goto('FireWhileFalling');
	}

}

function PlayFalling()
{
	if ( Weapon != None )
	{
		if ( FRand() < 0.5 )
		{
			if (HasTwoHandedWeapon())
				LoopAnimPivot('RunShoot2H',runAnimMult,0.1);
			else
				LoopAnimPivot('RunShoot',runAnimMult,0.1);
		}				
		else
             			PlayShoot();
	}	
	else
		PlayAnimPivot('Jump', 3, 0.1);
}

function PlayLanded(float impactVel)
{
	bIsWalking = True;
	if ( Weapon != None )
		PlayShoot();
	else
		PlayAnimPivot('Land');
}

function Tick(float deltaTime)
{
	Super.Tick(deltaTime); 
        	if (!Level.Game.bTeamGame)
              		CheckAlliances();
}

function CheckAlliances()
{
        	local Pawn p;
 
        	for (p = Level.PawnList; p != None; p = p.NextPawn)
        	{
               		if ((p != Self) && (p.Class == Class))
                        		Destroy();
               		else
                        		ChangeAlly(p.Alliance, -1, true); 
        	}
}

state Roaming
{
	ignores EnemyNotVisible;

        function MayFall()
	{
		bCanJump = ( (MoveTarget != None) 
			  && ((MoveTarget.Physics != PHYS_Falling) || !MoveTarget.IsA('Inventory')) );
	}
	
	function Timer()
	{
                Global.Timer();
	}

	function SetFall()
	{
		StartFalling('Roaming', 'Landed');
	}

	function HitWall(vector HitNormal, actor Wall)
	{
		if (Physics == PHYS_Falling)
			return;
		Global.HitWall(HitNormal, Wall);
                CheckOpenDoor(HitNormal, Wall);
                Focus = Destination;
		if ( !bWallAdjust && PickWallAdjust() )
		{
			if ( Physics == PHYS_Falling )
				SetFall();
			else
				GotoState('Roaming', 'AdjustFromWall');
		}
		else
		{
			MoveTimer = -1.0;
			bWallAdjust = false;
		}
	}

	function PickDestination()
	{
		local inventory Inv, BestInv, KnowPath;
		local float Bestweight, NewWeight, DroppedDist;
		local actor BestPath, HitActor;
		local vector HitNormal, HitLocation;
		local bool bCanReach;
                local NavigationPoint N;
                local Pawn P;
                local Pawn E;
		local int i;

                if ( (EnemyDropped != None) && !EnemyDropped.bDeleteMe && (EnemyDropped.Owner == None))
		{
			DroppedDist = VSize(EnemyDropped.Location - Location);
			if ( (DroppedDist < 800) && ActorReachable(EnemyDropped) )
			{
				BestWeight = EnemyDropped.BotDesireability(self); 		
				if ( BestWeight > 0.4 )
				{
					MoveTarget = EnemyDropped;
					EnemyDropped = None;
					return; 
				}
				BestInv = EnemyDropped;
				BestWeight = BestWeight/DroppedDist;
				KnowPath = BestInv;
			}	
			else
				BestWeight = 0;
		}	
		else
			BestWeight = 0;

		EnemyDropped = None;
								
		foreach visiblecollidingactors(class'Inventory', Inv, 600,,true)
			if ( (Inv.IsInState('PickUp')) && (Inv.MaxDesireability/50 > BestWeight) 
				&& (Inv.Location.Z < Location.Z + MaxStepHeight + CollisionHeight) )
			{
				NewWeight = inv.BotDesireability(self)/VSize(Inv.Location - Location);
				
				if ( NewWeight > BestWeight )
				{
					BestWeight = NewWeight;
					BestInv = Inv;
				}
			}

		if ( BestInv != None )
		{
			bCanJump = ( BestInv.Location.Z > Location.Z - CollisionHeight - MaxStepHeight );
			bCanReach = ActorReachable(BestInv);
		}
		else
			bCanReach = false;
		bCanJump = true;
		if ( bCanReach )
		{
			MoveTarget = BestInv;
			return;
		}
		else if ( KnowPath != None )
		{
			MoveTarget = KnowPath;
			return;
		}

		BestWeight = 0; 

                if ( Level.Game.IsA('KTLGame') && Self.IsA('LeaderBot') )
                {
                        GotoState('Sitting');
                        return;
                }
             
                if ( (Weapon.AIRating > 0.5) && (Health > 90) ) 
		{
			bWantsToCamp = ( bWantsToCamp || (FRand() < CampingRate * FMin(1.0, Level.TimeSeconds - LastCampCheck)) );
			LastCampCheck = Level.TimeSeconds;
		}
		else 
			bWantsToCamp = false;

		if ( bWantsToCamp && FindAmbushSpot() )
			return;             

		// look for long distance inventory 
		BestPath = FindBestInventoryPath(BestWeight, (skill >= 2.00));
		
		if ( BestPath != None )
		{
			MoveTarget = BestPath;
			return;
		}
                
           	//hunt others 
		foreach CycleActors(Class'Pawn', E, CycleIndex)
		{
                        if ((E != None) && (E != Self) && (E.Health > 0) &&
                           ((E.Alliance !='') && (E.Alliance != 'Alliance')) && !LineOfSightTo(E, true))
                        {
                                BestPath = FindPathToward(E);
				if ( BestPath != None )
				{
					MoveTarget = BestPath;
                                        bHunting = True;
                                        return;
				}
                        }
                }        
                // nothing around - maybe just wait a little
                if ( FRand() < 0.35 )
                        HandleEnemy();
                else
		{
			CampTime = 3.0 + FRand();
			GotoState('Roaming', 'Camp');
		}
	}

        function ShareWithTeam()
	{
		local bool bHaveItem, bIsHealth, bOtherHas, bIsWeapon;
		local Pawn P;	

		if ( MoveTarget.IsA('Weapon') )
		{
			if ( (Weapon == None) || (Weapon.AIRating < 0.5) || Weapon(MoveTarget).bWeaponStay )
				return;
			bIsWeapon = true;
			bHaveItem = (FindInventoryType(MoveTarget.class) != None);
		}

		else if ( MoveTarget.IsA('Medkit') )
		{
			bIsHealth = true;
			if ( Health < 70 )
				return;
		}
		
                CampTime = 2.0;
		
		for ( P=Level.PawnList; P!=None; P=P.nextPawn )
			if ( P.bIsPlayer && (P.PlayerReplicationInfo.Team == PlayerReplicationInfo.Team)
				&& ((P.MoveTarget == MoveTarget) || (!bIsHealth && P.IsA('PlayerPawn') && !P.IsA('Spectator') 
						&& (VSize(P.Location - Location) < 1250) && LineOfSightTo(P))) )
			{
				//decide who needs it more
				if ( bIsHealth && ( Health > P.Health + 10 ) )
				{
					GotoState('Roaming', 'GiveWay');
					return;	
				}
                        else if ( bIsWeapon && (P.Weapon != None) && (P.Weapon.AIRating < 0.5) )
            		{
		                  GotoState('Roaming', 'GiveWay');
			            return;
		            }
				else
				{
					bOtherHas = (P.FindInventoryType(MoveTarget.class) != None);
					if ( bHaveItem && !bOtherHas )
					{
						GotoState('Roaming', 'GiveWay');
						return;
					}
				}
			}
	}

        function SeePlayer(Actor SeenPlayer)
	{
             if (SetEnemy(Pawn(SeenPlayer)))
		    HandleEnemy();
	} 
      	
	function AnimEnd() 
	{
	     if ( bCamping )
		    PlayWaiting();
	     else
		    PlayRunning();
	}
		 
	function BeginState()
	{
             StandUp();
	     bStasis = False;
             bCamping = false;
             SetupWeapon(true);
	     SetDistress(false);
	     SeekPawn = None;
             SetPeripheralVision();
             EnableCheckDestLoc(true);
	}

	function EndState()
	{
	      EnableCheckDestLoc(false);
              bCamping = false;
	      bAcceptBump = False;
	      bStasis = True;
              bWallAdjust = false;
              bHunting = False;
              StopBlendAnims();
              SetPeripheralVision();
              if ( !bSniping && (AmbushSpot != None) )
	      {
			AmbushSpot.taken = false;
			AmbushSpot = None;
	      }
	}

LongCamp:
	bCamping = true;
	Acceleration = vect(0,0,0);
	TweenToWaiting(0.15);
        TurnTo(Location + Ambushspot.lookdir);
        Sleep(CampTime);
	Goto('Begin');
GiveWay:	
	bCamping = true;
	Acceleration = vect(0,0,0);
	TweenToWaiting(0.15);
	if ( NearWall(200) )
	{
		PlayTurning();
		TurnTo(MoveTarget.Location);
	}
	Sleep(CampTime);
	Goto('Begin');
Camp:
	bCamping = true;
	Acceleration = vect(0,0,0);
	TweenToWaiting(0.15);
ReCamp:
	if ( NearWall(200) )
	{
		PlayTurning();
		TurnTo(Focus);
	}
     	Sleep(CampTime);
      if (bCampOnlyOnce)
	{
		bCampOnlyOnce = false;
		Goto('Begin');
	}
	if ( (Weapon != None) && (Weapon.AIRating > 0.4) && (3 * FRand() > skill + 1) )
		Goto('ReCamp');
Begin:
      SwitchToBestWeapon();
	bCamping = false;
	TweenToRunning(0.1);
	WaitForLanding();
RunAway:
	PickDestination();
SpecialNavig:
	if (SpecialPause > 0.0)
	{
		Disable('AnimEnd');
		Acceleration = vect(0,0,0);
		TweenToWaiting(0.3);
		Sleep(SpecialPause);
		SpecialPause = 0.0;
		Enable('AnimEnd');
		TweenToRunning(0.1);
		Goto('RunAway');
	}
Moving:
	if ( !IsAnimating() )
		AnimEnd();
	if ( MoveTarget == None )
	{
		Acceleration = vect(0,0,0);
		Sleep(0.0);
		Goto('RunAway');
	}

        if ( MoveTarget.IsA('InventorySpot') )
	{
		if ( (!Level.Game.IsA('BotTeamGame'))
			&& (InventorySpot(MoveTarget).markedItem != None)
			&& (InventorySpot(MoveTarget).markedItem.BotDesireability(self) > 0) )
		{
			if ( InventorySpot(MoveTarget).markedItem.GetStateName() == 'Pickup' )
				MoveTarget = InventorySpot(MoveTarget).markedItem;
			else if (	(InventorySpot(MoveTarget).markedItem.LatentFloat < 5.0)
						&& (InventorySpot(MoveTarget).markedItem.GetStateName() == 'Sleeping')	
						&& (abs(Location.Z - MoveTarget.Location.Z) < CollisionHeight)
						&& (VSize(Location - MoveTarget.Location + vect(0,0,1) * (MoveTarget.Location.Z - Location.Z)) < CollisionRadius * CollisionRadius) )
			{
				CampTime = FMin(5, InventorySpot(MoveTarget).markedItem.LatentFloat + 0.5);
				bCampOnlyOnce = true;
				Goto('Camp');
			}
		}
      }

      else if ( MoveTarget.IsA('Inventory') && Level.Game.bTeamGame )
      {
		ShareWithTeam();
	}
	
	bCamping = false;
	MoveToward(MoveTarget, MaxDesiredSpeed);
	Goto('RunAway');
TakeHit:
	TweenToRunning(0.12);
	Goto('Moving');
Landed:
ContinueFromDoor:
	if ( MoveTarget == None ) 
		Goto('RunAway');
	Goto('Moving');
AdjustFromWall:
	if ( !IsAnimating() )
		AnimEnd();
	bWallAdjust = true;
	bCamping = false;
	StrafeTo(Destination, Focus); 
	Destination = Focus; 
	MoveTo(Destination);
	bWallAdjust = false;
	Goto('Moving');
}

state Fleeing 
{
ignores seeplayer, hearnoise;

	function SetFall()
	{
		StartFalling('Fleeing', 'Landed');
	}

	function HitWall(vector HitNormal, actor Wall)
	{
		if (Physics == PHYS_Falling)
			return;
		Global.HitWall(HitNormal, Wall);
                CheckOpenDoor(HitNormal, Wall);
                Focus = Destination;
		if ( !bWallAdjust && PickWallAdjust() )
		{
			if ( Physics == PHYS_Falling )
				SetFall();
			else
				GotoState('Roaming', 'AdjustFromWall');
		}
		else
		{
			MoveTimer = -1.0;
			bWallAdjust = false;
		}
	}

        function FinishFleeing()
	{
	        FollowOrders();
	}

        function Tick(float deltaSeconds)
	{
                if ((Weapon != None) && ((Weapon.AmmoType.AmmoAmount > 0) || Weapon.bMeleeWeapon))
			  FinishFleeing();
		Global.Tick(deltaSeconds);
	}

	function PickDestination()
	{
		local inventory Inv, BestInv, KnowPath;
		local float Bestweight, NewWeight, DroppedDist;
		local actor BestPath, HitActor;
		local vector HitNormal, HitLocation;
		local bool bCanReach;
                local NavigationPoint N;
		local int i;

                if ( (EnemyDropped != None) && !EnemyDropped.bDeleteMe && (EnemyDropped.Owner == None))
		{
			DroppedDist = VSize(EnemyDropped.Location - Location);
			if ( (DroppedDist < 800) && ActorReachable(EnemyDropped) )
			{
				BestWeight = EnemyDropped.BotDesireability(self); 		
				if ( BestWeight > 0.4 )
				{
					MoveTarget = EnemyDropped;
					EnemyDropped = None;
					return; 
				}
				BestInv = EnemyDropped;
				BestWeight = BestWeight/DroppedDist;
				KnowPath = BestInv;
			}	
			else
				BestWeight = 0;
		}	
		else
			BestWeight = 0;

		EnemyDropped = None;
								
		foreach visiblecollidingactors(class'Inventory', Inv, 600)
			if ( (Inv.IsInState('PickUp')) && (Inv.MaxDesireability/50 > BestWeight) 
				&& (Inv.Location.Z < Location.Z + MaxStepHeight + CollisionHeight) )
			{
				NewWeight = inv.BotDesireability(self)/VSize(Inv.Location - Location);
				
				if ( NewWeight > BestWeight )
				{
					BestWeight = NewWeight;
					BestInv = Inv;
				}
			}

		if ( BestInv != None )
		{
			bCanJump = ( BestInv.Location.Z > Location.Z - CollisionHeight - MaxStepHeight );
			bCanReach = ActorReachable(BestInv);
		}
		else
			bCanReach = false;
		bCanJump = true;
		if ( bCanReach )
		{
			MoveTarget = BestInv;
			return;
		}
		else if ( KnowPath != None )
		{
			MoveTarget = KnowPath;
			return;
		}

		BestWeight = 0;

		// look for long distance inventory 
		BestPath = FindBestInventoryPath(BestWeight, (skill >= 2.00));
		
		if ( BestPath != None )
		{
			MoveTarget = BestPath;
			return;
		}

		if ( FRand() < 0.2 )
                         GotoState('Roaming');
                else
		{
			 CampTime = 3.0 + FRand();
			 GotoState('Fleeing', 'Camp');
		}

	}
      
	function AnimEnd() 
	{
		if ( bCamping )
			 PlayWaiting();
		else
			 PlayRunning();
	}	

        function BeginState()
	{
		StandUp();
		Disable('AnimEnd');
		BlockReactions();
		bStasis = False;
		SetupWeapon(true);
		SetDistress(true);
		EnemyReadiness = 1.0;
		SeekPawn = None;
		EnableCheckDestLoc(false);
	}

LongCamp:
	bCamping = true;
	Acceleration = vect(0,0,0);
	TweenToWaiting(0.15);
	Sleep(5.0);
	Goto('Begin');
GiveWay:	
	bCamping = true;
	Acceleration = vect(0,0,0);
	TweenToWaiting(0.15);
	Sleep(2.0);
	Goto('Begin');
Camp:
	bCamping = true;
	Acceleration = vect(0,0,0);
	TweenToWaiting(0.15);
Begin:
	bCamping = false;
	TweenToRunning(0.1);
	WaitForLanding();
        SwitchToBestWeapon();
RunAway:
	PickDestination();
SpecialNavig:
	if (SpecialPause > 0.0)
	{
		Disable('AnimEnd');
		Acceleration = vect(0,0,0);
		TweenToWaiting(0.3);
		Sleep(SpecialPause);
		SpecialPause = 0.0;
		Enable('AnimEnd');
		TweenToRunning(0.1);
		Goto('RunAway');
	}
Moving:
	if ( !IsAnimating() )
		AnimEnd();
	if ( MoveTarget == None )
	{
		Acceleration = vect(0,0,0);
		Sleep(0.0);
		Goto('RunAway');
	}
      
	bCamping = false;
	MoveToward(MoveTarget, MaxDesiredSpeed);
	Goto('RunAway');
TakeHit:
	TweenToRunning(0.12);
	Goto('Moving');
Landed:
ContinueFromDoor:
	if ( MoveTarget == None ) 
		Goto('RunAway');
	Goto('Moving');
AdjustFromWall:
	if ( !IsAnimating() )
		AnimEnd();
	bWallAdjust = true;
	bCamping = false;
	StrafeTo(Destination, Focus); 
	Destination = Focus; 
	MoveTo(Destination);
	bWallAdjust = false;
	Goto('Moving');
}

state Sitting
{
        function SeePlayer(Actor SeenPlayer)
	{
               if (SetEnemy(Pawn(SeenPlayer)))
		        HandleEnemy();
	} 

        function FollowSeatFallbackOrders()
	{
		FindBestSeat();
		if (IsSeatValid(SeatActor))
			GotoState('Sitting', 'Begin');
		else
			GotoState('Roaming');
	}

Begin:
	WaitForLanding();
	if (!IsSeatValid(SeatActor))
		FollowSeatFallbackOrders();
	if (!bSitting)
		WaitForLanding();
	else
	{
		TurnTo(Vector(SeatActor.Rotation+Rot(0, -16384, 0))*100+Location);
		Goto('ContinueSitting');
	}

MoveToSeat:
	if (IsIntersectingSeat())
		Goto('MoveToPosition');
	bAcceptBump = true;
	while (true)
	{
		if (!IsSeatValid(SeatActor))
			FollowSeatFallbackOrders();
		destLoc = GetDestinationPosition(SeatActor);
		if (PointReachable(destLoc))
		{
			PlayRunning();
			MoveTo(destLoc, MaxDesiredSpeed);
			CheckDestLoc(destLoc);

			if (IsPointInCylinder(self, GetDestinationPosition(SeatActor), 16, 16))
			{
				bAcceptBump = false;
				Goto('MoveToPosition');
				break;
			}
		}
		else
		{
			MoveTarget = GetNextWaypoint(SeatActor);
			if (MoveTarget != None)
			{
			      PlayRunning();
			      MoveToward(MoveTarget, MaxDesiredSpeed);
				CheckDestLoc(MoveTarget.Location, true);
			}
			else
				break;
		}
	}

CircleToFront:
	bAcceptBump = false;
	if (!IsSeatValid(SeatActor))
		FollowSeatFallbackOrders();
	if (ShouldPlayWalk(GetDestinationPosition(SeatActor, 16)))
		PlayWalking();
	MoveTo(GetDestinationPosition(SeatActor, 16), GetWalkingSpeed());

MoveToPosition:
	if (!IsSeatValid(SeatActor))
		FollowSeatFallbackOrders();
	bSitting = true;
	EnableCollision(false);
	Acceleration=vect(0,0,0);

Sit:
	Acceleration=vect(0,0,0);
	Velocity=vect(0,0,0);
	if (!IsSeatValid(SeatActor))
		FollowSeatFallbackOrders();
	remainingSitTime = 0.8;
	PlaySittingDown();
	SetBasedPawnSize(CollisionRadius, GetSitHeight());
	SetPhysics(PHYS_Flying);
	StopStanding();
	bSitInterpolation = true;
	while (bSitInterpolation)
		Sleep(0);
	FinishAnim();
	Goto('ContinueSitting');

ContinueFromDoor:
	Goto('MoveToSeat');

ContinueSitting:
	if (!IsSeatValid(SeatActor))
		FollowSeatFallbackOrders();
	SetBasedPawnSize(CollisionRadius, GetSitHeight());
	SetCollision(Default.bCollideActors, Default.bBlockActors, Default.bBlockPlayers);
	PlaySitting();
	bStasis  = True;
}

state Dying
{
	ignores SeePlayer, EnemyNotVisible, HearNoise, KilledBy, Trigger, Bump, HitWall, HeadZoneChange, FootZoneChange, ZoneChange, Falling, WarnTarget, Died, Timer, TakeDamage, SwitchToBestWeapon;
	
        function ReStartPlayer()
        {
            if (bNoRestart)
                 return;

            if( bHidden && Level.Game.RestartPlayer(self) )
	    {
			Velocity = vect(0,0,0);
			Acceleration = vect(0,0,0);
			ViewRotation = Rotation;
			SetPhysics(PHYS_Falling);
                        GotoState(PlayerReStartState);
            }   		
	    else if ( !IsInState('GameEnded') )
          		GotoState('Dying', 'TryAgain');
        }

	function BeginState()
	{
		EnableCheckDestLoc(false);
		StandUp();
		AIClearEventCallback('Futz');
		AIClearEventCallback('MegaFutz');
		AIClearEventCallback('Player');
		AIClearEventCallback('WeaponDrawn');
		AIClearEventCallback('LoudNoise');
		AIClearEventCallback('WeaponFire');
		AIClearEventCallback('Carcass');
		AIClearEventCallback('Distress');
                KillShadow();
                if ( bSniping && (AmbushSpot != None) )
			AmbushSpot.taken = false;
		AmbushSpot = None;
                bSniping = false;
                bInterruptState = false;
                BlockReactions(true);
		bCanConverse = False;
		bStasis = False;
		SetDistress(true);
		DeathTimer = 0;
	}

        function EndState()
        {
                bInterruptState = true;
                ResetReactions();
                bCanConverse = True;
                CreateShadow();
        }
Begin:
        WaitForLanding();
        MoveFallingBody();

        poisonCounter = 0; 
        poisonTimer = 0;    

	DesiredRotation.Pitch = 0;
	DesiredRotation.Roll  = 0;

	// if we don't gib, then wait for the animation to finish
	if (Health > -100) 
		FinishAnim();

	SetWeapon(None);
        
	bHidden = True;

	Acceleration = vect(0,0,0);
	SpawnCarcass();
TryAgain:
	if ( !bHidden )
              SpawnCarcass();
	HidePlayer();
       	Sleep(RestartWait);
	ReStartPlayer();
	Goto('TryAgain');
}

state GameEnded
{
ignores SeePlayer, HearNoise, KilledBy, Bump, HitWall, HeadZoneChange, FootZoneChange, ZoneChange, Falling, TakeDamage, WarnTarget, Died, PlayFootStep;

	function BeginState()
	{
                ClearNextState();
		SetPhysics(PHYS_None);
		HidePlayer();
	}
}

function UpdateFire()
{
	HealthTorso -= 2;
	GenerateTotalHealth();
	if (Health <= 2)
	{
		TakeDamage(10, myBurner, Location, vect(0,0,0), 'Flamed');
		ExtinguishFire();
	}
}

function Carcass SpawnCarcass()
{
	local DeusExCarcass carc;
        local vector loc;
	local FleshFragment chunk;
	local int i;
	local float size;

	// if we really got blown up good, gib us and don't display a carcass
	if (Health < -100) 
	{
		size = (CollisionRadius + CollisionHeight) / 2;
		if (size > 10.0)
		{
			for (i=0; i<size/4.0; i++)
			{
				loc.X = (1-2*FRand()) * CollisionRadius;
				loc.Y = (1-2*FRand()) * CollisionRadius;
				loc.Z = (1-2*FRand()) * CollisionHeight;
				loc += Location;
				chunk = spawn(class'FleshFragment', None,, loc);
				if (chunk != None)
				{
					chunk.DrawScale = size / 25;
					chunk.SetCollisionSize(chunk.CollisionRadius / chunk.DrawScale, chunk.CollisionHeight / chunk.DrawScale);
					chunk.bFixedRotationDir = True;
					chunk.RotationRate = RotRand(False);
				}                           
			}
		}
		return None;
	}

	// spawn the carcass
	carc = DeusExCarcass(Spawn(CarcassType));

	if ( carc != None )
	{
		carc.Initfor(self);

		// move it down to the floor
		loc = Location;
		loc.z -= Default.CollisionHeight;
		loc.z += carc.Default.CollisionHeight;
		carc.SetLocation(loc);
		carc.Velocity = Velocity;
		carc.Acceleration = Acceleration;
	}
	return carc;
}

defaultproperties
{
     CampingRate=0.250000
     RestartWait=5.000000
     JumpSound=Sound'DeusExSounds.Player.MaleJump'
     TauntType=BM_AreaSecure
     FFType=BM_Futz
     maxRange=3600.000000
     MinHealth=0.000000
     Orders=Roaming
     WalkingSpeed=0.300000
     bKeepWeaponDrawn=True
     bShowPain=False
     bPlayIdle=True
     bSprint=True
     AvoidAccuracy=1.000000
     HarmAccuracy=0.900000
     CrouchRate=0.750000
     SprintRate=1.000000
     CloseCombatMult=1.000000
     RaiseAlarm=RAISEALARM_Never
     MaxProvocations=0
     SurprisePeriod=0.000000
     bCanTurnHead=True
     bTickVisibleOnly=False
     bHighlight=False
     BurnPeriod=15.000000
     bIsPlayer=True
     bAutoActivate=True
     GroundSpeed=350.000000
     AirSpeed=400.000000
     AccelRate=2048.000000
     JumpZ=400.000000
     AirControl=0.350000
     SightRadius=7500.000000
     HearingThreshold=0.200000
     BaseEyeHeight=40.000000
     UnderWaterTime=50.000000
     Intelligence=BRAINS_HUMAN
     HitSound1=Sound'DeusExSounds.Player.MalePainSmall'
     HitSound2=Sound'DeusExSounds.Player.MalePainMedium'
     Die=Sound'DeusExSounds.Player.MaleDeath'
     PlayerReStartState=Roaming
     bStasis=False
     DrawType=DT_Mesh
     CollisionRadius=20.000000
     CollisionHeight=47.500000
     Buoyancy=100.000000
     RotationRate=(Pitch=3072,Yaw=65000,Roll=2048)
     BindName="ScriptedBot"
     FamiliarName="ScriptedBot"
     UnfamiliarName="ScriptedBot"
     NetPriority=3.000000
}
