//=============================================================================
// ScubaDiver.
//=============================================================================
class ScubaDiver extends HumanCivilian;

function GotoDisabledState(name damageType, EHitLocation hitPos)
{
	if (!bCollideActors && !bBlockActors && !bBlockPlayers)
		return;
	if (CanShowPain())
		TakeHit(hitPos);
	else
		GotoNextState();
}

function bool IgnoreDamageType(Name damageType)
{
	if ((damageType == 'TearGas') || (damageType == 'PoisonGas') || (damageType == 'HalonGas'))
		return True;
	else
		return False;
}

function float ShieldDamage(Name damageType)
{
	if (IgnoreDamageType(damageType))
		return 0.0;
	else if (damageType == 'Flamed')
		return 0.2;
	else if ((damageType == 'Poison') || (damageType == 'PoisonEffect'))
		return 0.5;
	else
		return Super.ShieldDamage(damageType);
}

defaultproperties
{
     BaseAccuracy=0.000000
     maxRange=1600.000000
     MinHealth=0.000000
     CarcassType=Class'DeusEx.ScubaDiverCarcass'
     WalkingSpeed=0.296000
     bAvoidAim=True
     bReactProjectiles=True
     bFearShot=False
     bFearIndirectInjury=False
     bFearCarcass=False
     bFearDistress=False
     bFearAlarm=False
     SurprisePeriod=0.100000
     EnemyTimeout=5.000000
     InitialInventory(0)=(Inventory=Class'DeusEx.WeaponMiniCrossbow')
     InitialInventory(1)=(Inventory=Class'DeusEx.AmmoDartPoison',Count=12)
     InitialInventory(2)=(Inventory=Class'DeusEx.WeaponPepperGun')
     InitialInventory(3)=(Inventory=Class'DeusEx.AmmoPepper',Count=12)
     InitialInventory(4)=(Inventory=Class'DeusEx.WeaponCombatKnife')
     BurnPeriod=0.000000
     walkAnimMult=0.780000
     bCanStrafe=True
     GroundSpeed=220.000000
     AccelRate=1024.000000
     Health=200
     UnderWaterTime=-1.000000
     HealthHead=200
     HealthTorso=200
     HealthLegLeft=200
     HealthLegRight=200
     HealthArmLeft=200
     HealthArmRight=200
     Texture=Texture'DeusExCharacters.Skins.ScubasuitTex1'
     Mesh=LodMesh'DeusExCharacters.GM_Scubasuit'
     MultiSkins(0)=Texture'DeusExCharacters.Skins.ScubasuitTex0'
     MultiSkins(1)=Texture'DeusExCharacters.Skins.ScubasuitTex0'
     MultiSkins(2)=Texture'DeusExCharacters.Skins.ScubasuitTex1'
     CollisionRadius=20.000000
     CollisionHeight=47.500000
     BindName="ScubaDiver"
     FamiliarName="Scuba Diver"
     UnfamiliarName="Scuba Diver"
}
