//=============================================================================
// ShockBall.
//=============================================================================
class ShockBall extends DeusExProjectile;

simulated function DrawExplosionEffects(vector HitLocation, vector HitNormal)
{
	local SphereEffect sphere;

	sphere = Spawn(class'SphereEffect',,, HitLocation);
	if (sphere != None)
   	{
		sphere.RemoteRole = ROLE_None;
		sphere.Skin = Skin;
		sphere.size = blastRadius / 32.0;
   	}
}

simulated function SpawnEffects(Vector HitLocation, Vector HitNormal, Actor Other)
{
	local int i;
	local DeusExDecal mark;
   	
   	if (DeusExMover(Other) != None)
		if (DeusExMover(Other).bDestroyed)
			ExplosionDecal = None;
	
	if (ExplosionDecal != None)
	{
		mark = DeusExDecal(Spawn(ExplosionDecal, Self,, HitLocation, Rotator(HitNormal)));
		if (mark != None)
		{
			mark.DrawScale = 0.2;
			mark.ReattachDecal();
		}
		ExplosionDecal = None;
	}
}

auto simulated state Flying
{
    	simulated function Explode(vector HitLocation, vector HitNormal)
    	{
		local bool bDestroy;
		
		if ( Role == ROLE_Authority )
		{
			if (damagee != None)
			{
              				if ( Level.NetMode != NM_Standalone )
				{
					if ( damagee.IsA('DeusExPlayer') )
						DeusExPlayer(damagee).myProjKiller = Self;
				}
				damagee.TakeDamage(Damage, Pawn(Owner), HitLocation, MomentumTransfer*Normal(Velocity), damageType);
				damagee.TakeDamage(Damage, Pawn(Owner), HitLocation, MomentumTransfer*Normal(Velocity), SecondaryDamageType);
			}
		}
		if (!bStuck)
			bDestroy = true;
		
		PlayImpactSound();

      		if (Role == ROLE_Authority)
       		{
           			if (ImpactSound != None)
           			{
               				AISendEvent('LoudNoise', EAITYPE_Audio, 2.0, blastRadius*24);
               				MakeNoise(0.25);
           			}
        		}
        		if ((Level.NetMode != NM_DedicatedServer) || (Role < ROLE_Authority))			
             			DrawExplosionEffects(HitLocation, HitNormal);
		if (bDestroy)
			Destroy();
   	}
}

function PlayImpactSound()
{
	if ((Level.NetMode == NM_Standalone) || (Level.NetMode == NM_ListenServer) || (Level.NetMode == NM_DedicatedServer))
		PlaySound(ImpactSound, SLOT_None, 0.5,, 1024);
}

defaultproperties
{
     blastRadius=32.000000
     DamageType=EMP
     SecondaryDamageType=Stunned
     AccurateRange=14400
     maxRange=24000
     bIgnoresNanoDefense=True
     ItemName="Shock Ball"
     ItemArticle="a"
     speed=2000.000000
     Damage=25.000000
     MomentumTransfer=1000
     ImpactSound=Sound'DeusEx.Impacts.PulseImpact'
     ExplosionDecal=Class'DeusEx.ScorchMark'
     DrawType=DT_Sprite
     Style=STY_Translucent
     Texture=Texture'DeusEx.Effects.asmd_a00'
     Skin=Texture'DeusEx.Effects.asmd_a00'
     DrawScale=0.200000
     bUnlit=True
     LightType=LT_Steady
     LightEffect=LE_NonIncidence
     LightBrightness=128
     LightHue=150
     LightSaturation=32
     LightRadius=3
     bFixedRotationDir=True
}
