//=============================================================================
// SpiderGrenade.
//=============================================================================
class SpiderGrenade extends ThrownProjectile;

simulated function DrawExplosionEffects(vector HitLocation, vector HitNormal)
{
	local ExplosionLight light;
	local int i;
	local Rotator rot;
	local SphereEffect sphere;
   	local ExplosionSmall expeffect;
	local SpiderBot2 Spider;

	// draw a pretty explosion
	light = Spawn(class'ExplosionLight',,, HitLocation);
	if (light != None)
	{
      		if (!bDamaged)
         			light.RemoteRole = ROLE_None;
		light.size = 2;
		light.LightHue = 128;
		light.LightSaturation = 96;
		light.LightEffect = LE_Shell;
	}

	expeffect = Spawn(class'ExplosionSmall',,, HitLocation);
   	if ((expeffect != None) && (!bDamaged))
      		expeffect.RemoteRole = ROLE_None;

	// draw a cool light sphere
	sphere = Spawn(class'SphereEffect',,, HitLocation);
	if (sphere != None)
   	{
      		if (!bDamaged)
         			sphere.RemoteRole = ROLE_None;
		sphere.size = blastRadius / 32.0;
   	}
	Spider = Spawn(class'SpiderBot2',Instigator,, HitLocation + vect(0,0,1) * 30);
	if ( Spider != None )
	{
		if ( Instigator != None )
		{
			Spider.DrawScale = 0.5;
			Spider.MaxStepHeight = 24.0;
			Spider.SetCollisionSize(17.0, 6.5);
			Spider.SetAlliance(Instigator.Alliance);
            			Spider.ChangeAlly(Instigator.Alliance, 1.0, true);
			Spider.SetOrders('Following', '', True);
			Spider.InitializeInventory();
			Spider.InitializeAlliances();
		}
	}
}

defaultproperties
{
     fuseLength=1.500000
     proxRadius=128.000000
     AISoundLevel=0.100000
     bBlood=False
     bDebris=False
     blastRadius=64.000000
     DamageType=NanoVirus
     spawnWeaponClass=Class'DeusEx.WeaponNanoVirusGrenade'
     ItemName="SpiderBot Grenade"
     speed=1000.000000
     MaxSpeed=1000.000000
     Damage=100.000000
     MomentumTransfer=1000
     ImpactSound=Sound'DeusExSounds.Weapons.NanoVirusGrenadeExplode'
     LifeSpan=0.000000
     Mesh=LodMesh'DeusExItems.NanoVirusGrenadePickup'
     CollisionRadius=2.630000
     CollisionHeight=4.410000
     Mass=5.000000
     Buoyancy=2.000000
}
