//=============================================================================
// SpyDrone.
//=============================================================================
class SpyDrone extends ThrownProjectile;

var bool bForceDoors;

auto state Flying
{
	function ProcessTouch (Actor Other, Vector HitLocation)
	{
	}
	simulated function HitWall (vector HitNormal, actor HitWall)
	{
		if (HitWall.IsA('DeusExMover') && bForceDoors )
                    		SetCollision(false, false, false);
                		else
                    		SetCollision(Default.bCollideActors, Default.bBlockActors, Default.bBlockPlayers);
	}
}

function Tick(float deltaTime)
{
	// do nothing
}

function TakeDamage(int Damage, Pawn instigatedBy, Vector HitLocation, Vector Momentum, name damageType)
{
	// fall to the ground if EMP'ed
	if ((DamageType == 'EMP') && !bDisabled)
	{
		SetPhysics(PHYS_Falling);
		bBounce = True;
		LifeSpan = 10.0;
	}

	if ( Level.NetMode != NM_Standalone )
	{
		if ( DeusExPlayer(Owner) != None )
			DeusExPlayer(Owner).ForceDroneOff();
		else
			log("Warning:Drone with no owner?" );
	}
	Super.TakeDamage(Damage, instigatedBy, HitLocation, Momentum, damageType);
}

function BeginPlay()
{
	// do nothing
}

function Destroyed()
{
	if ( DeusExPlayer(Owner) != None )
		DeusExPlayer(Owner).aDrone = None;

	Super.Destroyed();
}

simulated function SpawnEffects(Vector HitLocation, Vector HitNormal, Actor Other)
{
}

simulated function DrawExplosionEffects(vector HitLocation, vector HitNormal)
{
	local int i;
	local Rotator rot;
	local SphereEffect sphere;
        
	// draw a cool light sphere
	sphere = Spawn(class'SphereEffect',,, HitLocation);
	if (sphere != None)
        	{
               		if (!bDamaged)
                  		sphere.RemoteRole = ROLE_None;
	  	sphere.size = blastRadius / 32.0;
        	}
}

defaultproperties
{
     elasticity=0.200000
     fuseLength=0.000000
     bHighlight=False
     bBlood=False
     bDebris=False
     blastRadius=64.000000
     DamageType=NanoVirus
     bEmitDanger=False
     bIgnoresNanoDefense=True
     ItemName="Remote Spy Drone"
     MaxSpeed=0.000000
     Damage=20.000000
     ImpactSound=Sound'DeusExSounds.Augmentation.CloakDown'
     Physics=PHYS_Projectile
     RemoteRole=ROLE_DumbProxy
     LifeSpan=0.000000
     Mesh=LodMesh'DeusExCharacters.SpyDrone'
     SoundRadius=24
     SoundVolume=192
     AmbientSound=Sound'DeusExSounds.Augmentation.AugDroneLoop'
     CollisionRadius=13.000000
     CollisionHeight=2.760000
     Mass=10.000000
     Buoyancy=2.000000
}
