//=============================================================================
// TexturesAndSounds.
// Import textures and sounds and models
//=============================================================================
class TexturesAndSounds expands Object
      abstract;


//Muzzle flashes
#exec Texture Import File=Textures\BioMuzzle.pcx Name=BioMuzzle GROUP="Skins" 
#exec Texture Import File=Textures\Muzzleflash01.pcx Name=Muzzleflash01 GROUP="Skins"
#exec Texture Import File=Textures\Muzzleflash02.pcx Name=Muzzleflash02 GROUP="Skins"
#exec Texture Import File=Textures\Muzzleflash03.pcx Name=Muzzleflash03 GROUP="Skins"

//Crosshair
#exec Texture Import File=Textures\MyCross1.pcx Name=MyCross1 GROUP="Icons" 
#exec Texture Import File=Textures\MyCross2.pcx Name=MyCross2 GROUP="Icons" 
#exec Texture Import File=Textures\MyCross3.pcx Name=MyCross3 GROUP="Icons"
#exec Texture Import File=Textures\Reticle1.pcx Name=Reticle1 GROUP="Icons"

//Shells
#exec MESH IMPORT MESH=Shellc ANIVFILE=MODELS\shellc_a.3D DATAFILE=MODELS\shellc_d.3D X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=Shellc X=0 Y=0 Z=0 YAW=0 ROLL=64
#exec MESH SEQUENCE MESH=Shellc SEQ=All  STARTFRAME=0  NUMFRAMES=1
#exec TEXTURE IMPORT NAME=Shellcase5 FILE=TEXTURES\shellcase5.PCX GROUP="Skins"
#exec MESHMAP SCALE MESHMAP=Shellc X=0.01 Y=0.01 Z=0.01
#exec MESHMAP SETTEXTURE MESHMAP=Shellc NUM=0 TEXTURE=Shellcase5 TLOD=30

//Sounds
#exec AUDIO IMPORT FILE="Sounds\AssaultRifleFire.wav" NAME="AssaultRifleFire" Group="Weapons"
#exec AUDIO IMPORT FILE="Sounds\AssaultRifleFire2.wav" NAME="AssaultRifleFire2" Group="Weapons"
#exec AUDIO IMPORT FILE="Sounds\AssaultRifleFire3.wav" NAME="AssaultRifleFire3" Group="Weapons"
#exec AUDIO IMPORT FILE="Sounds\PS20Fire.wav" NAME="PS20Fire" Group="Weapons"
#exec AUDIO IMPORT FILE="Sounds\PulseGunFire.wav" NAME="PulseGunFire" Group="Weapons"
#exec AUDIO IMPORT FILE="Sounds\SilencedFire2.wav" NAME="SilencedFire2" Group="Weapons"
#exec AUDIO IMPORT FILE="Sounds\SilencedFire3.wav" NAME="SilencedFire3" Group="Weapons"	
#exec AUDIO IMPORT FILE="Sounds\SilencedFire4.wav" NAME="SilencedFire4" Group="Weapons"	
#exec AUDIO IMPORT FILE="Sounds\SilencedFire44.wav" NAME="SilencedFire44" Group="Weapons"
#exec AUDIO IMPORT FILE="Sounds\SilencedFire5.wav" NAME="SilencedFire5" Group="Weapons"	
#exec AUDIO IMPORT FILE="Sounds\ShotgunFire.wav"  NAME="ShotgunFire"   GROUP="Weapons"
#exec AUDIO IMPORT FILE="Sounds\ShotgunBurstFire.wav"  NAME="ShotgunBurstFire"   GROUP="Weapons"
#exec AUDIO IMPORT FILE="Sounds\MachineGunFire.wav"  NAME="MachineGunFire"   GROUP="Weapons"	
#exec AUDIO IMPORT FILE="Sounds\SabotFire.wav"  NAME="SabotFire"   GROUP="Weapons"
#exec AUDIO IMPORT FILE="Sounds\SabotAltFire.wav"  NAME="SabotAltFire"   GROUP="Weapons"
#exec AUDIO IMPORT FILE="Sounds\AssaultRifleAltFire.wav" NAME="AssaultRifleAltFire" Group="Weapons"																		
#exec AUDIO IMPORT FILE="Sounds\EndFire1.wav"  NAME="EndFire1"   GROUP="Weapons"																								
#exec AUDIO IMPORT FILE="Sounds\PistolFire2.wav" NAME="PistolFire2" Group="Weapons"
#exec AUDIO IMPORT FILE="Sounds\PistolFire3.wav" NAME="PistolFire3" Group="Weapons"
#exec AUDIO IMPORT FILE="Sounds\PistolFire4.wav" NAME="PistolFire4" Group="Weapons"
#exec AUDIO IMPORT FILE="Sounds\PlasmaRifleFire1.wav" NAME="PlasmaRifleFire1" Group="Weapons"
#exec AUDIO IMPORT FILE="Sounds\PlasmaRifleFire2.wav" NAME="PlasmaRifleFire2" Group="Weapons"
#exec AUDIO IMPORT FILE="Sounds\BioFire.wav" NAME="BioFire" Group="Weapons"
#exec AUDIO IMPORT FILE="Sounds\BioHit.wav" NAME="BioHit" Group="Weapons"
#exec AUDIO IMPORT FILE="Sounds\BioExp.wav" NAME="BioExp" Group="Weapons"	
#exec AUDIO IMPORT FILE="Sounds\ProdFire2.wav" NAME="ProdFire2" Group="Weapons"										
#exec AUDIO IMPORT FILE="Sounds\FlameAltFire.wav" NAME="FlameAltFire" Group="Weapons"
#exec AUDIO IMPORT FILE="Sounds\SuperPlasmaFire.wav" NAME="SuperPlasmaFire" Group="Weapons"																			
#exec AUDIO IMPORT FILE="Sounds\AmmoLoad.wav" NAME="AmmoLoad" Group="Weapons"
#exec AUDIO IMPORT FILE="Sounds\GEPGunAltFire.wav"  NAME="GEPGunAltFire"   GROUP="Weapons"	
#exec AUDIO IMPORT FILE="Sounds\RailStealthFire.wav"  NAME="RailStealthFire"   GROUP="Weapons"
#exec AUDIO IMPORT FILE="Sounds\SniperFire.wav"  NAME="SniperFire"   GROUP="Weapons"
#exec AUDIO IMPORT FILE="Sounds\ZoomIn.wav"  NAME="ZoomIn"   GROUP="Weapons"
#exec AUDIO IMPORT FILE="Sounds\ZoomOut.wav"  NAME="ZoomOut"   GROUP="Weapons"
#exec AUDIO IMPORT FILE="Sounds\DryClick.wav"  NAME="DryClick"   GROUP="Weapons"
#exec AUDIO IMPORT FILE="Sounds\ShotgunLoadShell.wav"  NAME="ShotgunLoadShell"   GROUP="Weapons"
#exec AUDIO IMPORT FILE="Sounds\ShotgunReloaded.wav"  NAME="ShotgunReloaded"   GROUP="Weapons"
#exec AUDIO IMPORT FILE="Sounds\ShotgunEjectShell.wav"  NAME="ShotgunEjectShell"   GROUP="Weapons"																							
#exec AUDIO IMPORT FILE="Sounds\RespawnSound.wav" NAME="RespawnSound" Group="Effect"																			
#exec AUDIO IMPORT FILE="Sounds\LeaderSound.wav" NAME="LeaderSound" Group="Effect"
#exec AUDIO IMPORT FILE="Sounds\ProdArmorHit.wav" NAME="ProdArmorHit" Group="Effect"	
#exec AUDIO IMPORT FILE="Sounds\MGunFire.wav" NAME="MGunFire" Group="Machinegun"
#exec AUDIO IMPORT FILE="Sounds\PlayerHit1.wav" Name=PlayerHit1 GROUP="Player"
#exec AUDIO IMPORT FILE="Sounds\PlayerHit2.wav" Name=PlayerHit2 GROUP="Player"
#exec AUDIO IMPORT FILE="Sounds\PlayerHit3.wav" Name=PlayerHit3 GROUP="Player"
#exec AUDIO IMPORT FILE="Sounds\PlayerDie1.wav" Name=PlayerDie1 GROUP="Player" 
#exec AUDIO IMPORT FILE="Sounds\PlayerDie2.wav" Name=PlayerDie2 GROUP="Player"
#exec AUDIO IMPORT FILE="Sounds\PlayerDie3.wav" Name=PlayerDie3 GROUP="Player"
#exec AUDIO IMPORT FILE="Sounds\PlayerJump1.wav" Name=PlayerJump1 GROUP="Player"
#exec AUDIO IMPORT FILE="Sounds\PlayerLand1.wav" Name=PlayerLand1 GROUP="Player"																																																																																								
#exec AUDIO IMPORT FILE="Sounds\MechHit1.wav" Name=MechHit1 GROUP="Player"
#exec AUDIO IMPORT FILE="Sounds\MechHit2.wav" Name=MechHit2 GROUP="Player"
#exec AUDIO IMPORT FILE="Sounds\MechDie.wav" Name=MechDie GROUP="Player" 
#exec AUDIO IMPORT FILE="Sounds\MechUnconscious.wav" Name=MechUnconscious GROUP="Player"
#exec AUDIO IMPORT FILE="Sounds\MechUnconscious2.wav" Name=MechUnconscious2 GROUP="Player"
#exec AUDIO IMPORT FILE="Sounds\MjcHit1.wav" Name=MjcHit1 GROUP="Player"
#exec AUDIO IMPORT FILE="Sounds\MjcHit2.wav" Name=MjcHit2 GROUP="Player"
#exec AUDIO IMPORT FILE="Sounds\MechJump.wav" Name=MechJump GROUP="Player"
#exec AUDIO IMPORT FILE="Sounds\HPlayerDie1.wav" Name=HPlayerDie1 GROUP="Player" 
#exec AUDIO IMPORT FILE="Sounds\HPlayerDie2.wav" Name=HPlayerDie2 GROUP="Player"
#exec AUDIO IMPORT FILE="Sounds\HPlayerDie3.wav" Name=HPlayerDie3 GROUP="Player"
#exec AUDIO IMPORT FILE="Sounds\HPlayerJump1.wav" Name=HPlayerJump1 GROUP="Player"
#exec AUDIO IMPORT FILE="Sounds\HPlayerHit1.wav" Name=HPlayerHit1 GROUP="Player"
#exec AUDIO IMPORT FILE="Sounds\HPlayerHit2.wav" Name=HPlayerHit2 GROUP="Player"
#exec AUDIO IMPORT FILE="Sounds\HPlayerHit3.wav" Name=HPlayerHit3 GROUP="Player"
#exec AUDIO IMPORT FILE="Sounds\HPlayerJump1.wav" Name=HPlayerJump1 GROUP="Player"
#exec AUDIO IMPORT FILE="Sounds\FemalePlayerDie1.wav" Name=FemalePlayerDie1 GROUP="Player" 
#exec AUDIO IMPORT FILE="Sounds\FemalePlayerDie2.wav" Name=FemalePlayerDie2 GROUP="Player" 
#exec AUDIO IMPORT FILE="Sounds\FemalePlayerDie3.wav" Name=FemalePlayerDie3 GROUP="Player"
#exec AUDIO IMPORT FILE="Sounds\FemalePlayerHit1.wav" Name=FemalePlayerHit1 GROUP="Player"
#exec AUDIO IMPORT FILE="Sounds\FemalePlayerHit2.wav" Name=FemalePlayerHit2 GROUP="Player"
#exec AUDIO IMPORT FILE="Sounds\FemalePlayerHit3.wav" Name=FemalePlayerHit3 GROUP="Player"
#exec AUDIO IMPORT FILE="Sounds\BulletImpactMetal1.wav"  NAME="BulletImpactMetal1"   GROUP="Impacts"
#exec AUDIO IMPORT FILE="Sounds\BulletImpactMetal2.wav"  NAME="BulletImpactMetal2"   GROUP="Impacts"
#exec AUDIO IMPORT FILE="Sounds\PulseImpact.wav"  NAME="PulseImpact"   GROUP="Impacts"  

//DoublePistol
#exec MESH IMPORT MESH=Glockl ANIVFILE=MODELS\Glockl_a.3d DATAFILE=MODELS\Glockl_d.3d unmirror=1 
#exec MESH ORIGIN MESH=Glockl X=0 Y=0 Z=0 YAW=-64
#exec MESHMAP SCALE MESHMAP=Glockl X=0.00390625 Y=0.00390625 Z=0.00390625
#exec MESH SEQUENCE MESH=Glockl SEQ=All			STARTFRAME=0	NUMFRAMES=82
#exec MESH SEQUENCE MESH=Glockl SEQ=Still		STARTFRAME=51	NUMFRAMES=1
#exec MESH SEQUENCE MESH=Glockl SEQ=Select		STARTFRAME=1	NUMFRAMES=15	RATE=24 GROUP=Select
#exec MESH SEQUENCE MESH=Glockl SEQ=Shoot		STARTFRAME=16	NUMFRAMES=8		RATE=36
#exec MESH SEQUENCE MESH=Glockl SEQ=ReloadBegin	STARTFRAME=24	NUMFRAMES=16	RATE=24
#exec MESH SEQUENCE MESH=Glockl SEQ=Reload		STARTFRAME=40	NUMFRAMES=5		RATE=8
#exec MESH SEQUENCE MESH=Glockl SEQ=ReloadEnd	STARTFRAME=45	NUMFRAMES=3		RATE=8
#exec MESH SEQUENCE MESH=Glockl SEQ=Down			STARTFRAME=48	NUMFRAMES=3		RATE=24
#exec MESH SEQUENCE MESH=Glockl SEQ=Idle1		STARTFRAME=51	NUMFRAMES=8		RATE=4
#exec MESH SEQUENCE MESH=Glockl SEQ=Idle2		STARTFRAME=59	NUMFRAMES=12	RATE=4
#exec MESH SEQUENCE MESH=Glockl SEQ=Idle3		STARTFRAME=71	NUMFRAMES=11	RATE=4

#exec MESHMAP SETTEXTURE MESHMAP=Glockl NUM=1 TEXTURE=DeusExItems.Skins.WeaponHandsTex
#exec MESHMAP SETTEXTURE MESHMAP=Glockl NUM=2 TEXTURE=DeusExItems.Skins.WeaponHandsTex
#exec MESHMAP SETTEXTURE MESHMAP=Glockl NUM=3 TEXTURE=DeusExItems.Skins.GlockTex1
#exec MESHMAP SETTEXTURE MESHMAP=Glockl NUM=4 TEXTURE=DeusExItems.Skins.PinkMaskTex

#exec MESH NOTIFY MESH=Glockl SEQ=Shoot	TIME=0.02	FUNCTION=SwapMuzzleFlashTexture

//Biogel
#exec MESH IMPORT MESH=BioGelm ANIVFILE=MODELS\BioGelm_a.3D DATAFILE=MODELS\BioGelm_d.3D X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=BioGelm X=0 Y=0 Z=0 YAW=0 PITCH=-64 ROLL=0
#exec MESH SEQUENCE MESH=BioGelm SEQ=All     STARTFRAME=0   NUMFRAMES=56
#exec MESH SEQUENCE MESH=BioGelm SEQ=Flying  STARTFRAME=0   NUMFRAMES=13
#exec MESH SEQUENCE MESH=BioGelm SEQ=Still   STARTFRAME=13  NUMFRAMES=1
#exec MESH SEQUENCE MESH=BioGelm SEQ=Hit     STARTFRAME=14  NUMFRAMES=10
#exec MESH SEQUENCE MESH=BioGelm SEQ=Drip    STARTFRAME=24  NUMFRAMES=13
#exec MESH SEQUENCE MESH=BioGelm SEQ=Slide   STARTFRAME=37  NUMFRAMES=7
#exec MESH SEQUENCE MESH=BioGelm SEQ=Shrivel STARTFRAME=44  NUMFRAMES=12
#exec MESHMAP SCALE MESHMAP=BioGelm X=0.2 Y=0.2 Z=0.2
#exec MESHMAP SETTEXTURE MESHMAP=BioGelm NUM=0 TEXTURE=DeusExDeco.Skins.AlarmLightTex5
#exec MESH NOTIFY MESH=BioGelm SEQ=Drip TIME=0.6 FUNCTION=DropDrip

//
//PlasmaBall
//
#exec TEXTURE IMPORT NAME=phit_a00 FILE=Textures\phit_a00.pcx GROUP="Effects"
#exec TEXTURE IMPORT NAME=phit_a01 FILE=Textures\phit_a01.pcx GROUP="Effects"
#exec TEXTURE IMPORT NAME=phit_a02 FILE=Textures\phit_a02.pcx GROUP="Effects"
#exec TEXTURE IMPORT NAME=phit_a03 FILE=Textures\phit_a03.pcx GROUP="Effects"

//Taunts
#exec Texture Import File=Textures\aj_tp.pcx Name=aj_tp GROUP="Taunts"
#exec Texture Import File=Textures\an_tp.pcx Name=an_tp GROUP="Taunts"
#exec Texture Import File=Textures\fem_tp.pcx Name=fem_tp GROUP="Taunts"
#exec Texture Import File=Textures\gh_tp.pcx Name=gh_tp GROUP="Taunts"
#exec Texture Import File=Textures\gq_tp.pcx Name=gq_tp GROUP="Taunts"
#exec Texture Import File=Textures\hs_tp.pcx Name=hs_tp GROUP="Taunts"
#exec Texture Import File=Textures\ivan_tp.pcx Name=ivan_tp GROUP="Taunts"
#exec Texture Import File=Textures\jan_tp.pcx Name=jan_tp GROUP="Taunts"
#exec Texture Import File=Textures\jc_tp.pcx Name=jc_tp GROUP="Taunts"
#exec Texture Import File=Textures\jock_tp.pcx Name=jock_tp GROUP="Taunts"
#exec Texture Import File=Textures\lp_tp.pcx Name=lp_tp GROUP="Taunts"
#exec Texture Import File=Textures\mch_tp.pcx Name=mch_tp GROUP="Taunts"
#exec Texture Import File=Textures\smug_tp.pcx Name=smug_tp GROUP="Taunts"
#exec Texture Import File=Textures\mib_tp.pcx Name=mib_tp GROUP="Taunts"
#exec Texture Import File=Textures\mj_tp.pcx Name=mj_tp GROUP="Taunts"
#exec Texture Import File=Textures\pd_tp.pcx Name=pd_tp GROUP="Taunts"
#exec Texture Import File=Textures\riot_tp.pcx Name=riot_tp GROUP="Taunts"
#exec Texture Import File=Textures\cop_tp.pcx Name=cop_tp GROUP="Taunts"
#exec Texture Import File=Textures\terr_tp.pcx Name=terr_tp GROUP="Taunts"
#exec Texture Import File=Textures\mchen_tp.pcx Name=mchen_tp GROUP="Taunts"
#exec Texture Import File=Textures\res_tp.pcx Name=res_tp GROUP="Taunts"
#exec Texture Import File=Textures\tt_tp.pcx Name=tt_tp GROUP="Taunts"
#exec Texture Import File=Textures\un_tp.pcx Name=un_tp GROUP="Taunts"
#exec Texture Import File=Textures\wib_tp.pcx Name=wib_tp GROUP="Taunts"
#exec Texture Import File=Textures\ws_tp.pcx Name=ws_tp GROUP="Taunts"
#exec Texture Import File=Textures\sc_tp.pcx Name=sc_tp GROUP="Taunts"


//Misc
#exec Texture Import File=Textures\asmd_a00.pcx Name=asmd_a00 GROUP="Effects"
#exec Texture Import File=Textures\asmd_a01.pcx Name=asmd_a01 GROUP="Effects"
#exec Texture Import File=Textures\asmd_a02.pcx Name=asmd_a02 GROUP="Effects"
#exec Texture Import File=Textures\asmd_a03.pcx Name=asmd_a03 GROUP="Effects"
#exec Texture Import File=Textures\pbolt_a00.pcx Name=pbolt_a00 GROUP="Effects"
#exec Texture Import File=Textures\pbolt_a01.pcx Name=pbolt_a01 GROUP="Effects"
#exec Texture Import File=Textures\pbolt_a02.pcx Name=pbolt_a02 GROUP="Effects"
#exec Texture Import File=Textures\pbolt_a03.pcx Name=pbolt_a03 GROUP="Effects"
#exec Texture Import File=Textures\pbolt_a04.pcx Name=pbolt_a04 GROUP="Effects"
#exec Texture Import File=Textures\GreenRing.pcx Name=GreenRing GROUP="Effects"

//Cyborg Dog
#exec Texture Import File=Textures\CDog.pcx Name=CDog GROUP="Icons"
#exec Texture Import File=Textures\CDog_Belt.pcx Name=CDog_Belt GROUP="Icons"


///////////////////////////////////////////////////////
///////////////////////////////////////////////////////
//////////////////////////////////////////////////////
//NEW WEAPONS
//////////////////////////////////////////////////////
//////////////////////////////////////////////////////
//////////////////////////////////////////////////////

// QuadShot--------------------------------------------------------------------
#exec TEXTURE IMPORT NAME=GunPick1 FILE=TEXTURES\GunPick1.PCX GROUP="Skins" FLAGS=2
#exec TEXTURE IMPORT NAME=QuadHand1 FILE=TEXTURES\GunPick1.PCX GROUP="Skins"
// pickup
#exec MESH IMPORT MESH=QuadShotPickup ANIVFILE=MODELS\QuadShotPickup_a.3D DATAFILE=MODELS\QuadShotPickup_d.3D X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=QuadShotPickup X=0 Y=-50 Z=-15 YAW=0 PITCH=-64
#exec MESH SEQUENCE MESH=QuadShotPickup SEQ=All  STARTFRAME=0  NUMFRAMES=1
#exec MESHMAP SCALE MESHMAP=QuadShotPickup X=0.2 Y=0.2 Z=0.2
#exec MESHMAP SETTEXTURE MESHMAP=QuadShotPickup NUM=0 TEXTURE=GunPick1 
#exec MESHMAP SETTEXTURE MESHMAP=QuadShotPickup NUM=1 TEXTURE=BlackMaskTex
// for Bots/NPC
#exec MESH IMPORT MESH=QuadShot3 ANIVFILE=MODELS\QuadShot3_a.3D DATAFILE=MODELS\QuadShot3_d.3D X=0 Y=0 Z=0 
#exec MESH ORIGIN MESH=QuadShot3 X=1 Y=-85 Z=-25 YAW=-56 ROLL=-30
#exec MESH SEQUENCE MESH=QuadShot3 SEQ=All  STARTFRAME=0  NUMFRAMES=1
#exec MESH SEQUENCE MESH=QuadShot3 SEQ=Shoot  STARTFRAME=3  NUMFRAMES=6
#exec MESHMAP SCALE MESHMAP=QuadShot3 X=0.2 Y=0.2 Z=0.2
#exec MESHMAP SETTEXTURE MESHMAP=QuadShot3 NUM=0 TEXTURE=GunPick1
#exec MESHMAP SETTEXTURE MESHMAP=QuadShot3 NUM=1 TEXTURE=DeusExItems.Skins.PinkMaskTex
#exec MESHMAP SETTEXTURE MESHMAP=QuadShot3 NUM=2 TEXTURE=DeusExItems.Skins.PinkMaskTex
#exec MESH NOTIFY MESH=QuadShot3 SEQ=Shoot	TIME=0.01 FUNCTION=SwapMuzzleFlashTexture


// ======== PlayerView version ==================
#exec MESH IMPORT MESH=QuadShotHeld ANIVFILE=MODELS\QuadShotHeld_a.3D DATAFILE=MODELS\QuadShotHeld_d.3D X=0 Y=0 Z=0 UnMirror=1 // :O
#exec MESH ORIGIN MESH=QuadShotHeld X=0 Y=0 Z=0 YAW=0 PITCH=0 ROLL=0 // yaw was 128
#exec MESH SEQUENCE MESH=QuadShotHeld SEQ=All STARTFRAME=0 NUMFRAMES=100

// Idle animations
#exec MESH SEQUENCE MESH=QuadShotHeld SEQ=Idle1  STARTFRAME=86  NUMFRAMES=14 RATE=1
#exec MESH SEQUENCE MESH=QuadShotHeld SEQ=Idle2  STARTFRAME=86  NUMFRAMES=14 RATE=1
#exec MESH SEQUENCE MESH=QuadShotHeld SEQ=Idle3  STARTFRAME=86  NUMFRAMES=14 RATE=1

// Reloading 
#exec MESH SEQUENCE MESH=QuadShotHeld SEQ=ReloadBegin STARTFRAME=33  NUMFRAMES=8 RATE=7
#exec MESH SEQUENCE MESH=QuadShotHeld SEQ=Reload STARTFRAME=43  NUMFRAMES=2 RATE=3
#exec MESH SEQUENCE MESH=QuadShotHeld SEQ=ReloadEnd STARTFRAME=46  NUMFRAMES=4 RATE=15
//#exec MESH SEQUENCE MESH=QuadShotHeld SEQ=ReloadBegin STARTFRAME=34  NUMFRAMES=10 RATE=7
//#exec MESH SEQUENCE MESH=QuadShotHeld SEQ=Reload STARTFRAME=43  NUMFRAMES=4 RATE=5
//#exec MESH SEQUENCE MESH=QuadShotHeld SEQ=ReloadEnd STARTFRAME=46  NUMFRAMES=4 RATE=15

// Other
#exec MESH SEQUENCE MESH=QuadShotHeld SEQ=Select STARTFRAME=5  NUMFRAMES=7 Group="Select" RATE=20
#exec MESH SEQUENCE MESH=QuadShotHeld SEQ=Down STARTFRAME=12  NUMFRAMES=7 RATE=25
#exec MESH SEQUENCE MESH=QuadShotHeld SEQ=Shoot STARTFRAME=22  NUMFRAMES=6 RATE=45
#exec MESH SEQUENCE MESH=QuadShotHeld SEQ=ShootShort STARTFRAME=24  NUMFRAMES=3 RATE=45
#exec MESH SEQUENCE MESH=QuadShotHeld SEQ=Still  STARTFRAME=71  NUMFRAMES=1
// 
/*#exec MESHMAP SCALE MESHMAP=QuadShotHeld X=0.296594 Y=0.296594 Z=0.296594*/

/*#exec MESHMAP SCALE MESHMAP=QuadShotHeld X=0.00390625 Y=0.00390625 Z=0.00390625*/
#exec MESHMAP SCALE MESHMAP=QuadShotHeld X=0.08 Y=0.08 Z=0.08


#exec MESHMAP SETTEXTURE MESHMAP=QuadShotHeld NUM=0 TEXTURE=QuadHand1
#exec MESHMAP SETTEXTURE MESHMAP=QuadShotHeld NUM=1 TEXTURE=WeaponHandsTex
// #exec MESHMAP SETTEXTURE MESHMAP=QuadShotHeld NUM=4 TEXTURE=SomethingWithShininess
#exec MESH LODPARAMS MESH=QuadShotHeld MORPH=0.1


#exec MESH NOTIFY MESH=QuadShotHeld SEQ=Shoot	TIME=0.10	FUNCTION=QuadSound

// Muzzle flashes
#exec TEXTURE IMPORT NAME=SniperMuzzle1  FILE=Textures\SniperMuzzle1.pcx  LODSET=2
#exec TEXTURE IMPORT NAME=SniperMuzzle2  FILE=Textures\SniperMuzzle2.pcx  LODSET=2
// Icons
#exec TEXTURE IMPORT NAME=QIcon FILE=Textures\QIcon.pcx GROUP=Icons FLAGS=2 MIPS=OFF  LODSET=2
#exec TEXTURE IMPORT NAME=QBeltIcon FILE=Textures\QBeltIcon.pcx GROUP=Icons FLAGS=2 MIPS=OFF LODSET=2
// Fire sound
#exec AUDIO IMPORT NAME=QuadShotFire FILE=Sounds\QuadShotFire.wav GROUP=Weapon
#exec AUDIO IMPORT NAME=QuadShotAltFire FILE=Sounds\QuadShotAltFire.wav GROUP=Weapon

//-----------------------------------------------


// ================================ Shotgun
//
// player view version
#exec MESH IMPORT MESH=Shotgun1 ANIVFILE=Models\Shotgun_a.3d DATAFILE=Models\Shotgun_d.3d
#exec MESH ORIGIN MESH=Shotgun1 X=0 Y=0 Z=0 YAW=-64
#exec MESHMAP SCALE MESHMAP=Shotgun1 X=0.00390625 Y=0.00390625 Z=0.00390625
#exec MESH SEQUENCE MESH=Shotgun1 SEQ=All			STARTFRAME=0	NUMFRAMES=74
#exec MESH SEQUENCE MESH=Shotgun1 SEQ=Still			STARTFRAME=0	NUMFRAMES=1
#exec MESH SEQUENCE MESH=Shotgun1 SEQ=Select			STARTFRAME=1	NUMFRAMES=12	RATE=12	GROUP=Select
#exec MESH SEQUENCE MESH=Shotgun1 SEQ=AltReloadEnd			STARTFRAME=5	NUMFRAMES=8	RATE=8	GROUP=AltReloadEnd FUNCTION=ShotGunReloadEnd
#exec MESH SEQUENCE MESH=Shotgun1 SEQ=Shoot			STARTFRAME=13	NUMFRAMES=15	RATE=11
#exec MESH SEQUENCE MESH=Shotgun1 SEQ=ReloadBegin	STARTFRAME=28	NUMFRAMES=5		RATE=10
#exec MESH SEQUENCE MESH=Shotgun1 SEQ=Reload			STARTFRAME=33	NUMFRAMES=7		RATE=8
#exec MESH SEQUENCE MESH=Shotgun1 SEQ=ReloadEnd		STARTFRAME=40	NUMFRAMES=4		RATE=8
#exec MESH SEQUENCE MESH=Shotgun1 SEQ=Down			STARTFRAME=44	NUMFRAMES=6		RATE=8
#exec MESH SEQUENCE MESH=Shotgun1 SEQ=Idle1			STARTFRAME=50	NUMFRAMES=8		RATE=3
#exec MESH SEQUENCE MESH=Shotgun1 SEQ=Idle2			STARTFRAME=58	NUMFRAMES=8		RATE=3
#exec MESH SEQUENCE MESH=Shotgun1 SEQ=Idle3			STARTFRAME=66	NUMFRAMES=8		RATE=3

#exec MESHMAP SETTEXTURE MESHMAP=Shotgun1 NUM=0 TEXTURE=WeaponHandsTex
#exec MESHMAP SETTEXTURE MESHMAP=Shotgun1 NUM=1 TEXTURE=ShotgunTex1
#exec MESHMAP SETTEXTURE MESHMAP=Shotgun1 NUM=2 TEXTURE=BlackMaskTex
#exec MESHMAP SETTEXTURE MESHMAP=Shotgun1 NUM=3 TEXTURE=WeaponHandsTex

#exec MESH NOTIFY MESH=Shotgun1 SEQ=Shoot	TIME=0.05	FUNCTION=SwapMuzzleFlashTexture
#exec MESH NOTIFY MESH=Shotgun1 SEQ=Shoot	TIME=0.40	FUNCTION=SawedOffCockSound

#exec AUDIO IMPORT NAME=ShotgunReload FILE=Sounds\ShotgunReload.wav GROUP=Weapon



// UMP

#exec TEXTURE IMPORT NAME=UMP_inv FILE=textures\ump_inv.pcx GROUP=Icons MIPS=OFF FLAGS=2 LODSET=2
#exec TEXTURE IMPORT NAME=UMP_belt FILE=textures\ump_belt.pcx GROUP=Icons MIPS=OFF FLAGS=2 LODSET=2


#exec TEXTURE IMPORT NAME=UMPTex4 FILE=textures\UMPTex4.bmp GROUP=Skins
#exec TEXTURE IMPORT NAME=UMPTex5 FILE=textures\UMPTex5.bmp GROUP=Skins
#exec TEXTURE IMPORT NAME=UMPTex3 FILE=textures\UMPTex3.bmp GROUP=Skins
#exec TEXTURE IMPORT NAME=UMPLauncherTex FILE=textures\UMPLauncherTex.bmp GROUP=Skins
#exec TEXTURE IMPORT NAME=UMPLensTex FILE=textures\UMPLensTex.bmp GROUP=Skins
#exec TEXTURE IMPORT NAME=UMPSightTex FILE=textures\UMPSightTex.bmp GROUP=Skins

#exec AUDIO IMPORT FILE="Sounds\UMPTacticalFire.wav" NAME="UMPTacticalFire" Group="Weapons"
#exec AUDIO IMPORT FILE="Sounds\UMPTacticalSelect.wav" NAME="UMPTacticalSelect" Group="Weapons"
#exec AUDIO IMPORT FILE="Sounds\UMPTacticalReloadEnd.wav" NAME="UMPTacticalReloadEnd" Group="Weapons"
#exec AUDIO IMPORT FILE="Sounds\UMPTacticalReloadBegin.wav" NAME="UMPTacticalReloadBegin" Group="Weapons"

///////////////////////////////////////////////////
// umptactical3rd.
///////////////////////////////////////////////////

#exec MESH IMPORT MESH=umptactical3rd ANIVFILE=MODELS\umptactical3rd_a.3d DATAFILE=MODELS\umptactical3rd_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=umptactical3rd X=0 Y=0 Z=0 YAW=-64

#exec MESH SEQUENCE MESH=umptactical3rd SEQ=All STARTFRAME=0 NUMFRAMES=100
#exec MESHMAP NEW MESHMAP=umptactical3rd MESH=umptactical3rd

#exec MESH LODPARAMS MESH=umptactical3rd STRENGTH=0

#exec MESHMAP SCALE MESHMAP=umptactical3rd X=0.158781 Y=0.158781 Z=0.158781
#exec MESHMAP SETTEXTURE MESHMAP=umptactical3rd NUM=0 TEXTURE=UMPTex4
#exec MESHMAP SETTEXTURE MESHMAP=umptactical3rd NUM=1 TEXTURE=UMPTex5
#exec MESHMAP SETTEXTURE MESHMAP=umptactical3rd NUM=2 TEXTURE=BlackMaskTex
#exec MESHMAP SETTEXTURE MESHMAP=umptactical3rd NUM=3 TEXTURE=UMPTex3
#exec MESHMAP SETTEXTURE MESHMAP=umptactical3rd NUM=4 TEXTURE=UMPSightTex
#exec MESHMAP SETTEXTURE MESHMAP=umptactical3rd NUM=5 TEXTURE=UMPLensTex
#exec MESHMAP SETTEXTURE MESHMAP=umptactical3rd NUM=6 TEXTURE=umpLauncherTex

///////////////////////////////////////////////////
// umptacticalpickup.
///////////////////////////////////////////////////

#exec MESH IMPORT MESH=umptacticalpickup ANIVFILE=MODELS\umptacticalpickup_a.3d DATAFILE=MODELS\umptacticalpickup_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=umptacticalpickup X=0 Y=0 Z=0

#exec MESH SEQUENCE MESH=umptacticalpickup SEQ=All STARTFRAME=0 NUMFRAMES=100
#exec MESHMAP NEW MESHMAP=umptacticalpickup MESH=umptacticalpickup

#exec MESH LODPARAMS MESH=umptacticalpickup STRENGTH=0

#exec MESHMAP SCALE MESHMAP=umptacticalpickup X=0.122833 Y=0.122833 Z=0.122833
#exec MESHMAP SETTEXTURE MESHMAP=umptacticalpickup NUM=0 TEXTURE=UMPTex4
#exec MESHMAP SETTEXTURE MESHMAP=umptacticalpickup NUM=1 TEXTURE=UMPTex5
#exec MESHMAP SETTEXTURE MESHMAP=umptacticalpickup NUM=2 TEXTURE=UMPTex3
#exec MESHMAP SETTEXTURE MESHMAP=umptacticalpickup NUM=3 TEXTURE=UMPSightTex
#exec MESHMAP SETTEXTURE MESHMAP=umptacticalpickup NUM=4 TEXTURE=UMPLensTex
#exec MESHMAP SETTEXTURE MESHMAP=umptacticalpickup NUM=5 TEXTURE=UMPLauncherTex

//=============================================================================
// umptactical1st.
//=============================================================================

#exec MESH IMPORT MESH=umptactical1st ANIVFILE=MODELS\umptactical1st_a.3d DATAFILE=MODELS\umptactical1st_d.3d X=0 Y=0 Z=0 unmirror=0
#exec MESH ORIGIN MESH=umptactical1st X=4500 Y=2800 Z=600 YAW=-64 // **X**(-)forward(+)back **Y**(-)right(+)left **Z**(-)up(+)down

#exec MESH SEQUENCE MESH=umptactical1st SEQ=All			STARTFRAME=0	NUMFRAMES=77
#exec MESH SEQUENCE MESH=umptactical1st SEQ=Still		STARTFRAME=0	NUMFRAMES=1
#exec MESH SEQUENCE MESH=umptactical1st SEQ=Select		STARTFRAME=1	NUMFRAMES=22	RATE=40
#exec MESH SEQUENCE MESH=umptactical1st SEQ=Shoot		STARTFRAME=23	NUMFRAMES=6		RATE=50
#exec MESH SEQUENCE MESH=umptactical1st SEQ=ReloadBegin	STARTFRAME=36	NUMFRAMES=7	RATE=20
#exec MESH SEQUENCE MESH=umptactical1st SEQ=Reload		STARTFRAME=45 NUMFRAMES=3		RATE=4
#exec MESH SEQUENCE MESH=umptactical1st SEQ=ReloadEnd	STARTFRAME=50	NUMFRAMES=12		RATE=18
#exec MESH SEQUENCE MESH=umptactical1st SEQ=Down			STARTFRAME=64	NUMFRAMES=4		RATE=8
#exec MESH SEQUENCE MESH=umptactical1st SEQ=Idle1			STARTFRAME=70	NUMFRAMES=2		RATE=1
#exec MESH SEQUENCE MESH=umptactical1st SEQ=Idle2			STARTFRAME=73	NUMFRAMES=2		RATE=2
#exec MESH SEQUENCE MESH=umptactical1st SEQ=Idle3			STARTFRAME=73	NUMFRAMES=2		RATE=2

#exec MESHMAP NEW   MESHMAP=umptactical1st MESH=umptactical1st
#exec MESHMAP SCALE MESHMAP=umptactical1st X=0.00390625 Y=0.00390625 Z=0.00390625

#exec MESH LODPARAMS MESH=umptactical1st STRENGTH=0

#exec MESHMAP SETTEXTURE MESHMAP=umptactical1st NUM=1 TEXTURE=WeaponHandsTex
#exec MESHMAP SETTEXTURE MESHMAP=umptactical1st NUM=2 TEXTURE=BlackMaskTex
#exec MESHMAP SETTEXTURE MESHMAP=umptactical1st NUM=3 TEXTURE=UMPLensTex
#exec MESHMAP SETTEXTURE MESHMAP=umptactical1st NUM=4 TEXTURE=UMPSightTex
#exec MESHMAP SETTEXTURE MESHMAP=umptactical1st NUM=5 TEXTURE=UMPTex3
#exec MESHMAP SETTEXTURE MESHMAP=umptactical1st NUM=6 TEXTURE=UMPLauncherTex
#exec MESHMAP SETTEXTURE MESHMAP=umptactical1st NUM=7 TEXTURE=UMPTex5
#exec MESHMAP SETTEXTURE MESHMAP=umptactical1st NUM=8 TEXTURE=UMPTex4

#exec MESH NOTIFY MESH=umptactical1st SEQ=Shoot	TIME=0.01	FUNCTION=SwapMuzzleFlashTexture

// FAMAS

#exec TEXTURE IMPORT NAME=FAMASBipodTex FILE=textures\FAMASBipodTex.pcx GROUP=Skins
#exec TEXTURE IMPORT NAME=FAMASScopeTex FILE=textures\FAMASScopeTex.pcx GROUP=Skins
#exec TEXTURE IMPORT NAME=FAMASTex1 FILE=textures\FAMASTex1.pcx GROUP=Skins
#exec TEXTURE IMPORT NAME=FAMASTex2 FILE=textures\FAMASTex2.pcx GROUP=Skins

#exec AUDIO IMPORT FILE="Sounds\FAMASReloadBegin.wav" NAME="FAMASReloadBegin" Group="Weapons"
#exec AUDIO IMPORT FILE="Sounds\FAMASReloadEnd.wav" NAME="FAMASReloadEnd" Group="Weapons"
#exec AUDIO IMPORT FILE="Sounds\FAMASSelect.wav" NAME="FAMASSelect" Group="Weapons"


#exec TEXTURE IMPORT NAME=Famas_inv FILE=textures\Famas_inv.pcx GROUP=Icons MIPS=OFF FLAGS=2 LODSET=2
#exec TEXTURE IMPORT NAME=FamasBelt FILE=textures\famasbelt.bmp GROUP=Icons


///////////////////////////////////////////////////
// famas3rd.
///////////////////////////////////////////////////

#exec MESH IMPORT MESH=famas3rd ANIVFILE=MODELS\famas3rd_a.3d DATAFILE=MODELS\famas3rd_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=famas3rd X=0 Y=0 Z=0 YAW=-64

#exec MESH SEQUENCE MESH=famas3rd SEQ=All STARTFRAME=0 NUMFRAMES=100
#exec MESHMAP NEW MESHMAP=famas3rd MESH=famas3rd

#exec MESH LODPARAMS MESH=famas3rd STRENGTH=0

#exec MESHMAP SCALE MESHMAP=famas3rd X=0.178781 Y=0.178781 Z=0.178781
#exec MESHMAP SETTEXTURE MESHMAP=famas3rd NUM=0 TEXTURE=FamasScopeTex
#exec MESHMAP SETTEXTURE MESHMAP=famas3rd NUM=1 TEXTURE=FAMASTex1
#exec MESHMAP SETTEXTURE MESHMAP=famas3rd NUM=2 TEXTURE=BlackMaskTex
#exec MESHMAP SETTEXTURE MESHMAP=famas3rd NUM=3 TEXTURE=FAMASTex2
#exec MESHMAP SETTEXTURE MESHMAP=famas3rd NUM=4 TEXTURE=FAMASBipodTex

///////////////////////////////////////////////////
// famaspickup.
///////////////////////////////////////////////////

#exec MESH IMPORT MESH=famaspickup ANIVFILE=MODELS\famaspickup_a.3d DATAFILE=MODELS\famaspickup_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=famaspickup X=0 Y=0 Z=0

#exec MESH SEQUENCE MESH=famaspickup SEQ=All STARTFRAME=0 NUMFRAMES=100
#exec MESHMAP NEW MESHMAP=famaspickup MESH=famaspickup

#exec MESH LODPARAMS MESH=famaspickup STRENGTH=0

#exec MESHMAP SCALE MESHMAP=famaspickup X=0.162833 Y=0.162833 Z=0.162833
#exec MESHMAP SETTEXTURE MESHMAP=famaspickup NUM=0 TEXTURE=FAMASScopeTex
#exec MESHMAP SETTEXTURE MESHMAP=famaspickup NUM=1 TEXTURE=FAMASTex1
#exec MESHMAP SETTEXTURE MESHMAP=famaspickup NUM=2 TEXTURE=FAMASTex2
#exec MESHMAP SETTEXTURE MESHMAP=famaspickup NUM=3 TEXTURE=FAMASBipodTex


//=============================================================================
// famas1st. this version has a scope
//=============================================================================

#exec MESH IMPORT MESH=famas1st ANIVFILE=MODELS\famas1st_a.3d DATAFILE=MODELS\famas1st_d.3d X=0 Y=0 Z=0 unmirror=0
#exec MESH ORIGIN MESH=famas1st X=5500 Y=-5300 Z=-1300 YAW=-64 // **X**(-)forward(+)back **Y**(-)right(+)left **Z**(-)up(+)down

#exec MESH SEQUENCE MESH=famas1st SEQ=All			STARTFRAME=0	NUMFRAMES=83
#exec MESH SEQUENCE MESH=famas1st SEQ=Still		STARTFRAME=0	NUMFRAMES=1
#exec MESH SEQUENCE MESH=famas1st SEQ=Select		STARTFRAME=1	NUMFRAMES=22	RATE=40
#exec MESH SEQUENCE MESH=famas1st SEQ=Shoot		STARTFRAME=23	NUMFRAMES=12		RATE=80
//       #exec MESH SEQUENCE MESH=famas1st SEQ=ReloadBegin	STARTFRAME=36	NUMFRAMES=14	RATE=30
#exec MESH SEQUENCE MESH=famas1st SEQ=ReloadBegin	STARTFRAME=42	NUMFRAMES=8	RATE=10 // 
#exec MESH SEQUENCE MESH=famas1st SEQ=Reload		STARTFRAME=52 NUMFRAMES=2		RATE=2
#exec MESH SEQUENCE MESH=famas1st SEQ=ReloadEnd	STARTFRAME=54	NUMFRAMES=13		RATE=23
#exec MESH SEQUENCE MESH=famas1st SEQ=Down			STARTFRAME=68	NUMFRAMES=6		RATE=15
#exec MESH SEQUENCE MESH=famas1st SEQ=Idle1			STARTFRAME=76	NUMFRAMES=2		RATE=1
#exec MESH SEQUENCE MESH=famas1st SEQ=Idle2			STARTFRAME=79	NUMFRAMES=2		RATE=2

#exec MESHMAP NEW   MESHMAP=famas1st MESH=famas1st
#exec MESHMAP SCALE MESHMAP=famas1st X=0.00300625 Y=0.00300625 Z=0.00300625

#exec MESH LODPARAMS MESH=famas1st STRENGTH=0

#exec MESHMAP SETTEXTURE MESHMAP=famas1st NUM=1 TEXTURE=WeaponHandsTex
#exec MESHMAP SETTEXTURE MESHMAP=famas1st NUM=2 TEXTURE=BlackMaskTex
#exec MESHMAP SETTEXTURE MESHMAP=famas1st NUM=3 TEXTURE=WeaponHandsTex
#exec MESHMAP SETTEXTURE MESHMAP=famas1st NUM=4 TEXTURE=FAMASBipodTex
#exec MESHMAP SETTEXTURE MESHMAP=famas1st NUM=5 TEXTURE=FAMASTex2
#exec MESHMAP SETTEXTURE MESHMAP=famas1st NUM=6 TEXTURE=WeaponHandsTex
#exec MESHMAP SETTEXTURE MESHMAP=famas1st NUM=7 TEXTURE=FAMASTex1
#exec MESHMAP SETTEXTURE MESHMAP=famas1st NUM=8 TEXTURE=FAMASScopeTex


#exec MESH NOTIFY MESH=famas1st SEQ=Shoot	TIME=0.01	FUNCTION=SwapMuzzleFlashTexture

///////////////////////////////////////
//////////////////////////////////////
//////////////////////////////////////
//Map Information
////////////////////////////////////
/////////////////////////////////////
////////////////////////////////////
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
#exec Texture Import File=Textures\NoScreenShot.pcx Name=NoScreenShot
#exec Texture Import File=Textures\MapDetailsBK__0_0.bmp Name=MapDetailsBK__0_0 GROUP="UserInterface"
#exec Texture Import File=Textures\MapDetailsBK__0_1.bmp Name=MapDetailsBK__0_1 GROUP="UserInterface"
#exec Texture Import File=Textures\MapDetailsBK__1_0.bmp Name=MapDetailsBK__1_0 GROUP="UserInterface"
#exec Texture Import File=Textures\MapDetailsBK__1_1.bmp Name=MapDetailsBK__1_1 GROUP="UserInterface"
//_____________________________________________________________________________


//////////////////////
//Import Portraits
/////////////////////
#exec TEXTURE IMPORT File=Textures\AJacobson.pcx    NAME="AJacobson"
#exec TEXTURE IMPORT File=Textures\Anna.pcx         NAME="Anna"
#exec TEXTURE IMPORT File=Textures\ChineseGang.pcx  NAME="ChineseGang"
#exec TEXTURE IMPORT File=Textures\Cop1.pcx         NAME="Cop1" //  
#exec TEXTURE IMPORT File=Textures\Cop2.pcx         NAME="Cop2"
#exec TEXTURE IMPORT File=Textures\Crazy.pcx        NAME="Crazy"
#exec TEXTURE IMPORT File=Textures\DarkMaiden.pcx   NAME="DarkMaiden"
#exec TEXTURE IMPORT File=Textures\GHermann.pcx     NAME="GHermann"
#exec TEXTURE IMPORT File=Textures\GordonQuick.pcx  NAME="GordonQuick"
#exec TEXTURE IMPORT File=Textures\Howard.pcx       NAME="Howard"
#exec TEXTURE IMPORT File=Textures\Ivan.pcx         NAME="Ivan"
#exec TEXTURE IMPORT File=Textures\Jock.pcx         NAME="Jock"
#exec TEXTURE IMPORT File=Textures\Lebedev.pcx      NAME="Lebedev"
#exec TEXTURE IMPORT File=Textures\MChow.pcx        NAME="MChow"
#exec TEXTURE IMPORT File=Textures\MIB.pcx          NAME="MIB"
#exec TEXTURE IMPORT File=Textures\PaulDenton.pcx   NAME="PaulDenton"
#exec TEXTURE IMPORT File=Textures\SamCarter.pcx    NAME="SamCarter"
#exec TEXTURE IMPORT File=Textures\Smuggler.pcx     NAME="Smuggler"
#exec TEXTURE IMPORT File=Textures\TTong.pcx        NAME="TTong"
#exec TEXTURE IMPORT File=Textures\WIB.pcx          NAME="WIB"
#exec TEXTURE IMPORT File=Textures\WSimons.pcx      NAME="WSimons"


defaultproperties
{
}
