//=============================================================================
// TraceHitSpawner class so we can reduce nettraffic for hitspangs
//=============================================================================
class TraceHitSpawner extends Effects;

var float HitDamage;
var bool bPenetrating; // shot that hit was a penetrating shot
var bool bHandToHand;  // shot that hit was hand to hand
var bool bInstantHit;
var Name damageType;

simulated function PostBeginPlay()
{
   	Super.PostBeginPlay();
   
   	if (Owner == None)
      		SetOwner(Level);
   	SpawnEffects(Owner,HitDamage);
}

simulated function Timer()
{
   	Destroy();
}

simulated function PlayHitSound(actor destActor, Actor hitActor)
{
	local float rnd;
	local sound snd;

	if ((damageType == 'Shot') || (damageType == 'AutoShot') || (damageType == 'Decapitated'))
	{	
     		rnd = FRand();

		if (rnd < 0.25)
			snd = sound'Ricochet1';
	     	else if (rnd < 0.5)
		 	snd = sound'Ricochet2';
	     	else if (rnd < 0.75)
			snd = sound'Ricochet3';
	     	else
			snd = sound'Ricochet4';

	    	if (hitActor != None) 
	    	{
			if (hitActor.IsA('DeusExDecoration') && (DeusExDecoration(hitActor).minDamageThreshold > 10))
				snd = sound'ArmorRicochet';
			else if ( hitActor.IsA('CrateUnbreakableSmall') || hitActor.IsA('CrateUnbreakableMed') || hitActor.IsA('CrateUnbreakableLarge') )
			{
				if (rnd < 0.75)
					snd = sound'BulletImpactMetal1';
	     			else
					snd = sound'BulletImpactMetal2';
			}				
		 	else if (hitActor.IsA('Robot'))
				snd = sound'ArmorRicochet';
	    	}
	    	if (destActor != None)
			destActor.PlaySound(snd, SLOT_None,,, 1024, 1.1 - 0.2*FRand());
        }
}

simulated function SpawnEffects(Actor Other, float Damage)
{
   	local SmokeTrail puff;
   	local int i;
   	local BulletHole hole;
   	local RockChip chip;
   	local Rotator rot;
   	local DeusExMover mov;
   	local Spark spark;
   	local GunSpark spark2;

   	SetTimer(0.1,False);
   	if (Level.NetMode == NM_DedicatedServer)
      		return;

	if (bPenetrating && !bHandToHand && !Other.IsA('DeusExDecoration'))
	{
		if (DeusExMPGame(Level.Game) != None)
		{
			puff = spawn(class'SmokeTrail',,,Location+(Vector(Rotation)*1.5), Rotation);
			if ( puff != None )
			{
				puff.DrawScale = 1.0;
				puff.OrigScale = puff.DrawScale;
				puff.LifeSpan = 1.0;
				puff.OrigLifeSpan = puff.LifeSpan;
                                			puff.RemoteRole = ROLE_None;
			}
		}
		else
		{
			puff = spawn(class'SmokeTrail',,,Location+(Vector(Rotation)*1.5), Rotation);
			if (puff != None)
			{
				puff.DrawScale = 0.1;
				puff.OrigScale = puff.DrawScale;
				puff.LifeSpan = 0.5;
				puff.OrigLifeSpan = puff.LifeSpan;
                                			puff.RemoteRole = ROLE_None;
			}
		}
	}

        	if ( (!bHandToHand) && bInstantHit && bPenetrating )
	{
               		hole = spawn(class'BulletHole', Other,, Location+Vector(Rotation), Rotation);
               		if (hole != None)      
                       		hole.RemoteRole = ROLE_None;

		if ( !Other.IsA('Pawn') )		// Sparks on pawns look bad
		{
                        		if (Level.Netmode != NM_Standalone)
                        		{
			      	spark = spawn(class'Spark',,,Location+Vector(Rotation), Rotation);
			      	if (spark != None)
			     	{
				    	spark.RemoteRole = ROLE_None;
				    	spark.DrawScale = 0.1;
				    	PlayHitSound(spark, Other);
			      	}
                        		}
                        		else
                        		{
                              			spark2 = spawn(class'GunSpark',,,Location+Vector(Rotation), Rotation);
			      	if (spark2 != None)
			      	{
				    	spark2.RemoteRole = ROLE_None;
				    	spark2.DrawScale = 0.25;
			      	}
                        		}
		}
	}

	// draw the correct damage art for what we hit
	if (bPenetrating || bHandToHand)
	{
		if (Other.IsA('DeusExMover'))
		{
			mov = DeusExMover(Other);
			if ((mov != None) && (hole == None))
         			{
            				hole = spawn(class'BulletHole', Other,, Location+Vector(Rotation), Rotation);
            				if (hole != None)
               					hole.remoteRole = ROLE_None;
         			}

			if (hole != None)
			{
				if (mov.bBreakable && (mov.minDamageThreshold <= Damage))
				{
					// don't draw damage art on destroyed movers
					if (mov.bDestroyed)
						hole.Destroy();
					else if (mov.FragmentClass == class'GlassFragment')
					{
						// glass hole
						if (FRand() < 0.5)
							hole.Texture = Texture'FlatFXTex29';
						else
							hole.Texture = Texture'FlatFXTex30';

						hole.DrawScale = 0.1;
						hole.ReattachDecal();
					}
					else
					{
						// non-glass crack
						if (FRand() < 0.5)
							hole.Texture = Texture'FlatFXTex7';
						else
							hole.Texture = Texture'FlatFXTex8';

						hole.DrawScale = 0.4;
						hole.ReattachDecal();
					}
				}
				else
				{
					if (!bPenetrating || bHandToHand)
						hole.Destroy();
				}
			}
		}
	}
}

defaultproperties
{
     HitDamage=-1.000000
     bPenetrating=True
     bInstantHit=True
     RemoteRole=ROLE_None
}
