//=============================================================================
// TraceHitSpawner class so we can reduce nettraffic for hitspangs
//=============================================================================
class TraceHitSpawner2 extends TraceHitSpawner;

simulated function SpawnEffects(Actor Other, float Damage)
{
   	local SmokeTrail puff;
   	local int i;
   	local BulletHole hole;
   	local RockChip chip;
   	local Rotator rot;
   	local DeusExMover mov;
   	local Spark2 spark;
   	local GunSpark2 spark2;

   	SetTimer(0.1,False);
   	if (Level.NetMode == NM_DedicatedServer)
      		return;
	
        	if ( (!bHandToHand) && bInstantHit && bPenetrating )
	{
               		hole = spawn(class'BulletHole', Other,, Location+Vector(Rotation), Rotation);
               		if (hole != None)      
                       	hole.RemoteRole = ROLE_None;

		if ( !Other.IsA('Pawn') )		// Sparks on pawns look bad
		{
                        		if (Level.Netmode != NM_Standalone)
                        		{
			 	spark = spawn(class'Spark2',,,Location+Vector(Rotation), Rotation);
			      	if (spark != None)
			      	{
					spark.RemoteRole = ROLE_None;
				    	spark.DrawScale = 0.2;
				    	PlayHitSound(spark, Other);
			      	}
                        		}
                        		else
                        		{
                              			spark2 = spawn(class'GunSpark2',,,Location+Vector(Rotation), Rotation);
				if (spark2 != None)
				{
				    	spark2.RemoteRole = ROLE_None;
				    	spark2.DrawScale = 0.25;
			 	}
                        		}
		}
	}

	// draw the correct damage art for what we hit
	if (bPenetrating || bHandToHand)
	{
		if (Other.IsA('DeusExMover'))
		{
			mov = DeusExMover(Other);
			if ((mov != None) && (hole == None))
         			{
            				hole = spawn(class'BulletHole', Other,, Location+Vector(Rotation), Rotation);
            				if (hole != None)
               					hole.remoteRole = ROLE_None;
         			}

			if (hole != None)
			{
				if (mov.bBreakable && (mov.minDamageThreshold <= Damage))
				{
					// don't draw damage art on destroyed movers
					if (mov.bDestroyed)
						hole.Destroy();
					else if (mov.FragmentClass == class'GlassFragment')
					{
						// glass hole
						if (FRand() < 0.5)
							hole.Texture = Texture'FlatFXTex29';
						else
							hole.Texture = Texture'FlatFXTex30';

						hole.DrawScale = 0.1;
						hole.ReattachDecal();
					}
					else
					{
						// non-glass crack
						if (FRand() < 0.5)
							hole.Texture = Texture'FlatFXTex7';
						else
							hole.Texture = Texture'FlatFXTex8';

						hole.DrawScale = 0.4;
						hole.ReattachDecal();
					}
				}
				else
				{
					if (!bPenetrating || bHandToHand)
						hole.Destroy();
				}
			}
		}
	}
}

defaultproperties
{
}
