//=============================================================================
// TraceHitSpawner class so we can reduce nettraffic for hitspangs
//=============================================================================
class TraceHitSpawner3 extends TraceHitSpawner;

simulated function PostBeginPlay()
{
        	Super.PostBeginPlay();       
        	MakeSound();  
}

simulated function SpawnEffects(Actor Other, float Damage)
{
   	local SmokeTrail puff;
   	local int i;
   	local BulletHole hole;
      	local Rotator rot;
   	local DeusExMover mov;
	   
   	SetTimer(0.1,False);
   	if ( Level.NetMode == NM_DedicatedServer )
      		return;

	if ( !Other.IsA('DeusExDecoration') )
	{
		puff = spawn(class'SmokeTrail',,,Location+(Vector(Rotation)*1.5), Rotation);
		if (puff != None)
		{
			puff.DrawScale = 0.5;
			puff.OrigScale = puff.DrawScale;
			puff.LifeSpan = 0.5;
			puff.OrigLifeSpan = puff.LifeSpan;
                                		puff.RemoteRole = ROLE_None;
		}
	}

	hole = spawn(class'BulletHole', Other,, Location+Vector(Rotation), Rotation);
               	if (hole != None)      
	{
                		hole.RemoteRole = ROLE_None;
		hole.DrawScale = 0.15;
		hole.ReattachDecal();
	}
	
	if ( Other.IsA('DeusExMover') )
	{
		mov = DeusExMover(Other);
		if ( (mov != None) && (hole == None) )
         		{
            			hole = spawn(class'BulletHole', Other,, Location+Vector(Rotation), Rotation);
            			if (hole != None)
               				hole.remoteRole = ROLE_None;
         		}
		if ( hole != None )
		{
			if (mov.bBreakable && (mov.minDamageThreshold <= Damage))
			{
				// don't draw damage art on destroyed movers
				if (mov.bDestroyed)
					hole.Destroy();
				else if (mov.FragmentClass == class'GlassFragment')
				{
					// glass hole
					if (FRand() < 0.5)
						hole.Texture = Texture'FlatFXTex29';
					else
						hole.Texture = Texture'FlatFXTex30';

					hole.DrawScale = 0.15;
					hole.ReattachDecal();
				}
				else
				{
					if (FRand() < 0.5)
						hole.Texture = Texture'FlatFXTex7';
					else
						hole.Texture = Texture'FlatFXTex8';

					hole.DrawScale = 0.4;
					hole.ReattachDecal();
				}
			}
			else
			{
				if ( !bPenetrating )
					hole.Destroy();
			}			
		}
	}
}

function name GetImpactMaterial()
{
	local vector EndTrace, HitLocation, HitNormal;
	local actor target;
	local int texFlags;
	local name texName, texGroup;

	EndTrace = Location - (Vector(Rotation) * 5.0);

	foreach TraceTexture(class'Actor', target, texName, texGroup, texFlags, HitLocation, HitNormal, EndTrace)
	{
		if ((target == Level) || target.IsA('Mover'))
			break;
	}

	return texGroup;
}

function MakeSound()
{
	if ( (GetImpactMaterial() == 'Metal') || (GetImpactMaterial() == 'Ladder') )
	{
		if ( FRand() < 0.75 )
			PlaySound(Sound'BulletImpactMetal1', SLOT_None,,, 1024, 1.1 - 0.2*FRand());
		else
			PlaySound(Sound'BulletImpactMetal2', SLOT_None,,, 1024, 1.1 - 0.2*FRand());
	}
	else
		PlaySound(Sound'Ricochet4', SLOT_None,,, 1024, 1.1 - 0.2*FRand());
}

defaultproperties
{
}
