//=============================================================================
// VacuumGrenade.
//=============================================================================
class VacuumGrenade extends ThrownProjectile;

simulated function DrawExplosionEffects(vector HitLocation, vector HitNormal)
{
	local ExplosionLight light;
	local int i;
	local Rotator rot;
	local SphereEffect sphere;
   	local ExplosionSmall expeffect;

	// draw a pretty explosion
	light = Spawn(class'ExplosionLight',,, HitLocation);
	if (light != None)
	{
      		if (!bDamaged)
         			light.RemoteRole = ROLE_None;
		light.size = 8;
		light.LightHue = 83;
		light.LightSaturation = 96;
		light.LightEffect = LE_Shell;
	}

	expeffect = Spawn(class'ExplosionSmall',,, HitLocation);
   	if ((expeffect != None) && (!bDamaged))
      		expeffect.RemoteRole = ROLE_None;

	// draw a cool light sphere
	sphere = Spawn(class'SphereEffect',,, HitLocation);
	if (sphere != None)
   	{
      		if (!bDamaged)
         			sphere.RemoteRole = ROLE_None;
		sphere.Skin = Texture'phit_a00';
		sphere.size = blastRadius / 32.0;
   	}
}

state Exploding
{
 	function DamageRing()
   	{
		local Pawn P;
		local float damageRadius;
		local Vector dist;

		damageRadius = (blastRadius / gradualHurtSteps) * gradualHurtCounter;

		for ( P = Level.PawnList; P != None; P = P.nextPawn )
		{
			if ( !P.IsA('CyborgDog') && !P.IsA('HoloDenton') )
			{
				dist = P.Location - Location;
				if ( VSize(dist) < damageRadius )
					P.TakeDamage(Damage, Pawn(Owner), vect(0,0,0), MomentumTransfer*vect(0,0,1), damageType);
			}
		}
   	}
}

defaultproperties
{
     fuseLength=2.000000
     proxRadius=128.000000
     AISoundLevel=0.100000
     bBlood=False
     bDebris=False
     DamageType=PoisonGas
     spawnWeaponClass=Class'DeusEx.WeaponGasGrenade'
     ItemName="Vacuum Grenade"
     speed=1000.000000
     MaxSpeed=1000.000000
     Damage=25.000000
     MomentumTransfer=250000
     ImpactSound=Sound'DeusExSounds.Weapons.EMPGrenadeExplode'
     LifeSpan=0.000000
     Mesh=LodMesh'DeusExItems.GasGrenadePickup'
     CollisionRadius=4.300000
     CollisionHeight=1.400000
     Mass=5.000000
     Buoyancy=2.000000
}
