//=============================================================================
// WaltonSimons.
//=============================================================================
class WaltonSimons extends HumanMilitary;

//
// Damage type table for Walton Simons:
//
// Shot			- 100%
// Sabot		- 100%
// Exploded		- 100%
// TearGas		- 10%
// PoisonGas	- 10%
// Poison		- 10%
// PoisonEffect	- 10%
// HalonGas		- 10%
// Radiation	- 10%
// Shocked		- 10%
// Stunned		- 0%
// KnockedOut   - 0%
// Flamed		- 0%
// Burned		- 100%
// NanoVirus	- 0%
// EMP			- 0%
//

function float ShieldDamage(name damageType)
{
	// handle special damage types
	if ( (damageType == 'Flamed') || (damageType == 'Stunned') || (damageType == 'KnockedOut') )
		return 0.0;
	else if ( (damageType == 'TearGas') || (damageType == 'PoisonGas') || (damageType == 'HalonGas') ||
		(damageType == 'Radiation') || (damageType == 'Shocked') || (damageType == 'Poison') ||
	        	(damageType == 'PoisonEffect') || (damageType == 'Fell') )
		return 0.1;
	else
		return Super.ShieldDamage(damageType);
}

function GotoDisabledState(name damageType, EHitLocation hitPos)
{
	if (!bCollideActors && !bBlockActors && !bBlockPlayers)
		return;
	if (CanShowPain())
		TakeHit(hitPos);
	else
		GotoNextState();
}

function Timer()
{
	local DeusExProjectile proj, minproj;
	local float dist, mindist;

	mindist = 999999;
	minproj = None;

               	if ( Level.Game.Difficulty == 3 )
               	{
                    	SetTimer(0.1,false);
                        	return; 
                }

	foreach AllActors(class'DeusExProjectile', proj)
	{
		if ( !proj.bIgnoresNanoDefense )
		{
			// make sure we don't own it
			if (proj.Owner != Self)
			{
				// make sure it's moving fast enough
				if (VSize(proj.Velocity) > 100)
				{
					dist = VSize(Location - proj.Location);
					if (dist < mindist)
					{
						mindist = dist;
						minproj = proj;
					}
				}
			}
		}
	}
		
	if (minproj != None)
	{
		if (mindist < 256)
		{
			minproj.Explode(minproj.Location, vect(0,0,1));
                               		PlaySound(sound'ProdFire', SLOT_None,,,, 2.0);
		}
	}
}

function FireWeapon()
{
	Super.FireWeapon();
	if ( Level.Game.Difficulty < 3 )
	{
		if ( ((Enemy != None) && Enemy.bIsPlayer) && (FRand() < 0.33) )
			if ( VSize(Enemy.Location - Location) < 450 )
				ReleaseShockBeam();
	}
}

function ReleaseShockBeam()
{
	local int i;
	local NanoEmitter ShockBeam;
	
	for (i=0; i<3; i++)
	{
		ShockBeam = Spawn( Class'NanoEmitter',Self,,Location + vect(0,0,1) * 100 );
		if ( ShockBeam != None )
		{
			ShockBeam.damageAmount = 10;
			ShockBeam.Instigator = Self;
			ShockBeam.SetBase(Self);
			ShockBeam.SetLocation(Location);
			ShockBeam.SetRotation(ViewRotation);
			ShockBeam.LifeSpan = 0.5;
			ShockBeam.TurnOn();
			ShockBeam.RemoteRole = ROLE_None;
		}
	}
}

function PostBeginPlay()
{
	Super.PostBeginPlay();
               	SetTimer(0.1, True);
}

defaultproperties
{
     CarcassType=Class'DeusEx.WaltonSimonsCarcass'
     WalkingSpeed=0.333333
     bImportant=True
     bInvincible=True
     AvoidAccuracy=1.000000
     CloseCombatMult=0.500000
     BaseAssHeight=-23.000000
     BurnPeriod=0.000000
     bHasCloak=True
     CloakThreshold=200
     walkAnimMult=1.400000
     GroundSpeed=270.000000
     Health=1250
     Skill=1.000000
     HealthHead=1500
     HealthTorso=1250
     HealthLegLeft=1250
     HealthLegRight=1250
     HealthArmLeft=1250
     HealthArmRight=1250
     Mesh=LodMesh'DeusExCharacters.GM_Trench'
     MultiSkins(0)=Texture'DeusExCharacters.Skins.WaltonSimonsTex0'
     MultiSkins(1)=Texture'DeusExCharacters.Skins.WaltonSimonsTex2'
     MultiSkins(2)=Texture'DeusExCharacters.Skins.PantsTex5'
     MultiSkins(3)=Texture'DeusExCharacters.Skins.WaltonSimonsTex0'
     MultiSkins(4)=Texture'DeusExCharacters.Skins.WaltonSimonsTex1'
     MultiSkins(5)=Texture'DeusExCharacters.Skins.WaltonSimonsTex2'
     MultiSkins(6)=Texture'DeusExItems.Skins.GrayMaskTex'
     MultiSkins(7)=Texture'DeusExItems.Skins.BlackMaskTex'
     CollisionRadius=20.000000
     CollisionHeight=47.500000
     BindName="WaltonSimons"
     FamiliarName="Walton Simons"
     UnfamiliarName="Walton Simons"
     bVisionImportant=False
}
