//=============================================================================
// WeaponAssaultGun.
//=============================================================================
class WeaponAssaultGun extends DeusExWeapon;

var() class<ammo>    AltAmmoName;
var travel ammo	AltAmmoType;
var() int            AltPickupAmmoCount;
var bool             bHas20mm;

replication
{
	// Things the server should send to the client.
	reliable if( Role==ROLE_Authority && bNetOwner )
		AltAmmoType;
}

simulated function PreBeginPlay()
{
	Super.PreBeginPlay();

	if ( ((Level.Game != None) && Level.Game.bDeathMatch) || (Level.NetMode != NM_Standalone) )
	{
		HitDamage = mpHitDamage;
		BaseAccuracy = mpBaseAccuracy;
		ReloadTime = mpReloadTime;
		AccurateRange = mpAccurateRange;
		MaxRange = mpMaxRange;
		ReloadCount = mpReloadCount;
		FiringMode = Automatic;
                		PickupAmmoCount = 100;
                		InventoryGroup = 4;
                		return;
	}
        	if ( Level.Game.Difficulty == 3 )
	{
		HitDamage = 15;
		ReloadTime = mpReloadTime;
                		FiringMode = Automatic;
	}
}

simulated function PostBeginPlay()
{
        	Super.PostBeginPlay();
	if ( ((Level.Game != None) && Level.Game.bDeathMatch) || (Level.NetMode != NM_Standalone) )
	                AltPickupAmmoCount = 4;
}

event TravelPostAccept()
{
	Super(Inventory).TravelPostAccept();
	if ( Pawn(Owner) == None )
		return;
	if ( AmmoName != None )
	{
		if ( AmmoType == None )
		{		
			AmmoType = Ammo(Pawn(Owner).FindInventoryType(AmmoName));
			if (AmmoType == None)
			{
				AmmoType = Spawn(AmmoName);	// Create ammo type required		
				Pawn(Owner).AddInventory(AmmoType);		// and add to player's inventory
				AmmoType.BecomeItem();
				AmmoType.AmmoAmount = PickUpAmmoCount; 
				AmmoType.GotoState('Idle2');
			}
		}
	}

        	if ( AltAmmoName != None )
	{
		if ( AltAmmoType == None )
		{		
			AltAmmoType = Ammo(Pawn(Owner).FindInventoryType(AltAmmoName));
			if (AltAmmoType == None)
			{
				AltAmmoType = Spawn(AltAmmoName);	// Create ammo type required		
				Pawn(Owner).AddInventory(AltAmmoType);		// and add to player's inventory
				AltAmmoType.BecomeItem();
				AltAmmoType.AmmoAmount = AltPickUpAmmoCount; 
				AltAmmoType.GotoState('Idle2');
			}
		}
	}       

	if ( self == Pawn(Owner).Weapon )
		BringUp();
	else GoToState('Idle2');

        	if (AmmoType != None)
		AmmoName = AmmoType.Class;

        	if (AltAmmoType != None)
		AltAmmoName = AltAmmoType.Class;

	if (!bAltInstantHit)
	{
		if (AltProjectileClass != None)
			AltProjectileSpeed = AltProjectileClass.Default.speed;
        	}
}

function inventory SpawnCopy( pawn Other )
{
	local inventory Copy;
	local Weapon newWeapon;

	if( Level.Game.ShouldRespawn(self) )
	{
		Copy = spawn(Class,Other,,,rot(0,0,0));
		Copy.Tag           = Tag;
		Copy.Event         = Event;
		if ( !bWeaponStay )
			GotoState('Sleeping');
	}
	else
		Copy = self;

	Copy.RespawnTime = 0.0;
	Copy.bHeldItem = true;
	Copy.bTossedOut = false;

	WeaponAssaultGun(Copy).GiveAmmo(Other);
        	WeaponAssaultGun(Copy).GiveAltAmmo(Other);
	Copy.GiveTo( Other );
	
	newWeapon = Weapon(Copy);
	newWeapon.Instigator = Other;
	if ( Level.Game.bDeathMatch || (Level.NetMode != NM_Standalone))
        	{
            		newWeapon.SetSwitchPriority(Other);
	    	if ( !Other.bNeverSwitchOnPickup )
			newWeapon.WeaponSet(Other);
        	}
        	newWeapon.AmbientGlow = 0;
	return newWeapon;
}

function GiveAltAmmo( Pawn Other )
{
	if ( AltAmmoName == None )
		return;
	AltAmmoType = Ammo(Other.FindInventoryType(AltAmmoName));
	if ( AltAmmoType != None )
		AltAmmoType.AddAmmo(AltPickUpAmmoCount);
	else
	{
		AltAmmoType = Spawn(AltAmmoName);		
		Other.AddInventory(AltAmmoType);		
		AltAmmoType.BecomeItem();
		AltAmmoType.AmmoAmount = AltPickUpAmmoCount; 
		AltAmmoType.GotoState('Idle2');
	}
}	

function bool HandlePickupQuery(Inventory Item)
{
	local WeaponAssaultGun W;
        	local Pawn PawnOwner;
	local class<Ammo> myAmmoClass;
	local Ammo myAmmo;
	
	W = WeaponAssaultGun(Item);
	PawnOwner = Pawn(Owner);

	if (Item.Class == Class)
	{
           		if ( W.bWeaponStay && (!W.bHeldItem || W.bTossedOut) )
			return true;

		if ( AltAmmoType != None )
		{
			myAmmoClass = AltAmmoName;
			myAmmo = Ammo(PawnOwner.FindInventoryType(myAmmoClass));
			myAmmo.AddAmmo( WeaponAssaultGun(Item).AltPickupAmmoCount );  	
		}
        	}
	return Super.HandlePickupQuery(Item);
}

function CycleAmmo()
{
}

simulated function PlayFiringSound()
{
}

simulated function PlaySelectiveFiring()
{
	local Pawn aPawn;
	local Name anim;

	anim = FireAnim;
	
	if (( Level.NetMode == NM_Standalone ) || ( DeusExPlayer(Owner) == DeusExPlayer(GetPlayerPawn())) )
	{
		if (DeusExPlayer(Owner) != None)
                		{
                        		bAutomatic = False;
                        		bRapidFire = True;
               	        		PlayAnim(anim, 1.0, 0.01);
                		}
	        	else
                		{
                        		bAutomatic = True;
                        		bRapidFire = False;
		        	LoopAnim(anim, FireRate, TimeBetweenFire);
                		}
	}
	else if ( Role == ROLE_Authority )
	{
		for ( aPawn = Level.PawnList; aPawn != None; aPawn = aPawn.nextPawn )
		{
			if ( aPawn.IsA('DeusExPlayer') && ( DeusExPlayer(Owner) != DeusExPlayer(aPawn) ) )
			{
				if ( DeusExPlayer(aPawn).FastTrace( DeusExPlayer(aPawn).Location, Location ))
					DeusExPlayer(aPawn).ClientPlayAnimation( Self, anim, 0.1, bAutomatic );
			}
		}
	}
}

function DropFrom(vector StartLocation)
{
	if ( !SetLocation(StartLocation) )
	     	return; 
	AmbientSound = None;
	if ( bHasMuzzleFlash )
		EraseMuzzleFlashTexture();
	Super.DropFrom(StartLocation);
}

state NormalFire
{
        	function Tick( float DeltaTime )
	{
	        	if ( (Owner == None) || Owner.IsInState('Dying') ) 
		AmbientSound = None;
		Global.Tick( DeltaTime );
	}

        	function BeginState()
	{
		AmbientSound = FireSound;
		Super.BeginState();
	}	

	function EndState()
	{
                		AmbientSound = None;
                		PlayEndFire();
               		Super.EndState();
	}
} 

simulated state ClientFiring
{
        	simulated function Tick( float DeltaTime )
	{
	        	if ( (Owner == None) || Owner.IsInState('Dying') ) 
		AmbientSound = None;
		Global.Tick( DeltaTime );
	}

        	simulated function BeginState()
	{
                		AmbientSound = FireSound;
		Super.BeginState();
	}	

	simulated function EndState()
	{
                		AmbientSound = None;
	                	PlayEndFire();
               		Super.EndState();
	}
}

function AltFire(float Value)
{
	local float sndVolume;
	local bool bListenClient;

	bListenClient = (Owner.IsA('DeusExPlayer') && DeusExPlayer(Owner).PlayerIsListenClient());

	sndVolume = TransientSoundVolume;

        	if ( Level.Game.bDeathMatch || (Level.NetMode != NM_Standalone))
             		sndVolume = TransientSoundVolume * 2.0;
       
	if ( Level.NetMode != NM_Standalone )  
	{
		if ( !bClientReady && !bListenClient && Owner.IsA('DeusExPlayer'))
		{
			DeusExPlayer(Owner).bJustAltFired = False;
			bReadyToFire = True;
			bPointing = False;
			bFiring = False;
			return;
		}
	}
	// check for surrounding environment
	if ((EnviroEffective == ENVEFF_Air) || (EnviroEffective == ENVEFF_Vacuum) || (EnviroEffective == ENVEFF_AirVacuum))
	{
		if (Region.Zone.bWaterZone)
		{
			if (Pawn(Owner) != None)
			{
				Pawn(Owner).ClientMessage(msgNotWorking);
				PlaySimSound( Misc1Sound, SLOT_None, sndVolume, 1024 );		
			}
			GotoState('Idle');
			return;
		}
	}
        	
	if (AltAmmoType.UseAmmo(1))
	{
		if (( Level.NetMode != NM_Standalone ) && (!bListenClient || !Owner.IsA('DeusExPlayer'))  )
			bClientReady = False;                       
		bFiring = True;
		bReadyToFire = False;
                       	 if (( Level.NetMode != NM_Standalone ) && ((Owner != None) && !Owner.IsA('DeusExPlayer')))
                              		ClientAltFire(Value);
                    	GotoState('AltFiring');
                       
		if (( Level.NetMode == NM_Standalone ) || ( Owner.IsA('DeusExPlayer') && DeusExPlayer(Owner).PlayerIsListenClient()) )
		{
			if ( PlayerPawn(Owner) != None )		
				PlayerPawn(Owner).ShakeView(ShakeTime, currentAccuracy * ShakeMag + ShakeMag, currentAccuracy * ShakeVert);
		}
		bPointing=True;
		ProjectileAltFire(AltProjectileClass, AltProjectileSpeed, bAltWarnTarget);
		if ( Owner.IsA('PlayerPawn') )
			PlayerPawn(Owner).PlayFiring();
		PlaySelectiveAltFiring();   
		PlayFiringAltSound();
		if ( Owner.bHidden )
			CheckVisibility();
	}       
	else
        	{
		PlaySimSound( Misc1Sound, SLOT_None, sndVolume, 1024 );	
                		if (Pawn(Owner) != None)
                        		Pawn(Owner).ClientMessage(msgOutOf20mm);	
        	}
}

simulated function bool ClientAltFire( float value )
{
	local bool bWaitOnAnim;
	local vector shake;

	// check for surrounding environment
	if ((EnviroEffective == ENVEFF_Air) || (EnviroEffective == ENVEFF_Vacuum) || (EnviroEffective == ENVEFF_AirVacuum))
	{
		if (Region.Zone.bWaterZone)
		{
			if (Pawn(Owner) != None)
			{
				Pawn(Owner).ClientMessage(msgNotWorking);
				PlaySimSound( Misc1Sound, SLOT_None, TransientSoundVolume * 2.0, 1024 );
			}
			return false;
		}
	}

	if ( !bLooping ) // Wait on animations when not looping
	{
		bWaitOnAnim = ( IsAnimating() && ((AnimSequence == 'Select') || (AnimSequence == 'Shoot') || (AnimSequence == 'ReloadBegin') || (AnimSequence == 'Reload') || (AnimSequence == 'ReloadEnd') || (AnimSequence == 'Down')));
	}
	else
	{
		bWaitOnAnim = False;
		bLooping = False;
	}

	if ( !bClientReadyToFire || bInProcess || ((DeusExPlayer(Owner) != None) && bWaitOnAnim) )
	{
                		if (Owner.IsA('DeusExPlayer'))
			DeusExPlayer(Owner).bJustAltFired = False;
		bPointing = False;
		bFiring = False;
		return false;
	}
               	ServerForceAltFire();
	
	if (AltAmmoType.AmmoAmount > 0)
	{
			if ( AltAmmoType != None )
				AltAmmoType.SimUseAmmo();

			bFiring = True;
			bPointing = True;
			bClientReadyToFire = False;
			bInProcess = True;
			GotoState('ClientAltFiring');
			if ( PlayerPawn(Owner) != None )
			{
				shake.X = 0.0;
				shake.Y = 100.0 * (ShakeTime*0.5);
				shake.Z = 100.0 * -(currentAccuracy * ShakeVert);
				PlayerPawn(Owner).ClientShake( shake );
				PlayerPawn(Owner).PlayFiring();
			}
			PlaySelectiveAltFiring();
			PlayFiringAltSound();
			ProjectileAltFire(AltProjectileClass, AltProjectileSpeed, bAltWarnTarget);
	}

        	else   
        	{ 
		PlaySimSound( Misc1Sound, SLOT_None, TransientSoundVolume * 2.0, 1024 );// play dry fire sound
                		if (Pawn(Owner) != None)
                       		Pawn(Owner).ClientMessage(msgOutOf20mm);	
        	}
 	return true;
}

simulated function SwapMuzzleFlashTexture()
{
   	if ( !bHasMuzzleFlash )
      		return;  

	MultiSkins[2] = FireTexture'Effects.Laser.LaserSpot2';
	SetTimer(0.1, False);
}

state AltFiring
{
        	function SwapMuzzleFlashTexture()
        	{
        	}
Begin:	
	Sleep(GetAltShotTime());
	bFiring = False;
	FinishAnim();
	ReadyToFire();
Done:
	bFiring = False;
	AltFinish();
}

simulated state ClientAltFiring
{
        	simulated function SwapMuzzleFlashTexture()
        	{
        	}
Begin:
	Sleep(GetSimAltShotTime());
	bFiring = False;
	FinishAnim();
	bInProcess = False;
        	if ( (Owner != None) && !Owner.IsA('DeusExPlayer') )
                	ReadyClientToFire( True );
Done:
	bInProcess = False;
	bFiring = False;
	SimAltFinish();
}

function AltFinish()
{
	if ( Level.NetMode != NM_Standalone )
		ReadyClientToFire( True );
	
	if (bHasMuzzleFlash)
		EraseMuzzleFlashTexture();

	if ( bChangeWeapon )
	{
		GotoState('DownWeapon');
		return;
	}

	if (( Level.NetMode != NM_Standalone ) && IsInState('Active'))
	{
		GotoState('Idle');
		return;
	}

	if (Pawn(Owner) == None)
	{
		GotoState('Idle');
		return;
	}
	if ( PlayerPawn(Owner) == None )
	{
		if ((AltAmmoType == None) || (AltAmmoType.AmmoAmount<=0))
		{
                     		if (Pawn(Owner).bAltFire!=0)
                     		{
                            			Pawn(Owner).bAltFire = 0;
                            			Pawn(Owner).bFire = 1;
                            			Global.Fire(0);
                     		}
		}
		else 
		{
                     		if ((Pawn(Owner).bAltFire != 0) && (FRand() < AltRefireRate) )
                            			Global.AltFire(0);
                     		else
                     		{
				Pawn(Owner).StopFiring();
			 	GotoState('Idle');
                     		}
		}
		return;
	}

	if (( Level.NetMode == NM_DedicatedServer ) || ((Level.NetMode == NM_ListenServer) && Owner.IsA('DeusExPlayer') && !DeusExPlayer(Owner).PlayerIsListenClient()))
	{
		GotoState('Idle');
		return;
	}

	if ( ((AltAmmoType==None) || (AltAmmoType.AmmoAmount<=0)) || (Pawn(Owner).Weapon != self) )
		GotoState('Idle');
	else if (!bSemiAuto && (Pawn(Owner).bFire!=0))
		Global.Fire(0);
	else if (!bAltSemiAuto && (Pawn(Owner).bAltFire!=0))
		Global.AltFire(0);
	else 
		GotoState('Idle');
}

simulated function SimAltFinish()
{
	ServerGotoFinishFire();

	bInProcess = False;
	bFiring = False;

	if (bHasMuzzleFlash)
		EraseMuzzleFlashTexture();

	if (Pawn(Owner) == None)
	{
		GotoState('SimIdle');
		return;
	}

	if ( PlayerPawn(Owner) == None )
	{
		GotoState('SimIdle');
		return;
	}

        	if ( PlayerPawn(Owner) == None )
	{
		if ((AltAmmoType == None) || (AltAmmoType.AmmoAmount<=0))
	    	{
                    		if (Pawn(Owner).bAltFire!=0)
                    		{
                           			Pawn(Owner).bAltFire = 0;
                           			Pawn(Owner).bFire = 1;
                           			ClientReFire(0);
                    		}
	    	}
            		else 
	    	{
                    		if ((Pawn(Owner).bAltFire != 0) && (FRand() < AltRefireRate) )
                           			ClientAltReFire(0);
                    		else
                    		{
				Pawn(Owner).StopFiring();
				GotoState('SimIdle');
                    		}
	    	}
	    	return;
	}

	if ((Pawn(Owner).bFire != 0) && !bSemiAuto)
		ClientReFire(0);
        	else  if ((Pawn(Owner).bAltFire != 0) && !bAltSemiAuto)
		ClientAltReFire(0);
	else
		GotoState('SimIdle');
}

state Idle
{
Begin:
	bFiring = False;
        	ReadyToFire();
        	if (Level.Game.bDeathMatch || (Level.Game.Difficulty > 2) || (Level.NetMode != NM_Standalone))
        	{
               		if ( (AmmoType != None) && (AmmoType.AmmoAmount<=0) 
                  	   && (AltAmmoType != None) && (AltAmmoType.AmmoAmount<=0)) 
                         		Pawn(Owner).SwitchToBestWeapon(); 
        	}
	if (((Level.NetMode == NM_DedicatedServer) && Owner.IsA('DeusExPlayer')) || ((Level.NetMode == NM_ListenServer) && Owner.IsA('DeusExPlayer') && !DeusExPlayer(Owner).PlayerIsListenClient()))
	{
	}
	else
	{
		PlayAnim('Idle1',,0.1);
		SetTimer(3.0, True);
	}
}

simulated state SimIdle
{
Begin:
        	if ( (Owner != None) && !Owner.IsA('DeusExPlayer') )
                	ReadyClientToFire( True );
        	bInProcess = False;
	bFiring = False;
        	if ( ((Level.Game != None) && Level.Game.bDeathMatch) || (Level.NetMode != NM_Standalone) || ((Level.Game != None) && (Level.Game.Difficulty > 2)) )
        	{
               		if ( (AmmoType != None) && (AmmoType.AmmoAmount<=0) 
                  	   && (AltAmmoType != None) && (AltAmmoType.AmmoAmount<=0)) 
                      		Pawn(Owner).SwitchToBestWeapon(); 
        	}
        	if (!bNearWall)
		PlayAnim('Idle1',,0.1);
	SetTimer(3.0, True);
}

simulated function PlayFiringAltSound()
{
	PlaySimSound( AltFireSound, SLOT_None, TransientSoundVolume, 2048 );
}

simulated function PlayEndFire()
{
	PlaySimSound( Misc3Sound, SLOT_None, TransientSoundVolume, 2048 );
}

function float RateSelf( out int bUseAltMode )
{
        	local float EnemyDist;
	local bool bRetreating;
	local vector EnemyDir;
	local Pawn P;

      	bUseAltMode = 0;
	P = Pawn(Owner);

	if ( AmmoType.AmmoAmount <=0 )
		return -2;

        	if ( Region.Zone.bWaterZone )
		return  -2;

	if ( P.Enemy == None )
		return AIRating;
         
        	if ( P.bIsPlayer || bHas20mm )
        	{
             		EnemyDir = P.Enemy.Location - Owner.Location; 
	     	EnemyDist = VSize(EnemyDir);

		if ( EnemyDist < -1.5 * EnemyDir.Z )
		{
			if ( AltAmmoType.AmmoAmount > 0 )
				bUseAltMode = 1;
			else
				bUseAltMode = 0;
		}
		else
		{
			bRetreating = ( ((EnemyDir/EnemyDist) Dot Owner.Velocity) < -0.7 );
	          		bUseAltMode = 0;
	          		if ( bRetreating && (EnemyDist < 800) )
			{
				if ( AltAmmoType.AmmoAmount > 0 )
					bUseAltMode = 1;
				else
					bUseAltMode = 0;
			}	
		}
        	}
	return AIRating;
}

function LoadAmmoType(Ammo ammo)
{
}

function LoadAmmoClass(Class<Ammo> ammoClass)
{
}

simulated function bool TestMPBeltSpot(int BeltSpot)
{
        	return (BeltSpot == 4);
}

defaultproperties
{
     AltAmmoName=Class'DeusEx.Ammo20mm'
     LowAmmoWaterMark=25
     GoverningSkill=Class'DeusEx.SkillWeaponRifle'
     NoiseLevel=0.500000
     EnviroEffective=ENVEFF_Air
     Concealability=CONC_Visual
     bAutomatic=True
     bAltSemiAuto=False
     ShotTime=0.100000
     ReloadSound=Sound'DeusExSounds.Weapons.AssaultGunReloadEnd'
     SilencedSound=Sound'DeusEx.Weapons.AssaultRifleFire'
     AltFireRate=2.000000
     bTournamentWeapon=True
     reloadTime=2.000000
     BaseAccuracy=0.800000
     bCanHaveLaser=True
     AmmoNames(0)=Class'DeusEx.Ammo762mm'
     AmmoNames(1)=Class'DeusEx.Ammo20mm'
     recoilStrength=0.300000
     MinWeaponAcc=0.200000
     mpReloadTime=0.500000
     mpHitDamage=8
     mpBaseAccuracy=0.050000
     mpAccurateRange=4800
     mpMaxRange=9600
     mpReloadCount=100
     bCanHaveModBaseAccuracy=True
     bCanHaveModReloadCount=True
     bCanHaveModAccurateRange=True
     bCanHaveModReloadTime=True
     bCanHaveModRecoilStrength=True
     msgInfoSingle="AUTOMATIC"
     AmmoName=Class'DeusEx.Ammo762mm'
     ReloadCount=50
     PickupAmmoCount=50
     bInstantHit=True
     bAltWarnTarget=True
     FireOffset=(X=-16.000000,Y=5.000000,Z=11.500000)
     AltProjectileClass=Class'DeusEx.HECannister20mm'
     shakemag=200.000000
     AIRating=0.630000
     RefireRate=0.990000
     FireSound=Sound'DeusEx.Weapons.AssaultRifleFire'
     AltFireSound=Sound'DeusEx.Weapons.AssaultRifleAltFire'
     CockingSound=Sound'DeusExSounds.Weapons.AssaultGunReload'
     SelectSound=Sound'DeusExSounds.Weapons.AssaultGunSelect'
     Misc3Sound=Sound'DeusEx.Weapons.SilencedFire44'
     AutoSwitchPriority=5
     InventoryGroup=16
     ItemName="Assault Rifle"
     ItemArticle="an"
     PlayerViewOffset=(X=16.000000,Y=-5.000000,Z=-11.500000)
     PlayerViewMesh=LodMesh'DeusExItems.AssaultGun'
     PickupViewMesh=LodMesh'DeusExItems.AssaultGunPickup'
     ThirdPersonMesh=LodMesh'DeusExItems.AssaultGun3rd'
     LandSound=Sound'DeusExSounds.Generic.DropMediumWeapon'
     Icon=Texture'DeusExUI.Icons.BeltIconAssaultGun'
     largeIcon=Texture'DeusExUI.Icons.LargeIconAssaultGun'
     largeIconWidth=94
     largeIconHeight=65
     invSlotsX=2
     invSlotsY=2
     Description="The 7.62mm assault rifle is designed for close-quarters combat, utilizing a shortened barrel, noise suppressor and 'bullpup' design for increased maneuverability. An additional underhand 20mm HE launcher increases the rifle's effectiveness against a variety of targets."
     beltDescription="ASSAULT"
     Mesh=LodMesh'DeusExItems.AssaultGunPickup'
     SoundRadius=96
     SoundVolume=255
     CollisionRadius=15.000000
     CollisionHeight=3.000000
     Mass=30.000000
}
