//=============================================================================
// WeaponAssaultShotgun.
//=============================================================================
class WeaponAssaultShotgun extends DeusExWeapon;

simulated function PreBeginPlay()
{
    	Super.PreBeginPlay();

    	if ( ((Level.Game != None) && Level.Game.bDeathMatch) || (Level.NetMode != NM_Standalone) )
    	{
	   	HitDamage = mpHitDamage;
	   	BaseAccuracy = mpBaseAccuracy;
		ReloadTime = mpReloadTime;
		AccurateRange = mpAccurateRange;
	   	MaxRange = mpMaxRange;
	   	ReloadCount = mpReloadCount;
		ShotTime = AltShotTime;
           		InventoryGroup = 8;
    	}
}

simulated function Projectile ProjectileFire(class<projectile> ProjClass, float ProjSpeed, bool bWarn)
{
     	local vector realLoc, X, Y, Z;
     	local ShellCasing s;
     	local Projectile proj;

     	proj = Super.ProjectileFire(ProjClass, ProjSpeed, bWarn);
     	if (proj != None)
     	{
         		GetAxes(Pawn(Owner).ViewRotation, X, Y, Z);
         		realLoc = Owner.Location + CalcDrawOffset();
        		s = Spawn(class'ShellCasing',, '', realLoc + 2 * X + (FireOffset.Y + 15) * Y + Z);
		if ( s != None )
               		{
			s.Velocity = (FRand()*20+75) * Y + (10-FRand()*20) * X;
	        		s.Velocity.Z += 200;
			s.DrawScale = 3.5;
			s.RemoteRole = ROLE_None;
        		}
     	}
     	return proj;
}

simulated function SwapMuzzleFlashTexture()
{
   	if ( !bHasMuzzleFlash )
      		return;  
	
	MultiSkins[2] = Texture'LaserSpot2';
	MuzzleFlashLight();  
	SetTimer(0.1, False);
}

simulated function MuzzleFlashLight()
{
	local Vector offset, X, Y, Z;

      	if ( Owner == None )
		return;

 	if ( !bHasMuzzleFlash )
		return;

	if ((flash != None) && !flash.bDeleteMe)
		flash.LifeSpan = flash.Default.LifeSpan;
	else
	{
		GetAxes(Pawn(Owner).ViewRotation,X,Y,Z);
		offset = Owner.Location;
		offset += X * Owner.CollisionRadius * 2;
		flash = spawn(class'MuzzleFlash',,, offset);
		if (flash != None)
		{
			flash.SetBase(Owner);
			flash.LightHue = 150;
			flash.LightSaturation = 32;
		}
	}
}

function float RateSelf( out int bUseAltMode )
{
	local float EnemyDist, rating;
	local vector EnemyDir;

	if ( AmmoType.AmmoAmount <=0 )
		return -2;
	if ( Region.Zone.bWaterZone )
		return -2;
	if ( Pawn(Owner).Enemy == None )
	{
		bUseAltMode = 0;
		return AIRating;
	}
	EnemyDir = Pawn(Owner).Enemy.Location - Owner.Location;
	EnemyDist = VSize(EnemyDir);
	rating = FClamp(AIRating - (EnemyDist - 450) * 0.001, 0.2, AIRating);
	if ( EnemyDist > 900 )
	{
		bUseAltMode = 0;
		if ( EnemyDist > 2000 )
		{
			if ( EnemyDist > 3500 )
				return 0.21;
			return (AIRating - 0.3);
		}			
		if ( EnemyDir.Z < -0.5 * EnemyDist )
		{
			bUseAltMode = 1;
			return (AIRating - 0.3);
		}
	}
	else if ( (EnemyDist < 750) && (Pawn(Owner).Enemy.Weapon != None) && Pawn(Owner).Enemy.Weapon.bMeleeWeapon )
	{
		bUseAltMode = 0;
		return (AIRating + 0.3);
	}
	else if ( (EnemyDist < 340) || (EnemyDir.Z > 30) )
	{
		bUseAltMode = 0;
		return (AIRating + 0.2);
	}
	else
		bUseAltMode = int( FRand() < 0.65 );
	return rating;
}

function float SuggestAttackStyle()
{
	local bot B;

	B = Bot(Owner);
	if ( (B != None) && B.bNovice )
		return 0.2;
	return 0.4;
}

function float SuggestDefenseStyle()
{
	return -0.3;
}

simulated function bool TestMPBeltSpot(int BeltSpot)
{
   	return (BeltSpot == 8);
}

defaultproperties
{
     LowAmmoWaterMark=20
     GoverningSkill=Class'DeusEx.SkillWeaponRifle'
     NoiseLevel=1.500000
     EnviroEffective=ENVEFF_Air
     bAltSemiAuto=False
     AltShotTime=0.700000
     ReloadSound=Sound'DeusExSounds.Weapons.AssaultShotgunReloadEnd'
     TimeBetweenFire=0.050000
     FiringMode="AUTO-REFIRE"
     bTournamentWeapon=True
     reloadTime=3.000000
     HitDamage=15
     maxRange=14400
     AccurateRange=7200
     BaseAccuracy=0.800000
     AreaOfEffect=AOE_Cone
     recoilStrength=0.750000
     mpReloadTime=0.500000
     mpHitDamage=15
     mpBaseAccuracy=0.400000
     mpAccurateRange=7200
     mpMaxRange=14400
     mpReloadCount=20
     bCanHaveModBaseAccuracy=True
     bCanHaveModReloadCount=True
     bCanHaveModReloadTime=True
     bCanHaveModRecoilStrength=True
     msgInfoSingle="AUTO-REFIRE"
     AmmoName=Class'DeusEx.AmmoSabot'
     ReloadCount=20
     PickupAmmoCount=20
     bWarnTarget=True
     bAltWarnTarget=True
     bSplashDamage=True
     bRecommendAltSplashDamage=True
     FireOffset=(X=-30.000000,Y=10.000000,Z=12.000000)
     ProjectileClass=Class'DeusEx.SabotShell'
     AltProjectileClass=Class'DeusEx.SabotGrenade'
     shakemag=50.000000
     AIRating=0.750000
     RefireRate=0.900000
     AltRefireRate=0.850000
     FireSound=Sound'DeusEx.Weapons.SabotFire'
     AltFireSound=Sound'DeusEx.Weapons.SabotAltFire'
     CockingSound=Sound'DeusExSounds.Weapons.AssaultShotgunReload'
     SelectSound=Sound'DeusExSounds.Weapons.AssaultShotgunSelect'
     AutoSwitchPriority=9
     InventoryGroup=15
     ItemName="Sabot Cannon"
     PlayerViewOffset=(Y=-10.000000,Z=-12.000000)
     PlayerViewMesh=LodMesh'DeusExItems.AssaultShotgun'
     PickupViewMesh=LodMesh'DeusExItems.AssaultShotgunPickup'
     ThirdPersonMesh=LodMesh'DeusExItems.AssaultShotgun3rd'
     LandSound=Sound'DeusExSounds.Generic.DropMediumWeapon'
     Icon=Texture'DeusExUI.Icons.BeltIconAssaultShotgun'
     largeIcon=Texture'DeusExUI.Icons.LargeIconAssaultShotgun'
     largeIconWidth=99
     largeIconHeight=55
     invSlotsX=2
     invSlotsY=2
     Description="The HFSC-12 12mm Fragmentation Sabot Cannon is capable of firing both high-velocity caseless ammunition and cased fragmentation grenade rounds. With an unloaded weight of only 30 LBS, the HFSC-12 is portable and maneuverable, easily worn across the back when employing the optional carrying strap. The HFSC-12 is the weapon of choice for the discerning soldier."
     beltDescription="CANNON"
     Mesh=LodMesh'DeusExItems.AssaultShotgunPickup'
     CollisionRadius=15.000000
     CollisionHeight=8.000000
     Mass=30.000000
}
