//=============================================================================
// WeaponBaton.
//=============================================================================
class WeaponBaton extends DeusExWeapon;

//-----------------------------------
// omg... there is only PlayerView mesh :D
function prebeginplay()
{
     local mesh HDTPmesh;
     HDTPmesh = LODMesh(dynamicloadObject("HDTPItems.HDTPWeaponBaton",class'mesh', true));
     if(HDTPmesh != none)
     {
		    PlayerViewMesh=HDTPmesh;
     }
 super.prebeginplay();
}
//----------------------------------------



function name WeaponDamageType()
{
	return 'KnockedOut';
}

simulated function bool ClientAltFire( float Value )
{
        	bClientReadyToFire = False;
        	bInProcess = True;
        	GotoState('ClientFiring');
        	bPointing = True;
        	if ( PlayerPawn(Owner) != None )
	     	PlayerPawn(Owner).PlayFiring();
        	PlayFiringAltSound();
        	ProjectileAltFire(AltProjectileClass, AltProjectileSpeed, bAltWarnTarget);
        	if (HardcorePlayer(Owner) != None) 
             		HardcorePlayer(Owner).SwitchWeapon(0);
        	Destroy();
        	return true;		
}

function AltFire( float Value )
{
        	GotoState('AltFiring');
        	bPointing = True;
        	if ( Owner.IsA('PlayerPawn') )
	     	PlayerPawn(Owner).PlayFiring();
        	PlayFiringAltSound();
        	ProjectileAltFire(AltProjectileClass, AltProjectileSpeed, bAltWarnTarget);
        	if (HardcorePlayer(Owner) != None) 
             		HardcorePlayer(Owner).SwitchWeapon(0);
        	Destroy();
}

function bool HandlePickupQuery( inventory Item )
{
        	local DeusExPlayer P;

        	if ( Item.Class == Class )
        	{
             		P = DeusExPlayer(Owner);
             		if (P != None)
                 		P.ClientMessage(Sprintf(P.CanCarryOnlyOne, itemName));
	     	return true;
        	}
        	return Super.HandlePickupQuery(Item);
}

function Finish()
{
	if ( Level.NetMode != NM_Standalone )
		ReadyClientToFire( True );
		
	if ( bChangeWeapon )
	{
		GotoState('DownWeapon');
		return;
	}

	if ( (Level.NetMode != NM_Standalone ) && IsInState('Active') )
	{
		GotoState('Idle');
		return;
	}

	if (Pawn(Owner) == None)
	{
		GotoState('Idle');
		return;
	}
	if ( PlayerPawn(Owner) == None )
	{
		if ( (Pawn(Owner).bFire != 0) && (FRand() < RefireRate) )
			Global.Fire(0);
		else 
		{
			Pawn(Owner).StopFiring();
			GotoState('Idle');
		}
		return;
	}

	if ( ( Level.NetMode == NM_DedicatedServer ) || ((Level.NetMode == NM_ListenServer) && Owner.IsA('DeusExPlayer') && !DeusExPlayer(Owner).PlayerIsListenClient()) )
	{
		GotoState('Idle');
		return;
	}

	if ( Pawn(Owner).Weapon != self )
		GotoState('Idle');
	else if ( Pawn(Owner).bFire!=0 )
		Global.Fire(0);
	else 
		GotoState('Idle');
}

function float SuggestAttackStyle()
{
	return 10.0;
}

function float SuggestDefenseStyle()
{
	return -2.0;
}

defaultproperties
{
     LowAmmoWaterMark=0
     GoverningSkill=Class'DeusEx.SkillWeaponLowTech'
     NoiseLevel=0.050000
     AmmoPerFire=0
     AmmoPerAltFire=0
     FiringMode="MELEE"
     reloadTime=0.000000
     HitDamage=17
     maxRange=80
     AccurateRange=80
     BaseAccuracy=1.000000
     bPenetrating=False
     bHasMuzzleFlash=False
     bHandToHand=True
     bFallbackWeapon=True
     bEmitWeaponDrawn=False
     AmmoName=Class'DeusEx.AmmoNone'
     ReloadCount=0
     bInstantHit=True
     bMeleeWeapon=True
     FireOffset=(X=-24.000000,Y=14.000000,Z=17.000000)
     AltProjectileClass=Class'DeusEx.Baton'
     shakemag=20.000000
     FireSound=Sound'DeusExSounds.Weapons.BatonFire'
     AltFireSound=Sound'DeusExSounds.Weapons.BatonFire'
     SelectSound=Sound'DeusExSounds.Weapons.BatonSelect'
     Misc1Sound=Sound'DeusExSounds.Weapons.BatonHitFlesh'
     Misc2Sound=Sound'DeusExSounds.Weapons.BatonHitHard'
     Misc3Sound=Sound'DeusExSounds.Weapons.BatonHitSoft'
     InventoryGroup=7
     ItemName="Baton"
     PlayerViewOffset=(X=24.000000,Y=-14.000000,Z=-17.000000)
     PlayerViewMesh=LodMesh'DeusExItems.Baton'
     PickupViewMesh=LodMesh'DeusExItems.BatonPickup'
     ThirdPersonMesh=LodMesh'DeusExItems.Baton3rd'
     Icon=Texture'DeusExUI.Icons.BeltIconBaton'
     largeIcon=Texture'DeusExUI.Icons.LargeIconBaton'
     largeIconWidth=46
     largeIconHeight=47
     Description="A hefty looking baton, typically used by riot police and national security forces to discourage civilian resistance."
     beltDescription="BATON"
     Mesh=LodMesh'DeusExItems.BatonPickup'
     CollisionRadius=14.000000
     CollisionHeight=3.000000
}
