//=============================================================================
// WeaponCombatKnife.
//=============================================================================
class WeaponCombatKnife extends DeusExWeapon;

simulated function PreBeginPlay()
{
	Super.PreBeginPlay();

	if ( ((Level.Game != None) && Level.Game.bDeathMatch) || (Level.NetMode != NM_Standalone) )
	{
		HitDamage = mpHitDamage;
		BaseAccuracy = mpBaseAccuracy;
		ReloadTime = mpReloadTime;
		AccurateRange = mpAccurateRange;
		MaxRange = mpMaxRange;
	}
}

simulated function bool ClientAltFire( float Value )
{
        	bClientReadyToFire = False;
        	bInProcess = True;
        	GotoState('ClientFiring');
        	bPointing = True;
        	if ( PlayerPawn(Owner) != None )
	     	PlayerPawn(Owner).PlayFiring();
        	PlayFiringAltSound();
        	ProjectileAltFire(AltProjectileClass, AltProjectileSpeed, bAltWarnTarget);
        	if (HardcorePlayer(Owner) != None) 
             		HardcorePlayer(Owner).SwitchWeapon(0);
        	Destroy();
        	return true;		
}

function AltFire( float Value )
{
        	GotoState('AltFiring');
        	bPointing = True;
        	if ( Owner.IsA('PlayerPawn') )
	     	PlayerPawn(Owner).PlayFiring();
        	PlayFiringAltSound();
        	ProjectileAltFire(AltProjectileClass, AltProjectileSpeed, bAltWarnTarget);
        	if (HardcorePlayer(Owner) != None) 
             		HardcorePlayer(Owner).SwitchWeapon(0);
        	Destroy();
}

function bool HandlePickupQuery( inventory Item )
{
        	local DeusExPlayer P;

        	if ( Item.Class == Class )
        	{
             		P = DeusExPlayer(Owner);
             		if (P != None)
                 		P.ClientMessage(Sprintf(P.CanCarryOnlyOne, itemName));
	     	return true;
        	}
        	return Super.HandlePickupQuery(Item);
}

function Finish()
{
	if ( Level.NetMode != NM_Standalone )
		ReadyClientToFire( True );
		
	if ( bChangeWeapon )
	{
		GotoState('DownWeapon');
		return;
	}

	if ( (Level.NetMode != NM_Standalone ) && IsInState('Active') )
	{
		GotoState('Idle');
		return;
	}

	if (Pawn(Owner) == None)
	{
		GotoState('Idle');
		return;
	}
	if ( PlayerPawn(Owner) == None )
	{
		if ( (Pawn(Owner).bFire != 0) && (FRand() < RefireRate) )
			Global.Fire(0);
		else 
		{
			Pawn(Owner).StopFiring();
			GotoState('Idle');
		}
		return;
	}

	if ( ( Level.NetMode == NM_DedicatedServer ) || ((Level.NetMode == NM_ListenServer) && Owner.IsA('DeusExPlayer') && !DeusExPlayer(Owner).PlayerIsListenClient()) )
	{
		GotoState('Idle');
		return;
	}

	if ( Pawn(Owner).Weapon != self )
		GotoState('Idle');
	else if ( Pawn(Owner).bFire!=0 )
		Global.Fire(0);
	else 
		GotoState('Idle');
}

function float SuggestAttackStyle()
{
	return 10.0;
}

function float SuggestDefenseStyle()
{
	return -2.0;
}

defaultproperties
{
     LowAmmoWaterMark=0
     GoverningSkill=Class'DeusEx.SkillWeaponLowTech'
     NoiseLevel=0.050000
     EnemyEffective=ENMEFF_Organic
     Concealability=CONC_Visual
     AmmoPerFire=0
     AmmoPerAltFire=0
     FiringMode="MELEE"
     reloadTime=0.000000
     maxRange=80
     AccurateRange=80
     BaseAccuracy=1.000000
     bHasMuzzleFlash=False
     bHandToHand=True
     bFallbackWeapon=True
     mpHitDamage=20
     mpBaseAccuracy=1.000000
     mpAccurateRange=96
     mpMaxRange=96
     AmmoName=Class'DeusEx.AmmoNone'
     ReloadCount=0
     bInstantHit=True
     bMeleeWeapon=True
     FireOffset=(X=-5.000000,Y=8.000000,Z=14.000000)
     AltProjectileClass=Class'DeusEx.CombatKnife'
     shakemag=20.000000
     FireSound=Sound'DeusExSounds.Weapons.CombatKnifeFire'
     AltFireSound=Sound'DeusExSounds.Weapons.CombatKnifeFire'
     SelectSound=Sound'DeusExSounds.Weapons.CombatKnifeSelect'
     Misc1Sound=Sound'DeusExSounds.Weapons.CombatKnifeHitFlesh'
     Misc2Sound=Sound'DeusExSounds.Weapons.CombatKnifeHitHard'
     Misc3Sound=Sound'DeusExSounds.Weapons.CombatKnifeHitSoft'
     InventoryGroup=6
     ItemName="Combat Knife"
     PlayerViewOffset=(X=5.000000,Y=-8.000000,Z=-14.000000)
     PlayerViewMesh=LodMesh'DeusExItems.CombatKnife'
     PickupViewMesh=LodMesh'DeusExItems.CombatKnifePickup'
     ThirdPersonMesh=LodMesh'DeusExItems.CombatKnife3rd'
     Icon=Texture'DeusExUI.Icons.BeltIconCombatKnife'
     largeIcon=Texture'DeusExUI.Icons.LargeIconCombatKnife'
     largeIconWidth=49
     largeIconHeight=45
     Description="An ultra-high carbon stainless steel knife."
     beltDescription="KNIFE"
     Mesh=LodMesh'DeusExItems.CombatKnifePickup'
     CollisionRadius=12.650000
     CollisionHeight=0.800000
}
