//=============================================================================
// WeaponCrowbar.
//=============================================================================
class WeaponCrowbar extends DeusExWeapon;


//-----------------------------------
// Uses HDTP's models/textures if they exists ;)
simulated function PreBeginPlay()
{
     local mesh HDTPmeshPView;
     local mesh HDTPmeshPick;
     local mesh HDTPmesh3rd;
		 local texture HDTPreflectionmap;
		 local texture HDTPinventoryicon;
//------------------------------
	Super.PreBeginPlay();
//------------------------------
	if ( ((Level.Game != None) && Level.Game.bDeathMatch) || (Level.NetMode != NM_Standalone) )
	{
		HitDamage = mpHitDamage;
		BaseAccuracy = mpBaseAccuracy;
		ReloadTime = mpReloadTime;
		AccurateRange = mpAccurateRange;
		MaxRange = mpMaxRange;
	}
//------------------------------
     HDTPmeshPView = LODMesh(dynamicloadObject("HDTPItems.HDTPWeaponCrowbar",class'mesh', true));
     HDTPmeshPick = LODMesh(dynamicloadObject("HDTPItems.HDTPCrowbarPickup",class'mesh', true));
     HDTPmesh3rd = LODMesh(dynamicloadObject("HDTPItems.HDTPCrowbar3rd",class'mesh', true));
		 HDTPreflectionmap = Texture(dynamicloadObject("HDTPItems.Skins.HDTPWeaponCrowbarTex2",class'texture', true));
		 HDTPinventoryicon = Texture(dynamicloadObject("HDTPItems.Skins.HDTPLargeIconCrowbar",class'texture', true));
//------------------------------
     if((HDTPmeshPView != none) && (HDTPmeshPick != none) && (HDTPmesh3rd != none) && (HDTPinventoryicon != none) && (HDTPreflectionmap != none))
     {
    		PlayerViewMesh=HDTPmeshPView;
    		PickupViewMesh=HDTPmeshPick;
		    ThirdPersonMesh=HDTPmesh3rd;
				Texture=HDTPreflectionmap;
	      	if (Level.Game.Difficulty == 1) // hmm...
				    largeIcon=HDTPinventoryicon;
     }
//------------------------------
}

simulated function bool ClientAltFire( float Value )
{
        	bClientReadyToFire = False;
        	bInProcess = True;
        	GotoState('ClientFiring');
        	bPointing = True;
        	if ( PlayerPawn(Owner) != None )
	     	PlayerPawn(Owner).PlayFiring();
        	PlayFiringAltSound();
        	ProjectileAltFire(AltProjectileClass, AltProjectileSpeed, bAltWarnTarget);
        	if (HardcorePlayer(Owner) != None) 
             		HardcorePlayer(Owner).SwitchWeapon(0);
        	Destroy();
        	return true;		
}

function AltFire( float Value )
{
        	GotoState('AltFiring');
        	bPointing = True;
        	if ( Owner.IsA('PlayerPawn') )
	     	PlayerPawn(Owner).PlayFiring();
        	PlayFiringAltSound();
        	ProjectileAltFire(AltProjectileClass, AltProjectileSpeed, bAltWarnTarget);
        	if (HardcorePlayer(Owner) != None) 
             		HardcorePlayer(Owner).SwitchWeapon(0);
        	Destroy();
}

function bool HandlePickupQuery( inventory Item )
{
        	local DeusExPlayer P;

        	if ( Item.Class == Class )
        	{
             		P = DeusExPlayer(Owner);
             		if (P != None)
                 		P.ClientMessage(Sprintf(P.CanCarryOnlyOne, itemName));
	     	return true;
        	}
        	return Super.HandlePickupQuery(Item);
}

function Finish()
{
	if ( Level.NetMode != NM_Standalone )
		ReadyClientToFire( True );
		
	if ( bChangeWeapon )
	{
		GotoState('DownWeapon');
		return;
	}

	if ( (Level.NetMode != NM_Standalone ) && IsInState('Active') )
	{
		GotoState('Idle');
		return;
	}

	if (Pawn(Owner) == None)
	{
		GotoState('Idle');
		return;
	}
	if ( PlayerPawn(Owner) == None )
	{
		if ( (Pawn(Owner).bFire != 0) && (FRand() < RefireRate) )
			Global.Fire(0);
		else 
		{
			Pawn(Owner).StopFiring();
			GotoState('Idle');
		}
		return;
	}

	if ( ( Level.NetMode == NM_DedicatedServer ) || ((Level.NetMode == NM_ListenServer) && Owner.IsA('DeusExPlayer') && !DeusExPlayer(Owner).PlayerIsListenClient()) )
	{
		GotoState('Idle');
		return;
	}

	if ( Pawn(Owner).Weapon != self )
		GotoState('Idle');
	else if ( Pawn(Owner).bFire!=0 )
		Global.Fire(0);
	else 
		GotoState('Idle');
}

function float SuggestAttackStyle()
{
	return 10.0;
}

function float SuggestDefenseStyle()
{
	return -2.0;
}

defaultproperties
{
     LowAmmoWaterMark=0
     GoverningSkill=Class'DeusEx.SkillWeaponLowTech'
     NoiseLevel=0.050000
     AmmoPerFire=0
     AmmoPerAltFire=0
     FiringMode="MELEE"
     reloadTime=0.000000
     HitDamage=15
     maxRange=80
     AccurateRange=80
     BaseAccuracy=1.000000
     bPenetrating=False
     bHasMuzzleFlash=False
     bHandToHand=True
     bFallbackWeapon=True
     bEmitWeaponDrawn=False
     mpHitDamage=25
     mpBaseAccuracy=1.000000
     mpAccurateRange=96
     mpMaxRange=96
     AmmoName=Class'DeusEx.AmmoNone'
     ReloadCount=0
     bInstantHit=True
     bMeleeWeapon=True
     FireOffset=(X=-40.000000,Y=15.000000,Z=8.000000)
     AltProjectileClass=Class'DeusEx.Crowbar'
     shakemag=20.000000
     FireSound=Sound'DeusExSounds.Weapons.CrowbarFire'
     AltFireSound=Sound'DeusExSounds.Weapons.CrowbarFire'
     SelectSound=Sound'DeusExSounds.Weapons.CrowbarSelect'
     Misc1Sound=Sound'DeusExSounds.Weapons.CrowbarHitFlesh'
     Misc2Sound=Sound'DeusExSounds.Weapons.CrowbarHitHard'
     Misc3Sound=Sound'DeusExSounds.Weapons.CrowbarHitSoft'
     InventoryGroup=5
     ItemName="Crowbar"
     PlayerViewOffset=(X=40.000000,Y=-15.000000,Z=-8.000000)
     PlayerViewMesh=LodMesh'DeusExItems.Crowbar'
     PickupViewMesh=LodMesh'DeusExItems.CrowbarPickup'
     ThirdPersonMesh=LodMesh'DeusExItems.Crowbar3rd'
     LandSound=Sound'DeusExSounds.Generic.DropMediumWeapon'
     Icon=Texture'DeusExUI.Icons.BeltIconCrowbar'
     largeIcon=Texture'DeusExUI.Icons.LargeIconCrowbar'
     largeIconWidth=101
     largeIconHeight=43
     invSlotsX=2
     Description="A crowbar. Hit someone or something with it. Repeat.|n|n<UNATCO OPS FILE NOTE GH010-BLUE> Many crowbars we call 'murder of crowbars.'  Always have one for kombat. Ha. -- Gunther Hermann <END NOTE>"
     beltDescription="CROWBAR"
     Mesh=LodMesh'DeusExItems.CrowbarPickup'
     CollisionRadius=19.000000
     CollisionHeight=3.000000
     Mass=15.000000
}
