//=============================================================================
// WeaponDXQuadShot.
// There is no support for the Unrealistic difficulty!!!
//=============================================================================
class WeaponDXQuadShot extends DeusExWeapon;

var() texture   MuzzleFlashVariations[10];


#exec OBJ LOAD FILE=CoreTexMetal

simulated function PreBeginPlay()
{
	local Rotator rot;

	if ( Level.NetMode == NM_Standalone ) 
	{
		if ( !Level.Game.bDeathMatch )
       			bDifficulty3 = False; 
	}

	Super.PreBeginPlay();

	if ( ((Level.Game != None) && Level.Game.bDeathMatch) || (Level.NetMode != NM_Standalone) )
	{
		HitDamage = 10;
		ReloadTime = 1.0;
		ReloadCount = 20;
		PickupAmmoCount = 20;
		InventoryGroup = 10;

		rot = Rotation;
		rot.Roll = 0;
		rot.Pitch = 16384;
		rot.Yaw = 0;
		SetRotation(rot);

    		return;
	}
 	if ( Level.Game.Difficulty == 3 )
	{
		ReloadTime = 2.000000;
	  	HitDamage = 10;
	}
}

simulated function PlaySelectiveFiring()
{
	Super.PlaySelectiveFiring();
        if ( (PlayerPawn(Owner) != None )  
	&& ( PlayerPawn(Owner).DesiredFOV == PlayerPawn(Owner).DefaultFOV) )
		bMuzzleFlash++;
	MuzzleFlashLight();   
}

simulated function PlaySelectiveAltFiring()
{
	Super.PlaySelectiveAltFiring();
        if ((PlayerPawn(Owner) != None)  
	&& (PlayerPawn(Owner).DesiredFOV == PlayerPawn(Owner).DefaultFOV) )
		bMuzzleFlash++;
	MuzzleFlashLight();   
}


function float RateSelf( out int bUseAltMode )
{
	local float EnemyDist;

 	if ( AmmoType.AmmoAmount <=0 ) // no ammo? swith to something else
  		return -2;

 	if ( Region.Zone.bWaterZone ) //the weapon is underwater? this is bad, swith
  		return  -2;

 	if (Pawn(Owner).Enemy == None) //if there is no enemy don't bother us at all
 	{
  		bUseAltMode = 0;
  		return AIRating;
 	}

 	EnemyDist = VSize(Pawn(Owner).Enemy.Location - Owner.Location); //What the current distance between me and the enemy?
 	if ( (EnemyDist < 800) && (AmmoLeftInClip() >= AmmoPerAltFire) )
        	bUseAltMode = 1;
	else
        	bUseAltMode = 0;
 	
	return AIRating;
}

simulated event RenderOverlays(canvas Canvas)
{
	Super.RenderOverlays(Canvas);

	if ( (bMuzzleFlash > 0) && !Level.bDropDetail )
		MFTexture = MuzzleFlashVariations[Rand(2)];
}

simulated function TraceAltFire( float Accuracy )
{
	local vector HitLocation, HitNormal, StartTrace, EndTrace, X, Y, Z;
	local Rotator rot;
	local actor Other;
	local float dist, alpha, degrade;
	local int i, numSlugs;
	local float volume, radius;
	
	if ( !bHasSilencer )
	{
		GetAIVolume(volume, radius);
            		Owner.MakeNoise(Pawn(Owner).SoundDampening);
		Owner.AISendEvent('WeaponFire', EAITYPE_Audio, volume, radius);
		Owner.AISendEvent('LoudNoise', EAITYPE_Audio, volume, radius);
		if (!Owner.IsA('PlayerPawn'))
			Owner.AISendEvent('Distress', EAITYPE_Audio, volume, radius);
	}

	GetAxes(Pawn(owner).ViewRotation,X,Y,Z);
	StartTrace = ComputeProjectileStart(X, Y, Z);
	AdjustedAim = pawn(owner).AdjustAim(1000000, StartTrace, 2*AimError, False, False);

	numSlugs = AmmoPerAltFire*5;	

	for (i=0; i<numSlugs; i++)
	{
      		if (Accuracy < MinAltSpreadAcc)
            		Accuracy = MinAltSpreadAcc;
      		
      		EndTrace = StartTrace + Accuracy * (FRand()-0.5)*Y*1000 + Accuracy * (FRand()-0.5)*Z*1000 ;
      		EndTrace += (FMax(1024.0, MaxRange) * vector(AdjustedAim));
      
      		Other = Pawn(Owner).TraceShot(HitLocation,HitNormal,EndTrace,StartTrace);
		
		dist = Abs(VSize(HitLocation - Owner.Location));

		if (dist <= AccurateRange)		// we hit just fine
			ProcessAltTraceHit(Other, HitLocation, HitNormal, vector(AdjustedAim),Y,Z);
		else if (dist <= MaxRange)
		{
			alpha = (dist - AccurateRange) / (MaxRange - AccurateRange);
			degrade = 0.5 * Square(alpha);
			HitLocation.Z += degrade * (Owner.Location.Z - Owner.CollisionHeight);
			ProcessAltTraceHit(Other, HitLocation, HitNormal, vector(AdjustedAim),Y,Z);
		}
	}
}

function ReloadAmmo()
{  
	if ( !IsInState('Reload') )
	{
		TweenAnim('Still', 0.1);
		GotoState('Reload');
	}
}

state Reload
{
	ignores AltFire;

	function Fire(float Value)
	{
		if ( Owner.IsA('DeusExPlayer') && ((Level.NetMode == NM_Standalone) && !Level.Game.bDeathMatch) )
		{
			Global.Fire(Value);
		}
		else
		{
			//Do nothing...
		}
	}

	function float GetReloadTime()
	{
		local float val;

		val = ReloadTime;

		if (ScriptedPawn(Owner) != None)
		{
                 			if (Level.Game.Difficulty > 1)
                     			val = ReloadTime/2;
                 			else
			   	val = ReloadTime * (ScriptedPawn(Owner).BaseAccuracy*1+1);
			val = FMax(val, 0.4*ReloadCount);
		}
            		else if (Bot(Owner) != None)
		{
			val = ReloadTime/2.5;
			val = FMax(val, 0.4*ReloadCount);
		}
		else if (DeusExPlayer(Owner) != None)
		{
			val = GetWeaponSkill();
			val = ReloadTime + (val*ReloadTime);
			val = FMax(val, 0.4*ReloadCount);
		}

		return val;
	}		
Begin:
	FinishAnim();

	if (AmmoType.AmmoAmount > 0)
	{
		if ( ((Level.NetMode == NM_DedicatedServer ) && Owner.IsA('DeusExPlayer')) || ((Level.NetMode == NM_ListenServer) && Owner.IsA('DeusExPlayer') && !DeusExPlayer(Owner).PlayerIsListenClient()))               
		{
				ClientReload();
				Sleep(GetReloadTime());
				ReadyClientToFire( True );
		}
		else
		{
			Owner.PlaySound(CockingSound, SLOT_None,,, 1024);
			PlayAnim('ReloadBegin');
			NotifyOwner(True);
			FinishAnim();
LoadShell:
			if ( (ClipCount > 0) && ((AmmoType.AmmoAmount - AmmoLeftInClip()) > 0) )
			{
				if ( ClipCount == 1 )
					Owner.PlaySound(ReloadedSound, SLOT_None,,, 1024, 1.1 + 0.1*FRand());
				else
					Owner.PlaySound(ReloadSound, SLOT_None,,, 1024, 1.1 + 0.1*FRand());
				ClipCount--;
				LoopAnim('Reload');
				Sleep(GetReloadTime() / ReloadCount);
				Goto 'LoadShell';
			} 
			else
			{
				PlayAnim('ReloadEnd');
				FinishAnim();
				NotifyOwner(False);
			}
		}
	}
Done:
	GotoState('Idle');
}

simulated state SimReload
{	
	simulated function float GetSimReloadTime()
	{
		local float val;

		val = ReloadTime;

		if (ScriptedPawn(Owner) != None)
		{
                 			if ( Level.Game.Difficulty > 1 )
                     			val = ReloadTime/2;
                 			else
			   	val = ReloadTime * (ScriptedPawn(Owner).BaseAccuracy*1+1);
			val = FMax(val, 0.4*ReloadCount);
		}
            		else if (Bot(Owner) != None)
		{
			val = ReloadTime/2.5;
			val = FMax(val, 0.4*ReloadCount);
		}
		else if (DeusExPlayer(Owner) != None)
		{
			val = GetWeaponSkill();
			val = ReloadTime + (val*ReloadTime);
			val = FMax(val, 0.4*ReloadCount);
		}
		return val;
	}
Begin:
	if ( bWasInFiring )
	{		
		EraseMuzzleFlashTexture();
		FinishAnim();
	}
	bInProcess = False;
	bFiring=False;
      	
	Owner.PlaySound(CockingSound, SLOT_None,,, 1024);		
	PlayAnim('ReloadBegin');
	FinishAnim();
LoadShell:
	if ( (ClipCount > 0) && ((AmmoType.AmmoAmount - AmmoLeftInClip()) > 0) )
	{
		if ( ClipCount == 1 )
			Owner.PlaySound(ReloadedSound, SLOT_None,,, 1024, 1.1 + 0.1*FRand());
		else
			Owner.PlaySound(ReloadSound, SLOT_None,,, 1024, 1.1 + 0.1*FRand());
		ServerDoneReloading();
		LoopAnim('Reload');
		Sleep(GetSimReloadTime() / ReloadCount);
		Goto 'LoadShell';
	} 
	else
	{
		PlayAnim('ReloadEnd');
		FinishAnim();
	}
Done:
	GotoState('SimIdle');
}

function ServerDoneReloading()
{
	ClipCount--;
}

defaultproperties
{
     MuzzleFlashVariations(0)=Texture'DeusEx.SniperMuzzle1'
     MuzzleFlashVariations(1)=Texture'DeusEx.SniperMuzzle2'
     LowAmmoWaterMark=4
     GoverningSkill=Class'DeusEx.SkillWeaponRifle'
     NoiseLevel=1.500000
     EnviroEffective=ENVEFF_Air
     Concealability=CONC_All
     bSemiAuto=True
     bAltSemiAuto=True
     ShotTime=0.100000
     AltShotTime=0.200000
     AmmoPerAltFire=4
     MinAltSpreadAcc=0.500000
     ReloadSound=Sound'DeusEx.Weapons.ShotgunLoadShell'
     ReloadedSound=Sound'DeusExSounds.Weapons.SawedOffShotgunReloadEnd'
     FiringMode="SEMI-AUTO/BURST"
     MomentumTransfer=30000
     bTournamentWeapon=True
     reloadTime=4.000000
     HitDamage=8
     maxRange=1600
     AccurateRange=3200
     BaseAccuracy=0.100000
     AmmoNames(0)=Class'DeusEx.AmmoShell'
     AreaOfEffect=AOE_Cone
     recoilStrength=0.800000
     MinSpreadAcc=0.200000
     bCanHaveModReloadTime=True
     bCanHaveModRecoilStrength=True
     AmmoName=Class'DeusEx.AmmoShell'
     ReloadCount=12
     PickupAmmoCount=12
     bInstantHit=True
     bAltInstantHit=True
     bRapidFire=True
     AIRating=0.525000
     FireOffset=(X=-10.000000,Y=3.000000,Z=7.000000)
     shakemag=500.000000
     RefireRate=0.990000
     AltRefireRate=0.900000
     FireSound=Sound'DeusEx.Weapon.QuadShotFire'
     AltFireSound=Sound'DeusEx.Weapon.QuadShotAltFire'
     CockingSound=Sound'DeusExSounds.Weapons.SawedOffShotgunReload'
     SelectSound=Sound'DeusEx.Weapon.ShotgunReload'
     FlashO=0.025000
     FlashS=128
     bDrawMuzzleFlash=True
     MuzzleScale=1.000000
     FlashLength=0.010000
     MFTexture=Texture'DeusEx.SniperMuzzle1'
     InventoryGroup=143
     ItemName="Shotgun F4"
     PlayerViewOffset=(X=10.000000,Y=-3.000000,Z=-7.000000)
     PlayerViewMesh=LodMesh'DeusEx.QuadShotHeld'
     PlayerViewScale=1.300000
     BobDamping=0.800000
     PickupViewMesh=LodMesh'DeusEx.QuadShotPickup'
     ThirdPersonMesh=LodMesh'DeusEx.QuadShot3'
     bMuzzleFlashParticles=True
     MuzzleFlashTexture=Texture'DeusEx.SniperMuzzle1'
     LandSound=Sound'DeusExSounds.Generic.DropMediumWeapon'
     Icon=Texture'DeusEx.Icons.QBeltIcon'
     largeIcon=Texture'DeusEx.Icons.QIcon'
     largeIconWidth=250
     largeIconHeight=64
     invSlotsX=4
     Description="Powerful and reliable semi-atomatic four-barrel shotgun, accepts 12 gauge buckshot shells, has alternative firing mode: 4-round burst."
     beltDescription="QUADSHOT"
     Mesh=LodMesh'DeusEx.QuadShotPickup'
     CollisionRadius=14.000000
     CollisionHeight=3.000000
     Mass=30.000000
     Texture=texture'DeusExItems.Skins.ReflectionMapTex1'
}
