//=============================================================================
// WeaponFlamethrower.
//=============================================================================
class WeaponFlamethrower extends DeusExWeapon;

var int BurnTime, BurnDamage;

var int		mpBurnTime;
var int		mpBurnDamage;

simulated function PreBeginPlay()
{
	Super.PreBeginPlay();

	if ( ((Level.Game != None) && Level.Game.bDeathMatch) || (Level.NetMode != NM_Standalone) )
	{
              		HitDamage = mpHitDamage;
              		BaseAccuracy=mpBaseAccuracy;
              		ReloadTime = mpReloadTime;
              		AccurateRange = mpAccurateRange;
              		MaxRange = mpMaxRange;
              		ReloadCount = mpReloadCount;
              		BurnTime = mpBurnTime;
              		BurnDamage = mpBurnDamage;
              		PickupAmmoCount = mpReloadCount;
              		InventoryGroup = 5;
	}       
}

simulated function Tick(float deltaTime)
{
        	Super.Tick(deltaTime);
        	AmmoPerAltFire = Max(1, AmmoLeftInClip());
}

simulated function Projectile ProjectileAltFire(class<projectile> ProjClass, float ProjSpeed, bool bWarn)
{
	local Projectile proj;

	proj = Super.ProjectileAltFire(ProjClass, ProjSpeed, bWarn);

	if (proj != None)
       		proj.Damage *= AmmoPerAltFire;
        	return proj;
}

function GetWeaponRanges(out float wMinRange, out float wMaxAccurateRange, out float wMaxRange)
{
        	wMinRange         = 0;
	wMaxAccurateRange = 800;
	wMaxRange         = 1000;
}

simulated function PlaySelectiveFiring()
{
	Super.PlaySelectiveFiring();
	bWarnTarget = (FRand() < 0.2);
}

function float RateSelf( out int bUseAltMode )
{
	local float EnemyDist, rating;
	local vector EnemyDir;
        	local bool bRetreating;

	if ( AmmoType.AmmoAmount <=0 )
		return -2;

        	if ( Region.Zone.bWaterZone )
		return  -2;

	if ( Pawn(Owner).Enemy == None )
	{
		bUseAltMode = 0;
		return AIRating;
	}

	EnemyDir = Pawn(Owner).Enemy.Location - Owner.Location;
	EnemyDist = VSize(EnemyDir);
	rating = FClamp(AIRating - (EnemyDist - 50) * 0.001, 0.2, AIRating);       
        
	if ( EnemyDist > 400 ) 
	{
		bRetreating = ( ((EnemyDir/EnemyDist) Dot Owner.Velocity) < -0.7 );
                		if  ( EnemyDist > 800 ) 
               		{
                   		bUseAltMode = 1;
                   		return (0.2 + FRand() * 0.05);
                		}
		else if ( bRetreating )
                		{
                   		bUseAltMode = 1;
                  		 return (AIRating + 0.2);
                		}
                		return AIRating;
	}
        	else
        	{         
	        	bUseAltMode = 0;
                		return AIRating;
        	}
	return rating;
}

function float SuggestAttackStyle()
{
	local bot B;

	B = Bot(Owner);
	if ( (B != None) && B.bNovice )
		return 0.2;
	return 0.4;
}

function float SuggestDefenseStyle()
{
	return -0.3;
}

simulated function bool TestMPBeltSpot(int BeltSpot)
{
        	return (BeltSpot == 5);
}

defaultproperties
{
     burnTime=30
     BurnDamage=5
     mpBurnTime=15
     mpBurnDamage=2
     LowAmmoWaterMark=50
     GoverningSkill=Class'DeusEx.SkillWeaponHeavy'
     EnviroEffective=ENVEFF_Air
     bAutomatic=True
     bAltSemiAuto=False
     ShotTime=0.100000
     AltShotTime=1.500000
     ReloadSound=Sound'DeusExSounds.Weapons.FlamethrowerReloadEnd'
     AltFireAnim=Idle2
     AltFireRate=3.000000
     FiringMode="AUTOMATIC"
     bTournamentWeapon=True
     reloadTime=4.000000
     HitDamage=2
     maxRange=640
     AccurateRange=640
     BaseAccuracy=0.900000
     bHasMuzzleFlash=False
     mpReloadTime=0.500000
     mpHitDamage=5
     mpBaseAccuracy=0.200000
     mpAccurateRange=800
     mpMaxRange=800
     mpReloadCount=100
     bCanHaveModAccurateRange=True
     bCanHaveModReloadTime=True
     AmmoName=Class'DeusEx.AmmoNapalm'
     ReloadCount=100
     PickupAmmoCount=100
     bAltWarnTarget=True
     bSplashDamage=True
     FireOffset=(Y=14.000000,Z=10.000000)
     ProjectileClass=Class'DeusEx.Fireball'
     AltProjectileClass=Class'DeusEx.NapalmCannister'
     shakemag=10.000000
     AIRating=0.700000
     RefireRate=0.990000
     AltRefireRate=0.100000
     FireSound=Sound'DeusExSounds.Weapons.FlamethrowerFire'
     AltFireSound=Sound'DeusEx.Weapons.FlameAltFire'
     CockingSound=Sound'DeusExSounds.Weapons.FlamethrowerReload'
     SelectSound=Sound'DeusExSounds.Weapons.FlamethrowerSelect'
     Misc1Sound=Sound'DeusExSounds.Weapons.FlamethrowerReloadEnd'
     AutoSwitchPriority=6
     InventoryGroup=20
     ItemName="Flamethrower"
     PlayerViewOffset=(X=20.000000,Y=-14.000000,Z=-12.000000)
     PlayerViewMesh=LodMesh'DeusExItems.Flamethrower'
     PickupViewMesh=LodMesh'DeusExItems.FlamethrowerPickup'
     ThirdPersonMesh=LodMesh'DeusExItems.Flamethrower3rd'
     LandSound=Sound'DeusExSounds.Generic.DropLargeWeapon'
     Icon=Texture'DeusExUI.Icons.BeltIconFlamethrower'
     largeIcon=Texture'DeusExUI.Icons.LargeIconFlamethrower'
     largeIconWidth=203
     largeIconHeight=69
     invSlotsX=4
     invSlotsY=2
     Description="A portable flamethrower that discards the old and highly dangerous backpack fuel delivery system in favor of pressurized canisters of napalm. The canister can be launched as a short-range missile. Inexperienced agents will find that a flamethrower can be difficult to maneuver, however."
     beltDescription="FLAMETHWR"
     Mesh=LodMesh'DeusExItems.FlamethrowerPickup'
     CollisionRadius=20.500000
     CollisionHeight=4.400000
     Mass=40.000000
}
