//=============================================================================
// WeaponGasGrenade.
//=============================================================================
class WeaponGasGrenade extends DeusExWeapon;

var bool bVacuum;

simulated function PreBeginPlay()
{
	Super.PreBeginPlay();

	if ( ((Level.Game != None) && Level.Game.bDeathMatch) || (Level.NetMode != NM_Standalone) )
	{
		HitDamage = mpHitDamage;
		BaseAccuracy = mpBaseAccuracy;
		ReloadTime = mpReloadTime;
		AccurateRange = mpAccurateRange;
		MaxRange = mpMaxRange;
	}
}

event TravelPostAccept()
{
	Super.TravelPostAccept();
	if ( FiringMode ~= AltGrenade )
		FiringMode = Grenade;
}

function Fire(float Value)
{
	// if facing a wall, affix the GasGrenade to the wall
	if (Pawn(Owner) != None)
	{
		if (bNearWall)
		{
			bReadyToFire = False;
			GotoState('NormalFire');
			bPointing = True;
			PlayAnim('Place',, 0.1);
			return;
		}
	}

	// otherwise, throw as usual
	Super.Fire(Value);
}

simulated function bool ClientAltFire(float Value)
{
	if ( bVacuum )
	{
		bVacuum = False;
		FiringMode = Grenade;
		ProjectileClass = Default.ProjectileClass;
		PlayFiringAltSound();
       		return False; 
	}
	bVacuum = True; 
	FiringMode = AltGrenade;
	ProjectileClass = AltProjectileClass;
	PlayFiringAltSound();
	return True;
}

function AltFire(float Value)
{
	ClientAltFire(Value);
}

function Projectile ProjectileAltFire(class<projectile> ProjClass, float ProjSpeed, bool bWarn)
{
}

function bool HandlePickupQuery( inventory Item )
{
        	local DeusExPlayer P;

        	if ( (Item.Class == Class) && (AmmoType.AmmoAmount >= AmmoType.MaxAmmo) )
	{
             		P = DeusExPlayer(Owner);
             		if (P != None)
                 		P.ClientMessage(P.TooMuchAmmo);
	     	return true;
        	}
        	return Super.HandlePickupQuery(Item);
}

function ReloadAmmo()
{
	ClipCount = 0;
}

defaultproperties
{
     LowAmmoWaterMark=2
     GoverningSkill=Class'DeusEx.SkillDemolition'
     EnemyEffective=ENMEFF_Organic
     EnviroEffective=ENVEFF_Air
     Concealability=CONC_All
     ShotTime=0.300000
     FiringMode="TEAR GAS"
     Grenade="TEAR GAS"
     AltGrenade="VACUUM"
     reloadTime=0.100000
     HitDamage=0
     maxRange=4800
     AccurateRange=2400
     BaseAccuracy=1.000000
     bPenetrating=False
     StunDuration=60.000000
     bHasMuzzleFlash=False
     bHandToHand=True
     bUseAsDrawnWeapon=False
     AITimeLimit=4.000000
     AIFireDelay=20.000000
     bNeedToSetMPPickupAmmo=False
     mpReloadTime=0.100000
     mpHitDamage=2
     mpBaseAccuracy=1.000000
     mpAccurateRange=2400
     mpMaxRange=2400
     AmmoName=Class'DeusEx.AmmoGasGrenade'
     ReloadCount=1
     PickupAmmoCount=1
     bWarnTarget=True
     FireOffset=(Y=10.000000,Z=20.000000)
     ProjectileClass=Class'DeusEx.GasGrenade'
     AltProjectileClass=Class'DeusEx.VacuumGrenade'
     shakemag=50.000000
     AltFireSound=Sound'DeusExSounds.Generic.DryFire'
     SelectSound=Sound'DeusExSounds.Weapons.GasGrenadeSelect'
     InventoryGroup=25
     ItemName="Gas Grenade"
     PlayerViewOffset=(Y=-13.000000,Z=-19.000000)
     PlayerViewMesh=LodMesh'DeusExItems.GasGrenade'
     PickupViewMesh=LodMesh'DeusExItems.GasGrenadePickup'
     ThirdPersonMesh=LodMesh'DeusExItems.GasGrenade3rd'
     Icon=Texture'DeusExUI.Icons.BeltIconGasGrenade'
     largeIcon=Texture'DeusExUI.Icons.LargeIconGasGrenade'
     largeIconWidth=23
     largeIconHeight=46
     Description="Upon detonation, the gas grenade releases a large amount of CS (a military-grade 'tear gas' agent) over its area of effect. CS will cause irritation to all exposed mucous membranes leading to temporary blindness and uncontrolled coughing. Like a LAM, gas grenades can be attached to any surface and used as a remote charge. Switching the firing mod results the gas grenade creates a highly pressured vacuum explosion."
     beltDescription="GAS GREN"
     Mesh=LodMesh'DeusExItems.GasGrenadePickup'
     CollisionRadius=2.300000
     CollisionHeight=3.300000
     Mass=5.000000
     Buoyancy=2.000000
}
