//=============================================================================
// WeaponHideAGun.
//=============================================================================
class WeaponHideAGun extends DeusExWeapon;

var float ChargeSize, Count;

event TravelPostAccept()
{
	Super.TravelPostAccept();
	if ( FiringMode ~= Burst )
		FiringMode = SemiAuto;
}

function ReloadAmmo()
{
}

simulated function PlaySelectiveFiring()
{
	Super.PlaySelectiveFiring();
	bWarnTarget = (FRand() < 0.33);
        	SwapMuzzleFlashTexture();
}

simulated function SwapMuzzleFlashTexture()
{ 
        	MultiSkins[2] = Texture'pbolt_a00';
        	SetTimer(0.1, False);
}

simulated function MuzzleFlashLight()
{
	local Vector offset, X, Y, Z;

	if ( Owner == None )
		return;

      	if ( !bHasMuzzleFlash )
		return;

	if ( (flash != None) && !flash.bDeleteMe )
		flash.LifeSpan = flash.Default.LifeSpan;
	else
	{
		GetAxes(Pawn(Owner).ViewRotation,X,Y,Z);
		offset = Owner.Location;
		offset += X * Owner.CollisionRadius * 2;
		flash = spawn(class'MuzzleFlash',,, offset);
		if ( flash != None )
		{
			flash.SetBase(Owner);
			flash.LightHue = 55;
			flash.LightSaturation = 32;
		}
	}
}

function AltFire(float Value)
{
	local float sndVolume;
	local bool bListenClient;

	bListenClient = (Owner.IsA('DeusExPlayer') && DeusExPlayer(Owner).PlayerIsListenClient());

	sndVolume = TransientSoundVolume;	

        	if ( Level.Game.bDeathMatch || (Level.NetMode != NM_Standalone) )
           		sndVolume = TransientSoundVolume * 2.0;

	if ( Level.NetMode != NM_Standalone )  
	{
		if ( !bClientReady && !bListenClient && Owner.IsA('DeusExPlayer') )
		{
                       		if ( Owner.IsA('DeusExPlayer') ) 
				DeusExPlayer(Owner).bJustAltFired = False;
			bReadyToFire = True;
			bPointing = False;
			bFiring = False;
			return;
		}
	}
	
	if ( AmmoType.UseAmmo(1) )
	{
  		if ( (Level.NetMode != NM_Standalone) && !bListenClient )
			bClientReady = False;                 
	    	bFiring = True;
	      	bReadyToFire = False;
		GotoState('AltFiring');
		bPointing = True;
		if ( Owner.IsA('PlayerPawn') )
			PlayerPawn(Owner).PlayFiring();
		PlaySelectiveAltFiring();   
                		if ( Owner.bHidden )
			CheckVisibility();
	}
	else
	      	PlaySimSound( Misc1Sound, SLOT_None, sndVolume, 1024 );		
	
	if ( DeusExPlayer(Owner) != None )
		DeusExPlayer(Owner).UpdateBeltText(Self);
}

simulated function bool ClientAltFire( float value )
{
	local bool bWaitOnAnim;
	local vector shake;
	
	if ( !bLooping ) // Wait on animations when not looping
	{
		bWaitOnAnim = ( IsAnimating() && ((AnimSequence == 'Select') || (AnimSequence == 'Shoot') || (AnimSequence == FireAnim) || (AnimSequence == AltFireAnim) || (AnimSequence == 'ReloadBegin') || (AnimSequence == 'Reload') || (AnimSequence == 'ReloadEnd') || (AnimSequence == 'Down')));
	}
	else
	{
		bWaitOnAnim = False;
		bLooping = False;
	}

        	if ( !bClientReadyToFire || bInProcess || ((DeusExPlayer(Owner) != None) && bWaitOnAnim) )
	{
                		if ( Owner.IsA('DeusExPlayer') )
			DeusExPlayer(Owner).bJustAltFired = False;
		bPointing = False;
		bFiring = False;
		return false;
	}
        	ServerForceAltFire();
	
	if ( AmmoType.AmmoAmount > 0) 
	{
		if ( AmmoType != None )
			AmmoType.SimUseAmmo();

		bFiring = True;
		bPointing = True;
		bClientReadyToFire = False;
		bInProcess = True;
		GotoState('ClientAltFiring');
		if ( PlayerPawn(Owner) != None )
			PlayerPawn(Owner).PlayFiring();
		PlaySelectiveAltFiring();
        	}
	else
	{
	  	PlaySimSound( Misc1Sound, SLOT_None, TransientSoundVolume * 2.0, 1024 );		// play dry fire sound
	}
         	return true;
}

state AltFiring
{
   	function Tick( float DeltaTime )
   	{
		ChargeSize += DeltaTime;
		if( (pawn(Owner).bAltFire==0)) GoToState('AltBurst');
		Count += DeltaTime;
		if ( Count > 0.3 ) 
		{
			Count = 0.0;
			if ( !AmmoType.UseAmmo(1) ) GoToState('AltBurst');
				AmmoType.GoToState('Idle2');
		}
   	}

   	function BeginState()
   	{
        		AmbientSound = AltFireSound;
		FiringMode = Burst;
        		ChargeSize = 0.0;
		Count = 0.0;
   	}

   	function EndState()
   	{
		local Projectile Shock;

        		if ( Owner == None )
            			return;
    
        		Shock = ProjectileAltFire(AltProjectileClass, AltProjectileSpeed, bAltWarnTarget);
        		PlayFiringBurstSound();
		AmbientSound = None;
		FiringMode = SemiAuto;
   	}
}

simulated state ClientAltFiring
{
   	simulated function Tick( float DeltaTime )
   	{
		ChargeSize += DeltaTime;
		if( (Pawn(Owner).bAltFire==0) ) GoToState('SimAltBurst');
			Count += DeltaTime;
		if ( Count > 0.3 ) 
		{
			Count = 0.0;
			if ( !AmmoType.UseAmmo(1) ) GoToState('SimAltBurst');
				AmmoType.GoToState('Idle2');
		}
   	}

   	simulated function BeginState()
   	{
		AmbientSound = AltFireSound;
		FiringMode = Burst;
        		ChargeSize = 0.0;
		Count = 0.0;
   	}

   	simulated function EndState()
   	{
        		local Projectile Shock;

        		if ( Owner == None )
            			return;
    
        		Shock = ProjectileAltFire(AltProjectileClass, AltProjectileSpeed, bAltWarnTarget);
        		AmbientSound = None;
		FiringMode = SemiAuto;
   	}
}

state AltBurst
{
Begin:
	PlayFiringBurstSound();
      	PlayAltBurst();
      	FinishAnim();
      	GotoState('Idle');
}

state SimAltBurst
{
Begin:
      	PlayFiringBurstSound();
      	PlayAltBurst();
      	FinishAnim();
      	GotoState('SimIdle');
}

simulated function PlayAltBurst()
{
	local Pawn aPawn;
	local Name anim;

	anim = FireAnim;
        
	bAltWarnTarget = (FRand() < 0.5);

	if ( (Level.NetMode == NM_Standalone) || ( DeusExPlayer(Owner) == DeusExPlayer(GetPlayerPawn())) )
	{
		PlayAnim(anim,, 0.1);
	}
	else if ( Role == ROLE_Authority )
	{
		for ( aPawn = Level.PawnList; aPawn != None; aPawn = aPawn.nextPawn )
		{
			if ( aPawn.IsA('DeusExPlayer') && ( DeusExPlayer(Owner) != DeusExPlayer(aPawn) ) )
			{
				if ( DeusExPlayer(aPawn).FastTrace( DeusExPlayer(aPawn).Location, Location) )
					DeusExPlayer(aPawn).ClientPlayAnimation( Self, anim, 0.1, bAutomatic );
			}
		}
	}
}

simulated function Projectile ProjectileAltFire(class<projectile> ProjClass, float ProjSpeed, bool bWarn)
{
	local Projectile proj;

	proj = Super.ProjectileAltFire(ProjClass, ProjSpeed, bWarn);

	if ( proj != None )
        	{
		proj.DrawScale = 0.100000;
           		proj.Damage *= ChargeSize;
        	}
        	return proj;
}

simulated function PlayFiringSound()
{
     	  PlaySimSound( FireSound, SLOT_None, TransientSoundVolume*2.0, 2048 );     	
}

simulated function PlayFiringBurstSound()
{
	PlaySimSound( FireSound, SLOT_None, TransientSoundVolume, 2048 );
        	PlaySimSound(Sound'PulseGunFire', SLOT_Interact, TransientSoundVolume + 1 * ChargeSize, 3600);
}

simulated function int AmmoLeftInClip()
{
	if ( AmmoType == None )
		return 0;
	else
		return AmmoType.AmmoAmount;
}

simulated function int NumClips()
{
	return 0;
}

defaultproperties
{
     LowAmmoWaterMark=4
     GoverningSkill=Class'DeusEx.SkillWeaponPistol'
     NoiseLevel=0.200000
     Concealability=CONC_All
     bSemiAuto=True
     bAltSemiAuto=False
     ShotTime=0.100000
     AltShotTime=0.100000
     FireAnim=Shoot2
     AltFireAnim=Idle3
     AltFireRate=5.000000
     TimeBetweenFire=0.050000
     TimeBetweenAltFire=0.050000
     FiringMode="SEMI-AUTO"
     Burst="CHARGED"
     reloadTime=0.000000
     HitDamage=25
     maxRange=24000
     AccurateRange=14400
     BaseAccuracy=0.000000
     bPenetrating=False
     msgInfoSingle="SEMI-AUTO OR CHARGED"
     AmmoName=Class'DeusEx.AmmoBattery'
     ReloadCount=255
     PickupAmmoCount=10
     FireOffset=(X=-20.000000,Y=8.000000,Z=11.000000)
     ProjectileClass=Class'DeusEx.PulseBall'
     AltProjectileClass=Class'DeusEx.PulseBall'
     shakemag=50.000000
     AIRating=0.230000
     FireSound=Sound'DeusEx.Weapons.PS20Fire'
     AltFireSound=Sound'DeusEx.Weapons.ProdFire2'
     SelectSound=Sound'DeusExSounds.Weapons.HideAGunSelect'
     Misc1Sound=Sound'DeusExSounds.Generic.DryFire'
     InventoryGroup=12
     ItemName="Pulse Pistol"
     PlayerViewOffset=(X=20.000000,Y=-10.000000,Z=-16.000000)
     PlayerViewMesh=LodMesh'DeusExItems.HideAGun'
     PickupViewMesh=LodMesh'DeusExItems.HideAGunPickup'
     ThirdPersonMesh=LodMesh'DeusExItems.HideAGun3rd'
     Icon=Texture'DeusExUI.Icons.BeltIconHideAGun'
     largeIcon=Texture'DeusExUI.Icons.LargeIconHideAGun'
     largeIconWidth=29
     largeIconHeight=47
     Description="The PS20 pulse pistol creates a localized pulse that will temporarily disable all electronics within its area of effect, including cameras and security grids and shock organic targets."
     beltDescription="PS20"
     Mesh=LodMesh'DeusExItems.HideAGunPickup'
     SoundVolume=32
     CollisionRadius=3.300000
     CollisionHeight=3.000000
     Mass=5.000000
     Buoyancy=2.000000
}
