//=============================================================================
// WeaponLAM.
//=============================================================================
class WeaponLAM extends DeusExWeapon;

var localized String shortName;

simulated function PreBeginPlay()
{
	Super.PreBeginPlay();

	if ( ((Level.Game != None) && Level.Game.bDeathMatch) || (Level.NetMode != NM_Standalone) )
	{
		HitDamage = mpHitDamage;
		BaseAccuracy = mpBaseAccuracy;
		ReloadTime = mpReloadTime;
		AccurateRange = mpAccurateRange;
		MaxRange = mpMaxRange;
	}
}

function AltFire(float Value)
{      
        	local LAM myLam;
	
        	ForEach AllActors( Class'LAM', myLam )
        	{
                	if ( (myLam != None) && myLam.bProximityTriggered && 
                   		((myLam.Owner != None) && (myLam.Owner == Owner)) )
                	{
	               		bReadyToFire = False;
       	               		GotoState('AltFiring');
	               		bPointing = True;
                       		PlayFiringAltSound();
                       		PlaySelectiveAltFiring();
	               		myLam.Explode(myLam.Location, Vector(myLam.Rotation));
                	}
        	}               		
}

simulated function bool ClientAltFire( float value )
{	
        	local LAM myLam;
	
        	ForEach AllActors( Class'LAM', myLam )
        	{
                 	if ( (myLam != None) && myLam.bProximityTriggered && 
                    		((myLam.Owner != None) && (myLam.Owner == Owner)) )
                 	{
	               		bReadyToFire = False;
       	               		GotoState('AltFiring');
	               		bPointing = True;
                       		PlayFiringAltSound();
                       		PlaySelectiveAltFiring();
	               		myLam.Explode(myLam.Location, Vector(myLam.Rotation));
                 	}
        	}             
        	return true;
}

simulated function PlaySelectiveAltFiring()
{
	PlayAnim(AltFireAnim,AltFireRate, TimeBetweenAltFire);
}

function Fire(float Value)
{
	if ( Pawn(Owner) != None )
	{
		if ( bNearWall )
		{
			bReadyToFire = False;
			GotoState('NormalFire');
			bPointing = True;
			PlayAnim('Place',, 0.1);
			return;
		}
	}

	Super.Fire(Value);
}

function Projectile ProjectileAltFire(class<projectile> ProjClass, float ProjSpeed, bool bWarn)
{
}

function bool HandlePickupQuery( inventory Item )
{
        	local DeusExPlayer P;

        	if ( (Item.Class == Class) && (AmmoType.AmmoAmount >= AmmoType.MaxAmmo) )
	{
             		P = DeusExPlayer(Owner);
             		if ( P != None )
                 		P.ClientMessage(P.TooMuchAmmo);
	     	return true;
        	}
        	return Super.HandlePickupQuery(Item);
}

function ReloadAmmo()
{
	ClipCount = 0;
}

defaultproperties
{
     ShortName="LAM"
     LowAmmoWaterMark=2
     GoverningSkill=Class'DeusEx.SkillDemolition'
     EnviroEffective=ENVEFF_AirWater
     Concealability=CONC_All
     ShotTime=0.300000
     AltFireAnim=Down
     FiringMode="LAM"
     reloadTime=0.100000
     HitDamage=50
     maxRange=4800
     AccurateRange=2400
     BaseAccuracy=1.000000
     bHasMuzzleFlash=False
     bHandToHand=True
     bUseAsDrawnWeapon=False
     AITimeLimit=3.500000
     AIFireDelay=5.000000
     bNeedToSetMPPickupAmmo=False
     mpReloadTime=0.100000
     mpHitDamage=50
     mpBaseAccuracy=1.000000
     mpAccurateRange=2400
     mpMaxRange=2400
     AmmoName=Class'DeusEx.AmmoLAM'
     ReloadCount=1
     PickupAmmoCount=1
     bWarnTarget=True
     FireOffset=(Y=10.000000,Z=20.000000)
     ProjectileClass=Class'DeusEx.LAM'
     shakemag=50.000000
     AltFireSound=Sound'DeusExSounds.Weapons.LAMSelect'
     SelectSound=Sound'DeusExSounds.Weapons.LAMSelect'
     InventoryGroup=22
     ItemName="Lightweight Attack Munitions (LAM)"
     PlayerViewOffset=(X=24.000000,Y=-15.000000,Z=-17.000000)
     PlayerViewMesh=LodMesh'DeusExItems.LAM'
     PickupViewMesh=LodMesh'DeusExItems.LAMPickup'
     ThirdPersonMesh=LodMesh'DeusExItems.LAM3rd'
     Icon=Texture'DeusExUI.Icons.BeltIconLAM'
     largeIcon=Texture'DeusExUI.Icons.LargeIconLAM'
     largeIconWidth=35
     largeIconHeight=45
     Description="A multi-functional explosive with electronic priming system that can either be thrown or attached to any surface with its polyhesive backing and used as a proximity mine or as a remote explosive.|n|n<UNATCO OPS FILE NOTE SC093-BLUE> Disarming a proximity device should only be attempted with the proper demolitions training. Trust me on this. -- Sam Carter <END NOTE>"
     beltDescription="LAM"
     Mesh=LodMesh'DeusExItems.LAMPickup'
     CollisionRadius=3.800000
     CollisionHeight=3.500000
     Mass=5.000000
     Buoyancy=2.000000
}
