//=============================================================================
// WeaponLAW.
//=============================================================================
class WeaponLAW extends DeusExWeapon;

simulated function PreBeginPlay()
{
	Super.PreBeginPlay();

	if ( ((Level.Game != None) && Level.Game.bDeathMatch) || (Level.NetMode != NM_Standalone) )
	{
		HitDamage = mpHitDamage;
		BaseAccuracy = mpBaseAccuracy;
		ReloadTime = mpReloadTime;
		AccurateRange = mpAccurateRange;
		MaxRange = mpMaxRange;
		ReloadCount = mpReloadCount;
		InventoryGroup = 9;
		return;
	}
	if ( Level.Game.Difficulty == 3 )
        	{
       	        	BaseAccuracy = mpBaseAccuracy;
                		ReloadTime = mpReloadTime;
        	}
}

event TravelPostAccept()
{
	Super.TravelPostAccept();
	bSemiAuto = False;
	bHasNightVision = False;
	FiringMode = Automatic;
}

simulated function PlaySelectiveFiring()
{
	Super.PlaySelectiveFiring();
	MuzzleFlashLight(); 
        	if ( (PlayerPawn(Owner) != None)  
	&& (PlayerPawn(Owner).DesiredFOV == PlayerPawn(Owner).DefaultFOV) )
                		bMuzzleFlash++;  
}

simulated function MuzzleFlashLight()
{
	local Vector offset, X, Y, Z;

	if ( Owner == None )
		return;
      
	if ( (flash != None) && !flash.bDeleteMe )
		flash.LifeSpan = flash.Default.LifeSpan;
	else
	{
		GetAxes(Pawn(Owner).ViewRotation,X,Y,Z);
		offset = Owner.Location;
		offset += X * Owner.CollisionRadius * 2;
		flash = spawn(class'MuzzleFlash',,, offset);
		if ( flash != None )
			flash.SetBase(Owner);
	}
}

function DropFrom(vector StartLocation)
{
	if ( !SetLocation(StartLocation) )
	     	return; 
	AmbientSound = None;
	Super.DropFrom(StartLocation);
}

function AltFire(float Value)
{
  	ClientAltFire(Value);
}

simulated function bool ClientAltFire(float Value)
{
  	ScopeToggle();
  	return true;
}

simulated function RefreshScopeDisplay(DeusExPlayer Player, bool bInstant, bool bScopeOn)
{
	local Inventory Inv;

	for ( Inv = Player.Inventory; Inv != None; Inv = Inv.Inventory )
	{
		if ( Inv.IsA('TechGoggles') && Inv.bActive )
			Inv.Activate();
	}

	if ( bScopeOn && (Player != None) )
	{
		bSemiAuto = True;
		bHasNightVision = True;
		FiringMode = SemiAuto;
		PlaySimSound( Misc2Sound, SLOT_None, 0.5, 1024 );
		DeusExRootWindow(Player.RootWindow).HUD.AugDisplay.VisionLevel = 2;
		DeusExRootWindow(Player.RootWindow).HUD.AugDisplay.bVisionActive = True;
		DeusExRootWindow(Player.rootWindow).scopeView.ActivateView(ScopeFOV, False, bInstant);
	}
      	else if ( !bScopeOn )
      	{
		bSemiAuto = False;
		bHasNightVision = False;
		FiringMode = Automatic;
		PlaySimSound( Misc2Sound, SLOT_None, 0.5, 1024 );
           		DeusExrootWindow(Player.rootWindow).scopeView.DeactivateView();
		DeusExRootWindow(Player.RootWindow).hud.augDisplay.visionBlinder = None;
		DeusExRootWindow(Player.RootWindow).HUD.AugDisplay.bVisionActive = False;
      	}
}

state NormalFire
{   
        	function Tick( float DeltaTime )
	{
                		if ( (Owner==None) || Owner.IsInState('Dying') ) 
		AmbientSound = None;
		Global.Tick( DeltaTime );
	}

        	function BeginState()
	{
              		AmbientSound = FireSound;
                		Super.BeginState();
	}	

	function EndState()
	{
                		AmbientSound = None;
                            	PlayEndFire();
              		Super.EndState();
	}
}

simulated state ClientFiring
{
        	simulated function Tick( float DeltaTime )
	{
                		if ( (Owner==None) || Owner.IsInState('Dying') ) 
		AmbientSound = None;
		Global.Tick( DeltaTime );
	}

        	simulated function BeginState()
	{
              		AmbientSound = FireSound;
                		Super.BeginState();
	}	

	simulated function EndState()
	{
                		AmbientSound = None;
                            	PlayEndFire();
              		Super.EndState();
	}
}

simulated function PlayFiringSound()
{
}

simulated function PlayEndFire()
{
	PlaySimSound( Misc3Sound, SLOT_None, TransientSoundVolume, 2048 );
}

function ReloadAmmo()
{
}

simulated function int AmmoLeftInClip()
{
	if ( AmmoType == None )
		return 0;
	else
		return AmmoType.AmmoAmount;
}

simulated function int NumClips()
{
	return 0;
}

function float RateSelf( out int bUseAltMode )
{
	bUseAltMode = 0;

	if ( AmmoType.AmmoAmount <=0 )
		return -2;

        	if ( Region.Zone.bWaterZone )
		return  -2;

	if ( Pawn(Owner).Enemy == None )
		return AIRating;
				
	return AIRating;
}

function bool SplashJump()
{
  	return true;
}

function float SuggestAttackStyle()
{
	local float EnemyDist;

	// recommend backing off if target is too close
	EnemyDist = VSize(Pawn(Owner).Enemy.Location - Owner.Location);
	if ( EnemyDist < 300 )
	{
		if ( EnemyDist < 150 )
			return -1.5;
		else
			return -0.7;
	}
	else
		return -0.2;
}

simulated function bool TestMPBeltSpot(int BeltSpot)
{
   	return (BeltSpot == 9);
}

defaultproperties
{
     GoverningSkill=Class'DeusEx.SkillWeaponHeavy'
     NoiseLevel=2.000000
     EnviroEffective=ENVEFF_Air
     ShotTime=0.125000
     TimeBetweenFire=0.050000
     FiringMode="AUTOMATIC"
     bTournamentWeapon=True
     reloadTime=3.000000
     HitDamage=50
     maxRange=24000
     AccurateRange=14400
     BaseAccuracy=0.600000
     bCanHaveScope=True
     bHasScope=True
     ScopeFOV=20
     bCanHaveLaser=True
     bHasMuzzleFlash=False
     recoilStrength=1.000000
     mpReloadTime=2.000000
     mpHitDamage=50
     mpBaseAccuracy=0.500000
     mpAccurateRange=14400
     mpMaxRange=24000
     mpReloadCount=255
     bCanHaveModBaseAccuracy=True
     bCanHaveModRecoilStrength=True
     msgInfoSingle="AUTOMATIC"
     AmmoName=Class'DeusEx.AmmoLAW'
     ReloadCount=255
     PickupAmmoCount=25
     bWarnTarget=True
     bSplashDamage=True
     bRecommendSplashDamage=True
     bRapidFire=True
     FireOffset=(X=28.000000,Y=12.000000,Z=4.000000)
     ProjectileClass=Class'DeusEx.RocketMicro'
     shakemag=500.000000
     AIRating=0.790000
     RefireRate=0.950000
     FireSound=Sound'DeusEx.Weapons.MachineGunFire'
     AltFireSound=Sound'DeusEx.Weapons.MachineGunFire'
     SelectSound=Sound'DeusExSounds.Weapons.LAWSelect'
     Misc2Sound=Sound'DeusExSounds.Special.Switch1Click'
     Misc3Sound=Sound'DeusEx.Weapons.EndFire1'
     bDrawMuzzleFlash=True
     MuzzleScale=1.200000
     FlashY=-0.070000
     FlashO=-0.011000
     FlashC=1.000000
     FlashLength=0.020000
     MFTexture=Texture'DeusEx.Skins.Muzzleflash02'
     InventoryGroup=21
     ItemName="Rocket Machinegun (RMG)"
     PlayerViewOffset=(X=18.000000,Y=-18.000000,Z=-7.000000)
     PlayerViewMesh=LodMesh'DeusExItems.LAW'
     PickupViewMesh=LodMesh'DeusExItems.LAWPickup'
     ThirdPersonMesh=LodMesh'DeusExItems.LAW3rd'
     LandSound=Sound'DeusExSounds.Generic.DropLargeWeapon'
     Icon=Texture'DeusExUI.Icons.BeltIconLAW'
     largeIcon=Texture'DeusExUI.Icons.LargeIconLAW'
     largeIconWidth=166
     largeIconHeight=47
     invSlotsX=4
     Description="The RMG (Rocket Machinegun) provides cheap, dependable anti-armor capability in the form of a rapid rocket-fire and delivery system, though at the expense of any laser guidance. Like other heavy weapons, the RMG can slow agents who have not trained with it extensively."
     beltDescription="RMG"
     Mesh=LodMesh'DeusExItems.LAWPickup'
     SoundRadius=96
     SoundVolume=255
     CollisionRadius=25.000000
     CollisionHeight=6.800000
     Mass=50.000000
}
