//=============================================================================
// WeaponMiniCrossbow.
//=============================================================================
class WeaponMiniCrossbow extends DeusExWeapon;

simulated function PreBeginPlay()
{
	Super.PreBeginPlay();

	if ( ((Level.Game != None) && Level.Game.bDeathMatch) || (Level.NetMode != NM_Standalone) )
	{
                		HitDamage = mpHitDamage;
		BaseAccuracy = mpBaseAccuracy;
		ReloadTime = mpReloadTime;
		AccurateRange = mpAccurateRange;
		MaxRange = mpMaxRange;
		ReloadCount = mpReloadCount;
		TimeBetweenFire = 0.050000;
		FireRate = 3.000000;
		bSemiAuto = False;
                		PickupAmmoCount = 20;
                		bHasScope = True;  
                		bHasSilencer = False;
		bRapidFire = False;
                		PickupViewScale = 2.0;
                		InventoryGroup = 3;
	}
}

state NormalFire
{
	function BeginState()
	{
		if (ClipCount >= ReloadCount)
			MultiSkins[3] = Texture'PinkMaskTex';

		if ((AmmoType != None) && (AmmoType.AmmoAmount <= 0))
			MultiSkins[3] = Texture'PinkMaskTex';
	
		Super.BeginState();
	}
}


function Tick(float deltaTime)
{
	if (MultiSkins[3] != None)
		if ((AmmoType != None) && (AmmoType.AmmoAmount > 0) && (ClipCount < ReloadCount))
			MultiSkins[3] = None;

	Super.Tick(deltaTime);
}

function AltFire(float Value)
{
        	ClientAltFire(Value);
}

simulated function bool ClientAltFire(float Value)
{
        	ScopeToggle();
        	return true;
}

function float RateSelf( out int bUseAltMode )
{
	        
	if ( (AmmoType != None) && (AmmoType.AmmoAmount <=0) )
		return -2;

        	if ( Region.Zone.bWaterZone )
		return 2;

        	bUseAltMode = 0;

	return (AIRating + FRand() * 0.05);
}

function float SuggestAttackStyle()
{
	return 0.1;
}

function float SuggestDefenseStyle()
{
	return -0.2;
}

simulated function bool TestMPBeltSpot(int BeltSpot)
{
   	return (BeltSpot == 3);
}

defaultproperties
{
     LowAmmoWaterMark=12
     GoverningSkill=Class'DeusEx.SkillWeaponPistol'
     NoiseLevel=0.050000
     EnemyEffective=ENMEFF_Organic
     Concealability=CONC_All
     bSemiAuto=True
     ShotTime=0.125000
     ReloadSound=Sound'DeusExSounds.Weapons.MiniCrossbowReloadEnd'
     SilencedSound=Sound'DeusExSounds.Weapons.MiniCrossbowFire'
     TimeBetweenFire=0.050000
     FiringMode="PNEUMATIC"
     bTournamentWeapon=True
     reloadTime=2.000000
     HitDamage=25
     BaseAccuracy=0.800000
     bCanHaveScope=True
     ScopeFOV=20
     bCanHaveLaser=True
     bHasSilencer=True
     AmmoNames(0)=Class'DeusEx.AmmoDartPoison'
     AmmoNames(1)=Class'DeusEx.AmmoDart'
     AmmoNames(2)=Class'DeusEx.AmmoDartFlare'
     ProjectileNames(0)=Class'DeusEx.DartPoison'
     ProjectileNames(1)=Class'DeusEx.Dart'
     ProjectileNames(2)=Class'DeusEx.DartFlare'
     StunDuration=10.000000
     bHasMuzzleFlash=False
     mpReloadTime=0.500000
     mpHitDamage=30
     mpBaseAccuracy=0.100000
     mpAccurateRange=4800
     mpMaxRange=9600
     mpReloadCount=20
     mpPickupAmmoCount=20
     bCanHaveModBaseAccuracy=True
     bCanHaveModAccurateRange=True
     bCanHaveModReloadTime=True
     msgInfoSingle="PNEUMATIC, SINGLE"
     AmmoName=Class'DeusEx.AmmoDartPoison'
     ReloadCount=12
     PickupAmmoCount=12
     bRapidFire=True
     FireOffset=(X=-25.000000,Y=8.000000,Z=14.000000)
     ProjectileClass=Class'DeusEx.DartPoison'
     shakemag=30.000000
     AIRating=0.500000
     RefireRate=1.000000
     AltRefireRate=0.850000
     FireSound=Sound'DeusExSounds.Weapons.MiniCrossbowFire'
     AltFireSound=Sound'DeusExSounds.Weapons.MiniCrossbowFire'
     CockingSound=Sound'DeusExSounds.Weapons.MiniCrossbowReload'
     SelectSound=Sound'DeusExSounds.Weapons.MiniCrossbowSelect'
     Misc1Sound=Sound'DeusExSounds.Generic.DryFire'
     Misc2Sound=Sound'DeusExSounds.Special.Switch1Click'
     AutoSwitchPriority=4
     InventoryGroup=10
     ItemName="Mini-Crossbow"
     PlayerViewOffset=(X=25.000000,Y=-8.000000,Z=-14.000000)
     PlayerViewMesh=LodMesh'DeusExItems.MiniCrossbow'
     PickupViewMesh=LodMesh'DeusExItems.MiniCrossbowPickup'
     ThirdPersonMesh=LodMesh'DeusExItems.MiniCrossbow3rd'
     Icon=Texture'DeusExUI.Icons.BeltIconCrossbow'
     largeIcon=Texture'DeusExUI.Icons.LargeIconCrossbow'
     largeIconWidth=47
     largeIconHeight=46
     Description="The mini-crossbow was specifically developed for espionage work, and accepts a range of dart types (normal, tranquilizer, or gas) that can be changed depending upon the mission requirements."
     beltDescription="CROSSBOW"
     Mesh=LodMesh'DeusExItems.MiniCrossbowPickup'
     CollisionRadius=8.000000
     CollisionHeight=3.000000
     Mass=15.000000
}
