//=============================================================================
// WeaponNanoKeyRing
//=============================================================================
class WeaponNanoKeyRing extends DeusExWeapon;

var localized String StrLocked;
var localized String StrUnlocked;
var localized String StrPicked;
var localized String StrAlreadyUnlock;
var localized String StrBypassed;
var localized String StrAlreadyBypassed;
var localized String StrDogPatrol;
var localized String StrDogSupport;

function name WeaponDamageType()
{
	return 'KnockedOut';
}

function bool HasKey(Name KeyToLookFor)
{
	local DeusExPlayer P;
 
        	P = DeusExPlayer(Owner);
        	if ((P != None) && (P.KeyRing != None))
             		return P.KeyRing.HasKey(KeyToLookFor);
        	else
             		return false;
}

function bool CanHack()
{
        	local Inventory tool;
        	local DeusExPlayer player;

        	player = DeusExPlayer(Owner);
   
        	tool = player.FindInventoryType(Class'Multitool');
        	if (tool != None)
        	{
               		Multitool(tool).numCopies--;
               		if (Multitool(tool).NumCopies <= 0)
                    		player.DeleteInventory(tool);
               		return true;
        	}
        	else
               		return false;
}

function bool CanPick()
{
        	local Inventory pick;
        	local DeusExPlayer player;

      	player = DeusExPlayer(Owner);
   
        	pick = player.FindInventoryType(Class'Lockpick');
        	if (pick != None)
        	{
               		Lockpick(pick).numCopies--;
               		if (Lockpick(pick).NumCopies <= 0)
                       		player.DeleteInventory(pick);
               		return true;
        	}
        	else
               		return false;
}

simulated function TraceFire( Float Accuracy )
{
	local DeusExPlayer P;
        	local Actor Other, Target;
        	local DeusExMover dxm, M;
        	local HackableDevices device;
	local CyborgDog Dog;
	local vector HitLocation, HitNormal, StartTrace, EndTrace, X,Y,Z;
	
        	P = DeusExPlayer(Owner);        

        	if (P != None)
        	{
               		Other = P.FrobTarget;

	       	if (Other != None)
	       	{
			dxm = DeusExMover(Other);
                      		device = HackableDevices(Other);
			Dog = CyborgDog(Other);
                    		if (dxm != None)
                      		{
                                 		if ((dxm.KeyIDNeeded != '') && (dxm.lockStrength > 0.0) && HasKey(dxm.KeyIDNeeded))
                                 		{
		                          		dxm.bLocked = !dxm.bLocked;
                                          			dxm.TimeSinceReset = 0;
                                          			if ((dxm.Tag != '') && (dxm.Tag != 'DeusExMover'))
                                          			{
				               		foreach AllActors(class'DeusExMover', M, dxm.Tag)
                                               				{
					            		if ((M != None) && (M != dxm))
					            		{
						         		M.bLocked = !M.bLocked;
						         		M.TimeSinceReset = 0;
					            		}
                                                			}
                                          			}
                                          			if (dxm.bLocked)
					        	P.ClientMessage(StrLocked);
				          	else
					        	P.ClientMessage(StrUnlocked);
                                  		}
                                  		else if (dxm.bPickable && ((dxm.KeyIDNeeded == '') || ((dxm.KeyIDNeeded != '') && !HasKey(dxm.KeyIDNeeded))))
			          	{
                                          			if (dxm.bLocked)
				          	{
                                                 			if (CanPick())
                                                 			{
                                                      				dxm.lockStrength -= 0.2;
                                                      				P.MakeNoise(0.1);
                                                      				AIStartEvent('MegaFutz', EAITYPE_Visual);
                                                      				if ((dxm.lockStrength <= 0.0) || (dxm.lockStrength ~= 0.0))
		                                      			{
			                                    			dxm.lockStrength = 0.0;
			                                    			dxm.bLocked = False;
                                                            					dxm.TimeSinceReset = 0;
                                                            					if ((dxm.Tag != '') && (dxm.Tag != 'DeusExMover'))
                                                            					{
				                                 			foreach AllActors(class'DeusExMover', M, dxm.Tag)
                                                                 					{ 
					                               				if ((M != None) && (M != dxm))
					                               				{
						                            				M.bLocked = False;
						                            				M.TimeSinceReset = 0;
						                            				M.lockStrength = 0.0;
					                               				}
                                                                 					} 
                                                            					}
                                                            					P.ClientMessage(StrPicked);
                                                        				}
                                                   			} 
                                            			} 
                                            			else
                                                   			P.ClientMessage(StrAlreadyUnlock);  
                                   		}     
	                	}

                        		else if (device != None)
	                	{
		                 	if (device.bHackable)
		                   	{
			                    	if (device.hackStrength > 0)
			                    	{
                                                    			if (CanHack())
                                                    			{	
                                                           				P.MakeNoise(0.1);
                                                           				AIStartEvent('MegaFutz', EAITYPE_Visual);
				                           		device.hackStrength -= 0.2;
                                                           				if ((device.hackStrength <= 0.0) || (device.hackStrength ~= 0.0))
                                             		   			{
			                                         			device.hackStrength = 0.0;
			                                         			P.ClientMessage(StrBypassed);
                                                                 				device.TimeSinceReset = 0;
				                                 		device.HackAction(P, true);
                                                                 				if (device.IsA('ControlPanel'))
                                                                         				device.PlayAnim('Open');
                                                           				}
                                                     			}
			                    	}
                                            			else
                                                     			P.ClientMessage(StrAlreadyBypassed);      
		                    	}
	                 	}
			
			else if ( Dog != None )
			{
				SwitchDogOrders(Dog);
			}
               		}

		else
		{
			GetAxes(P.ViewRotation,X,Y,Z);
			StartTrace = Owner.Location + CalcDrawOffset() + FireOffset.X * X + FireOffset.Y * Y + FireOffset.Z * Z; 
			AdjustedAim = P.AdjustAim(1000000, StartTrace, 100, False, False);	
			EndTrace = StartTrace + Accuracy * (FRand() - 0.5 )* Y * 1000
			+ Accuracy * (FRand() - 0.5 ) * Z * 1000;
			X = vector(AdjustedAim);
			EndTrace += (14400 * X); 
			Target = P.TraceShot(HitLocation,HitNormal,EndTrace,StartTrace);
			ProcessTraceHit(Target, HitLocation, HitNormal, X,Y,Z);
		}
        	}                                                  
}

simulated function ProcessTraceHit(Actor Other, Vector HitLocation, Vector HitNormal, Vector X, Vector Y, Vector Z)
{
	if ( Other != None )
	{	
		if ( (Other != self) && (Other != Owner) )
		{
		     	if ( Role == ROLE_Authority )
			{
				if ( Other.IsA('CyborgDog') )
					SwitchDogOrders(CyborgDog(Other));
			}
                	}
	}
}

simulated function SwitchDogOrders(CyborgDog Dog)
{
	if ( Dog == None )
		return;

	if ( Dog.IsInState('Following') )
	{
		Dog.SetOrders('Wandering', '', True);
		Pawn(Owner).ClientMessage(StrDogPatrol);
		PlaySound(Sound'Beep3');
		return;
	}
	if ( Dog.IsInState('Wandering') )
	{
		Dog.SetOrders('Following', '', True);
		Pawn(Owner).ClientMessage(StrDogSupport);
		PlaySound(Sound'Beep3');
	}
}

function ReloadAmmo()
{
}

state NormalFire
{
Begin:
	Sleep(GetShotTime());
	bFiring = False;
        	FinishAnim();
        	LoopAnim('UseLoop',, 0.1);
        	FinishAnim();
        	PlayAnim('UseEnd',, 0.1);
	FinishAnim();
	ReadyToFire();
Done:
	bFiring = False;
        	Finish();
}

simulated state ClientFiring
{
Begin:
	Sleep(GetSimShotTime());
	bFiring = False;
        	FinishAnim();
        	LoopAnim('UseLoop',, 0.1);
        	FinishAnim();
        	PlayAnim('UseEnd',, 0.1);
	FinishAnim();
	bInProcess = False;
        	if ( (Owner != None) && !Owner.IsA('DeusExPlayer') )
              		ReadyClientToFire( True );
Done:
	bInProcess = False;
	bFiring = False;
        	SimFinish();
}
     
state AltFiring
{
Begin:
       	Sleep(GetAltShotTime());
	bFiring = False;
        	FinishAnim();
        	PlayAnim('UseEnd',, 0.1);
	FinishAnim();
	ReadyToFire();
Done:
	bFiring = False;
        	Finish();
}

simulated state ClientAltFiring
{
Begin:
	Sleep(GetSimAltShotTime());
	bFiring = False;
        	FinishAnim();
        	PlayAnim('UseEnd',, 0.1);
	FinishAnim();
	bInProcess = False;
        	if ( (Owner != None) && !Owner.IsA('DeusExPlayer') )
              		ReadyClientToFire( True );
Done:
	bInProcess = False;
	bFiring = False;
        	SimFinish();
}   

state Idle
{
        	function BeginState()
        	{
                	Super.BeginState();
                	AIEndEvent('MegaFutz', EAITYPE_Visual);
        	}
}

function Finish()
{
	if ( Level.NetMode != NM_Standalone )
		ReadyClientToFire( True );
	
	if ( bChangeWeapon )
	{
		GotoState('DownWeapon');
		return;
	}

	if (( Level.NetMode != NM_Standalone ) && IsInState('Active'))
	{
		GotoState('Idle');
		return;
	}

	if (Pawn(Owner) == None)
	{
		GotoState('Idle');
		return;
	}
	if ( PlayerPawn(Owner) == None )
	{
		if ((Pawn(Owner).bFire != 0) && !bSemiAuto && (FRand() < RefireRate) )
			Global.Fire(0);
		else if ((Pawn(Owner).bAltFire != 0) && !bAltSemiAuto && (FRand() < AltRefireRate) )
			Global.AltFire(0);	
		else 
		{
			Pawn(Owner).StopFiring();
			GotoState('Idle');
		}
		return;
	}

	if (( Level.NetMode == NM_DedicatedServer ) || ((Level.NetMode == NM_ListenServer) && Owner.IsA('DeusExPlayer') && !DeusExPlayer(Owner).PlayerIsListenClient()))
	{
		GotoState('Idle');
		return;
	}

	if (!bSemiAuto && (Pawn(Owner).bFire!=0))
		Global.Fire(0);
	else if (!bAltSemiAuto && (Pawn(Owner).bAltFire!=0))
		Global.AltFire(0);
	else 
		GotoState('Idle');
}

function bool PutDown()
{
	AIEndEvent('MegaFutz', EAITYPE_Visual);
	return Super.PutDown();
}

function float SuggestAttackStyle()
{
	return 10.0;
}

function float SuggestDefenseStyle()
{
	return -2.0;
}

function float RateSelf( out int bUseAltMode )
{       
        	bUseAltMode = 1;     	
	return ( AIRating + FRand() * 0.05 );
}

defaultproperties
{
     StrLocked="Your NanoKey Ring locked it"
     StrUnlocked="Your NanoKey Ring unlocked it"
     StrPicked="You picked the lock"
     StrAlreadyUnlock="It's already unlocked"
     StrBypassed="You bypassed the device"
     StrAlreadyBypassed="It's already bypassed"
     StrDogPatrol="Cyborg Dog orders: Patroling"
     StrDogSupport="Cyborg Dog orders: Supporting"
     GoverningSkill=Class'DeusEx.SkillWeaponLowTech'
     NoiseLevel=0.000000
     EnemyEffective=ENMEFF_Organic
     Concealability=CONC_Visual
     bAltSemiAuto=False
     ShotTime=0.200000
     AltShotTime=0.500000
     FireAnim=UseBegin
     AltFireAnim=UseBegin
     AltFireRate=2.000000
     TimeBetweenAltFire=0.010000
     AmmoPerFire=0
     AmmoPerAltFire=0
     FiringMode="KEY RING"
     HitDamage=25
     maxRange=120
     AccurateRange=120
     BaseAccuracy=0.000000
     bPenetrating=False
     bHasMuzzleFlash=False
     bFallbackWeapon=True
     bEmitWeaponDrawn=False
     bUseAsDrawnWeapon=False
     AmmoName=Class'DeusEx.AmmoNone'
     ReloadCount=0
     bInstantHit=True
     bAltInstantHit=True
     bCanThrow=False
     bMeleeWeapon=True
     FireOffset=(X=-16.000000,Y=12.000000,Z=16.000000)
     shakemag=0.000000
     shaketime=0.000000
     shakevert=0.000000
     FireSound=Sound'DeusExSounds.Generic.KeysRattling'
     AltFireSound=Sound'DeusExSounds.Generic.BulletProofHit'
     SelectSound=Sound'DeusExSounds.Weapons.HideAGunSelect'
     InventoryGroup=0
     bDisplayableInv=False
     ItemName="Nanokey Ring"
     ItemArticle="the"
     PlayerViewOffset=(X=16.000000,Y=-12.000000,Z=-16.000000)
     PlayerViewMesh=LodMesh'DeusExItems.NanoKeyRingPOV'
     PickupViewMesh=LodMesh'DeusExItems.NanoKeyRing'
     ThirdPersonMesh=LodMesh'DeusExItems.NanoKeyRing'
     Icon=Texture'DeusExUI.Icons.BeltIconNanoKeyRing'
     largeIcon=Texture'DeusExUI.Icons.LargeIconNanoKeyRing'
     largeIconWidth=47
     largeIconHeight=44
     Description="A nanokey ring can read and store the two-dimensional molecular patterns from different nanokeys, and then recreate those patterns on demand. The nanokey ring also use the command frequencies used by CD-01 cyborg dogs by switching the dog's supporting mode."
     beltDescription="KEY RING"
     Mesh=LodMesh'DeusExItems.NanoKeyRing'
     CollisionRadius=5.510000
     CollisionHeight=4.690000
}
