//=============================================================================
// WeaponNanoVirusGrenade.
//=============================================================================
class WeaponNanoVirusGrenade extends DeusExWeapon;

var bool bSpider;

event TravelPostAccept()
{
	Super.TravelPostAccept();
	if ( FiringMode ~= AltGrenade )
		FiringMode = Grenade;
}

function Fire(float Value)
{
	// if facing a wall, affix the NanoVirusGrenade to the wall
	if (Pawn(Owner) != None)
	{
		if (bNearWall)
		{
			bReadyToFire = False;
			GotoState('NormalFire');
			bPointing = True;
			PlayAnim('Place',, 0.1);
			return;
		}
	}

	// otherwise, throw as usual
	Super.Fire(Value);
}

function Projectile ProjectileFire(class<projectile> ProjClass, float ProjSpeed, bool bWarn)
{
	local Projectile proj;

	proj = Super.ProjectileFire(ProjClass, ProjSpeed, bWarn);

	if (proj != None)
		proj.PlayAnim('Open');
}

simulated function bool ClientAltFire(float Value)
{
	if ( bSpider )
	{
		bSpider = False;
		FiringMode = Grenade;
		ProjectileClass = Default.ProjectileClass;
		PlayFiringAltSound();
       		return False; 
	}
	bSpider = True; 
	FiringMode = AltGrenade;
	ProjectileClass = AltProjectileClass;
	PlayFiringAltSound();
	return True;
}

function AltFire(float Value)
{
	ClientAltFire(Value);
}

function Projectile ProjectileAltFire(class<projectile> ProjClass, float ProjSpeed, bool bWarn)
{
}

function bool HandlePickupQuery( inventory Item )
{
        	local DeusExPlayer P;

        	if ( (Item.Class == Class) && (AmmoType.AmmoAmount >= AmmoType.MaxAmmo) )
	{
             		P = DeusExPlayer(Owner);
             		if (P != None)
                 		P.ClientMessage(P.TooMuchAmmo);
	     	return true;
        	}
        	return Super.HandlePickupQuery(Item);
}

function ReloadAmmo()
{
	ClipCount = 0;
}

defaultproperties
{
     LowAmmoWaterMark=2
     GoverningSkill=Class'DeusEx.SkillDemolition'
     EnemyEffective=ENMEFF_Robot
     Concealability=CONC_All
     ShotTime=0.300000
     AltFireAnim=Down
     FiringMode="SCRAMBLE"
     Grenade="SCRAMBLE"
     AltGrenade="SPIDER"
     reloadTime=0.100000
     HitDamage=0
     maxRange=4800
     AccurateRange=2400
     BaseAccuracy=1.000000
     bPenetrating=False
     bHasMuzzleFlash=False
     bHandToHand=True
     bUseAsDrawnWeapon=False
     AITimeLimit=3.500000
     AIFireDelay=5.000000
     AmmoName=Class'DeusEx.AmmoNanoVirusGrenade'
     ReloadCount=1
     PickupAmmoCount=1
     FireOffset=(Y=10.000000,Z=20.000000)
     ProjectileClass=Class'DeusEx.NanoVirusGrenade'
     AltProjectileClass=Class'DeusEx.SpiderGrenade'
     shakemag=50.000000
     AltFireSound=Sound'DeusExSounds.Generic.DryFire'
     SelectSound=Sound'DeusExSounds.Weapons.NanoVirusGrenadeSelect'
     InventoryGroup=24
     ItemName="Scramble Grenade"
     PlayerViewOffset=(X=24.000000,Y=-15.000000,Z=-19.000000)
     PlayerViewMesh=LodMesh'DeusExItems.NanoVirusGrenade'
     PickupViewMesh=LodMesh'DeusExItems.NanoVirusGrenadePickup'
     ThirdPersonMesh=LodMesh'DeusExItems.NanoVirusGrenade3rd'
     Icon=Texture'DeusExUI.Icons.BeltIconWeaponNanoVirus'
     largeIcon=Texture'DeusExUI.Icons.LargeIconWeaponNanoVirus'
     largeIconWidth=24
     largeIconHeight=49
     Description="The detonation of a GUARDIAN scramble grenade broadcasts a short-range, polymorphic broadband assault on the command frequencies used by almost all bots manufactured since 2028. The ensuing electronic storm causes bots within its radius of effect to indiscriminately attack other bots until command control can be re-established. Like a LAM, scramble grenades can be attached to any surface. Switching the firing mod results the scramble grenade explosion release a friendly Mini-SpiderBot."
     beltDescription="SCRM GREN"
     Mesh=LodMesh'DeusExItems.NanoVirusGrenadePickup'
     CollisionRadius=3.000000
     CollisionHeight=2.430000
     Mass=5.000000
     Buoyancy=2.000000
}
