//=============================================================================
// WeaponPepperGun. DX style Bio Rifle!
//=============================================================================
class WeaponPepperGun extends DeusExWeapon;

simulated function PreBeginPlay()
{
	Super.PreBeginPlay();

	if ( ((Level.Game != None) && Level.Game.bDeathMatch) || (Level.NetMode != NM_Standalone) )
	{
		HitDamage = mpHitDamage;
		BaseAccuracy = mpBaseAccuracy;
		ReloadCount = mpReloadCount;
		ReloadTime = mpReloadTime;
		AccurateRange = mpAccurateRange;
		MaxRange = mpMaxRange;
		PickupAmmoCount = 50;
                		NoiseLevel = 1.000000;
                		PickupViewScale = 2.0;
                		InventoryGroup = 2;
	}
}

simulated function PlaySelectiveFiring()
{
	Super.PlaySelectiveFiring();
        	if ((PlayerPawn(Owner) != None)  
	   && (PlayerPawn(Owner).DesiredFOV == PlayerPawn(Owner).DefaultFOV) )
               		bMuzzleFlash++;   
}

function float RateSelf( out int bUseAltMode )
{
	local float EnemyDist;
	local bool bRetreating;
	local vector EnemyDir;
        
	if ( AmmoType.AmmoAmount <=0 )
		return -2;
	
	if ( Pawn(Owner).Enemy == None )
		return AIRating;

	EnemyDir = Pawn(Owner).Enemy.Location - Owner.Location;
	EnemyDist = VSize(EnemyDir);
        
	if ( EnemyDist > 480 )
		return 0;

	bRetreating = (((EnemyDir/EnemyDist) Dot Owner.Velocity) < -0.6 );
	if ( (EnemyDist > 200) && (EnemyDir.Z > -0.4 * EnemyDist) )
	{
		// only use if enemy not too far and retreating
		if ( !bRetreating )
			return 0;

		return AIRating;
	}

	bUseAltMode = int( 200 > EnemyDist );

	if ( bRetreating || (EnemyDir.Z < -0.7 * EnemyDist) )
		return (AIRating + 0.18);
	return AIRating;
}

function float SuggestAttackStyle()
{
	return -0.3;
}

function float SuggestDefenseStyle()
{
	return -0.4;
}

simulated function bool TestMPBeltSpot(int BeltSpot)
{
   	return (BeltSpot == 2);
}

defaultproperties
{
     LowAmmoWaterMark=5
     GoverningSkill=Class'DeusEx.SkillWeaponPistol'
     NoiseLevel=0.250000
     EnemyEffective=ENMEFF_Organic
     Concealability=CONC_Visual
     bAutomatic=True
     bAltAutomatic=True
     bAltSemiAuto=False
     AltShotTime=0.100000
     ReloadSound=Sound'DeusExSounds.Weapons.PepperGunReloadEnd'
     FireAnim=Idle3
     fireRate=15.000000
     TimeBetweenFire=0.010000
     FiringMode="BIOMATIC"
     bTournamentWeapon=True
     reloadTime=2.000000
     HitDamage=15
     maxRange=1280
     AccurateRange=640
     BaseAccuracy=0.600000
     bPenetrating=False
     StunDuration=15.000000
     bHasMuzzleFlash=False
     mpReloadTime=0.500000
     mpBaseAccuracy=0.500000
     mpAccurateRange=640
     mpMaxRange=1280
     mpReloadCount=50
     mpPickupAmmoCount=50
     msgInfoAuto="BIOMATIC"
     AmmoName=Class'DeusEx.AmmoPepper'
     ReloadCount=25
     PickupAmmoCount=25
     FireOffset=(X=8.000000,Y=4.000000,Z=14.000000)
     ProjectileClass=Class'DeusEx.BioProj'
     AltProjectileClass=Class'DeusEx.TearGas'
     shakemag=10.000000
     AIRating=0.600000
     RefireRate=0.990000
     AltRefireRate=0.990000
     FireSound=Sound'DeusEx.Weapons.BioFire'
     AltFireSound=Sound'DeusExSounds.Weapons.PepperGunFire'
     CockingSound=Sound'DeusExSounds.Weapons.PepperGunReload'
     SelectSound=Sound'DeusExSounds.Weapons.PepperGunSelect'
     Misc1Sound=Sound'DeusExSounds.Weapons.PepperGunReloadEnd'
     bDrawMuzzleFlash=True
     MuzzleScale=1.500000
     FlashY=0.040000
     FlashO=-0.012000
     FlashC=0.100000
     FlashLength=0.050000
     MFTexture=Texture'DeusEx.Skins.BioMuzzle'
     AutoSwitchPriority=3
     InventoryGroup=11
     ItemName="Bio Pistol"
     PlayerViewOffset=(X=16.000000,Y=-10.000000,Z=-16.000000)
     PlayerViewMesh=LodMesh'DeusExItems.PepperGun'
     PickupViewMesh=LodMesh'DeusExItems.PepperGunPickup'
     ThirdPersonMesh=LodMesh'DeusExItems.PepperGun3rd'
     Icon=Texture'DeusExUI.Icons.BeltIconPepperSpray'
     largeIcon=Texture'DeusExUI.Icons.LargeIconPepperSpray'
     largeIconWidth=46
     largeIconHeight=40
     Description="The bio gun provides rapid-fire wide-area coverage in primary firing mode, and a spray-fire secondary firing mode. In layman's terms, this equates to being able to pepper an area with small globs of Biosludge, or spray a toxic tear gas at the target."
     beltDescription="BIOGUN"
     Mesh=LodMesh'DeusExItems.PepperGunPickup'
     CollisionRadius=7.000000
     CollisionHeight=3.000000
     Mass=7.000000
     Buoyancy=2.000000
}
