//=============================================================================
// WeaponPistol.
//=============================================================================
class WeaponPistol extends DeusExWeapon;

var WeaponPistol SlavePistol;		
var bool bIsSlave;
var bool bSetup;				
var bool bFirstFire, bBringingUp;
var int DoubleSwitchPriority;

replication
{
	reliable if ( Role == ROLE_Authority )
		SlavePistol, bIsSlave, bBringingUp, bFirstFire;
}

simulated function PreBeginPlay()
{
	Super.PreBeginPlay();

	if ( ((Level.Game != None) && Level.Game.bDeathMatch) || (Level.NetMode != NM_Standalone) )
	{
		HitDamage = mpHitDamage;
		BaseAccuracy = mpBaseAccuracy;
		ReloadTime = mpReloadTime;
		AccurateRange = mpAccurateRange;
		MaxRange = mpMaxRange;
		ReloadCount = mpReloadCount;
               		PickupAmmoCount = 60;
		InventoryGroup = 1;
	          	return;
	}
       	if ( Level.Game.Difficulty == 3 ) 
	{
        		ReloadTime = mpReloadTime;
		HitDamage = 25;
	}
}

event TravelPostAccept()
{
	Super.TravelPostAccept();
	if ( FiringMode ~= Automatic)
		FiringMode = SemiAuto;
}

simulated event RenderOverlays(canvas Canvas)
{
	local PlayerPawn PlayerOwner;
	local int realhand;

	PlayerOwner = PlayerPawn(Owner);
	if ( PlayerOwner != None )
	{
		if ( PlayerOwner.DesiredFOV != PlayerOwner.DefaultFOV )
			return;
		realhand = PlayerOwner.Handedness;
		if (  (Level.NetMode == NM_Client) && (realHand == 2) )
		{
			bHideWeapon = true;
			return;
		}
		if ( !bHideWeapon )
		{
			if ( Mesh == mesh'GlockL' )
				PlayerOwner.Handedness = 1;
			else if ( bIsSlave || (SlavePistol != None) )
				PlayerOwner.Handedness = -1;
		}
	}
	if ( (PlayerOwner == None) || (PlayerOwner.Handedness == 0) )
	{
		FlashO = 1.9 * Default.FlashO;
		FlashY = Default.FlashY;
	}
	else
	{
		FlashO = Default.FlashO;
		FlashY = Default.FlashY;
	}
	if ( !bHideWeapon && ( (SlavePistol != None) || bIsSlave ) )
	{
		if ( PlayerOwner == None )
			bMuzzleFlash = 0;

		Super.RenderOverlays(Canvas);
		if ( SlavePistol != None )
		{
			if ( SlavePistol.bBringingUp )
			{
				SlavePistol.bBringingUp = false;
				SlavePistol.PlaySelect();
			}
			SlavePistol.RenderOverlays(Canvas);
		}
	}
	else
		Super.RenderOverlays(Canvas);

	if ( PlayerOwner != None )
		PlayerOwner.Handedness = realhand;
}

function AltFire(float Value)
{
        	local Pawn P;
	local Inventory Copy;

        	if ( ((Level.Game != None) && Level.Game.bDeathMatch) || (Level.NetMode != NM_Standalone) )
                		return;
            			
        	if ( SlavePistol == None )
        	{
      		P = Pawn(Owner);
                		Copy = Spawn(class, P);
		Copy.BecomeItem();
		SlavePistol = WeaponPistol(Copy);
	                	SetTwoHands();
		SlavePistol.SetUpSlave( Pawn(Owner).Weapon == self );
		SlavePistol.SetDisplayProperties(Style, Texture, bUnlit, bMeshEnviromap);
		SetTwoHands();
		FiringMode = Automatic;
		return;
        	}    
        	GotoState('DownSlave');
	FiringMode = SemiAuto; 
}

simulated function bool ClientAltFire(float Value)
{
        	return False;     
}

function GiveAmmo( Pawn Other )
{
	if ( AmmoName == None )
		return;
	AmmoType = Ammo(Other.FindInventoryType(AmmoName));
	if ( AmmoType != None )
        	{
                		if ( bIsSlave )
			AmmoType.AddAmmo(0);
                		else
                     		AmmoType.AddAmmo(PickUpAmmoCount);
        	}
	else
	{
		AmmoType = Spawn(AmmoName);		
		Other.AddInventory(AmmoType);		
		AmmoType.BecomeItem();
               		if ( bIsSlave )
		      	 AmmoType.AmmoAmount = 0; 
                		else
                       		AmmoType.AmmoAmount = PickUpAmmoCount; 
		AmmoType.GotoState('Idle2');
	}
}	

function ReloadAmmo()
{
        	Super.ReloadAmmo();
        	if ( SlavePistol != None )
		SlavePistol.ReloadAmmo(); 
        	bFirstFire = True;
}

function bool WeaponSet(Pawn Other)
{
	if ( bIsSlave )
		return false;
	else
		Super.WeaponSet(Other);
}

function SetSwitchPriority(pawn Other)
{
	local int i;
	local name temp, carried;

	if ( PlayerPawn(Other) != None )
	{
		Super.SetSwitchPriority(Other);

		for ( i=0; i<20; i++)
		{
			if ( PlayerPawn(Other).WeaponPriority[i] == 'doubleenforcer' )
			{
				DoubleSwitchPriority = i;
				return;
			}
		}
	}		
}

function float SwitchPriority() 
{
	local float temp;
	local int bTemp;

	if ( bIsSlave )
		return -10;
	if ( !Owner.IsA('PlayerPawn') )
		return RateSelf(bTemp);
	else if ( (AmmoType != None) && (AmmoType.AmmoAmount<=0) )
	{
		if ( Pawn(Owner).Weapon == self )
			return -0.5;
		else
			return -1;
	}
	else if ( SlavePistol != None )
		return DoubleSwitchPriority;
	else
		return AutoSwitchPriority;
}

function DropFrom(vector StartLocation)
{
	if ( !SetLocation(StartLocation) )
		return; 
	if ( SlavePistol != None )
		SlavePistol.Destroy();
	AIRating = Default.AIRating;
	SlavePistol = None;
	FiringMode = SemiAuto; 
	Super.DropFrom(StartLocation);
}

function SetDisplayProperties(ERenderStyle NewStyle, texture NewTexture, bool bLighting, bool bEnviroMap )
{
	if ( !bSetup )
	{
		bSetup = true;
		if ( SlavePistol != None )
			SlavePistol.SetDisplayProperties(NewStyle, NewTexture, bLighting, bEnviromap);
		bSetup = false;
	}			
	Super.SetDisplayProperties(NewStyle, NewTexture, bLighting, bEnviromap);
}

function SetDefaultDisplayProperties()
{
	if ( !bSetup )
	{
		bSetup = true;
		if ( SlavePistol != None )
			SlavePistol.SetDefaultDisplayProperties();
		bSetup = false;
	}			
	Super.SetDefaultDisplayProperties();
}

event float BotDesireability(Pawn Bot)
{
	local WeaponPistol AlreadyHas;
	local float desire;

	desire = MaxDesireability + Bot.AdjustDesireFor(self);
	AlreadyHas = WeaponPistol(Bot.FindInventoryType(class));
	if ( AlreadyHas != None )
	{
		if ( (!bHeldItem || bTossedOut) && bWeaponStay )
			return 0;
		if ( AlreadyHas.SlavePistol != None )
		{
			if ( (RespawnTime < 10)
				&& ( bHidden || (AlreadyHas.AmmoType == None)
					|| (AlreadyHas.AmmoType.AmmoAmount < AlreadyHas.AmmoType.MaxAmmo)) )
				return 0;
			if ( AlreadyHas.AmmoType == None )
				return 0.25 * desire;

			if ( AlreadyHas.AmmoType.AmmoAmount > 0 )
				return FMax( 0.25 * desire, 
						AlreadyHas.AmmoType.MaxDesireability
						 * FMin(1, 0.15 * AlreadyHas.AmmoType.MaxAmmo/AlreadyHas.AmmoType.AmmoAmount) ); 
		}
	}
	if ( (Bot.Weapon == None) || (Bot.Weapon.AIRating <= 0.4) )
		return 2*desire;

	return desire;
}

function bool HandlePickupQuery( inventory Item )
{
	local Pawn P;
	local Inventory Copy;

	if ( (Item.class == class) && (SlavePistol == None) 
              	&& (Level.Game.bDeathMatch || (Level.Netmode != NM_Standalone)) ) 
	{
		P = Pawn(Owner);
                		Copy = Spawn(class, P);
		Copy.BecomeItem();
		SlavePistol = WeaponPistol(Copy);
                		SetTwoHands();
		AIRating = 0.44;
		SlavePistol.SetUpSlave( Pawn(Owner).Weapon == self );
		SlavePistol.SetDisplayProperties(Style, Texture, bUnlit, bMeshEnviromap);
		SetTwoHands();
		FiringMode = Automatic;
		Item.PlaySound(Item.PickupSound);
		if (Level.Game.LocalLog != None)
			Level.Game.LocalLog.LogPickup(Item, Pawn(Owner));
		if (Level.Game.WorldLog != None)
			Level.Game.WorldLog.LogPickup(Item, Pawn(Owner));
		Item.SetRespawn();
		return true;
	}
	return Super.HandlePickupQuery(Item);
}

function SetUpSlave(bool bBringUp)
{
	bIsSlave = true;
        	GiveAmmo(Pawn(Owner));
	AmbientGlow = 0;
	if ( bBringUp )
		BringUp();
	else
		GotoState('Idle2');
}

function SetTwoHands()
{
	if ( SlavePistol == None )
		return;

	if ( (PlayerPawn(Owner) != None) && (PlayerPawn(Owner).Handedness == 2) )
	{
		SetHand(2);
		return;
	}

	if ( Mesh == mesh'GlockL' )
		SetHand(1);
	else
		SetHand(-1);
}

function SetHand(float Hand)
{
	local rotator newRot;

	if ( Hand == 2 )
	{
		bHideWeapon = true;
		Super.SetHand(Hand);
		return;
	}

	if ( SlavePistol != None )
	{
		if ( Hand == 0 )
			Hand = -1;
		SlavePistol.SetHand(-1 * Hand);
	}
	bHideWeapon = false;
	Super.SetHand(Hand);
        	if ( Hand == 1 )
		Mesh = mesh'GlockL';
	else
		Mesh = mesh'Glock';
}

simulated function TraceFire( float Accuracy )
{
	local vector RealOffset;

	RealOffset = FireOffset;
	FireOffset *= 0.35;
	if ( (SlavePistol != None) || bIsSlave )
		Accuracy += 0.2;
	Super.TraceFire(Accuracy);
	FireOffset = RealOffset;
}

function BringUp()
{
	if (SlavePistol != None ) 
	{
		SetTwoHands();
		SlavePistol.BringUp();
	}
	bBringingUp = true;
	Super.BringUp();
}

simulated function ProcessTraceHit(Actor Other, Vector HitLocation, Vector HitNormal, Vector X, Vector Y, Vector Z)
{
        	local ShellCasing s;
        	local vector realLoc;

        	Super.ProcessTraceHit(Other, HitLocation, HitNormal, X, Y, Z);
        	realLoc = Owner.Location + CalcDrawOffset();
        	s = Spawn(class'ShellCasing',, '', realLoc + 25 * X + FireOffset.Y * Y + Z);
	if ( s != None )
               	{
		if ( bIsSlave )
			s.Velocity = (FRand()*20-75) * Y + (10-FRand()*20) * X;
		else
                        		s.Velocity = (FRand()*20+75) * Y + (10-FRand()*20) * X;
	        	s.Velocity.Z += 200;
                        	s.DrawScale = 1.5;
		s.RemoteRole = ROLE_None;
        	}
}        

simulated function PlaySelectiveFiring()
{
	Super.PlaySelectiveFiring();
        	if ((PlayerPawn(Owner) != None)  
	&& (PlayerPawn(Owner).DesiredFOV == PlayerPawn(Owner).DefaultFOV) )
                	bMuzzleFlash++;
	MuzzleFlashLight();   
}

simulated function MuzzleFlashLight()
{
	local Vector offset, X, Y, Z;
      
	if ( Owner == None )
		return;

	if ( (flash != None) && !flash.bDeleteMe )
		flash.LifeSpan = flash.Default.LifeSpan;
	else
	{
		GetAxes(Pawn(Owner).ViewRotation,X,Y,Z);
		offset = Owner.Location;
		offset += X * Owner.CollisionRadius * 2;
		flash = spawn(class'MuzzleFlash',,, offset);
		if ( flash != None )
			flash.SetBase(Owner);
	}
}

function Destroyed()
{
	Super.Destroyed();
	if ( SlavePistol != None )
		SlavePistol.Destroy();
}

simulated function int AmmoLeftInTwoClip()
{
	local int dualclip;

	if ( SlavePistol != None )
		dualclip = 	SlavePistol.ReloadCount - SlavePistol.ClipCount;
	else
		dualclip = 0;

	if ( AmmoType == None )
		return 0;	
	else if ( AmmoType.AmmoAmount == 0 )		
		return 0;
	else if ( (ReloadCount - ClipCount) + dualclip > AmmoType.AmmoAmount )		
		return AmmoType.AmmoAmount;
	else
		return ( ReloadCount - ClipCount ) + dualclip;
}

state NormalFire
{
	function Timer()
	{
                		if ( SlavePistol != None )
			SlavePistol.Fire(0);
	}

       	function float GetShotTime()
	{
                		if ( SlavePistol != None )
		      	return 0.25;
                		else
                         		return ShotTime; 
	}

	function EndState()
	{
		Super.EndState();
		OldFlashCount = FlashCount;
	}
Begin:
	if ( AmmoLeftInClip() < AmmoPerFire ) 
	{
		FinishAnim();
		
		if (Owner != None)
		{
			if (Owner.IsA('DeusExPlayer'))
			{
				bFiring = False;

				if (DeusExPlayer(Owner).bAutoReload)
					ReloadAmmo();
				else
					GotoState('Idle');
			}

			else if (Owner.IsA('ScriptedPawn'))
			{
				bFiring = False;
				ReloadAmmo();
			}

                        		else if (Bot(Owner) != None)
			{
				bFiring = False;
                                			ReloadAmmo();
			}
		}
		else
		{
			GotoState('Idle');
		}
	}
       	 if ( SlavePistol != None )
		SetTimer(0.10, false);
	Sleep(GetShotTime());
	bFiring = False;
        	if (!bSemiAuto && !bRapidFire)
                	FinishAnim();
	ReadyToFire();
Done:
	bFiring = False;
        	if ( bIsSlave )
        		GotoState('Idle');
	else
                		Finish();
}

simulated state ClientFiring
{
	simulated function Timer()
	{
                		if ( SlavePistol != None )
			SlavePistol.ClientFire(0);
	}

	simulated function float GetSimShotTime()
	{
		if ( SlavePistol != None )
		         	return 0.25;
		else
                         		return ShotTime; 
	}

	simulated function EndState()
	{
		Super.EndState();
		OldFlashCount = FlashCount;
	}
Begin:
	if (AmmoLeftInClip() < AmmoPerFire) 
	{
		bFiring = False;
                		FinishAnim();

		if (Owner != None)
		{
			if (Owner.IsA('DeusExPlayer'))
			{
				bFiring = False;
				if (DeusExPlayer(Owner).bAutoReload)
				{
					bClientReadyToFire = False;
					bInProcess = False;
					ReloadAmmo();
					GotoState('SimQuickFinish');
				}
				else
				{
					IdleFunction();
					GotoState('SimQuickFinish');
				}
			}
			else if (Owner.IsA('ScriptedPawn'))
			{
                                			bClientReadyToFire = False;
				bInProcess = False;
				bFiring = False;
                                			ReloadAmmo();
				GotoState('SimQuickFinish');
			}
                        		else if (Bot(Owner) != None)
			{
                                			bClientReadyToFire = False;
				bInProcess = False;
				bFiring = False;
                                			ReloadAmmo();
                                			GotoState('SimQuickFinish');
			}
		}
		else
		{
			IdleFunction();
			GotoState('SimQuickFinish');
		}
	}
        	if ( SlavePistol != None )
		SetTimer(0.10, false);
	Sleep(GetSimShotTime());
	bFiring = False;
        	if (!bSemiAuto && !bRapidFire) 
                	FinishAnim();
	bInProcess = False;
        	if ( (Owner != None) && !Owner.IsA('DeusExPlayer') )
                	ReadyClientToFire( True );
Done:
	bInProcess = False;
	bFiring = False;
	if ( bIsSlave )
        		GotoState('SimIdle');
	else
        		SimFinish();
}

state Idle
{
	function bool PutDown()
	{
		return Super.PutDown();
	}	
Begin:
	bPointing=False;
        	bFiring = False;
        	ReadyToFire();
	if (Level.Game.bDeathMatch || (Level.NetMode != NM_Standalone) || (Level.Game.Difficulty > 2))
        	{
                		if ( (AmmoType != None) && (AmmoType.AmmoAmount<=0) ) 
                        		Pawn(Owner).SwitchToBestWeapon(); 
        	}
	if (((Level.NetMode == NM_DedicatedServer) && Owner.IsA('DeusExPlayer')) || ((Level.NetMode == NM_ListenServer) && Owner.IsA('DeusExPlayer') && !DeusExPlayer(Owner).PlayerIsListenClient()))
	{
	}
	else
	{
		PlayAnim('Idle1',,0.1);
		SetTimer(3.0, True);
	}
	if ( SlavePistol != None )
        	{
	        	if ( (Owner != None) && (Pawn(Owner).bFire!=0) )    
                		{
                         		if ( bIsSlave && bFirstFire )
                                   			bFirstFire = False;
                         		else    
                                   			Global.Fire(0.0);
                		}
                		else
                         		bFirstFire = False; 	
        	}
}

simulated state SimIdle
{
Begin:
        	if ( (Owner != None) && !Owner.IsA('DeusExPlayer') )
                 	ReadyClientToFire( True );
        	bInProcess = False;
        	bFiring = False;
        	if ( ((Level.Game != None) && Level.Game.bDeathMatch) || (Level.NetMode != NM_Standalone) || ((Level.Game != None) && (Level.Game.Difficulty > 2)) )
        	{
                 		if ( (AmmoType != None) && (AmmoType.AmmoAmount<=0) ) 
                          		Pawn(Owner).SwitchToBestWeapon(); 
        	}
      	PlayAnim('Idle1',,0.1);
	SetTimer(3.0, True);

        	if ( SlavePistol != None )
        	{
	        	if ( (Owner != None) && (Pawn(Owner).bFire!=0) ) 
                		{
                         		if ( bIsSlave && bFirstFire )
                                   			bFirstFire = False;
                         		else    
                                   			Global.ClientReFire(0.0);
                		}
                		else
                         		bFirstFire = False; 	
        	}
}

state Active
{
	function EndState()
	{
		Super.EndState();
		bBringingUp = false;
	}
}

simulated state SimActive
{
	simulated function EndState()
	{
		Super.EndState();
		bBringingUp = false;
	}
}

state DownWeapon
{
	function BeginState()
	{
		Super.BeginState();
		if ( SlavePistol != None )
                		{
                        		if ( (Owner != None) && Owner.IsA('JCDentonMale') )
                        		{
                                 			SlavePistol.Destroy();
                                 			SlavePistol = None;
				FiringMode = SemiAuto; 
                        		}
                        		else  
                	         			SlavePistol.GoToState('DownWeapon');
                		}
	}
}

simulated state SimDownWeapon
{
	simulated function BeginState()
	{
		Super.BeginState();
		if ( SlavePistol != None )
                     		SlavePistol.GoToState('SimDownWeapon');
	}
}

state DownSlave
{
Begin:
        	if ( SlavePistol != None )
        	{
                		SlavePistol.TweenDown();
                		SlavePistol.FinishAnim();
                		SlavePistol.Destroy();   
                		SlavePistol = None; 
		Owner.PlaySound(SelectSound, SLOT_Misc, Pawn(Owner).SoundDampening);	
        	}
        	GotoState('Idle'); 
}

simulated function TweenDown()
{
	if ( (AnimSequence != '') && (GetAnimGroup(AnimSequence) == 'Select') )
		TweenAnim( AnimSequence, AnimFrame * 0.4 );
	else
		PlayAnim('Down', 1.0, 0.05);
}

function CycleAmmo()
{
}

simulated function SwapMuzzleFlashTexture()
{
}

simulated function EraseMuzzleFlashTexture()
{
}

simulated function bool TestMPBeltSpot(int BeltSpot)
{
        	return (BeltSpot == 1);
}

defaultproperties
{
     LowAmmoWaterMark=10
     GoverningSkill=Class'DeusEx.SkillWeaponPistol'
     EnviroEffective=ENVEFF_Air
     Concealability=CONC_Visual
     bSemiAuto=True
     ShotTime=0.100000
     AltShotTime=0.100000
     TimeBetweenFire=0.050000
     FiringMode="SEMI-AUTO"
     bTournamentWeapon=True
     AltAccuracy=0.250000
     Automatic="DUAL"
     reloadTime=2.000000
     HitDamage=17
     maxRange=4800
     AccurateRange=2400
     BaseAccuracy=0.700000
     bHasMuzzleFlash=False
     recoilStrength=0.300000
     mpReloadTime=0.500000
     mpHitDamage=20
     mpBaseAccuracy=0.200000
     mpAccurateRange=3600
     mpMaxRange=4800
     mpReloadCount=20
     msgInfoSingle="SEMI-AUTO"
     AmmoName=Class'DeusEx.Ammo10mm'
     ReloadCount=10
     PickupAmmoCount=10
     bInstantHit=True
     bAltInstantHit=True
     FireOffset=(Y=-18.000000,Z=-4.000000)
     shakemag=50.000000
     AIRating=0.250000
     AltRefireRate=0.990000
     FireSound=Sound'DeusEx.Weapons.PistolFire2'
     AltFireSound=Sound'DeusEx.Weapons.PistolFire4'
     CockingSound=Sound'DeusExSounds.Weapons.PistolReload'
     SelectSound=Sound'DeusExSounds.Weapons.PistolSelect'
     Misc1Sound=Sound'DeusExSounds.Generic.DryFire'
     bDrawMuzzleFlash=True
     MuzzleScale=1.200000
     FlashY=0.200000
     FlashO=0.010000
     FlashC=0.040000
     FlashLength=0.025000
     FlashS=128
     MFTexture=Texture'DeusEx.Skins.Muzzleflash02'
     AutoSwitchPriority=2
     InventoryGroup=8
     ItemName="Pistol"
     PlayerViewOffset=(X=20.000000,Y=-14.000000,Z=-15.000000)
     PlayerViewMesh=LodMesh'DeusExItems.Glock'
     PickupViewMesh=LodMesh'DeusExItems.GlockPickup'
     ThirdPersonMesh=LodMesh'DeusExItems.Glock3rd'
     Icon=Texture'DeusExUI.Icons.BeltIconPistol'
     largeIcon=Texture'DeusExUI.Icons.LargeIconPistol'
     largeIconWidth=46
     largeIconHeight=28
     Description="Inexpensive and easily produced, the HMP-10 semi-automatic pistol provides a lightweight 10mm combat solution that is most effective against unarmored foes at close ranges. With low-to-moderate armor penetration capabilities, this pistol is best suited to a role as a light support weapon."
     beltDescription="PISTOL"
     Mesh=LodMesh'DeusExItems.GlockPickup'
     SoundRadius=96
     SoundVolume=255
     CollisionRadius=7.000000
     CollisionHeight=3.000000
}
