//=============================================================================
// WeaponPlasmaRifle.
//=============================================================================
class WeaponPlasmaRifle extends DeusExWeapon;

var Projectile Tracked;
var bool bBotSpecialMove;
var float TapTime;
var travel float RailDistance;

simulated function PreBeginPlay()
{
	Super.PreBeginPlay();

	if ( ((Level.Game != None) && Level.Game.bDeathMatch) || (Level.NetMode != NM_Standalone) )
	{
		HitDamage = mpHitDamage;
		BaseAccuracy = mpBaseAccuracy;
		ReloadTime = mpReloadTime;
		AccurateRange = mpAccurateRange;
		MaxRange = mpMaxRange;
		ReloadCount = mpReloadCount;
		bHasScope = False;
                		InventoryGroup = 7;
	}
}

simulated function PostRender( canvas Canvas )
{
	local float Scale;
	local PlayerPawn P;

	Super.PostRender(Canvas);

	if ( ((Level.Game != None) && Level.Game.bDeathMatch) 
	|| (Level.NetMode != NM_Standalone) )
		return;

	P = PlayerPawn(Owner);
	if ( (P != None) && bZoomed ) 
	{
		bOwnsCrossHair = true;
		Scale = Canvas.ClipX/640;
		Canvas.SetPos(0.5 * Canvas.ClipX - 128 * Scale, 0.5 * Canvas.ClipY - 128 * Scale );
		Canvas.Style = ERenderStyle.STY_Translucent;
		Canvas.DrawIcon(Texture'MyCross2', Scale);
		Canvas.SetPos(0.5 * Canvas.ClipX + 64 * Scale, 0.5 * Canvas.ClipY + 96 * Scale);
		Canvas.DrawColor.R = 0;
		Canvas.DrawColor.G = 255;
		Canvas.DrawColor.B = 0;
		Scale = P.DefaultFOV/P.DesiredFOV;
		Canvas.Font = Canvas.BigFont;
		Canvas.DrawText("X"$int(Scale)$"."$int(10 * Scale - 10 * int(Scale)));
		Scale = Canvas.ClipX/640;
		Canvas.SetPos(0.5 * Canvas.ClipX - 128 * Scale, 0.5 * Canvas.ClipY - 96 * Scale);
		Canvas.DrawColor.R = 0;
		Canvas.DrawColor.G = 255;
		Canvas.DrawColor.B = 0;
		Canvas.Font = Canvas.MedFont;
		Canvas.DrawText(Rand(99)$":"$Rand(99)$":"$Rand(99)$":"$Rand(99)$":"$Rand(99));
	}	
	else
		bOwnsCrossHair = false;		
}

function Fire( float Value )
{
	if ( Owner == None )
		return;
	
	if ( bHasScope && (DeusExPlayer(Owner) != None) )
		AmmoPerFire = Clamp(AmmoLeftInClip(), 1, 10);

	Super.Fire( Value );
}

function AltFire( float Value )
{
	local Inventory Inv;
	local actor HitActor;
	local vector HitLocation, HitNormal, Start; 

	if ( Owner == None )
		return;

	if ( bHasScope && Owner.IsA('DeusExPlayer') )
	{
		if ( (Level.NetMode == NM_Standalone) && !Level.Game.bDeathMatch  )
		{
			for (Inv = DeusExPlayer(Owner).Inventory; Inv != None; Inv = Inv.Inventory)
			{
				if ( Inv.IsA('TechGoggles') && Inv.bActive )
					Inv.Activate();
			} 
			GotoState('Zooming');
			return;
		}
	}

	if ( Owner.IsA('Bot') || Owner.IsA('ScriptedPawn') ) //make sure won't blow self up
	{
		Start = Owner.Location + CalcDrawOffset() + FireOffset.Z * vect(0,0,1); 
		if ( Pawn(Owner).Enemy != None )
			HitActor = Trace(HitLocation, HitNormal, Start + 250 * Normal(Pawn(Owner).Enemy.Location - Start), Start, false, vect(12,12,12));
		else
			HitActor = self;
		if ( HitActor != None )
		{
			Global.Fire(Value);
			return;
		}
	}	
	Super.AltFire( Value );
}

simulated function TraceFire( float Accuracy )
{
	local vector HitLocation, HitNormal, StartTrace, EndTrace, X,Y,Z;
	local actor Other;
        	local float volume, radius;

	if ( bHasScope && Owner.IsA('DeusExPlayer') )
	{
		if ( (Level.NetMode == NM_Standalone) && !Level.Game.bDeathMatch  )
		{
			TraceAltFire(Accuracy);
			return;
		}
	}

	if ( ScriptedPawn(Owner) != None )
        	              	Accuracy += 1.0 + FRand();
                	
	GetAIVolume(volume, radius);
        	Owner.MakeNoise(Pawn(Owner).SoundDampening);
	Owner.AISendEvent('WeaponFire', EAITYPE_Audio, volume, radius);
	Owner.AISendEvent('LoudNoise', EAITYPE_Audio, volume, radius);
	GetAxes(Pawn(owner).ViewRotation,X,Y,Z);
	StartTrace = ComputeProjectileStart(X, Y, Z);
	EndTrace = StartTrace + Accuracy * (FRand() - 0.5 )* Y * 1000
		+ Accuracy * (FRand() - 0.5 ) * Z * 1000 ;

	if ( bBotSpecialMove && (Tracked != None)
		&& (((Owner.Acceleration == vect(0,0,0)) && (VSize(Owner.Velocity) < 40)) ||
			(Normal(Owner.Velocity) Dot Normal(Tracked.Velocity) > 0.95)) )
		EndTrace += 24400 * Normal(Tracked.Location - StartTrace);
	else
	{
		AdjustedAim = pawn(owner).AdjustAim(1000000, StartTrace, 2.75*AimError, False, False);	
		EndTrace += (24400 * vector(AdjustedAim)); 
	}

	Tracked = None;
	bBotSpecialMove = false;

	Other = Pawn(Owner).TraceShot(HitLocation,HitNormal,EndTrace,StartTrace);
	ProcessTraceHit(Other, HitLocation, HitNormal, vector(AdjustedAim),Y,Z);
}

simulated function TraceAltFire(float Accuracy)
{
  	local vector HitLocation, HitNormal, StartTrace, EndTrace,X,Y,Z;
  	local Actor Other;
  	local float volume, radius;
  	local Pawn PawnOwner;
  	local float Penetration;
	local int NumHits;

  	PawnOwner = Pawn(Owner);
	Owner.MakeNoise(PawnOwner.SoundDampening);
  	GetAIVolume(volume, radius);
	Owner.AISendEvent('WeaponFire', EAITYPE_Audio, volume, radius);
	Owner.AISendEvent('LoudNoise', EAITYPE_Audio, volume, radius);
	GetAxes(PawnOwner.ViewRotation,X,Y,Z);
	StartTrace = ComputeProjectileStart(X, Y, Z);
	AdjustedAim = PawnOwner.AdjustAim(1000000,StartTrace,2*AimError,False,False);
	EndTrace = StartTrace + Accuracy * (FRand()-0.5)*Y*1000 + Accuracy * (FRand()-0.5)*Z*1000 ;
 	X = vector(AdjustedAim);
  	EndTrace+=(48000*X);
	Other = PawnOwner.TraceShot(HitLocation,HitNormal,EndTrace,StartTrace);
	ProcessTraceHit(Other,HitLocation,HitNormal,X,Y,Z);
Repeat:
	if ( NumHits < 150 )
	{
		NumHits++;
		if (Other.IsA('Pawn'))
   			Penetration = 36.000000;
    		else
   			Penetration = 40.000000;
		StartTrace = HitLocation + HitNormal + (Penetration*X);
		EndTrace = StartTrace + Accuracy*(FRand()-0.5)*Y*1000 + Accuracy*(FRand()-0.5)*Z*1000;
		EndTrace+=(48000*X);
		Other = PawnOwner.TraceShot(HitLocation,HitNormal,EndTrace,StartTrace);
		ProcessAltTraceHit(Other,HitLocation,HitNormal,X,Y,Z);
		Goto Repeat;
	}
}

function Timer()
{
	local actor targ;
	local float bestAim, bestDist;
	local vector FireDir;
	local Pawn P;

	bestAim = 0.95;

	P = Pawn(Owner);

	if ( P == None )
		return;
	
	FireDir = vector(P.ViewRotation);
	targ = P.PickTarget(bestAim, bestDist, FireDir, Owner.Location);
	if ( Pawn(targ) != None )
	{
		bPointing = true;
		Pawn(targ).WarnTarget(P, 300, FireDir);
		SetTimer(1 + 4 * FRand(), false);
	}
	else 
	{
		SetTimer(0.5 + 2 * FRand(), false);
		if ( (P.bFire == 0) && (P.bAltFire == 0) )
			bPointing = false;
	}
}	

function Finish()
{
	if ( (Pawn(Owner).bFire!=0) && (FRand() < 0.6) )
		Timer();
	if ( !bChangeWeapon && (Tracked != None) && !Tracked.bDeleteMe && (Owner != None) 
		&& (Owner.IsA('Bot')) && (Pawn(Owner).Enemy != None) && (FRand() < 0.3 + 0.35 * Pawn(Owner).skill)
		&& (AmmoType.AmmoAmount > 0) ) 
	{
		if ( (Owner.Acceleration == vect(0,0,0)) ||
			(Abs(Normal(Owner.Velocity) dot Normal(Tracked.Velocity)) > 0.95) )
		{
			bBotSpecialMove = true;
			GotoState('ComboMove');
			return;
		}
	}

	bBotSpecialMove = false;
	Tracked = None;
	Super.Finish();
}

simulated function PlaySelectiveFiring()
{
	Super.PlaySelectiveFiring();
        	if ((PlayerPawn(Owner) != None)  
		&& (PlayerPawn(Owner).DesiredFOV == PlayerPawn(Owner).DefaultFOV) )
                    	bMuzzleFlash++;   
}

simulated function PlaySelectiveAltFiring()
{
	Super.PlaySelectiveAltFiring();
        	if ((PlayerPawn(Owner) != None)  
		&& (PlayerPawn(Owner).DesiredFOV == PlayerPawn(Owner).DefaultFOV) )
                    	bMuzzleFlash++;   
}

simulated function PlayFiringSound()
{
     	if ( bHasScope )
     	  	PlaySimSound( Class'WeaponSuperPlasmaRifle'.Default.FireSound, SLOT_None, TransientSoundVolume, 2048 );
     	else
	    	PlaySimSound( FireSound, SLOT_None, TransientSoundVolume, 2048 );     	
}

simulated function Projectile ProjectileAltFire(class<projectile> ProjClass, float ProjSpeed, bool bWarn)
{
	Tracked = Super.ProjectileAltFire(ProjClass, ProjSpeed, bWarn);
        	return Tracked;
}

simulated function ProcessTraceHit(Actor Other, Vector HitLocation, Vector HitNormal, Vector X, Vector Y, Vector Z)
{
	local int i;
	local float mult;
	
	if (Other==None)
	{
		HitNormal = -X;
		HitLocation = Owner.Location + X*10000.0;
	}
	
	SpawnEffect(HitLocation, Owner.Location + CalcDrawOffset() + (FireOffset.X + 20) * X + FireOffset.Y * Y + FireOffset.Z * Z);

	if ( PlasmaBall(Other) != None )
	{ 
		AmmoType.UseAmmo(4);
		PlasmaBall(Other).SuperExplosion();
	}
	else
		Spawn(class'GreenSphere',,, HitLocation+HitNormal*8,rotator(HitNormal));

	if ( (Other != self) && (Other != Owner) && (Other != None) ) 
        	{
                		if ( Role == ROLE_Authority )
		{
			if ( ((Level.Game != None) && Level.Game.bDeathMatch) || (Level.NetMode != NM_Standalone) )
			{
		     		Other.TakeDamage(HitDamage, Pawn(Owner), HitLocation, 60000.0*X, 'Burned');
			}
			else
			{
				mult = FClamp(AmmoPerFire, 1.0, 5.0);
				/*if ( Level.Game.Difficulty < 3 )
					mult += -2.0 * GetWeaponSkill();*/
				Other.TakeDamage(HitDamage * mult, Pawn(Owner), HitLocation, 120000.0*X, 'Burned');
			}
		}
        	}
}

simulated function ProcessAltTraceHit(Actor Other, Vector HitLocation, Vector HitNormal, Vector X, Vector Y, Vector Z)
{
	local int i;
	local float mult;
	
	if (Other==None)
	{
		HitNormal = -X;
		HitLocation = Owner.Location + X*10000.0;
	}
	
	if ( PlasmaBall(Other) != None )
	{ 
		AmmoType.UseAmmo(4);
		PlasmaBall(Other).SuperExplosion();
	}
	else
		Spawn(class'GreenSphere',,, HitLocation+HitNormal*8,rotator(HitNormal));

	if ( (Other != self) && (Other != Owner) && (Other != None) ) 
        	{
                		if ( Role == ROLE_Authority )
		{
			if ( ((Level.Game != None) && Level.Game.bDeathMatch) || (Level.NetMode != NM_Standalone) )
			{
		     		Other.TakeDamage(HitDamage, Pawn(Owner), HitLocation, 60000.0*X, 'Burned');
			}
			else
			{
				mult = FClamp(AmmoPerFire, 1.0, 5.0);
				/*if ( Level.Game.Difficulty < 3 )
					mult += -2.0 * GetWeaponSkill();*/
				Other.TakeDamage(HitDamage * mult, Pawn(Owner), HitLocation, 120000.0*X, 'Burned');
			}
		}
        	}
}

simulated function SpawnEffect(vector HitLocation, vector SmokeLocation)
{
	local GreenBeam Smoke,shock;
	local Vector DVector;
	local int NumPoints;
	local rotator SmokeRotation;
	local LaserEmitter Rail;

	DVector = HitLocation - SmokeLocation;
	NumPoints = VSize(DVector)/25.0;
	if ( NumPoints < 1 )
		return;
	SmokeRotation = rotator(DVector);
	SmokeRotation.roll = Rand(65535);

	Rail = Spawn(class'LaserEmitter',Self,,SmokeLocation,SmokeRotation);
	if (Rail != None)
	{
		Rail.AmbientSound = None;
		Rail.LifeSpan = 0.2;
		Rail.SetGreenBeam();
		Rail.TurnOn();
		if ( (Owner != None) && Owner.IsA('PlayerPawn') )
			Rail.RemoteRole = ROLE_None;
	}	
	
	Smoke = Spawn(class'GreenBeam',,,SmokeLocation,SmokeRotation);
	if ( Smoke != None )
	{
		Smoke.MoveAmount = DVector/NumPoints;
		Smoke.NumPuffs = NumPoints - 1;
		if ( (Owner != None) && Owner.IsA('PlayerPawn') )
			Smoke.RemoteRole = ROLE_None;
	}
}

simulated function ScopeToggle()
{
	if ( IsInState('Idle') || IsInState('Zooming') )
	{
		if ( bHasScope && (Owner != None) && Owner.IsA('DeusExPlayer') )
		{
			if ( bZoomed )
				ScopeOff();
			else
				ScopeOn();
		}
	}
}

simulated function RefreshScopeDisplay(DeusExPlayer player, bool bInstant, bool bScopeOn)
{
	if ( bScopeOn && (player != None) )
	{
		bHasNightVision = True;
		PlaySimSound( Sound'ZoomIn', SLOT_None, 0.5, 1024 );
		DeusExRootWindow(Player.RootWindow).HUD.AugDisplay.VisionLevel = 3;
		DeusExRootWindow(Player.RootWindow).HUD.AugDisplay.bVisionActive = True;
		DeusExRootWindow(Player.RootWindow).HUD.AugDisplay.VisionLevelValue = RailDistance;
	}
      	else if ( !bScopeOn )
      	{
		bHasNightVision = False;
		PlaySimSound( Sound'ZoomOut', SLOT_None, 0.5, 1024 );
		DeusExrootWindow(Player.rootWindow).scopeView.DeactivateView();
		DeusExRootWindow(Player.RootWindow).hud.augDisplay.visionBlinder = None;
		DeusExRootWindow(Player.RootWindow).HUD.AugDisplay.bVisionActive = False;
      	}
}

function ReloadAmmo()
{
}

simulated function int AmmoLeftInClip()
{
	if (AmmoType == None)
		return 0;
	else
		return AmmoType.AmmoAmount;
}

simulated function int NumClips()
{
	return 0;
}

state Idle
{
	function Timer()
	{
		if ( PlayerPawn(Owner) != None )
			PlayIdleAnim();
		else if ( Bot(Owner) != None )
			Global.Timer();
		else
			PlayIdleAnim();
	}

	function BeginState()
	{
		bPointing = false;
		if ( Bot(Owner) != None )
			SetTimer(0.5 + 2 * FRand(), false);
		Super.BeginState();
		if (Pawn(Owner).bFire!=0) Fire(0.0);
		if (Pawn(Owner).bAltFire!=0) AltFire(0.0);		
	}

	function EndState()
	{
		SetTimer(0.0, false);
		Super.EndState();
	}
Begin:
	bFiring = False;
      	ReadyToFire();
      	if ( Level.Game.bDeathMatch || (Level.NetMode != NM_Standalone) || (Level.Game.Difficulty > 2) )
      	{
           		if ( (AmmoName != Class'AmmoNone') && (AmmoType != None) && (AmmoType.AmmoAmount<=0) ) 
                			Pawn(Owner).SwitchToBestWeapon(); 
      	}
	if (((Level.NetMode == NM_DedicatedServer) && Owner.IsA('DeusExPlayer')) || ((Level.NetMode == NM_ListenServer) && Owner.IsA('DeusExPlayer') && !DeusExPlayer(Owner).PlayerIsListenClient()))
	{
	}
	else 
	{
		if ( Owner.IsA('DeusExPlayer') || Owner.IsA('ScriptedPawn') )
		{
			PlayAnim('Idle1',,0.1);
			SetTimer(3.0, True);
		}
	}
}

state ComboMove
{
	function Fire(float F); 
	function AltFire(float F); 

	function Tick(float DeltaTime)
	{
		if ( (Owner == None) || (Pawn(Owner).Enemy == None) )
		{
			Tracked = None;
			bBotSpecialMove = false;
			Finish();
			return;
		}
		if ( (Tracked == None) || Tracked.bDeleteMe 
			|| (((Tracked.Location - Owner.Location) 
				dot (Tracked.Location - Pawn(Owner).Enemy.Location)) >= 0)
			|| (VSize(Tracked.Location - Pawn(Owner).Enemy.Location) < 100) )
			Global.Fire(0);
	}

Begin:
	Sleep(7.0);
	Tracked = None;
	bBotSpecialMove = false;
	Global.Fire(0);
}

state Zooming
{
	simulated function Tick(float DeltaTime)
	{
		if ( Pawn(Owner).bAltFire == 0 )
		{
			if ( (PlayerPawn(Owner) != None) && PlayerPawn(Owner).Player.IsA('ViewPort') )
				PlayerPawn(Owner).StopZoom();
			GoToState('Idle');
		}
	}

	simulated function Timer()
	{
		PlayIdleAnim();
	}

	simulated function BeginState()
	{
		if ( Owner.IsA('PlayerPawn') )
		{
			if ( PlayerPawn(Owner).Player.IsA('ViewPort') )
				PlayerPawn(Owner).ToggleZoom();
			SetTimer(3.0,True);
			if ( Owner.IsA('DeusExPlayer') )
				ScopeToggle();
		}
		else
		{
			Pawn(Owner).bFire = 1;
			Pawn(Owner).bAltFire = 0;
			Global.Fire(0);
		}
	}
}

function float RateSelf( out int bUseAltMode )
{
	local Pawn P;
	local bool bNovice;

	if ( AmmoType.AmmoAmount <=0 )
		return -2;
        	if ( Region.Zone.bWaterZone )
		return -2;

	P = Pawn(Owner);
	bNovice = ( (Bot(Owner) == None) || Bot(Owner).bNovice );
	if ( P.Enemy == None )
		bUseAltMode = 0;
	else if ( !bNovice && (P.IsInState('Hunting') || P.IsInState('StakeOut')
		|| P.IsInState('RangedAttack')) )
	{
		bUseAltMode = 1;
		return (AIRating + 0.3);
	}
	else if ( !bNovice && (P.Acceleration == vect(0,0,0)) )
		bUseAltMode = 1;
	else if ( !bNovice && (VSize(P.Enemy.Location - P.Location) > 1200) )
	{
		bUseAltMode = 0;
		return (AIRating + 0.05 + FMin(0.00009 * VSize(P.Enemy.Location - P.Location), 0.3)); 
	}
	else if ( P.Enemy.Location.Z > P.Location.Z + 200 )
	{
		bUseAltMode = int( FRand() < 0.6 );
		return (AIRating + 0.15);
	} 
	else
		bUseAltMode = int( FRand() < 0.4 );

	return AIRating;
}

simulated function bool TestMPBeltSpot(int BeltSpot)
{
       	return (BeltSpot == 7);
}

defaultproperties
{
     RailDistance=400.000000
     GoverningSkill=Class'DeusEx.SkillWeaponHeavy'
     NoiseLevel=1.500000
     EnviroEffective=ENVEFF_AirVacuum
     bAltSemiAuto=False
     ShotTime=1.000000
     AltShotTime=0.700000
     ReloadSound=Sound'DeusExSounds.Weapons.PlasmaRifleReloadEnd'
     FiringMode="AUTO-REFIRE"
     bTournamentWeapon=True
     reloadTime=2.000000
     HitDamage=50
     maxRange=24000
     AccurateRange=24400
     BaseAccuracy=0.000000
     bCanHaveScope=True
     bPenetrating=False
     recoilStrength=0.100000
     mpReloadTime=0.500000
     mpHitDamage=40
     mpAccurateRange=24400
     mpMaxRange=24400
     mpReloadCount=255
     bCanHaveModAccurateRange=True
     msgInfoSingle="AUTO-REFIRE"
     AmmoName=Class'DeusEx.AmmoPlasma'
     ReloadCount=255
     PickupAmmoCount=20
     bInstantHit=True
     bAltWarnTarget=True
     bSplashDamage=True
     AltProjectileClass=Class'DeusEx.PlasmaBall'
     shakemag=50.000000
     AIRating=0.730000
     RefireRate=0.800000
     AltRefireRate=0.700000
     FireSound=Sound'DeusEx.Weapons.PlasmaRifleFire1'
     AltFireSound=Sound'DeusEx.Weapons.PlasmaRifleFire2'
     CockingSound=Sound'DeusExSounds.Weapons.PlasmaRifleReload'
     SelectSound=Sound'DeusExSounds.Weapons.PlasmaRifleSelect'
     Misc1Sound=Sound'DeusExSounds.Weapons.ProdReload'
     bDrawMuzzleFlash=True
     MuzzleScale=1.000000
     FlashY=0.120000
     FlashO=0.022000
     FlashC=0.006000
     FlashS=128
     MFTexture=Texture'DeusEx.Effects.phit_a00'
     AutoSwitchPriority=8
     InventoryGroup=19
     ItemName="Plasma Rifle"
     PlayerViewOffset=(X=18.000000,Z=-7.000000)
     PlayerViewMesh=LodMesh'DeusExItems.PlasmaRifle'
     PlayerViewScale=0.750000
     PickupViewMesh=LodMesh'DeusExItems.PlasmaRiflePickup'
     ThirdPersonMesh=LodMesh'DeusExItems.PlasmaRifle3rd'
     LandSound=Sound'DeusExSounds.Generic.DropLargeWeapon'
     Icon=Texture'DeusExUI.Icons.BeltIconPlasmaRifle'
     largeIcon=Texture'DeusExUI.Icons.LargeIconPlasmaRifle'
     largeIconWidth=203
     largeIconHeight=66
     invSlotsX=4
     invSlotsY=2
     Description="The experimental plasma rifle sports two firing modes capable of acting in concert to neutralize opponents in a devastating shockwave. This combination attack is achieved when the weapon operator utilizes the secondary fire mode to deliver a charge of seeded plasma to the target. Once the slow-moving plasma charge is within range of the target, the weapon operator may fire the photon beam into the plasma core, releasing the explosive energy of the anti-photons contained within the plasmas EM field. When equipped with scope the plasma rifle can shoot through walls."
     beltDescription="PLASMA"
     Mesh=LodMesh'DeusExItems.PlasmaRiflePickup'
     SoundRadius=96
     SoundVolume=255
     CollisionRadius=15.600000
     CollisionHeight=5.200000
     Mass=50.000000
}
