//=============================================================================
// WeaponPrecisionRifle
// There is no support for MP, Botmatch and Unrealistic difficulty!!!
//=============================================================================
class WeaponPrecisionRifle extends DeusExWeapon;

simulated function PreBeginPlay()
{
	bTournamentWeapon = False;
    	bDifficulty3 = False;
	Super.PreBeginPlay();
}

simulated event RenderOverlays(canvas Canvas)
{
	local float Scale;
	local PlayerPawn P;
	
	Super.RenderOverlays(Canvas);
	P = PlayerPawn(Owner);
	if ( (P != None) && (P.DesiredFOV != P.DefaultFOV) ) 
	{
		bZoomed = True;
		Canvas.SetPos( 0, 0);
		Canvas.Style = ERenderStyle.STY_Modulated;
		Canvas.DrawIcon(Texture'SolidGreen', FMax(Canvas.ClipX, Canvas.ClipY));
	}	
	else
	{
		bZoomed = False;		
	}
}

function AltFire(float Value)
{
         ClientAltFire(Value);
}

simulated function bool ClientAltFire(float Value)
{
         ScopeToggle();
         return true;
}

simulated function ProcessTraceHit(Actor Other, Vector HitLocation, Vector HitNormal, Vector X, Vector Y, Vector Z)
{
        local ShellCasing s;
        local vector realLoc;

        Super.ProcessTraceHit(Other, HitLocation, HitNormal, X, Y, Z);
        realLoc = Owner.Location + CalcDrawOffset();
        s = Spawn(class'ShellCasing',, '', realLoc + 10 * X + FireOffset.Y * Y + Z);
	if ( s != None )
        {
		s.Velocity = (FRand()*20+75) * Y + (10-FRand()*20) * X;
	        s.Velocity.Z += 200;
		s.DrawScale = 2.5;
		s.RemoteRole = ROLE_None;
        }
}

simulated function RefreshScopeDisplay(DeusExPlayer Player, bool bInstant, bool bScopeOn)
{
	if (bScopeOn && (Player != None))
	{
		// Show the Scope View
		bHasNightVision = True;
		DeusExRootWindow(player.rootWindow).scopeView.ActivateView(ScopeFOV, False, bInstant);
		PlaySimSound( Misc2Sound, SLOT_None, 0.5, 1024 );
	}
      	else if (!bScopeOn)
      	{
		bHasNightVision = False;
           	DeusExrootWindow(Player.rootWindow).scopeView.DeactivateView();
		PlaySimSound( Misc2Sound, SLOT_None, 0.5, 1024 );
      	}
}

function CycleAmmo()
{
	if ( ((Level.Game != None) && Level.Game.bDeathMatch) || (Level.NetMode != NM_Standalone) )
	{
		Super.CycleAmmo();
		return;
	}

	if ( bSemiAuto )
	{
		bSemiAuto = False;
		FiringMode = Automatic;
		tempAccuracy = 0.200000;
		TimeBetweenFire = 0.020000;
		recoilStrength += 0.2;
		recoilStrength = FClamp(recoilStrength, 0.0, 0.7);
		PlaySimSound( AltFireSound, SLOT_None, TransientSoundVolume * 2.0, 1024 );
		return;
	}

	bSemiAuto = True; 
	FiringMode = SemiAuto;
	tempAccuracy = 0.000000;
	TimeBetweenFire = 0.050000;
	recoilStrength -= 0.2;
	recoilStrength = FClamp(recoilStrength, 0.0, 0.5);
	PlaySimSound( AltFireSound, SLOT_None, TransientSoundVolume * 2.0, 1024 );
}

defaultproperties
{
     LowAmmoWaterMark=20
     GoverningSkill=Class'DeusEx.SkillWeaponRifle'
     bSemiAuto=True
     ShotTime=0.100000
     ReloadSound=Sound'DeusEx.Weapons.FAMASReloadEnd'
     SilencedSound=Sound'DeusEx.Weapons.SilencedFire3'
     fireRate=1.750000
     TimeBetweenFire=0.050000
     reloadTime=2.000000
     HitDamage=20
     BaseAccuracy=0.700000
     bCanHaveScope=True
     bHasScope=True
     bCanHaveLaser=True
     bCanHaveSilencer=True
     recoilStrength=0.500000
     MinWeaponAcc=0.150000
     bCanHaveModBaseAccuracy=True
     bCanHaveModReloadCount=True
     bCanHaveModAccurateRange=True
     bCanHaveModReloadTime=True
     bCanHaveModRecoilStrength=True
     AmmoName=Class'DeusEx.Ammo3006'
     ReloadCount=20
     PickupAmmoCount=20
     bInstantHit=True
     bAltInstantHit=True
     AIRating=0.510000
     FireOffset=(Y=-11.000000,Z=9.000000)
     shakemag=200.000000
     FireSound=Sound'DeusEx.Weapons.SniperFire'
     AltFireSound=Sound'DeusExSounds.Generic.DryFire'
     CockingSound=Sound'DeusEx.Weapons.FAMASReloadBegin'
     SelectSound=Sound'DeusEx.Weapons.FAMASSelect'
     InventoryGroup=224
     ItemName="Precision Rifle"
     PlayerViewOffset=(X=16.000000,Y=-5.000000,Z=-11.500000)
     PlayerViewMesh=LodMesh'DeusEx.famas1st'
     PickupViewMesh=LodMesh'DeusEx.famaspickup'
     ThirdPersonMesh=LodMesh'DeusEx.famas3rd'
     LandSound=Sound'DeusExSounds.Generic.DropMediumWeapon'
     Icon=Texture'DeusExUI.Icons.FamasBelt'
     largeIcon=Texture'DeusEx.Icons.Famas_inv'
     largeIconWidth=256
     largeIconHeight=128
     invSlotsX=3
     invSlotsY=1
     Description="A Precision Rifle with night-vision scope. The weapon can be switched from the regular semi-automatic firing mode to a fully automatic mode, which is greatly decrease the weapon's accuracy, but can be very suitable in midrange combat situations."
     beltDescription="P-RIFLE"
     bDifficulty3=False
     Mesh=LodMesh'DeusEx.famaspickup'
     CollisionRadius=15.000000
     CollisionHeight=8.000000
     Mass=30.000000
}
